/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.apilogin.service;

import com.sapphireims.user.apilogin.api.ApiHelper;
import com.sapphireims.user.dao.LdapUserImportDao;
import com.sapphireims.user.ldap.service.LdapUserImportService;
import com.sapphireims.user.model.AdGroupDetails;
import com.sapphireims.user.model.AdGroupList;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.AdUserAdditionFieldsModel;
import com.sapphireims.user.model.AdUserDetails;
import com.sapphireims.user.model.AdUserList;
import com.sapphireims.user.model.ApiAuthToken;
import com.sapphireims.user.model.GsuiteMember;
import com.sapphireims.user.model.GsuiteMemberList;
import com.sapphireims.user.model.LdapAttributeListingModel;
import com.sapphireims.user.mysql.JdbCConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiUserImportService {
    public static final String GROUP_ID = "group_id";
    private final Logger logger = LoggerFactory.getLogger((String)"com.sapphireims.user");
    private final String className = this.getClass().getName();
    private final ApiHelper apiHelper;
    private final LdapUserImportDao userImportDao;
    private static final String DEFAULT_DATETIME_STR = "0000-00-00 00:00:00";

    public ApiUserImportService(ApiHelper apiHelper, LdapUserImportDao userImportDao) {
        this.apiHelper = apiHelper;
        this.userImportDao = userImportDao;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String importUsersFromAD(AdServerConfigurationModel serverConfig, String schema) {
        this.logger.trace("{} Executing 'importUsersFromAD' method", (Object)this.className);
        long startTime = System.currentTimeMillis();
        String result = "SUCCESS";
        try {
            this.logger.info("AD IMPORT : Started importing Ad users for DomainId {}", (Object)serverConfig.getSchedularId());
            String failureMessage = this.validateConfig(serverConfig);
            if (failureMessage != null) {
                return failureMessage;
            }
            try (Connection conn = new JdbCConnection().getConnection(schema);){
                int totalUsersImported = 0;
                ArrayList<Object> queryParamValues = new ArrayList<Object>(5);
                String maxWhenChanged = null;
                int domainId = serverConfig.getSchedularId();
                if (serverConfig.getImportType() == 1) {
                    String strQuery = "select max(whenChanged) as outputValue FROM userdetails where DomainID = ?";
                    queryParamValues.add(domainId);
                    String queryResult = this.userImportDao.getUniqueValueFromSQLQuery(strQuery, queryParamValues, conn);
                    if (queryResult != null && !queryResult.trim().isEmpty()) {
                        maxWhenChanged = queryResult;
                    }
                }
                ApiAuthToken authToken = new ApiAuthToken();
                this.logger.debug("{} Getting AD-LDAP Attributes", (Object)this.className);
                this.logger.trace("{} Getting AD-LDAP Attributes", (Object)this.className);
                List<LdapAttributeListingModel> adLdapAttributes = this.userImportDao.getAdLdapAttibutes(serverConfig, schema);
                this.logTraceLog("Configured attributes  is " + String.valueOf(adLdapAttributes));
                this.logger.debug("{} Getting User Additional Fields ", (Object)this.className);
                this.logger.trace("{} Getting User Additional Fields ", (Object)this.className);
                List<AdUserAdditionFieldsModel> addAttrUser = this.userImportDao.getUserAdditionalFields(serverConfig.getAdProtocolType(), serverConfig.getAdServerOperatingSystem(), schema);
                this.logTraceLog("Configured Additional Attributes " + String.valueOf(addAttrUser));
                Map<String, Integer> adLdapAttributesMap = this.userImportDao.getDefaultLdapAttributeStatusMap();
                List<String> attrList = LdapUserImportService.buildUserAttributes(adLdapAttributesMap, adLdapAttributes, addAttrUser);
                for (String groupId : serverConfig.getOuGuids().split(",")) {
                    String userNextLink;
                    String lastModifiedDate = Objects.requireNonNullElse(maxWhenChanged, "");
                    this.logger.trace("{} Validating token expiration, setting new token if expired. ", (Object)this.className);
                    authToken = this.validateAndSetIfApiAuthTokenExpired(serverConfig, authToken, conn);
                    serverConfig.setAccessToken(authToken.getAccess_token());
                    HashSet<String> gsuiteMemberUserEmails = new HashSet<String>(5);
                    AdUserList azureUserList = this.fetchUsersFromAPI(serverConfig, attrList, groupId, lastModifiedDate, gsuiteMemberUserEmails);
                    if (azureUserList == null) {
                        String string;
                        if (serverConfig.getImportType() != 2 && (lastModifiedDate == null || lastModifiedDate.isEmpty())) {
                            string = "SUCCESS";
                            return string;
                        }
                        this.logger.info("{} AD IMPORT : Unable to import users, Failed to fetch users from API", (Object)this.className);
                        string = "FAILURE";
                        return string;
                    }
                    double numLastModifiedDate = ApiUserImportService.getTempLastModifiedDate(serverConfig, lastModifiedDate);
                    do {
                        List<AdUserDetails> adUsersList = this.prepareUsersForImport(serverConfig, azureUserList, adLdapAttributes, addAttrUser, attrList, groupId, gsuiteMemberUserEmails, numLastModifiedDate);
                        ArrayList<AdUserDetails> adUsersToImport = new ArrayList<AdUserDetails>(adUsersList);
                        for (AdUserDetails userDetails : adUsersToImport) {
                            if (serverConfig.getIsImageImportEnabled() == 1 && (serverConfig.getAdProtocolType() == 3 || serverConfig.getAdProtocolType() == 5)) {
                                this.logTraceLog(String.format("getting the %s image", userDetails.getEmailAddress()));
                                authToken = this.validateAndSetIfApiAuthTokenExpired(serverConfig, authToken, conn);
                                serverConfig.setAccessToken(authToken.getAccess_token());
                                byte[] userPhotoByteArray = this.apiHelper.getUserPhoto(serverConfig, userDetails.getGuid());
                                userDetails.setUserProfilePhotoByteArr(userPhotoByteArray);
                            }
                            if (userDetails.getAccountExpireDate() == null) {
                                userDetails.setAccountExpireDate(DEFAULT_DATETIME_STR);
                            }
                            if (userDetails.getIsAccountLocked() != null) continue;
                            userDetails.setIsAccountLocked(DEFAULT_DATETIME_STR);
                        }
                        totalUsersImported += adUsersToImport.size();
                        this.logger.debug("{} Importing AD Users into SapphireIMS Database", (Object)this.className);
                        result = this.userImportDao.importAdUsers(adUsersToImport, domainId, serverConfig, schema, adLdapAttributesMap);
                        userNextLink = azureUserList.getNextLink(serverConfig.getAdProtocolType());
                        if (userNextLink == null || userNextLink.isEmpty()) continue;
                        this.logTraceLog("getting the users from Next Link");
                        this.logger.trace("{} Getting the users from Next Link. ", (Object)this.className);
                        authToken = this.validateAndSetIfApiAuthTokenExpired(serverConfig, authToken, conn);
                        serverConfig.setAccessToken(authToken.getAccess_token());
                        azureUserList = this.apiHelper.getUsersFromNextLink(serverConfig, userNextLink);
                    } while (userNextLink != null);
                }
                int roleId = serverConfig.getUserAccessType() == 0 ? 5 : serverConfig.getUserAccessType();
                this.userImportDao.updateUserRoles(domainId, conn, roleId);
                if (roleId != 5) {
                    this.userImportDao.updateUserRoles(domainId, conn, 5);
                }
                if (totalUsersImported > 0 && "SUCCESS".equals(result)) {
                    this.userImportDao.updateDeletedUsersFromADinDb(domainId, serverConfig.getImportType(), maxWhenChanged, conn);
                    this.userImportDao.sendUserImportNotification(serverConfig, schema);
                }
                this.userImportDao.updateUserPresyncStatus(serverConfig.getSchedularId(), schema);
                this.logger.info("Status After AD IMPORT :: Domain {}, Total No of users {}", (Object)serverConfig.getSchedularId(), (Object)totalUsersImported);
            }
        }
        catch (Exception e) {
            result = "FAILURE";
            this.logger.error("Exception occurred while importing azure ad users : {}", (Object)e.getMessage(), (Object)e);
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        this.logger.trace("{} Time taken while executing 'importUsersFromAD' method is {} milliseconds", (Object)this.className, (Object)timeTaken);
        return result;
    }

    private List<AdUserDetails> prepareUsersForImport(AdServerConfigurationModel serverConfig, AdUserList azureUserList, List<LdapAttributeListingModel> adLdapAttributes, List<AdUserAdditionFieldsModel> addAttrUser, List<String> attrList, String groupId, Set<String> gsuiteMemberUserEmails, double numLastModifiedDate) {
        ArrayList<AdUserDetails> adUsersList = new ArrayList<AdUserDetails>(200);
        azureUserList.getUsers().forEach(userListMap -> {
            this.validateAzureUserId(serverConfig, attrList, groupId, (Map<String, Object>)userListMap);
            HashMap<String, Object> adLdapUserAttributeValues = new HashMap<String, Object>(20);
            this.populateLdapAttributeValues(adLdapAttributes, (Map<String, Object>)userListMap, (Map<String, Object>)adLdapUserAttributeValues);
            AdUserDetails apiUser = new AdUserDetails();
            if (ApiUserImportService.validateOneLoginUserGroup(serverConfig, groupId, userListMap, apiUser)) {
                return;
            }
            LdapUserImportService.setUserProps("Logon Name", adLdapUserAttributeValues, apiUser::setUserName);
            LdapUserImportService.setUserProps("whenChanged Time", adLdapUserAttributeValues, apiUser::setWhenChanged);
            ApiUserImportService.checkAzureUserAccountEnabled(serverConfig, adLdapUserAttributeValues, apiUser);
            LdapUserImportService.setUserProps("Cell_No", adLdapUserAttributeValues, attribute -> apiUser.setCellNo(attribute.toString()));
            LdapUserImportService.setUserProps("GUID", adLdapUserAttributeValues, attribute -> apiUser.setGuid(attribute.toString()));
            LdapUserImportService.setUserProps("Fullname", adLdapUserAttributeValues, apiUser::setFullName);
            LdapUserImportService.setUserProps("Wing", adLdapUserAttributeValues, apiUser::setWing);
            LdapUserImportService.setUserProps("EmailAddress", adLdapUserAttributeValues, apiUser::setEmailAddress);
            LdapUserImportService.setUserProps("City", adLdapUserAttributeValues, apiUser::setCity);
            LdapUserImportService.setUserProps("EmployeeID", adLdapUserAttributeValues, attribute -> apiUser.setEmployeeId(attribute.toString()));
            LdapUserImportService.setUserProps("TelephoneNumber", adLdapUserAttributeValues, attribute -> apiUser.setTelephoneNumber(attribute.toString()));
            LdapUserImportService.setUserProps("AccountExpireDate", adLdapUserAttributeValues, apiUser::setAccountExpireDate);
            LdapUserImportService.setUserProps("IsAccountLocked", adLdapUserAttributeValues, attribute -> apiUser.setIsAccountLocked(attribute.toString()));
            LdapUserImportService.setUserProps("BadLoginCount", adLdapUserAttributeValues, attribute -> apiUser.setBadLoginCount(NumberUtils.toInt((String)attribute.toString())));
            LdapUserImportService.setUserProps("DepartmentID", adLdapUserAttributeValues, apiUser::setDepartmentName);
            LdapUserImportService.setUserProps("LocationID", adLdapUserAttributeValues, apiUser::setLocationName);
            LdapUserImportService.setUserProps("UserPrincipalName", adLdapUserAttributeValues, apiUser::setUserPrincipalName);
            LdapUserImportService.setUserProps("User Creation Time", adLdapUserAttributeValues, apiUser::setUserCreatedDateTime);
            LdapUserImportService.setUserProps("First Name", adLdapUserAttributeValues, apiUser::setFirstName);
            LdapUserImportService.setUserProps("Last Name", adLdapUserAttributeValues, apiUser::setLastName);
            LdapUserImportService.setUserProps("BaseDN", adLdapUserAttributeValues, apiUser::setBaseDn);
            LdapUserImportService.setUserProps("User Status", adLdapUserAttributeValues, attribute -> apiUser.setUserStatus(NumberUtils.toInt((String)attribute.toString())));
            LdapUserImportService.setUserProps("Language Code", adLdapUserAttributeValues, apiUser::setLanguageCode);
            LdapUserImportService.setUserProps("Domain Name", adLdapUserAttributeValues, apiUser::setDomainName);
            if (this.validateWhenChanged(serverConfig, groupId, numLastModifiedDate, apiUser)) {
                return;
            }
            if (ApiUserImportService.googleWorkspaceUserValidate(serverConfig, groupId, gsuiteMemberUserEmails, userListMap, apiUser)) {
                return;
            }
            if (serverConfig.getAdProtocolType() == 5 || serverConfig.getAdProtocolType() == 3) {
                apiUser.setUserName(null);
            }
            this.getUserAddtionalFields(addAttrUser, (Map<String, Object>)userListMap, apiUser);
            adUsersList.add(apiUser);
        });
        return adUsersList;
    }

    private static double getTempLastModifiedDate(AdServerConfigurationModel serverConfig, String lastModifiedDate) {
        double tempLastModifiedDate = 0.0;
        if (serverConfig.getImportType() == 1 && !lastModifiedDate.isEmpty()) {
            tempLastModifiedDate = Double.parseDouble(lastModifiedDate.replace("Z", "").trim());
        }
        return tempLastModifiedDate;
    }

    private AdUserList fetchUsersFromAPI(AdServerConfigurationModel serverConfig, List<String> attrList, String groupId, String lastModifiedDate, Set<String> gsuiteMemberUserEmails) {
        AdUserList azureUserList = "1".equals(groupId) ? this.fetchUserList(serverConfig, attrList, lastModifiedDate) : this.fetchAdUserListByGroup(serverConfig, attrList, groupId, gsuiteMemberUserEmails);
        return azureUserList;
    }

    private AdUserList fetchUserList(AdServerConfigurationModel serverConfig, List<String> attrList, String lastModifiedDate) {
        AdUserList azureUserList;
        if (serverConfig.getImportType() == 2) {
            azureUserList = this.apiHelper.getAdUserList(serverConfig, attrList);
        } else {
            String tempLastModifiedDate = ApiUserImportService.getLastModifiedDate(serverConfig, lastModifiedDate);
            this.logTraceLog("Last modified Date is " + tempLastModifiedDate);
            azureUserList = this.apiHelper.getUserListUpdatedAfter(serverConfig, attrList, tempLastModifiedDate);
        }
        return azureUserList;
    }

    private static void checkAzureUserAccountEnabled(AdServerConfigurationModel serverConfig, Map<String, Object> adLdapUserAttributeValues, AdUserDetails apiUser) {
        if (serverConfig.getAdProtocolType() == 3) {
            LdapUserImportService.setUserProps("Account Enabled", adLdapUserAttributeValues, attribute -> apiUser.setAzureAccountEnabled((Boolean)attribute));
        }
    }

    private static boolean validateOneLoginUserGroup(AdServerConfigurationModel serverConfig, String groupId, Map<String, Object> userListMap, AdUserDetails apiUser) {
        if (groupId.trim().length() > 1 && serverConfig.getAdProtocolType() == 4) {
            if (userListMap.containsKey(GROUP_ID) && userListMap.get(GROUP_ID) != null) {
                apiUser.setGroupId(String.valueOf(userListMap.get(GROUP_ID)));
            }
            return !groupId.trim().equals(apiUser.getGroupId());
        }
        return false;
    }

    private void populateLdapAttributeValues(List<LdapAttributeListingModel> adLdapAttributes, Map<String, Object> userListMap, Map<String, Object> adLdapUserAttributeValues) {
        for (LdapAttributeListingModel ldapAttributeList : adLdapAttributes) {
            if (ldapAttributeList.getIsConsiderForCollection() != 1) continue;
            Object attributeValue = userListMap.getOrDefault(ldapAttributeList.getAdLdapAttribute(), null);
            adLdapUserAttributeValues.put(ldapAttributeList.getIsMandatory() == 2 ? ldapAttributeList.getAdDisplayAttribute() : ldapAttributeList.getLdapColumnName(), attributeValue);
        }
    }

    private void validateAzureUserId(AdServerConfigurationModel serverConfig, List<String> attrList, String groupId, Map<String, Object> userListMap) {
        if (serverConfig.getAdProtocolType() == 3 && !"1".equals(groupId.trim())) {
            String userGuid = (String)userListMap.get("id");
            if (userGuid == null || userGuid.trim().isEmpty()) {
                userGuid = (String)userListMap.get("userPrincipalName");
            }
            userListMap.clear();
            Map<String, Object> tempAdpiUserMap = this.apiHelper.getAdUser(serverConfig, userGuid, attrList);
            if (tempAdpiUserMap != null) {
                userListMap.putAll(tempAdpiUserMap);
            }
        }
    }

    private AdUserList fetchAdUserListByGroup(AdServerConfigurationModel serverConfig, List<String> attrList, String groupId, Set<String> gsuiteMemberUserEmails) {
        if (groupId.isEmpty()) {
            this.logger.info("AD IMPORT : Empty group id , unable to import users");
            return null;
        }
        if (serverConfig.getAdProtocolType() == 3) {
            this.logTraceLog("Users are importing from Azure AD");
            return this.apiHelper.getAdUserListFromGroup(serverConfig, groupId, attrList);
        }
        if (serverConfig.getAdProtocolType() == 4) {
            this.logTraceLog("Users are importing from One Login");
            return this.apiHelper.getAdUserList(serverConfig, attrList);
        }
        if (serverConfig.getAdProtocolType() == 5) {
            this.logTraceLog("Users are importing from Google Workspace");
            ArrayList<GsuiteMember> allGsuiteMembers = new ArrayList<GsuiteMember>(5);
            GsuiteMemberList memberList = this.apiHelper.getGsuiteMemberListFromGroup(serverConfig, groupId, null);
            if (memberList != null && memberList.getMembers() != null) {
                allGsuiteMembers.addAll(memberList.getMembers());
                while (memberList.getNextPageToken() != null && !memberList.getNextPageToken().isEmpty()) {
                    memberList = this.apiHelper.getGsuiteMemberListFromGroup(serverConfig, groupId, memberList.getNextPageToken());
                    allGsuiteMembers.addAll(memberList.getMembers());
                }
            }
            for (GsuiteMember member : allGsuiteMembers) {
                gsuiteMemberUserEmails.add(member.getEmail());
            }
            return this.apiHelper.getAdUserList(serverConfig, attrList);
        }
        return null;
    }

    private void getUserAddtionalFields(List<AdUserAdditionFieldsModel> addAttrUser, Map<String, Object> userListMap, AdUserDetails apiUser) {
        HashMap<Integer, String> userAttrAddi = new HashMap<Integer, String>(5);
        for (AdUserAdditionFieldsModel addFieldId : addAttrUser) {
            userAttrAddi.put(addFieldId.getAdditionalFieldId(), this.getMappedValueFromResponse(addFieldId.getMappedAttribute(), userListMap).toString());
        }
        if (!userAttrAddi.isEmpty()) {
            apiUser.setUserAdditionalAttributes(userAttrAddi);
        }
    }

    private static boolean googleWorkspaceUserValidate(AdServerConfigurationModel serverConfig, String groupId, Set<String> gsuiteMemberUserEmails, Map<String, Object> userListMap, AdUserDetails apiUser) {
        if (serverConfig.getAdProtocolType() == 5) {
            if (!"1".equals(groupId.trim())) {
                if (gsuiteMemberUserEmails.contains(apiUser.getEmailAddress())) {
                    gsuiteMemberUserEmails.remove(apiUser.getEmailAddress());
                } else {
                    return true;
                }
            }
            if (userListMap.get("suspended") != null) {
                apiUser.setAccountSuspended((Boolean)userListMap.get("suspended"));
            }
        }
        return false;
    }

    private boolean validateWhenChanged(AdServerConfigurationModel serverConfig, String groupId, double numLastModifiedDate, AdUserDetails apiUser) {
        String udWhenChanged = apiUser.getUserCreatedDateTime();
        this.logTraceLog("validating user when changed value " + String.valueOf(apiUser));
        if (apiUser.getWhenChanged() != null && !apiUser.getWhenChanged().isBlank()) {
            udWhenChanged = apiUser.getWhenChanged();
        }
        if (udWhenChanged == null) {
            udWhenChanged = "0";
        }
        udWhenChanged = udWhenChanged.replace("-", "").replace(":", "").replace("T", "");
        if (!("1".equals(groupId.trim()) && serverConfig.getAdProtocolType() != 5 && serverConfig.getAdProtocolType() != 4 || serverConfig.getImportType() != 1)) {
            double numberAzAdUserLastModifiedData = Double.parseDouble(udWhenChanged.replace("Z", "").trim());
            return numberAzAdUserLastModifiedData < numLastModifiedDate;
        }
        return false;
    }

    private static String getLastModifiedDate(AdServerConfigurationModel serverConfig, String lastModifiedDate) {
        Object tempLastModifiedDate = serverConfig.getAdProtocolType() != 5 ? lastModifiedDate.substring(0, 4) + "-" + lastModifiedDate.substring(4, 6) + "-" + lastModifiedDate.substring(6, 8) + "T" + lastModifiedDate.substring(8, 10) + ":" + lastModifiedDate.substring(10, 12) + ":" + lastModifiedDate.substring(12) : lastModifiedDate;
        return tempLastModifiedDate;
    }

    private String validateConfig(AdServerConfigurationModel serverConfig) {
        if (serverConfig.getAdProtocolType() == 3 || serverConfig.getAdProtocolType() == 4) {
            return this.validateAzureOneLoginConfig(serverConfig);
        }
        if (serverConfig.getAdProtocolType() == 5) {
            return this.validateGoogleWorkspaceConfig(serverConfig);
        }
        return null;
    }

    private String validateGoogleWorkspaceConfig(AdServerConfigurationModel serverConfig) {
        if (serverConfig.getGsuiteEmail() == null || serverConfig.getGsuiteEmail().trim().isEmpty()) {
            this.logger.error("AD IMPORT : Invalid Google Workspace Email , Please provide the Gsuite Email in the Ldap rule configuration");
            return "FAILURE";
        }
        if (serverConfig.getGsuiteCustomerId() == null || serverConfig.getGsuiteCustomerId().trim().isEmpty()) {
            this.logger.error("AD IMPORT : Invalid Google Workspace Customer Id , Please provide the Gsuite Customer Id in the Ldap rule configuration");
            return "FAILURE";
        }
        if (serverConfig.getGsuiteServiceEmail() == null || serverConfig.getGsuiteServiceEmail().trim().isEmpty()) {
            this.logger.error("AD IMPORT : Invalid Google Workspace Service Email , Please provide the Gsuite Service Email in the Ldap rule configuration");
            return "FAILURE";
        }
        if (serverConfig.getGsuitePrivateKeyId() == null || serverConfig.getGsuitePrivateKeyId().trim().isEmpty()) {
            this.logger.error("AD IMPORT : Invalid Google Workspace Private Key Id, Please provide the Gsuite Private Key Id in the Ldap rule configuration");
            return "FAILURE";
        }
        if (serverConfig.getGsuitePrivateKey() == null || serverConfig.getGsuitePrivateKey().trim().isEmpty()) {
            this.logger.error("AD IMPORT : Invalid Google Workspace Private Key , Please provide the Gsuite Private Key in the Ldap rule configuration");
            return "FAILURE";
        }
        return null;
    }

    private String validateAzureOneLoginConfig(AdServerConfigurationModel serverConfig) {
        if (serverConfig.getAdAppId() == null || serverConfig.getAdAppId().trim().isEmpty()) {
            this.logger.error("AD IMPORT : Invalid App Id , Please provide the App Id in the Ldap rule configuration");
            return "FAILURE";
        }
        if (serverConfig.getAdClientSecretKey() == null || serverConfig.getAdClientSecretKey().trim().isEmpty()) {
            this.logger.error("AD IMPORT : Invalid Secret key , Please provide the Secret key in the Ldap rule configuration");
            return "FAILURE";
        }
        if (serverConfig.getAdProtocolType() == 3 && (serverConfig.getAdDirectoryId() == null || serverConfig.getAdDirectoryId().trim().isEmpty())) {
            this.logger.error("AD IMPORT : Invalid Directory Id , Please provide the Directory Id in the Ldap rule configuration");
            return "FAILURE";
        }
        return null;
    }

    private ApiAuthToken validateAndSetIfApiAuthTokenExpired(AdServerConfigurationModel serverConfig, ApiAuthToken authToken, Connection conn) throws SQLException {
        this.logger.trace("{} Executing 'validateAndSetIfApiAuthTokenExpired' method", (Object)this.className);
        long startTime = System.currentTimeMillis();
        if (authToken == null) {
            authToken = new ApiAuthToken();
        }
        if (this.apiHelper.isBearerTokenExpired(serverConfig)) {
            authToken = this.apiHelper.getBearerAuthToken(serverConfig);
            try (PreparedStatement pst = conn.prepareStatement("update ldapconfigmaster set access_token = ? where LdapConfigMasterID = ?");){
                pst.setString(1, authToken.getAccess_token());
                pst.setInt(2, serverConfig.getLdapConfigMasterId());
                pst.executeUpdate();
            }
        } else {
            authToken.setAccess_token(serverConfig.getAccessToken());
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        this.logger.trace("{} Time taken while executing 'validateAndSetIfApiAuthTokenExpired' method is {} milliseconds", (Object)this.className, (Object)timeTaken);
        return authToken;
    }

    public ApiAuthToken getBearerToken(AdServerConfigurationModel serverConfig) {
        return this.apiHelper.getBearerAuthToken(serverConfig);
    }

    public boolean isBearerTokenExpired(AdServerConfigurationModel serverConfig) {
        return this.apiHelper.isBearerTokenExpired(serverConfig);
    }

    public AdGroupList getGroupList(AdServerConfigurationModel serverConfig) {
        return this.apiHelper.getAdGroupList(serverConfig);
    }

    public AdGroupList getGroupsFromNextLink(AdServerConfigurationModel serverConfig, String nextLink) {
        return this.apiHelper.getGroupsFromNextLink(serverConfig, nextLink);
    }

    public AdGroupDetails getApiGroupByName(AdServerConfigurationModel serverConfig, String groupName) {
        this.logger.trace("{} Executing 'getApiGroupByName' method", (Object)this.className);
        long startTime = System.currentTimeMillis();
        AdGroupDetails azureAdGroup = null;
        if (serverConfig.getAdProtocolType() == 3) {
            azureAdGroup = this.apiHelper.getAdGroupByName(serverConfig, groupName);
        } else {
            List<AdGroupDetails> oneloginGroupListResponse = this.getAllApiAdGroups(serverConfig);
            for (AdGroupDetails adGroup : oneloginGroupListResponse) {
                if (!adGroup.getDisplayName().equals(groupName)) continue;
                azureAdGroup = adGroup;
                break;
            }
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        this.logger.trace("{} Time taken while executing 'getApiGroupByName' method is {} milliseconds", (Object)this.className, (Object)timeTaken);
        return azureAdGroup;
    }

    public List<AdGroupDetails> getAllApiAdGroups(AdServerConfigurationModel serverConfig) {
        this.logger.trace("{} Executing 'getAllApiAdGroups' method", (Object)this.className);
        long startTime = System.currentTimeMillis();
        AdGroupList groupList = this.getGroupList(serverConfig);
        LinkedList<AdGroupDetails> azureGroups = new LinkedList<AdGroupDetails>(groupList.getGroups());
        while (groupList.getNextLink() != null) {
            groupList = this.getGroupsFromNextLink(serverConfig, groupList.getNextLink());
            azureGroups.addAll(groupList.getGroups());
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        this.logger.trace("{} Time taken while executing 'getAllApiAdGroups' method is {} milliseconds", (Object)this.className, (Object)timeTaken);
        return azureGroups;
    }

    public String resetApiUserPassword(AdServerConfigurationModel serverConfig, AdUserDetails azureUser, String newPasswordEncrypted, String aesPath) {
        return this.apiHelper.resetApiUserPassword(serverConfig, azureUser, newPasswordEncrypted, aesPath);
    }

    private Object getMappedValueFromResponse(String mappedAttribute, Map<String, Object> attributeJson) {
        long startTime;
        String mappedValue;
        block9: {
            mappedValue = "";
            this.logger.trace("{} Executing 'getMappedValueFromResponse' method", (Object)this.className);
            startTime = System.currentTimeMillis();
            try {
                if (attributeJson == null) break block9;
                String[] jsonFields = mappedAttribute.replace('.', ' ').split(" ");
                Map attributeMap = null;
                for (String jsonAttribute : jsonFields) {
                    Map map;
                    List list;
                    Object object;
                    if (attributeMap == null) {
                        if (attributeJson.containsKey(jsonAttribute)) {
                            object = attributeJson.get(jsonAttribute);
                            if (object instanceof List) {
                                list = (List)object;
                                attributeMap = (Map)list.get(0);
                                continue;
                            }
                            object = attributeJson.get(jsonAttribute);
                            if (object instanceof Map) {
                                attributeMap = map = (Map)object;
                                continue;
                            }
                            mappedValue = attributeJson.get(jsonAttribute) == null ? "" : attributeJson.get(jsonAttribute);
                            continue;
                        }
                        break;
                    }
                    if (!attributeMap.containsKey(jsonAttribute)) continue;
                    object = attributeMap.get(jsonAttribute);
                    if (object instanceof List) {
                        list = (List)object;
                        attributeMap = (Map)list.get(0);
                        continue;
                    }
                    object = attributeMap.get(jsonAttribute);
                    if (object instanceof Map) {
                        attributeMap = map = (Map)object;
                        continue;
                    }
                    mappedValue = attributeMap.get(jsonAttribute) == null ? "" : attributeMap.get(jsonAttribute);
                }
            }
            catch (Exception exp) {
                this.logger.error("Exception in ApiUserImportService(getMappedValueFromResponse) : {}", (Object)exp.getMessage(), (Object)exp);
            }
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        this.logger.trace("{} Time taken while executing 'getMappedValueFromResponse' method is {} milliseconds", (Object)this.className, (Object)timeTaken);
        return mappedValue;
    }

    private void logTraceLog(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        }
    }
}

