/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.apilogin.util;

import com.sapphireims.user.model.AdServerConfigurationModel;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserApiUtil {
    private static final Log LOGGER = LogFactory.getLog((String)"com.sapphireims.user");

    private UserApiUtil() {
    }

    public static String generateSignedJwt(AdServerConfigurationModel serverModel) {
        String jwtToken = null;
        try {
            PrivateKey privateKey = UserApiUtil.getPrivateKey(serverModel.getGsuitePrivateKey());
            Instant now = Instant.now();
            jwtToken = ((JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)Jwts.builder().header().add((Object)"typ", (Object)"JWT")).add((Object)"kid", (Object)serverModel.getGsuitePrivateKeyId())).and()).claim("iss", (Object)serverModel.getGsuiteServiceEmail()).claim("scope", (Object)"https://www.googleapis.com/auth/admin.directory.user https://www.googleapis.com/auth/admin.directory.group https://www.googleapis.com/auth/admin.directory.group.member").claim("aud", (Object)"https://oauth2.googleapis.com/token").claim("sub", (Object)serverModel.getGsuiteEmail()).issuedAt(Date.from(now)).expiration(Date.from(now.plus(60L, ChronoUnit.MINUTES))).signWith((Key)privateKey, (SecureDigestAlgorithm)Jwts.SIG.RS256).compact();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exp) {
            LOGGER.error((Object)("Exception Occurred in UserApiUtil method : generateSignedJwt : " + exp.getMessage()), (Throwable)exp);
        }
        return jwtToken;
    }

    private static PrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        privateKey = privateKey.replace("\\n", "");
        privateKey = privateKey.replace("-----BEGIN PRIVATE KEY-----", "");
        privateKey = privateKey.replace("-----END PRIVATE KEY-----", "");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
        return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
    }
}

