/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.cloudconnector.jobprocessor;

import com.sapphireims.user.model.JobDetailModel;
import com.sapphireims.user.mysql.JdbCConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class CloudConnectorUserImportJobProcessor {
    private static final Log IMPORT_LOG = LogFactory.getLog((String)"com.sapphireims.user");

    public JobDetailModel checkForUserImportJobEntry(String tenantName) {
        JobDetailModel pendingJobsToProcess = null;
        try (Connection conn = new JdbCConnection().getConnection("ims");){
            String strQuery = "Select co.SNo, co.Type, co.UniqueID, co.GenericData  from cloud_outputdata co Where co.GenericData like '%%SAPP_USERSYNC:%%' AND AliasName = ? order by co.SNo desc limit 1";
            try (PreparedStatement pstmt = conn.prepareStatement(strQuery);){
                pstmt.setString(1, tenantName);
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        String genericData = rs.getString("GenericData");
                        String[] gericDataArr = genericData.split(":");
                        int jobId = NumberUtils.toInt((String)gericDataArr[1]);
                        pendingJobsToProcess = this.getJobDetailMode(jobId, tenantName);
                    }
                }
            }
        }
        catch (Exception e) {
            IMPORT_LOG.error((Object)"Exception Occurred in CloudConnectorUserImportJobProcessor method : checkForUserImportJobEntry :: ", (Throwable)e);
        }
        return pendingJobsToProcess;
    }

    private JobDetailModel getJobDetailMode(int jobId, String tenantName) throws SQLException {
        JobDetailModel jobModel = null;
        try (Connection conn = new JdbCConnection().getConnection(tenantName);){
            String strQuery = " select  jm.SchedularID as SchedularID, jm.JobName as JobName, jd.JobID as jobId from ((jobsmaster jm INNER JOIN jobdetails jd ON jm.SchedularID=jd.SchedularID and jd.JobTypeID=17016 and jd.JobID = ?) INNER JOIN jobsmasterlookup jml ON jm.SchedularID=jml.SchedularID and jml.JobParamID=267)";
            try (PreparedStatement pstmt = conn.prepareStatement(strQuery);){
                pstmt.setInt(1, jobId);
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        jobModel = new JobDetailModel(rs.getInt("jobId"), rs.getInt("SchedularID"), rs.getString("JobName"), true);
                    }
                }
            }
        }
        return jobModel;
    }

    public List<String> getOrganizationalUnitFromCloudOutputDataForJob(int schedularId, String tenantName) throws SQLException {
        ArrayList<String> organizationalUnitList = new ArrayList<String>(5);
        try (Connection conn = new JdbCConnection().getConnection("ims");
             PreparedStatement pstmt = conn.prepareStatement("select GenericData from cloud_outputdata where UniqueID = ? and AliasName = ? and GenericData like ?");){
            pstmt.setInt(1, schedularId);
            pstmt.setString(2, tenantName);
            pstmt.setString(3, "SAPP_OU_NAME:%");
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    String genericData = res.getString("GenericData");
                    if (genericData == null || genericData.trim().isEmpty()) continue;
                    organizationalUnitList.add(genericData.split(":")[1]);
                }
            }
        }
        return organizationalUnitList;
    }
}

