/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.cloudconnector.ldap.service;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sapphire.base64util.Base64;
import com.sapphireims.user.cloudconnector.util.CloudConnectorUserImportUtil;
import com.sapphireims.user.dao.JobConfigurationDao;
import com.sapphireims.user.dao.LdapUserImportDao;
import com.sapphireims.user.ldap.service.LdapSearch;
import com.sapphireims.user.ldap.service.LdapTemplateService;
import com.sapphireims.user.ldap.service.LdapUserImportService;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.AdUserAdditionFieldsModel;
import com.sapphireims.user.model.AdUserDetails;
import com.sapphireims.user.model.JobDetailModel;
import com.sapphireims.user.model.LdapAttributeListingModel;
import com.sapphireims.user.model.ServerCredential;
import com.sapphireims.user.mysql.JdbCConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CloudConnectorLdapService {
    private final LdapUserImportDao userImportDao;
    private final LdapUserImportService ldapUserImportService;
    private final LdapTemplateService ldapTemplateService;
    private final JobConfigurationDao jobConfigurationDao;
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudConnectorLdapService.class);
    private static final String CLOUD_JOBCONFIG_QUERY = "SELECT key, value, FirstColumn FROM cloud_jobconfiguration WHERE GroupID = ? AND SchedulerID = ? AND JobID = ? ";
    private static final String CLOUD_OUTPUTDATA_INSERT_QUERY = "Insert into cloud_outputdata (Type, UniqueID, GenericData) Values (?, ?, ?)";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String FIRST_COLUMN = "FirstColumn";
    private static final String DOLLAR_SAPP = "DOLLAR_SAPP";
    private static final String HASH_SAPP = "HASH_SAPP";
    private static final String SAPP_USERSYNC = "SAPP_USERSYNC";
    private static final String SAPP_OU_NAME = "SAPP_OU_NAME";
    public static final String HTTPS_PREFIX = "https://";
    public static final String HTTP_PREFIX = "http://";
    private static RestTemplate restTemplate = null;

    public CloudConnectorLdapService(LdapUserImportDao userImportDao, LdapTemplateService ldapTemplateService, LdapUserImportService ldapUserImportService, JobConfigurationDao jobConfigurationDao) {
        this.userImportDao = userImportDao;
        this.ldapTemplateService = ldapTemplateService;
        this.ldapUserImportService = ldapUserImportService;
        this.jobConfigurationDao = jobConfigurationDao;
    }

    private void logTraceLog(String message) {
        LOGGER.debug(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importActiveDirectoryUsersFromCloudConnector(JobDetailModel jobDetails, String tenantName, Connection sqlUtilConn, boolean sslStatus, String sapServerIP, int sapPort) {
        try {
            this.updateCloudJobDetailsStatus(jobDetails, 3, sqlUtilConn, tenantName, sslStatus, sapServerIP, sapPort);
            AdServerConfigurationModel ldapConfig = this.getServerConfigurationFromCloudConnector(jobDetails, sqlUtilConn);
            this.setConfigSettingsFromCloudConnector(jobDetails, sqlUtilConn);
            List<LdapAttributeListingModel> ldapAttributesList = this.getAdAttributeFromCloudConnector(jobDetails, sqlUtilConn);
            LOGGER.debug("ldapAttributesList ==================== {}", ldapAttributesList);
            Map<String, Integer> adLdapAttributesMap = this.userImportDao.getDefaultLdapAttributeStatusMap();
            List<AdUserAdditionFieldsModel> addAttrUser = this.getUserAdditionalFieldsFromCloudConnector(jobDetails, sqlUtilConn);
            LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplate(ldapConfig, Boolean.TRUE, null, null, Boolean.TRUE);
            String result = this.importUsersFromCloudConnector(ldapTemplate, ldapConfig, jobDetails, ldapAttributesList, addAttrUser, adLdapAttributesMap, sqlUtilConn);
            if (result.equals("SUCCESS")) {
                ArrayList<Object> paramValues = new ArrayList<Object>();
                paramValues.add("1");
                paramValues.add("" + ldapConfig.getSchedularId());
                paramValues.add("SAPP_USERSYNC:" + jobDetails.getJobId() + ":1:" + tenantName);
                this.userImportDao.executeInsertUpdateSqlQuery(CLOUD_OUTPUTDATA_INSERT_QUERY, paramValues, false, sqlUtilConn);
            }
            this.updateCloudJobDetailsStatus(jobDetails, "SUCCESS".equals(result) ? 1 : -1, sqlUtilConn, tenantName, sslStatus, sapServerIP, sapPort);
        }
        catch (Exception exp) {
            LOGGER.error("Exception in importActiveDirectoryUsersFromCloudConnector {}", (Object)exp.getMessage(), (Object)exp);
        }
        finally {
            if (sqlUtilConn != null) {
                try {
                    sqlUtilConn.close();
                }
                catch (SQLException exp) {
                    LOGGER.error("Exception in importActiveDirectoryUsersFromCloudConnector while closing sqlUtil connection ", (Throwable)exp);
                }
            }
        }
    }

    private List<AdUserAdditionFieldsModel> getUserAdditionalFieldsFromCloudConnector(JobDetailModel jobDetails, Connection sqlUtilConn) throws SQLException {
        ArrayList<AdUserAdditionFieldsModel> additionalFields = new ArrayList<AdUserAdditionFieldsModel>();
        List<Object[]> returnResult = this.getCloudjobConfigData(jobDetails, 4, sqlUtilConn);
        for (int index = 0; index < returnResult.size(); ++index) {
            Object[] row = returnResult.get(index);
            if (NumberUtils.toInt((String)((String)row[2])) != 1) continue;
            AdUserAdditionFieldsModel ldapAddAttributeModel = new AdUserAdditionFieldsModel();
            ldapAddAttributeModel.setAdditionalFieldId(NumberUtils.toInt((String)((String)row[1])));
            ldapAddAttributeModel.setMappedAttribute((String)returnResult.get(index + 1)[1]);
            additionalFields.add(ldapAddAttributeModel);
        }
        return additionalFields;
    }

    public AdServerConfigurationModel getServerConfigurationFromCloudConnector(JobDetailModel jobDetails, Connection sqlUtilConn) throws SQLException {
        AdServerConfigurationModel adServerConfigurationModel = new AdServerConfigurationModel();
        adServerConfigurationModel.setSchedularId(jobDetails.getSchedularId());
        this.setServerCredentialFromCloudConnector(adServerConfigurationModel, jobDetails, sqlUtilConn);
        this.setJobConfigurationFromCloudConnector(adServerConfigurationModel, jobDetails, sqlUtilConn);
        this.setSecondaryServerDetailsFromCloudConnector(adServerConfigurationModel, jobDetails, sqlUtilConn);
        return adServerConfigurationModel;
    }

    private void setServerCredentialFromCloudConnector(AdServerConfigurationModel serverConfig, JobDetailModel jobDetails, Connection sqlUtilConn) throws SQLException {
        List<Object[]> returnResult = this.getCloudjobConfigData(jobDetails, 1, sqlUtilConn);
        ServerCredential serverCred = new ServerCredential();
        block10: for (Object[] row : returnResult) {
            switch ((String)row[0]) {
                case "username": {
                    serverCred.setAdUserName((String)row[1]);
                    continue block10;
                }
                case "password": {
                    serverCred.setAdPassword((String)row[1]);
                    continue block10;
                }
                case "DomainName": {
                    serverCred.setAdDomainName((String)row[1]);
                    continue block10;
                }
            }
            LOGGER.warn("default case of getting details");
        }
        serverConfig.setServerCredential(serverCred);
    }

    private void setJobConfigurationFromCloudConnector(AdServerConfigurationModel serverConfig, JobDetailModel jobDetails, Connection sqlUtilConn) throws SQLException {
        List<Object[]> returnResult = this.getCloudjobConfigData(jobDetails, 2, sqlUtilConn);
        for (int index = 0; index < returnResult.size(); ++index) {
            Object[] row = returnResult.get(index);
            if (NumberUtils.toInt((String)((String)row[2])) != 1) continue;
            int jobParamId = NumberUtils.toInt((String)((String)row[1]));
            row = returnResult.get(index + 2);
            String jobParanValue = (String)row[1];
            this.jobConfigurationDao.setServerConfigJobParams(null, serverConfig, jobDetails.getSchedularId(), jobParamId, jobParanValue, Boolean.TRUE);
        }
    }

    private void setConfigSettingsFromCloudConnector(JobDetailModel jobDetails, Connection sqlUtilConn) throws SQLException {
        List<Object[]> returnResult = this.getCloudjobConfigData(jobDetails, 5, sqlUtilConn);
        for (Object[] row : returnResult) {
            CloudConnectorUserImportUtil.cloudConnectorConfigSettingMap.put((String)row[1], (String)row[2]);
        }
    }

    public void setSecondaryServerDetailsFromCloudConnector(AdServerConfigurationModel serverConfig, JobDetailModel jobDetails, Connection sqlUtilConn) throws SQLException {
        List<Object[]> returnResult = this.getCloudjobConfigData(jobDetails, 7, sqlUtilConn);
        returnResult.forEach(row -> {
            if (row != null && !((String)row[1]).isBlank()) {
                String[] secServerArr = ((String)row[1]).split(";");
                Arrays.stream(secServerArr).forEach(secServer -> {
                    String[] secServerDetails = secServer.split(",");
                    serverConfig.getSecondaryServerCredential().add(new ServerCredential(secServerDetails[0], secServerDetails[1], Base64.decode((String)secServerDetails[2]), secServerDetails[3]));
                });
            }
        });
    }

    public List<LdapAttributeListingModel> getAdAttributeFromCloudConnector(JobDetailModel jobDetails, Connection sqlUtilConn) throws SQLException {
        ArrayList<LdapAttributeListingModel> attributeMapping = new ArrayList<LdapAttributeListingModel>(5);
        List<Object[]> returnResult = this.getCloudjobConfigData(jobDetails, 3, sqlUtilConn);
        for (int index = 0; index < returnResult.size(); ++index) {
            Object[] row = returnResult.get(index);
            if (NumberUtils.toInt((String)((String)row[2])) != 1) continue;
            LdapAttributeListingModel ldapAttributeListingModel = new LdapAttributeListingModel();
            ldapAttributeListingModel.setAdLdapAttribute((String)row[1]);
            if ("ADDisplayAttribute".equals(returnResult.get(index + 1)[0])) {
                ldapAttributeListingModel.setAdDisplayAttribute((String)returnResult.get(index + 1)[1]);
                ldapAttributeListingModel.setIsMandatory(2);
            } else {
                ldapAttributeListingModel.setLdapColumnName((String)returnResult.get(index + 1)[1]);
            }
            ldapAttributeListingModel.setConversionType(NumberUtils.toInt((String)((String)returnResult.get(index + 2)[1]), (int)0));
            ldapAttributeListingModel.setIsConsiderForCollection(1);
            attributeMapping.add(ldapAttributeListingModel);
        }
        return attributeMapping;
    }

    public String importUsersFromCloudConnector(LdapTemplate ldapTemplate, AdServerConfigurationModel ldapConfig, JobDetailModel jobDetails, List<LdapAttributeListingModel> adLdapAttributes, List<AdUserAdditionFieldsModel> addAttrUser, Map<String, Integer> adLdapAttributesMap, Connection sqlUtilConn) {
        try {
            LOGGER.info("AD IMPORT : Started importing Ad users for DomainId {}", (Object)ldapConfig.getSchedularId());
            String maxWhenChanged = this.getWhenChangedFromCloudJobConfig(ldapConfig, jobDetails, sqlUtilConn);
            int scopeLevelUserImport = NumberUtils.toInt((String)CloudConnectorUserImportUtil.cloudConnectorConfigSettingMap.get("LDAP_SCOPE_LEVEL_USERIMPORT"), (int)2);
            String ldapSearchFilter = this.ldapUserImportService.buildLdapFilter(ldapConfig, adLdapAttributes, maxWhenChanged);
            this.logTraceLog(String.format("LDAP User Search filter is %s", ldapSearchFilter));
            SearchControls searchControls = this.ldapUserImportService.getUserImportSearchControls(scopeLevelUserImport, ldapConfig, adLdapAttributes, addAttrUser, adLdapAttributesMap);
            HashSet<String> organizationalUnits = new HashSet<String>(ldapConfig.getOrganizationalUnit());
            LdapContextSource contextSource = this.ldapTemplateService.buildLdapContextSource(ldapConfig, ldapConfig.getServerCredential(), Boolean.TRUE, null, null, Boolean.TRUE);
            for (String organizationalUnit : organizationalUnits) {
                this.logTraceLog(String.format("User importing started for %s  OU ", organizationalUnit));
                if (ldapConfig.getSecondaryServerCredential() != null && !ldapConfig.getSecondaryServerCredential().isEmpty() && this.ldapTemplateService.checkIfADServerDown(contextSource, ldapConfig.getAdServerOperatingSystem())) {
                    for (ServerCredential secondaryServer : ldapConfig.getSecondaryServerCredential()) {
                        contextSource = this.ldapTemplateService.buildLdapContextSource(ldapConfig, secondaryServer, Boolean.TRUE, null, null, Boolean.TRUE);
                    }
                }
                Object tempLdapFilter = ldapSearchFilter;
                if (ldapConfig.getUserImportType() == 2) {
                    if (!ldapConfig.getOuGuids().equals("1")) {
                        tempLdapFilter = ((String)tempLdapFilter).substring(0, ((String)tempLdapFilter).length() - 1);
                        tempLdapFilter = (String)tempLdapFilter + "(&(memberOf=" + organizationalUnit + ")))";
                    }
                    LOGGER.debug("Search filter for importing users using group {}", tempLdapFilter);
                } else {
                    ldapConfig.getOrganizationalUnit().clear();
                    ldapConfig.getOrganizationalUnit().add(organizationalUnit);
                    contextSource.setBase(LdapUserImportService.getOrganisationUnit(organizationalUnit));
                    contextSource.afterPropertiesSet();
                }
                LdapName baseName = new LdapName("");
                int sappUserSyncType = 1;
                ArrayList<Object> paramValues = new ArrayList<Object>();
                paramValues.add("" + sappUserSyncType);
                paramValues.add("" + ldapConfig.getSchedularId());
                paramValues.add("SAPP_OU_NAME:" + organizationalUnit + ":" + ldapConfig.getServerCredential().getAdHostName());
                this.userImportDao.executeInsertUpdateSqlQuery(CLOUD_OUTPUTDATA_INSERT_QUERY, paramValues, false, sqlUtilConn);
                PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(1000);
                LdapSearch ldapSearch = new LdapSearch(baseName, (String)tempLdapFilter, searchControls, adLdapAttributes, null, true, sqlUtilConn);
                ldapSearch.setProcessor(processor);
                ldapSearch.setLdapConfig(ldapConfig);
                ldapSearch.setAdLdapAttributesMap(adLdapAttributesMap);
                ldapSearch.setAddAttrUser(addAttrUser);
                ldapSearch.setUserImportService(this.ldapUserImportService);
                ldapSearch.setUserImportDao(this.userImportDao);
                long userCount = ldapSearch.doWithSingleContext(contextSource, organizationalUnit);
                this.logTraceLog(String.format("User importing completed for %s  OU and total users are %s  ", organizationalUnit, userCount));
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception Occurred in CloudConnectorLdapService method : importUsersFromCloudConnector : {}", (Object)e.getMessage(), (Object)e);
            return "FAILURE";
        }
        return "SUCCESS";
    }

    private String getWhenChangedFromCloudJobConfig(AdServerConfigurationModel ldapConfig, JobDetailModel jobDetails, Connection sqlUtilConn) throws SQLException {
        if (ldapConfig.getImportType() == 1) {
            String query = "select MAX(Value) as outputValue FROM cloud_jobconfiguration WHERE GroupID = ? AND SchedulerID = ? AND JobID = ? AND key = 'WhenChanged'";
            ArrayList<Object> paramValues = new ArrayList<Object>();
            paramValues.add(6);
            paramValues.add(jobDetails.getSchedularId());
            paramValues.add(jobDetails.getJobId());
            return this.userImportDao.getUniqueValueFromSQLQuery(query, paramValues, sqlUtilConn);
        }
        return "";
    }

    public String processCCUsersIntoDatabase(List<String> organizationalUnitList, AdServerConfigurationModel ldapConfig, String tenantName) {
        String userImportResult = "FAILURE";
        ArrayList<Object> queryParamValues = new ArrayList<Object>(5);
        try (Connection conn = new JdbCConnection().getConnection(tenantName);){
            List<LdapAttributeListingModel> adLdapAttributes = this.userImportDao.getAdLdapAttibutes(ldapConfig, tenantName);
            List<AdUserAdditionFieldsModel> addAttrUser = this.userImportDao.getUserAdditionalFields(ldapConfig.getAdProtocolType(), ldapConfig.getAdServerOperatingSystem(), tenantName);
            Map<String, Integer> adLdapAttributesMap = this.userImportDao.getDefaultLdapAttributeStatusMap();
            LdapUserImportService.buildUserAttributes(adLdapAttributesMap, adLdapAttributes, addAttrUser);
            String maxWhenChanged = this.ldapUserImportService.getWhenChanged(queryParamValues, ldapConfig.getSchedularId(), conn);
            long ldapUserTotalCount = 0L;
            for (String organizationalUnit : organizationalUnitList) {
                ArrayList<AdUserDetails> adUserDetailsList = new ArrayList<AdUserDetails>();
                List<Map<String, String>> userAttributeValuePair = this.getUserdetailsFromCloudOutputDataForJob(ldapConfig.getSchedularId(), organizationalUnit, tenantName);
                userAttributeValuePair.stream().forEach(adUserAttrValuePair -> {
                    try {
                        Map<String, Object> adLdapUserAttributeValues = this.ldapUserImportService.mapAdLdapUserAttributeValues(tenantName, adLdapAttributes, adUserAttrValuePair, Boolean.FALSE);
                        AdUserDetails ldapUserModel = this.ldapUserImportService.getAdUserDetails(ldapConfig, adLdapUserAttributeValues);
                        this.ldapUserImportService.processAdditionalAttributes(addAttrUser, adUserAttrValuePair, ldapUserModel);
                        adUserDetailsList.add(ldapUserModel);
                    }
                    catch (NamingException nme) {
                        LOGGER.trace("Exception occurred in CloudConnectorLdapService(processCCUsersIntoDatabase) on mapping ldap attribute value {}", (Object)nme.getMessage());
                    }
                });
                if (!adUserDetailsList.isEmpty()) {
                    this.userImportDao.importAdUsers(adUserDetailsList, ldapConfig.getSchedularId(), ldapConfig, tenantName, adLdapAttributesMap);
                }
                ldapUserTotalCount += (long)adUserDetailsList.size();
            }
            int roleId = ldapConfig.getUserAccessType() == 0 ? 5 : ldapConfig.getUserAccessType();
            this.userImportDao.updateUserRoles(ldapConfig.getSchedularId(), conn, roleId);
            if (roleId != 5) {
                this.userImportDao.updateUserRoles(ldapConfig.getSchedularId(), conn, 5);
            }
            if (ldapUserTotalCount != 0L) {
                this.userImportDao.updateDeletedUsersFromADinDb(ldapConfig.getSchedularId(), ldapConfig.getImportType(), maxWhenChanged, conn);
                this.userImportDao.sendUserImportNotification(ldapConfig, tenantName);
            }
            this.userImportDao.updateUserPresyncStatus(ldapConfig.getSchedularId(), tenantName);
            this.clearUserAndJobEntriesFromCloudOutputData(ldapConfig.getSchedularId());
            LOGGER.info("Status After AD IMPORT :: Domain Id {}, Total No of users {}", (Object)ldapConfig.getSchedularId(), (Object)ldapUserTotalCount);
            userImportResult = "SUCCESS";
        }
        catch (Exception exp) {
            LOGGER.error("Exception occurred in CloudConnectorLdapService(processCCUsersIntoDatabase) {}", (Object)exp.getMessage(), (Object)exp);
        }
        return userImportResult;
    }

    public void clearUserAndJobEntriesFromCloudOutputData(int uniqueId) throws SQLException {
        try (Connection conn = new JdbCConnection().getConnection("ims");
             PreparedStatement pstmt = conn.prepareStatement("Delete from cloud_outputdata where Type = 1 and UniqueID = ?");){
            pstmt.setInt(1, uniqueId);
            pstmt.execute();
        }
    }

    private void updateCloudJobDetailsStatus(JobDetailModel jobDetails, int jobStatus, Connection sqlUtilCon, String tenantName, boolean sslStatus, String sapServerIP, int sapPort) throws SQLException {
        String tempStr = "update cloud_jobdetails set Status = ?, Description = ? where JobID = ? and SchedulerID = ?";
        ArrayList<Object> paramValue = new ArrayList<Object>();
        String jobStatusDescription = switch (jobStatus) {
            case -1 -> "Job failed.";
            case 3 -> "Job processing started.";
            case 1 -> "Job completed successfully.";
            default -> "";
        };
        paramValue.add("" + jobStatus);
        paramValue.add(jobStatusDescription);
        paramValue.add("" + jobDetails.getJobId());
        paramValue.add("" + jobDetails.getSchedularId());
        this.userImportDao.executeInsertUpdateSqlQuery(tempStr, paramValue, false, sqlUtilCon);
        if (jobStatus == -1) {
            this.updateJobFailedStatusInSapphire(sapServerIP, sapPort, tenantName, jobDetails, sslStatus);
        }
    }

    private List<Map<String, String>> getUserdetailsFromCloudOutputDataForJob(int schedularId, String organizationalUnit, String tenantName) throws SQLException {
        ArrayList<Map<String, String>> userDetailsList = new ArrayList<Map<String, String>>(5);
        try (Connection conn = new JdbCConnection().getConnection("ims");
             PreparedStatement pstmt = conn.prepareStatement("select GenericData from cloud_outputdata where UniqueID = ? and AliasName = ? and GenericData like ?");){
            pstmt.setInt(1, schedularId);
            pstmt.setString(2, tenantName);
            pstmt.setString(3, "OUName####" + organizationalUnit + "$$$$%");
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    String genericData = res.getString("GenericData");
                    if (genericData == null || genericData.trim().isEmpty() || genericData.startsWith(SAPP_USERSYNC) || genericData.startsWith(SAPP_OU_NAME)) continue;
                    userDetailsList.add(this.getUserDetailsMapFromGenericData(genericData));
                }
            }
        }
        return userDetailsList;
    }

    private Map<String, String> getUserDetailsMapFromGenericData(String genericData) {
        HashMap<String, String> adUserAttributes = new HashMap<String, String>(10);
        Arrays.stream(genericData.replace("$$$$", DOLLAR_SAPP).split(DOLLAR_SAPP)).forEach(attr -> {
            String[] attributeValuePair = attr.replace("####", HASH_SAPP).split(HASH_SAPP);
            adUserAttributes.put(attributeValuePair[0], attributeValuePair[1]);
        });
        return adUserAttributes;
    }

    private List<Object[]> getCloudjobConfigData(JobDetailModel jobDetails, int jobConfigGroupId, Connection sqlUtilCon) throws SQLException {
        ArrayList<Object> paramValues = new ArrayList<Object>();
        ArrayList<String> columnNames = new ArrayList<String>();
        paramValues.add(jobConfigGroupId);
        paramValues.add(jobDetails.getSchedularId());
        paramValues.add(jobDetails.getJobId());
        columnNames.add(KEY);
        columnNames.add(VALUE);
        columnNames.add(FIRST_COLUMN);
        return this.userImportDao.getListFromSQLQuery(CLOUD_JOBCONFIG_QUERY, columnNames, paramValues, sqlUtilCon);
    }

    private void updateJobFailedStatusInSapphire(String sapServerIP, int sapPort, String tenantName, JobDetailModel jobDetails, boolean sslStatus) {
        if (restTemplate == null) {
            restTemplate = CloudConnectorUserImportUtil.restTemplateInstance();
        }
        ObjectNode jsonNodes = JsonNodeFactory.instance.objectNode();
        jsonNodes.put("JobIDs", jobDetails.getJobId());
        jsonNodes.put("status", -1);
        HttpEntity httpEn = new HttpEntity((Object)jsonNodes, (MultiValueMap)CloudConnectorUserImportUtil.createHeaders("sapphirecloud", "@Sapph!reCloud"));
        String jobDataUrl = (sslStatus ? HTTPS_PREFIX : HTTP_PREFIX) + sapServerIP + ":" + sapPort + "/SapphireIMS/rest/job/updatejobstatus?tenantDB=" + tenantName;
        restTemplate.postForObject(jobDataUrl, (Object)httpEn, Boolean.class, new Object[0]);
    }
}

