/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.controller;

import com.sapphireims.user.apilogin.service.ApiUserImportService;
import com.sapphireims.user.ldap.service.LdapUserImportService;
import com.sapphireims.user.model.AdServerConfigurationModel;
import org.springframework.stereotype.Controller;

@Controller
public class LdapUserImportController {
    private final LdapUserImportService adLdapuserImportService;
    private final ApiUserImportService azureOneloginUserImportService;

    public LdapUserImportController(LdapUserImportService adLdapuserImportService, ApiUserImportService azureOneloginUserImportService) {
        this.adLdapuserImportService = adLdapuserImportService;
        this.azureOneloginUserImportService = azureOneloginUserImportService;
    }

    public String processImportAdUsers(AdServerConfigurationModel ldapConfig, String schema) {
        String result = "FAILURE";
        if (ldapConfig.getAdProtocolType() == 1 || ldapConfig.getAdProtocolType() == 2) {
            result = this.adLdapuserImportService.importUsersFromAD(ldapConfig, schema);
        } else if (ldapConfig.getAdProtocolType() == 3 || ldapConfig.getAdProtocolType() == 4 || ldapConfig.getAdProtocolType() == 5) {
            result = this.azureOneloginUserImportService.importUsersFromAD(ldapConfig, schema);
        }
        return result;
    }
}

