/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.dao;

import com.sapphire.security.encryption.EncryptionUtil;
import com.sapphireims.user.ldap.service.PasswordValutService;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.ServerCredential;
import com.sapphireims.user.util.SapphireUserImportUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JobConfigurationDao {
    private static final int AD_HOSTNAME = 262;
    private static final int AD_OPERATING_SYSTEM = 263;
    private static final int AD_IMPORT_TYPE = 264;
    private static final int AD_SERVER_SSL_ENABLED = 265;
    private static final int AD_SERVER_PORT = 266;
    private static final int AD_PROTOCOL_TYPE = 267;
    private static final int AD_LDAP_FILTER = 268;
    private static final int AD_DOMAIN_FULLNAME = 269;
    private static final int AD_SCHEDULAR_ID = 270;
    private static final int AD_ORGANIZATIONAL_UNIT = 271;
    private static final int AD_IMPORT_OU_GUIDS = 275;
    private static final int AD_USER_ACCESS_TYPE = 289;
    private static final int AD_LDAP_RULE_ID = 339;
    private static final int AD_IMPORT_CUSTOM_OU = 346;
    private static final int AD_LDAP_LANGUAGE_CODE = 482;
    private static final int AD_USER_IS_IMAGEIMPORT_ENABLED = 582;
    private static final int AD_USER_IMPORT_GROUP = 602;
    private PasswordValutService passwordValutService;
    private static final Log LOGGER = LogFactory.getLog((String)"com.sapphireims.user");

    @Autowired
    public void setPasswordValutService(PasswordValutService passwordValutService) {
        this.passwordValutService = passwordValutService;
    }

    private void logTraceLog(String message) {
        LOGGER.trace((Object)message);
    }

    public void setJobProcessModelData(AdServerConfigurationModel adServerData, int schedularId, Connection conn) throws SQLException {
        this.logTraceLog(String.format("getting the AD configuration and notification details for scheduler Id %s", schedularId));
        String strQuery = "select JobParamID, JobParamValue from jobsmasterlookup where SchedularID = ?";
        try (PreparedStatement pstmt = conn.prepareStatement(strQuery);){
            pstmt.setInt(1, schedularId);
            try (ResultSet rs = pstmt.executeQuery();){
                if (adServerData.getServerCredential() == null) {
                    adServerData.setServerCredential(new ServerCredential());
                }
                while (rs.next()) {
                    this.handleResultSet(adServerData, schedularId, conn, rs);
                }
            }
        }
        pstmt = conn.prepareStatement("select ProfileValues, ProfileID from imsprofilevalues where profileid=(select profileid from imsprofilevalues where ProfileValues=? and ColumnID=137) and ColumnID=138");
        try {
            pstmt.setInt(1, adServerData.getSchedularId());
            try (ResultSet res = pstmt.executeQuery();){
                if (res.next()) {
                    adServerData.setUserNotifyProfileId(res.getInt("ProfileID"));
                    adServerData.setNotifyDetailsId(res.getInt("ProfileValues"));
                }
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    private void handleResultSet(AdServerConfigurationModel adServerData, int schedularId, Connection conn, ResultSet rs) throws SQLException {
        int jobParamId = rs.getInt("JobParamID");
        String jobParamValue = rs.getString("JobParamValue");
        if (jobParamValue == null) {
            jobParamValue = "";
        }
        this.setServerConfigJobParams(conn, adServerData, schedularId, jobParamId, jobParamValue, Boolean.FALSE);
    }

    public void setServerConfigJobParams(Connection conn, AdServerConfigurationModel adServerData, int schedularId, int jobParamId, String jobParamValue, boolean ccUserImportJob) throws SQLException {
        switch (jobParamId) {
            case 262: {
                adServerData.getServerCredential().setAdHostName(jobParamValue);
                break;
            }
            case 263: {
                adServerData.setAdServerOperatingSystem(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 264: {
                adServerData.setImportType(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 265: {
                adServerData.setIsSSLEnabled(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 266: {
                adServerData.setPortNumber(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 267: {
                adServerData.setAdProtocolType(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 268: {
                adServerData.setLdapFilter(jobParamValue);
                break;
            }
            case 269: {
                adServerData.setAdDomainFullName(jobParamValue);
                break;
            }
            case 271: {
                if (ccUserImportJob) {
                    adServerData.getOrganizationalUnit().addAll(List.of(jobParamValue.split(";")));
                    break;
                }
                this.handleOrganizationUnit(adServerData, schedularId, conn);
                break;
            }
            case 275: {
                adServerData.setOuGuids(jobParamValue);
                break;
            }
            case 289: {
                adServerData.setUserAccessType(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 339: {
                adServerData.setLdapConfigMasterId(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 346: {
                adServerData.setCustomOu(jobParamValue);
                break;
            }
            case 482: {
                adServerData.setLanguageCode(jobParamValue);
                break;
            }
            case 582: {
                adServerData.setIsImageImportEnabled(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 270: {
                adServerData.setSchedularId(NumberUtils.toInt((String)jobParamValue));
                break;
            }
            case 602: {
                adServerData.setUserImportType(NumberUtils.toInt((String)jobParamValue, (int)1));
                break;
            }
        }
    }

    private void handleOrganizationUnit(AdServerConfigurationModel adServerData, int schedularId, Connection conn) throws SQLException {
        try (PreparedStatement pstOu = conn.prepareStatement("select ipv.ProfileValues as selectedOu from imsprofilevalues ipv where ipv.ColumnID = 447 and ipv.ProfileID IN (Select jml.JobParamValue from jobsmasterlookup jml where jml.SchedularID = ? and jml.JobParamID = 271)");){
            pstOu.setInt(1, schedularId);
            try (ResultSet resOu = pstOu.executeQuery();){
                while (resOu.next()) {
                    adServerData.getOrganizationalUnit().add(resOu.getString("selectedOu"));
                }
            }
        }
    }

    public int getCredentialProfileId(Connection conn, AdServerConfigurationModel adServerData) throws SQLException {
        String strQuery = "select CredentialProfileId from jobsmasterdetail where SchedularID = ?";
        this.logTraceLog(String.format("getting the credential profile details for scheduler id %s", adServerData.getSchedularId()));
        try (PreparedStatement pstmt = conn.prepareStatement(strQuery);){
            pstmt.setInt(1, adServerData.getSchedularId());
            try (ResultSet rs = pstmt.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt("CredentialProfileId");
                    return n;
                }
            }
        }
        return 0;
    }

    public void setAdServerConfigurationDetails(AdServerConfigurationModel adServerData, Connection conn, String tenantName) throws SQLException {
        if (adServerData.getAdProtocolType() == 1 || adServerData.getAdProtocolType() == 2) {
            ServerCredential serverCredential = adServerData.getServerCredential();
            if (serverCredential == null) {
                serverCredential = new ServerCredential();
            }
            this.setServerCredentials(conn, serverCredential, adServerData.getAdServerOperatingSystem(), adServerData.getCredentialProfileID(), tenantName);
            String query = "SELECT HostName, CredentialProfileID FROM ldap_secondary_server_details WHERE LdapConfigMasterID = ?";
            try (PreparedStatement pstmt = conn.prepareStatement(query);){
                pstmt.setInt(1, adServerData.getLdapConfigMasterId());
                try (ResultSet res = pstmt.executeQuery();){
                    List<ServerCredential> secondaryServers = adServerData.getSecondaryServerCredential();
                    if (secondaryServers == null) {
                        secondaryServers = new ArrayList<ServerCredential>(5);
                    }
                    while (res.next()) {
                        ServerCredential secondaryServer = new ServerCredential();
                        secondaryServer.setAdHostName(res.getString("HostName"));
                        int secondaryCredentialId = res.getInt("CredentialProfileID");
                        this.setServerCredentials(conn, secondaryServer, adServerData.getAdServerOperatingSystem(), secondaryCredentialId, tenantName);
                        secondaryServers.add(secondaryServer);
                    }
                }
            }
        }
        try (PreparedStatement pstmt = conn.prepareStatement("select IsDefaultMapping, app_ID, Secret_Key, Directory_ID, access_token,gsuite_email, customer_id, service_email, privatekey_id, private_key from ldapconfigmaster where LdapConfigMasterID = ?");){
            pstmt.setInt(1, adServerData.getLdapConfigMasterId());
            try (ResultSet rs = pstmt.executeQuery();){
                if (rs.next()) {
                    adServerData.setDefaultMapping(rs.getInt("IsDefaultMapping"));
                    adServerData.setAdAppId(rs.getString("app_ID"));
                    adServerData.setAdClientSecretKey(rs.getString("Secret_Key"));
                    adServerData.setAdDirectoryId(rs.getString("Directory_ID"));
                    adServerData.setAccessToken(rs.getString("access_token"));
                    adServerData.setGsuiteEmail(rs.getString("gsuite_email"));
                    adServerData.setGsuiteCustomerId(rs.getString("customer_id"));
                    adServerData.setGsuiteServiceEmail(rs.getString("service_email"));
                    adServerData.setGsuitePrivateKeyId(rs.getString("privatekey_id"));
                    adServerData.setGsuitePrivateKey(rs.getString("private_key"));
                    adServerData.setAccessToken(rs.getString("access_token"));
                }
            }
        }
    }

    private void setServerCredentials(Connection conn, ServerCredential serverCredential, int operatingSystem, int credentialProfileId, String tenantName) throws SQLException {
        int userNameColumnId = 5;
        int passwordColumnId = 6;
        if (operatingSystem == 1) {
            userNameColumnId = 115;
            passwordColumnId = 116;
        }
        String query = "select (SELECT profilevalues FROM imsprofilevalues where columnid =? and profileid =? and SiteID=1) as username,(SELECT profilevalues FROM imsprofilevalues where columnid = ? and profileid =? and SiteID=1) as password, (SELECT  ProfileValues FROM imsprofilevalues where columnid = 30 and SiteID=1 and profileid in (SELECT  ProfileValues FROM imsprofilevalues where columnid =8 and profileid =? and SiteID=1)) as DomainName";
        try (PreparedStatement pstmt = conn.prepareStatement(query);){
            pstmt.setInt(1, userNameColumnId);
            pstmt.setInt(2, credentialProfileId);
            pstmt.setInt(3, passwordColumnId);
            pstmt.setInt(4, credentialProfileId);
            pstmt.setInt(5, credentialProfileId);
            try (ResultSet rs = pstmt.executeQuery();){
                if (rs.next()) {
                    serverCredential.setAdUserName(rs.getString("username"));
                    serverCredential.setAdPassword(rs.getString("password"));
                    serverCredential.setAdDomainName(rs.getString("DomainName"));
                }
            }
        }
        int passwordVaultType = NumberUtils.toInt((String)SapphireUserImportUtil.configSettingMap.get(tenantName).get("PASSWORDVAULT_INTEGRATION"), (int)0);
        if (passwordVaultType == 1) {
            int passwordVaultId = 0;
            try (PreparedStatement pst = conn.prepareStatement("select vault_profileid from password_vault_integration where profile_type = 0 and profileid = ? and siteid = 1");){
                pst.setInt(1, credentialProfileId);
                try (ResultSet rs = pst.executeQuery();){
                    if (rs.next()) {
                        passwordVaultId = rs.getInt("vault_profileid");
                    }
                }
            }
            Map<String, Object> mapData = this.passwordValutService.getPasswordFromVault(conn, passwordVaultId, passwordVaultType, tenantName);
            if (mapData != null && (Integer)mapData.get("status") == 200) {
                serverCredential.setAdUserName((String)mapData.get("userName"));
                serverCredential.setAdPassword(EncryptionUtil.encrypt((String)SapphireUserImportUtil.getAesPath(tenantName), (String)((String)mapData.get("content"))));
            }
        }
    }

    public void updateJobStatus(Integer jobId, Connection conn, int jobStatus, String jobStatusDescriptionSuccess, String jobStatusDescriptionFailed) throws SQLException {
        String strQuery = "update jobdetails set FinishedTime = now(), StatusDescription = ?, Status = ? where JobTypeID = 17016 and JobID = ?";
        this.logTraceLog(String.format("updating the job status in jobdetails table :: update jobdetails set FinishedTime = %s, StatusDescription = %s, Status = %s where JobTypeID = 17016 and JobId = %s", new java.sql.Date(new Date().getTime()), jobStatus == 1 ? jobStatusDescriptionSuccess : jobStatusDescriptionFailed, jobStatus, jobId));
        try (PreparedStatement pstmt = conn.prepareStatement(strQuery);){
            pstmt.setString(1, jobStatus == 1 ? jobStatusDescriptionSuccess : jobStatusDescriptionFailed);
            pstmt.setInt(2, jobStatus);
            pstmt.setInt(3, jobId);
            pstmt.executeUpdate();
        }
    }
}

