/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.dao;

import com.sapphire.security.encryption.EncryptionUtil;
import com.sapphireims.user.dao.UserAuditLogDao;
import com.sapphireims.user.ldap.service.LdapOuService;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.AdUserAdditionFieldsModel;
import com.sapphireims.user.model.AdUserDetails;
import com.sapphireims.user.model.LdapAttributeListingModel;
import com.sapphireims.user.model.UserAuditlogConfigDetail;
import com.sapphireims.user.model.UserNotificationModel;
import com.sapphireims.user.mysql.JdbCConnection;
import com.sapphireims.user.util.SapphireUserImportUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class LdapUserImportDao {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.sapphireims.user");
    public static final String EMPTY_DATE = "0000-00-00 00:00:00";
    private static final int BATCH_COUNT = 25;
    private static final int ACTIVE_USER_STATUS = 0;
    private static final int MERGED_USER_STATUS = 103;
    private static final int UNLICENSED_USER_STATUS = 3;
    private static final int DISABLED_USER_STATUS = 1;
    private static final int DELETED_USER_STATUS = 2;
    private static final String ONELOGIN_DEFAULT_DOMAIN_NAME = "ONELOGIN";
    private static final String MOBILENUMBER_REGEX = "^(\\+\\d{1,3}( )?)?((\\(\\d{3}\\))|\\d{3})[- .]?\\d{3}[- .]?\\d{4}$|^(\\+\\d{1,3}( )?)?(\\d{3}[ ]?){2}\\d{3}$|^(\\+\\d{1,3}( )?)?(\\d{3}[ ]?)(\\d{2}[ ]?){2}\\d{2}$|^\\d{12}$";
    public static final String USER_STATUS_PROPERTY = "userstatus";
    public static final String LDAP_SETTING_VALUE = "SettingValue";
    public static final String LDAP_ORGANIZATION_UNIT = "$$OU$$";
    public static final String DOMAINNAME = "domainname";
    private static final Map<String, Set<I18nRecord>> I18N_LANGUAGE = new ConcurrentHashMap<String, Set<I18nRecord>>(1);
    private static final Map<String, Map<String, Integer>> LOCATION_CACHE = new ConcurrentHashMap<String, Map<String, Integer>>(1);
    private static final Map<String, Map<String, Integer>> DEPARTMENT_CACHE = new ConcurrentHashMap<String, Map<String, Integer>>(1);

    public String importAdUsers(List<AdUserDetails> activeDirectoryUsers, int domainId, AdServerConfigurationModel ldapConfig, String schema, Map<String, Integer> adLdapAttributes) {
        Instant start = Instant.now();
        String result = "SUCCESS";
        ArrayList<Object> queryParamValues = new ArrayList<Object>(5);
        int noOfUsersImported = 0;
        int noOfUsersUpdated = 0;
        int noOfConflictUsers = 0;
        ArrayList<UserAuditlogConfigDetail> userAuditConfigList = new ArrayList<UserAuditlogConfigDetail>();
        try (Connection conn = new JdbCConnection().getConnection(schema);
             PreparedStatement updateConflictUser = conn.prepareStatement("update conflictuserdetails set UserStatus = ?, domainname = ?, DomainID = ?, FullName = ?, EmailAddress = ?, Cell_No = ?, Wing = ?, EmployeeID = ?, City = ?, TelephoneNumber = ?, userprincipalname = ?, whenChanged = ?, OUName = ?, Server = ?, BaseDN = ?, LocationID = ?, DepartmentID = ?, AccountExpireDate = ?, IsAccountLocked = ?, BadLoginCount = ?, DeletionAllowed=?, AD_Password_Reset_Time = ?, AD_Password_Never_Expires = ?  where UserName = ? AND DomainID = ? AND Guid = ?");
             PreparedStatement insertConflictUser = conn.prepareStatement("INSERT INTO conflictuserdetails (UserName,Password,domainname,DomainID,UserStatus,Guid,FullName,EmailAddress,Cell_No,Wing,EmployeeID,City,TelephoneNumber,userprincipalname,whenChanged, OUName, Server, BaseDN, LocationID, DepartmentID, DeletionAllowed, AccountExpireDate, IsAccountLocked, BadLoginCount, AD_Password_Reset_Time,AD_Password_Never_Expires) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
             PreparedStatement insertUserDetails = conn.prepareStatement("insert into userdetails(UserName,Password,SystemID,DomainID,domainname,UserStatus, Guid,UserPreSyncStatus, whenChanged, OUName, Server, DeletionAllowed,AD_Password_Reset_Time,AD_Password_Never_Expires) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)", 1);
             PreparedStatement insertUserManagement = conn.prepareStatement("insert into usermgmt_master (UserID, FullName, EmailAddress, Cell_No, AccessID, EmployeeID, Wing, TelephoneNumber, City, userprincipalname, BaseDN, AccountExpireDate, IsAccountLocked, BadLoginCount, DepartmentID, LocationID) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
             PreparedStatement updateUserManagement = conn.prepareStatement("update usermgmt_master set  FullName = ?, EmailAddress = ?, Cell_No = ?, AccessID = ?, EmployeeID = ?, Wing= ?, TelephoneNumber = ?, City = ?, userprincipalname = ?, BaseDN = ?, AccountExpireDate = ?, IsAccountLocked = ?, BadLoginCount = ?, DepartmentID = ?, LocationID = ? where UserID = ?");
             PreparedStatement updateUserDetails = conn.prepareStatement("update userdetails set DomainID = ?, domainname = ?,Guid = ?,whenChanged = ?,OUName = ?, Server = ?, DeletionAllowed = ?, UserStatus = ?, AD_Password_Reset_Time = ?, AD_Password_Never_Expires = ? where UserID = ?");
             PreparedStatement insertServiceRequest = conn.prepareStatement("insert into servicereqmaster_lookup (UserName, ColLookup, PreferredContactMethod, Language) values (?, ?, ?, ?)");
             PreparedStatement updateServiceRequest = conn.prepareStatement("update servicereqmaster_lookup set Language = ? where UserName = ?");){
            String strQuery = "select count(userId)-8 as outputValue from userdetails where UserStatus=0";
            int totalUsersImported = NumberUtils.toInt((String)this.getUniqueValueFromSQLQuery(strQuery, queryParamValues, conn), (int)0);
            int restrictLocationDepartment = NumberUtils.toInt((String)SapphireUserImportUtil.configSettingMap.get(schema).get("RESTRICT_LOCATION_AND_DEPARTMENT_INFO_FROM_ADSYNC"), (int)0);
            this.logTraceLog("update location and department restriction setting values is " + restrictLocationDepartment);
            int updatedConflictUserBatchCount = 0;
            int insertedConflictUserBatchCount = 0;
            int updatedUserBatchCount = 0;
            int insertUserManagementBatchCount = 0;
            int serviceRequestBatchCount = 0;
            int serviceRequestBatchCountForUpdate = 0;
            int userAccessType = ldapConfig.getUserAccessType();
            for (AdUserDetails adUser : activeDirectoryUsers) {
                boolean isNewUser = true;
                boolean isConflictedUser = false;
                try {
                    int udDeletionAllowed = 1;
                    int isUserDisabled = this.getUserDisabledStatus(ldapConfig, adUser);
                    this.processUserFields(adUser, ldapConfig, totalUsersImported, conn, isUserDisabled, restrictLocationDepartment, schema);
                    String udUserPassword = EncryptionUtil.getHashedPassword((String)adUser.getUserName().trim().replace(" ", ""));
                    Map<Integer, String> userAdditionalFiledIdValues = adUser.getUserAdditionalAttributes();
                    AdUserDetails userDetailsDataFromDb = null;
                    boolean isApiUserImported = LdapUserImportDao.isApiUserImported(ldapConfig, conn, adUser);
                    if (isApiUserImported) {
                        isNewUser = false;
                        userAccessType = adUser.getUserAccessType();
                    } else {
                        strQuery = "select ud.userId,ud.userName, ud.DomainID, ud.domainname, ud.Guid, ud.whenChanged, ud.OUName, ud.Server, ud.UserStatus,um.FullName,um.EmailAddress,um.Cell_No,um.AccessID,um.EmployeeID,um.Wing, um.TelephoneNumber,um.City,um.userprincipalname,um.BaseDN,um.AccountExpireDate,um.IsAccountLocked,um.BadLoginCount,um.DepartmentID,um.LocationID,ud.ad_password_reset_time,ud.ad_password_never_expires from userdetails ud inner join usermgmt_master um on ud.userid = um.userid and ud.username = ? and ud.DomainID <> 0";
                        ArrayList<Object> queryParams = new ArrayList<Object>();
                        queryParams.add(adUser.getUserName());
                        userDetailsDataFromDb = this.getAdUserDetailsFromQuery(strQuery, 0, queryParams, conn);
                    }
                    if (userDetailsDataFromDb != null) {
                        adUser.setUserId(userDetailsDataFromDb.getUserId());
                        userAccessType = userDetailsDataFromDb.getUserAccessType();
                        String tempDbUserGuid = userDetailsDataFromDb.getGuid();
                        strQuery = "select UserName as outputValue from conflictusermergedetails where UserName = ? AND Guid = ?";
                        queryParamValues.clear();
                        queryParamValues.add(adUser.getUserName());
                        queryParamValues.add(adUser.getGuid());
                        String strQueryResult = this.getUniqueValueFromSQLQuery(strQuery, queryParamValues, conn);
                        if (strQueryResult != null && !strQueryResult.isEmpty()) {
                            adUser.setUserProfilePhotoByteArr(null);
                            queryParamValues.clear();
                            this.updateUserDeleationStatus(conn, adUser.getUserName(), adUser.getDomainName());
                            LOG.info("{} user is merged so updating the user details skipped ", (Object)adUser.getUserName());
                            continue;
                        }
                        if (!adUser.getGuid().equals(tempDbUserGuid)) {
                            isConflictedUser = true;
                            ++noOfConflictUsers;
                            strQuery = "select userName,DomainID,  domainname,  Guid,  whenChanged,  OUName,  Server,  UserStatus, FullName, EmailAddress, Cell_No, EmployeeID, Wing,  TelephoneNumber, City, userprincipalname, BaseDN, AccountExpireDate, IsAccountLocked, BadLoginCount, DepartmentID, LocationID,ad_password_reset_time,ad_password_never_expires from conflictuserdetails where UserName = ? AND Guid = ?";
                            ArrayList<Object> queryParams = new ArrayList<Object>();
                            queryParams.add(adUser.getUserName());
                            queryParams.add(adUser.getGuid());
                            AdUserDetails conflictedUserDetailDb = this.getAdUserDetailsFromQuery(strQuery, 1, queryParams, conn);
                            if (conflictedUserDetailDb != null) {
                                ++updatedConflictUserBatchCount;
                                LOG.info("{} user is conflicted and updating user details conflictuserdetails table ", (Object)adUser.getUserName());
                                this.mergeAdUserDetailsWithDbUser(adLdapAttributes, adUser, conflictedUserDetailDb);
                                LdapUserImportDao.updateConflictUserDetails(domainId, ldapConfig, updateConflictUser, adUser, udDeletionAllowed);
                            } else {
                                ++insertedConflictUserBatchCount;
                                LOG.info("{} user is conflicted and inserting user details conflictuserdetails table ", (Object)adUser.getUserName());
                                LdapUserImportDao.insertNewConflictUser(domainId, ldapConfig, insertConflictUser, adUser, udDeletionAllowed, udUserPassword);
                                UserAuditlogConfigDetail userAuditConfig = new UserAuditlogConfigDetail(adUser.getUserId(), "", "", "", "", InetAddress.getLocalHost().getHostAddress(), 4, adUser.getFullName(), 0, "AD User Import");
                                userAuditConfigList.add(userAuditConfig);
                            }
                        }
                        isNewUser = false;
                    }
                    if (!isConflictedUser) {
                        if (isNewUser) {
                            ++noOfUsersImported;
                            this.logTraceLog(String.format("%s user is a new user and inserting  the user details into user tables", adUser.getUserName()));
                            LdapUserImportDao.insertNewUser(domainId, ldapConfig, insertUserDetails, adUser, udUserPassword, conn);
                            LdapUserImportDao.insertNewUserMgmtMaster(adUser, insertUserManagement, userAccessType);
                            ++insertUserManagementBatchCount;
                            this.insertServiceReqMaster(adUser, insertServiceRequest, ldapConfig, schema);
                            ++serviceRequestBatchCount;
                            ++totalUsersImported;
                            UserAuditlogConfigDetail userAuditConfig = new UserAuditlogConfigDetail(adUser.getUserId(), "", "", "", "", InetAddress.getLocalHost().getHostAddress(), 1, adUser.getFullName(), 0, "AD User Import");
                            userAuditConfigList.add(userAuditConfig);
                        } else {
                            ++noOfUsersUpdated;
                            this.logTraceLog(String.format("%s user is already imported  and updating user details ", adUser.getUserName()));
                            this.mergeAdUserDetailsWithDbUser(adLdapAttributes, adUser, userDetailsDataFromDb);
                            if (userDetailsDataFromDb != null) {
                                UserAuditLogDao.userAuditLogCheck(userDetailsDataFromDb, userAccessType, adUser, userAuditConfigList, conn);
                            }
                            LdapUserImportDao.updateUserDetails(domainId, ldapConfig, updateUserManagement, updateUserDetails, userAccessType, adUser, udDeletionAllowed);
                            ++updatedUserBatchCount;
                            this.updateServiceReqMaster(adUser, updateServiceRequest, ldapConfig, schema);
                            ++serviceRequestBatchCountForUpdate;
                        }
                        this.importAdditionalFieldValues(conn, adUser, userAdditionalFiledIdValues, userAuditConfigList, isConflictedUser, isNewUser);
                    }
                    insertUserManagementBatchCount = this.processBatch(insertUserManagement, insertUserManagementBatchCount);
                    serviceRequestBatchCount = this.processBatch(insertServiceRequest, serviceRequestBatchCount);
                    if (userAuditConfigList.size() >= 100) {
                        UserAuditLogDao.insertAuditLog(userAuditConfigList, conn);
                        userAuditConfigList.clear();
                    }
                    if (updatedUserBatchCount == 25) {
                        updateUserDetails.executeBatch();
                        updateUserDetails.clearBatch();
                        updateUserManagement.executeBatch();
                        updateUserManagement.clearBatch();
                        updatedUserBatchCount = 0;
                    }
                    serviceRequestBatchCountForUpdate = this.processBatch(updateServiceRequest, serviceRequestBatchCountForUpdate);
                    updatedConflictUserBatchCount = this.processBatch(updateConflictUser, updatedConflictUserBatchCount);
                    insertedConflictUserBatchCount = this.processBatch(insertConflictUser, insertedConflictUserBatchCount);
                }
                catch (Exception userImportExp) {
                    LOG.error("Exception Occurred while importing user {} , User import skipped for user = {} , guid = {}", new Object[]{adUser.getUserName(), adUser.getUserName(), adUser.getGuid(), userImportExp});
                    noOfUsersImported = this.deleteNewlyAddedUser(queryParamValues, noOfUsersImported, conn, adUser, isNewUser, isConflictedUser);
                }
            }
            if (!userAuditConfigList.isEmpty()) {
                UserAuditLogDao.insertAuditLog(userAuditConfigList, conn);
            }
            this.executeBatchIfNeeded(updateUserDetails, updatedUserBatchCount);
            this.executeBatchIfNeeded(updateConflictUser, updatedConflictUserBatchCount);
            this.executeBatchIfNeeded(insertConflictUser, insertedConflictUserBatchCount);
            this.executeBatchIfNeeded(updateUserManagement, updatedUserBatchCount);
            this.executeBatchIfNeeded(insertUserManagement, insertUserManagementBatchCount);
            this.executeBatchIfNeeded(insertServiceRequest, serviceRequestBatchCount);
            this.executeBatchIfNeeded(updateServiceRequest, serviceRequestBatchCountForUpdate);
            if (ldapConfig.getIsImageImportEnabled() == 1 && ldapConfig.getAdProtocolType() != 4) {
                this.saveAdUsersProfilePhoto(activeDirectoryUsers, domainId, schema);
            }
            Instant end = Instant.now();
            LOG.info("AD IMPORT : Number of Users imported = {}, updated = {}, Conflicted users = {},Time taken  = {} seconds", new Object[]{noOfUsersImported, noOfUsersUpdated, noOfConflictUsers, Duration.between(start, end).getSeconds()});
        }
        catch (Exception e) {
            result = "FAILURE";
            LOG.error("Exception Occurred in LdapUserImportDao method : importAdUsers :: {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private int processBatch(PreparedStatement statement, int batchSize) throws SQLException {
        if (batchSize == 25) {
            statement.executeBatch();
            statement.clearBatch();
            return 0;
        }
        return batchSize;
    }

    private void executeBatchIfNeeded(PreparedStatement statement, int batchCount) throws SQLException {
        if (batchCount > 0) {
            statement.executeBatch();
        }
    }

    private int deleteNewlyAddedUser(List<Object> queryParamValues, int noOfUsersImported, Connection conn, AdUserDetails adUser, boolean isNewUser, boolean isConflictedUser) throws SQLException {
        if (!isConflictedUser && isNewUser && adUser.getUserId() != 0) {
            String strQuery = "delete from userdetails where userid=?";
            queryParamValues.clear();
            queryParamValues.add(String.valueOf(adUser.getUserId()));
            this.executeInsertUpdateSqlQuery(strQuery, queryParamValues, Boolean.FALSE, conn);
            --noOfUsersImported;
        }
        return noOfUsersImported;
    }

    private static void updateConflictUserDetails(int domainId, AdServerConfigurationModel ldapConfig, PreparedStatement updateConflictUser, AdUserDetails adUser, int udDeletionAllowed) throws SQLException {
        updateConflictUser.setInt(1, adUser.getUserStatus());
        updateConflictUser.setString(2, adUser.getDomainName());
        updateConflictUser.setInt(3, domainId);
        updateConflictUser.setString(4, adUser.getFullName());
        updateConflictUser.setString(5, adUser.getEmailAddress());
        updateConflictUser.setString(6, adUser.getCellNo());
        updateConflictUser.setString(7, adUser.getWing());
        updateConflictUser.setString(8, adUser.getEmployeeId());
        updateConflictUser.setString(9, adUser.getCity());
        updateConflictUser.setString(10, adUser.getTelephoneNumber().toString());
        updateConflictUser.setString(11, adUser.getUserPrincipalName());
        updateConflictUser.setString(12, adUser.getWhenChanged());
        updateConflictUser.setString(13, adUser.getOuName());
        updateConflictUser.setString(14, ldapConfig.getServerCredential().getAdUserName());
        updateConflictUser.setString(15, adUser.getBaseDn());
        updateConflictUser.setInt(16, adUser.getLocationId());
        updateConflictUser.setInt(17, adUser.getDepartmentId());
        updateConflictUser.setString(18, adUser.getAccountExpireDate());
        updateConflictUser.setString(19, adUser.getIsAccountLocked());
        updateConflictUser.setInt(20, adUser.getBadLoginCount());
        updateConflictUser.setInt(21, udDeletionAllowed);
        updateConflictUser.setString(22, adUser.getPasswordLastSetTime());
        updateConflictUser.setInt(23, adUser.getPasswordNeverExpires());
        updateConflictUser.setString(24, adUser.getUserName());
        updateConflictUser.setInt(25, domainId);
        updateConflictUser.setString(26, adUser.getGuid());
        updateConflictUser.addBatch();
    }

    private static void insertNewConflictUser(int domainId, AdServerConfigurationModel ldapConfig, PreparedStatement insertConflictUser, AdUserDetails adUser, int udDeletionAllowed, String udUserPassword) throws SQLException {
        insertConflictUser.setString(1, adUser.getUserName());
        insertConflictUser.setString(2, udUserPassword);
        insertConflictUser.setString(3, adUser.getDomainName());
        insertConflictUser.setInt(4, domainId);
        insertConflictUser.setInt(5, adUser.getUserStatus());
        insertConflictUser.setString(6, adUser.getGuid());
        insertConflictUser.setString(7, adUser.getFullName());
        insertConflictUser.setString(8, adUser.getEmailAddress());
        insertConflictUser.setString(9, adUser.getCellNo());
        insertConflictUser.setString(10, adUser.getWing());
        insertConflictUser.setString(11, adUser.getEmployeeId());
        insertConflictUser.setString(12, adUser.getCity());
        insertConflictUser.setString(13, adUser.getTelephoneNumber().toString());
        insertConflictUser.setString(14, adUser.getUserPrincipalName());
        insertConflictUser.setString(15, adUser.getWhenChanged());
        insertConflictUser.setString(16, adUser.getOuName());
        insertConflictUser.setString(17, ldapConfig.getServerCredential().getAdHostName());
        insertConflictUser.setString(18, adUser.getBaseDn());
        insertConflictUser.setInt(19, adUser.getLocationId());
        insertConflictUser.setInt(20, adUser.getDepartmentId());
        insertConflictUser.setInt(21, udDeletionAllowed);
        insertConflictUser.setString(22, adUser.getAccountExpireDate());
        insertConflictUser.setString(23, adUser.getIsAccountLocked());
        insertConflictUser.setInt(24, adUser.getBadLoginCount());
        insertConflictUser.setString(25, adUser.getPasswordLastSetTime());
        insertConflictUser.setInt(26, adUser.getPasswordNeverExpires());
        insertConflictUser.addBatch();
    }

    private static void insertNewUser(int domainId, AdServerConfigurationModel ldapConfig, PreparedStatement insertUserDetails, AdUserDetails adUser, String udUserPassword, Connection connection) throws SQLException {
        try {
            insertUserDetails.setString(1, adUser.getUserName());
            insertUserDetails.setString(2, udUserPassword);
            insertUserDetails.setString(3, "ALL");
            insertUserDetails.setInt(4, domainId);
            insertUserDetails.setString(5, adUser.getDomainName());
            insertUserDetails.setInt(6, adUser.getUserStatus());
            insertUserDetails.setString(7, adUser.getGuid());
            insertUserDetails.setInt(8, -1);
            insertUserDetails.setString(9, adUser.getWhenChanged());
            insertUserDetails.setString(10, adUser.getOuName());
            insertUserDetails.setString(11, ldapConfig.getServerCredential().getAdHostName());
            insertUserDetails.setInt(12, 1);
            insertUserDetails.setString(13, adUser.getPasswordLastSetTime());
            insertUserDetails.setInt(14, adUser.getPasswordNeverExpires());
            insertUserDetails.executeUpdate();
            try (ResultSet res = insertUserDetails.getGeneratedKeys();){
                res.next();
                adUser.setUserId(res.getInt(1));
            }
        }
        catch (SQLIntegrityConstraintViolationException se) {
            LdapUserImportDao.setUserId(adUser, connection, domainId);
            LOG.debug("While inserting user into userdetails exception got {}", (Object)se.getMessage());
        }
    }

    private static void setUserId(AdUserDetails adUser, Connection conn, int domainId) throws SQLException {
        String query = "select UserId from userdetails where UserName= ? and guid=? and DomainId =?";
        try (PreparedStatement ps = conn.prepareStatement(query);){
            ps.setString(1, adUser.getUserName());
            ps.setString(2, adUser.getGuid());
            ps.setInt(3, domainId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    adUser.setUserId(rs.getInt(1));
                }
            }
        }
    }

    private static void insertNewUserMgmtMaster(AdUserDetails adUser, PreparedStatement insertUserManagement, int userAccessType) throws SQLException {
        insertUserManagement.setInt(1, adUser.getUserId());
        insertUserManagement.setString(2, adUser.getFullName());
        insertUserManagement.setString(3, adUser.getEmailAddress());
        insertUserManagement.setString(4, adUser.getCellNo());
        insertUserManagement.setInt(5, userAccessType);
        insertUserManagement.setString(6, adUser.getEmployeeId());
        insertUserManagement.setString(7, adUser.getWing());
        insertUserManagement.setString(8, adUser.getTelephoneNumber().toString());
        insertUserManagement.setString(9, adUser.getCity());
        insertUserManagement.setString(10, adUser.getUserPrincipalName());
        insertUserManagement.setString(11, adUser.getBaseDn());
        insertUserManagement.setString(12, adUser.getAccountExpireDate());
        insertUserManagement.setString(13, adUser.getIsAccountLocked());
        insertUserManagement.setInt(14, adUser.getBadLoginCount());
        insertUserManagement.setInt(15, adUser.getDepartmentId());
        insertUserManagement.setInt(16, adUser.getLocationId());
        insertUserManagement.addBatch();
    }

    private static void updateUserDetails(int domainId, AdServerConfigurationModel ldapConfig, PreparedStatement updateUserManagement, PreparedStatement updateUserDetails, int userAccessType, AdUserDetails adUser, int udDeletionAllowed) throws SQLException {
        updateUserDetails.setInt(1, domainId);
        updateUserDetails.setString(2, adUser.getDomainName());
        updateUserDetails.setString(3, adUser.getGuid());
        updateUserDetails.setString(4, adUser.getWhenChanged());
        updateUserDetails.setString(5, adUser.getOuName());
        updateUserDetails.setString(6, ldapConfig.getServerCredential().getAdHostName());
        updateUserDetails.setInt(7, udDeletionAllowed);
        updateUserDetails.setInt(8, adUser.getUserStatus());
        updateUserDetails.setString(9, adUser.getPasswordLastSetTime());
        updateUserDetails.setInt(10, adUser.getPasswordNeverExpires());
        updateUserDetails.setInt(11, adUser.getUserId());
        updateUserDetails.addBatch();
        updateUserManagement.setString(1, adUser.getFullName());
        updateUserManagement.setString(2, adUser.getEmailAddress());
        updateUserManagement.setString(3, adUser.getCellNo());
        updateUserManagement.setInt(4, userAccessType);
        updateUserManagement.setString(5, adUser.getEmployeeId());
        updateUserManagement.setString(6, adUser.getWing());
        updateUserManagement.setString(7, adUser.getTelephoneNumber().toString());
        updateUserManagement.setString(8, adUser.getCity());
        updateUserManagement.setString(9, adUser.getUserPrincipalName());
        updateUserManagement.setString(10, adUser.getBaseDn());
        updateUserManagement.setString(11, adUser.getAccountExpireDate());
        updateUserManagement.setString(12, adUser.getIsAccountLocked());
        updateUserManagement.setInt(13, adUser.getBadLoginCount());
        updateUserManagement.setInt(14, adUser.getDepartmentId());
        updateUserManagement.setInt(15, adUser.getLocationId());
        updateUserManagement.setInt(16, adUser.getUserId());
        updateUserManagement.addBatch();
    }

    private static boolean isApiUserImported(AdServerConfigurationModel ldapConfig, Connection conn, AdUserDetails adUser) throws SQLException {
        boolean isApiUserImported = false;
        if (ldapConfig.getIsUserImportJob() && (ldapConfig.getAdProtocolType() == 3 || ldapConfig.getAdProtocolType() == 5)) {
            String strQuery1 = "select ud.UserID as userId, um.EmailAddress as emailAddress, um.AccessID as accessId  from userdetails ud, usermgmt_master um where ud.UserID = um.UserID AND ud.UserName = ? AND ud.DomainID = 0";
            try (PreparedStatement pst = conn.prepareStatement(strQuery1);){
                pst.setString(1, adUser.getUserName());
                try (ResultSet res = pst.executeQuery();){
                    if (res.next()) {
                        adUser.setUserId(res.getInt("userId"));
                        adUser.setUserAccessType(res.getInt("accessId"));
                        String tempDBUserEmail = res.getString("emailAddress");
                        if (tempDBUserEmail.equals(adUser.getEmailAddress())) {
                            isApiUserImported = Boolean.TRUE;
                        }
                    }
                }
            }
        }
        return isApiUserImported;
    }

    public void updateDeletedUsersFromADinDb(int domainId, int syncType, String whenChanged, Connection conn) throws SQLException {
        String[] toUpdateTables = new String[]{"userdetails", "conflictuserdetails"};
        Object updateUserStatusQuery = "update MACRO_TABLE_NAME set UserStatus = ? where DomainID = ? and DeletionAllowed = 0";
        String resetDeletionAllowedQuery = "update MACRO_TABLE_NAME set DeletionAllowed = 0 where DomainID = ?";
        if (syncType == 1) {
            updateUserStatusQuery = (String)updateUserStatusQuery + " AND whenChanged >= ?";
        }
        int noOfUsersDeleted = 0;
        for (String toUpdateTable : toUpdateTables) {
            if ("userdetails".equalsIgnoreCase(toUpdateTable)) {
                UserAuditLogDao.insertAuditLogForDeletedUsers(domainId, false, "", conn, syncType, whenChanged, false);
            }
            try (PreparedStatement pst1 = conn.prepareStatement(((String)updateUserStatusQuery).replace("MACRO_TABLE_NAME", toUpdateTable));
                 PreparedStatement pst2 = conn.prepareStatement(resetDeletionAllowedQuery.replace("MACRO_TABLE_NAME", toUpdateTable));){
                pst1.setInt(1, 2);
                pst1.setInt(2, domainId);
                if (syncType == 1) {
                    pst1.setString(3, whenChanged);
                }
                int rowsCount = pst1.executeUpdate();
                if ("userdetails".equalsIgnoreCase(toUpdateTable)) {
                    noOfUsersDeleted = rowsCount;
                }
                pst2.setInt(1, domainId);
                pst2.executeUpdate();
            }
        }
        LOG.info("AD IMPORT : Total Number of Users moved into deleted state = {}", (Object)noOfUsersDeleted);
    }

    public List<LdapAttributeListingModel> getAdLdapAttibutes(AdServerConfigurationModel serverConfig, String schema) {
        ArrayList<LdapAttributeListingModel> adLdapAttributes = new ArrayList<LdapAttributeListingModel>(this.getAdMandatoryAttributes(serverConfig.getAdProtocolType(), serverConfig.getAdServerOperatingSystem(), schema));
        try (Connection conn = new JdbCConnection().getConnection(schema);){
            int ldapConfigMasterId = 1;
            if (serverConfig.getDefaultMapping() == 0) {
                ldapConfigMasterId = serverConfig.getLdapConfigMasterId();
            }
            int sappAdProtocolType = this.getProtocolType(serverConfig.getAdProtocolType(), serverConfig.getAdServerOperatingSystem());
            String query = "select attr.ADDisplayAttribute as adDisplayAttribute, attr.ADLdapAttribute as ldapAttribute, colum.LDAPColumnName as ldapColumnName, attr.ConversionType as conversionType, config.mappingattributeid as mappingAttribute, attr.IsConsiderForCollection as isConsiderForCollection, attr.IsMandatory as isMandarory from ldapattributelisting attr , ldapcolumndetails colum, ldapconfiguration config  where (attr.Attributeid = config.AdAttributeID) and ( colum.Columnid = config.Columnid) and config.LdapConfigMasterID = ? and attr.ProtocolType = ? and attr.IsMandatory != 2";
            try (PreparedStatement pstmt = conn.prepareStatement(query);){
                pstmt.setInt(1, ldapConfigMasterId);
                pstmt.setInt(2, sappAdProtocolType);
                try (ResultSet rs = pstmt.executeQuery();){
                    while (rs.next()) {
                        String adDisplayAttribute = rs.getString("adDisplayAttribute");
                        String ldapAttribute = rs.getString("ldapAttribute");
                        String ldapColumnName = rs.getString("ldapColumnName");
                        int conversionType = rs.getInt("conversionType");
                        int mappingAttribute = rs.getInt("mappingAttribute");
                        int isConsiderForCollection = rs.getInt("isConsiderForCollection");
                        int isMandarory = rs.getInt("isMandarory");
                        LdapAttributeListingModel ldapAttributeModel = new LdapAttributeListingModel(adDisplayAttribute, ldapAttribute, ldapColumnName, conversionType, mappingAttribute, isConsiderForCollection, isMandarory);
                        adLdapAttributes.add(ldapAttributeModel);
                    }
                }
            }
        }
        catch (SQLException exp) {
            adLdapAttributes = null;
            LOG.error("Exception Occurred in LdapUserImportDao method : getAdLdapAttibutes : {}", (Object)exp.getMessage(), (Object)exp);
        }
        return adLdapAttributes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AdUserAdditionFieldsModel> getUserAdditionalFields(int adProtocolType, int osType, String schema) {
        ArrayList<AdUserAdditionFieldsModel> additionalFields = new ArrayList<AdUserAdditionFieldsModel>();
        int sappAdProtocolType = this.getProtocolType(adProtocolType, osType);
        try (Connection conn = new JdbCConnection().getConnection(schema);){
            String query = " select udf.AdditionalFieldID as adFieldId,udfm.MappedAttribute as mappedAttribute, udfm.MappedAttributeID as mappedAttributeId from user_additionalfields udf inner join user_additionalfields_mapping udfm on udf.additionalfieldid = udfm.additionalfieldid where udf.IsFieldToImport = 1 and udfm.protocol_type = ?";
            try (PreparedStatement pstmt = conn.prepareStatement(query);){
                pstmt.setInt(1, sappAdProtocolType);
                try (ResultSet rs = pstmt.executeQuery();){
                    while (rs.next()) {
                        AdUserAdditionFieldsModel additionalField = new AdUserAdditionFieldsModel();
                        additionalField.setAdditionalFieldId(rs.getInt("adFieldId"));
                        additionalField.setMappedAttribute(rs.getString("mappedAttribute"));
                        additionalField.setMappedAttributeId(rs.getString("mappedAttributeId"));
                        additionalFields.add(additionalField);
                        if ("userdefined".equalsIgnoreCase(additionalField.getMappedAttributeId())) continue;
                        query = "SELECT ADDisplayAttribute FROM ldapattributelisting WHERE AttributeID = ?";
                        PreparedStatement childPstmt = conn.prepareStatement(query);
                        try {
                            childPstmt.setInt(1, NumberUtils.toInt((String)additionalField.getMappedAttributeId()));
                            ResultSet innRs = childPstmt.executeQuery();
                            try {
                                if (!innRs.next()) continue;
                                additionalField.setAdDisplayAttribute(innRs.getString("ADDisplayAttribute"));
                            }
                            finally {
                                if (innRs == null) continue;
                                innRs.close();
                            }
                        }
                        finally {
                            if (childPstmt == null) continue;
                            childPstmt.close();
                        }
                    }
                }
            }
            LOG.trace("Total no. of user additional fields: {}", (Object)additionalFields.size());
            return additionalFields;
        }
        catch (SQLException exp) {
            LOG.error("Exception Occurred in LdapUserImportService method : getUserAdditionalFields :: {}", (Object)exp.getMessage(), (Object)exp);
        }
        return additionalFields;
    }

    private List<LdapAttributeListingModel> getAdMandatoryAttributes(Integer ldapConfigProtocolType, Integer osType, String schema) {
        ArrayList<LdapAttributeListingModel> mandatoryFields = new ArrayList<LdapAttributeListingModel>();
        try (Connection conn = new JdbCConnection().getConnection(schema);){
            int adProtocolType = this.getProtocolType(ldapConfigProtocolType, osType);
            String query = "select ADDisplayAttribute, ADLdapAttribute, IsConsiderForCollection from LDAPAttributeListing where IsMandatory = 2 and ProtocolType=?";
            try (PreparedStatement pstmt = conn.prepareStatement(query);){
                pstmt.setInt(1, adProtocolType);
                try (ResultSet rs = pstmt.executeQuery();){
                    while (rs.next()) {
                        mandatoryFields.add(new LdapAttributeListingModel(rs.getString("ADDisplayAttribute"), rs.getString("ADLdapAttribute"), rs.getInt("IsConsiderForCollection"), 2));
                    }
                }
            }
            LOG.trace(" Total no. of mandatory attributes {}", (Object)mandatoryFields.size());
        }
        catch (SQLException exp) {
            LOG.error("Exception Occurred in LdapUserImportService method : getAdMandatoryAttributes :: ", (Throwable)exp);
        }
        return mandatoryFields;
    }

    public String getUniqueValueFromSQLQuery(String query, List<Object> paramValues, Connection conn) throws SQLException {
        String outputValue = "";
        try (PreparedStatement pstmt = conn.prepareStatement(query);){
            this.setParameters(paramValues, pstmt);
            try (ResultSet rs = pstmt.executeQuery();){
                if (rs.next()) {
                    outputValue = rs.getString("outputValue");
                }
            }
        }
        return outputValue;
    }

    private int getProtocolType(Integer ldapConfigProtocolType, Integer osType) {
        int adProtocolType = 1;
        if (ldapConfigProtocolType == 2) {
            if (osType == 1) {
                LOG.debug("Protocol Type is Open-ldap");
                adProtocolType = 2;
            } else {
                LOG.debug("Protocol Type is AD");
            }
        } else if (ldapConfigProtocolType == 3) {
            LOG.debug("Protocol Type is Azure");
            adProtocolType = 4;
        } else if (ldapConfigProtocolType == 4) {
            LOG.debug("Protocol Type is One Login");
            adProtocolType = 5;
        } else if (ldapConfigProtocolType == 5) {
            LOG.debug("Protocol Type is Google Workspace");
            adProtocolType = 6;
        }
        return adProtocolType;
    }

    private void setParameters(List<Object> paramValues, PreparedStatement pstmt) throws SQLException {
        if (paramValues != null && !paramValues.isEmpty()) {
            int paramPos = 1;
            for (Object paramValue : paramValues) {
                if (paramValue instanceof Integer) {
                    Integer val = (Integer)paramValue;
                    pstmt.setInt(paramPos, val);
                } else {
                    pstmt.setString(paramPos, paramValue.toString());
                }
                ++paramPos;
            }
        }
    }

    public int executeInsertUpdateSqlQuery(String query, List<Object> paramValues, boolean returnGenKey, Connection conn) throws SQLException {
        int status;
        block13: {
            status = 0;
            try (PreparedStatement pstmt = conn.prepareStatement(query, 1);){
                this.setParameters(paramValues, pstmt);
                status = pstmt.executeUpdate();
                if (!returnGenKey) break block13;
                try (ResultSet rs = pstmt.getGeneratedKeys();){
                    if (rs.next()) {
                        status = rs.getInt(1);
                    }
                }
            }
        }
        return status;
    }

    public void sendUserImportNotification(AdServerConfigurationModel serverConfigModel, String schema) {
        if (serverConfigModel.getNotifyDetailsId() != 0 && serverConfigModel.getUserNotifyProfileId() != 0 && !serverConfigModel.getIsUserImportJob()) {
            UserNotificationModel userNotifyModel = new UserNotificationModel();
            try (Connection conn = new JdbCConnection().getConnection(schema);){
                try (PreparedStatement pstmt = conn.prepareStatement("select SettingValue, SettingKEY from configsettings where SettingKEY in ('LDAP_USER_STATUS_NOTIFICATION_ENABLED', 'LDAP_USER_STATUS_MAIL_NUMBER')");
                     PreparedStatement pstmt1 = conn.prepareStatement("select EmailSubjectTag,EmailContent from NotificationConfig where NotificationCategoryID = 7 and isActive = 1 and SiteID = 1");){
                    try (ResultSet res = pstmt.executeQuery();){
                        while (res.next()) {
                            String settingKEY = res.getString("SettingKEY");
                            if (settingKEY.equals("LDAP_USER_STATUS_NOTIFICATION_ENABLED")) {
                                userNotifyModel.setEnabledNotificationStatus(res.getInt(LDAP_SETTING_VALUE));
                                continue;
                            }
                            if (!settingKEY.equals("LDAP_USER_STATUS_MAIL_NUMBER")) continue;
                            userNotifyModel.setEmailLimit(res.getInt(LDAP_SETTING_VALUE));
                        }
                    }
                    res = pstmt1.executeQuery();
                    try {
                        if (res.next()) {
                            userNotifyModel.setEmailContent(res.getString("EmailContent"));
                            userNotifyModel.setEmailSubjectTag(res.getString("EmailSubjectTag"));
                        }
                    }
                    finally {
                        if (res != null) {
                            res.close();
                        }
                    }
                }
                this.insertLdapUserNotify(serverConfigModel, userNotifyModel, conn);
            }
            catch (Exception exp) {
                LOG.error("Exception Occurred in LdapUserImportService(sendUserImportNotification) {}", (Object)exp.getMessage(), (Object)exp);
            }
        }
    }

    private void insertLdapUserNotify(AdServerConfigurationModel serverConfigModel, UserNotificationModel userNotifyModel, Connection conn) throws SQLException {
        ArrayList<Map<String, String>> alertUser = new ArrayList<Map<String, String>>(5);
        StringBuilder deletedUserNotify = new StringBuilder();
        StringBuilder disabledUserNotify = new StringBuilder();
        StringBuilder newUserNotify = new StringBuilder();
        HashMap<String, Integer> notifiedCountUpdate = HashMap.newHashMap(5);
        this.getUserDetailsForNotification(serverConfigModel, userNotifyModel, conn, alertUser);
        if (userNotifyModel.getEnabledNotificationStatus() == 1 || userNotifyModel.getEnabledNotificationStatus() == 4 || userNotifyModel.getEnabledNotificationStatus() == 5) {
            this.setNotificationMailBody(2, deletedUserNotify);
        }
        if (userNotifyModel.getEnabledNotificationStatus() == 2 || userNotifyModel.getEnabledNotificationStatus() == 4 || userNotifyModel.getEnabledNotificationStatus() == 5) {
            this.setNotificationMailBody(1, disabledUserNotify);
        }
        if (userNotifyModel.getEnabledNotificationStatus() == 3 || userNotifyModel.getEnabledNotificationStatus() == 5) {
            this.setNotificationMailBody(0, newUserNotify);
        }
        AtomicInteger deletedUserCount = new AtomicInteger();
        AtomicInteger disabledUserCount = new AtomicInteger();
        AtomicInteger newUserCount = new AtomicInteger();
        alertUser.forEach(userdetailsMap -> {
            String userName = (String)userdetailsMap.get("username");
            String ouName = (String)userdetailsMap.get("ouname");
            int userStatus = NumberUtils.toInt((String)((String)userdetailsMap.get(USER_STATUS_PROPERTY)));
            int userPreSyncStatus = NumberUtils.toInt((String)((String)userdetailsMap.get("userpresyncstatus")));
            int notifiedAlertCount = NumberUtils.toInt((String)((String)userdetailsMap.get("notifiedalertcount")));
            String domainName = (String)userdetailsMap.get(DOMAINNAME);
            if (serverConfigModel.getAdProtocolType() == 1 || serverConfigModel.getAdProtocolType() == 2) {
                domainName = LdapOuService.getDomainName(ouName, 1);
            }
            if (userStatus != userPreSyncStatus || notifiedAlertCount < userNotifyModel.getEmailLimit()) {
                if (userStatus == 2) {
                    if (userNotifyModel.getEnabledNotificationStatus() == 1 || userNotifyModel.getEnabledNotificationStatus() == 4 || userNotifyModel.getEnabledNotificationStatus() == 5) {
                        this.setUserDetailsIntoMailBody(deletedUserNotify, userName, ouName, userNotifyModel.getEmailContent(), domainName);
                        deletedUserCount.getAndIncrement();
                    }
                } else if (userStatus == 1) {
                    if (userNotifyModel.getEnabledNotificationStatus() == 2 || userNotifyModel.getEnabledNotificationStatus() == 4 || userNotifyModel.getEnabledNotificationStatus() == 5) {
                        this.setUserDetailsIntoMailBody(disabledUserNotify, userName, ouName, userNotifyModel.getEmailContent(), domainName);
                        disabledUserCount.getAndIncrement();
                    }
                } else if (userPreSyncStatus == -1 && (userNotifyModel.getEnabledNotificationStatus() == 3 || userNotifyModel.getEnabledNotificationStatus() == 5)) {
                    this.setUserDetailsIntoMailBody(newUserNotify, userName, ouName, userNotifyModel.getEmailContent(), domainName);
                    newUserCount.getAndIncrement();
                }
            }
            if (notifiedAlertCount == userNotifyModel.getEmailLimit()) {
                notifiedCountUpdate.put(userName, 1);
            } else {
                notifiedCountUpdate.put(userName, ++notifiedAlertCount);
            }
        });
        this.updateUserNotifiedCount(serverConfigModel.getSchedularId(), notifiedCountUpdate, conn);
        Set<String> receipientEmailList = this.getRecipientsEmailAddress(serverConfigModel, conn);
        String receipientEmails = String.join((CharSequence)",", receipientEmailList);
        if (deletedUserCount.get() > 0) {
            this.insertStatusMail(deletedUserNotify, userNotifyModel.getEmailSubjectTag(), receipientEmails, conn);
        }
        if (disabledUserCount.get() > 0) {
            this.insertStatusMail(disabledUserNotify, userNotifyModel.getEmailSubjectTag(), receipientEmails, conn);
        }
        if (newUserCount.get() > 0) {
            this.insertStatusMail(newUserNotify, userNotifyModel.getEmailSubjectTag(), receipientEmails, conn);
        }
    }

    private void getUserDetailsForNotification(AdServerConfigurationModel serverConfigModel, UserNotificationModel userNotifyModel, Connection conn, List<Map<String, String>> alertUser) throws SQLException {
        StringBuilder alertUserQuery = this.constructAlertUserQuery(userNotifyModel);
        try (PreparedStatement pstmt = conn.prepareStatement(alertUserQuery.toString());){
            pstmt.setInt(1, serverConfigModel.getSchedularId());
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    HashMap<String, String> userDetails = HashMap.newHashMap(5);
                    userDetails.put("username", res.getString("UserName"));
                    userDetails.put("ouname", res.getString("OUName"));
                    userDetails.put(USER_STATUS_PROPERTY, res.getString("UserStatus"));
                    userDetails.put("userpresyncstatus", res.getString("UserPreSyncStatus"));
                    userDetails.put("notifiedalertcount", res.getString("NotifiedAlertCount"));
                    userDetails.put(DOMAINNAME, res.getString(DOMAINNAME));
                    alertUser.add(userDetails);
                }
            }
        }
    }

    private StringBuilder constructAlertUserQuery(UserNotificationModel userNotifyModel) {
        StringBuilder alertUserQuery = new StringBuilder("select UserName,OUName,UserStatus,UserPreSyncStatus,NotifiedAlertCount,domainname from userdetails where DomainID = ?");
        switch (userNotifyModel.getEnabledNotificationStatus()) {
            case 2: {
                alertUserQuery.append(" and UserStatus = 1");
                break;
            }
            case 3: {
                alertUserQuery.append(" and UserStatus = 0 and UserPreSyncStatus = -1");
                break;
            }
            case 4: {
                alertUserQuery.append(" and UserStatus in (2,1)");
                break;
            }
            case 5: {
                alertUserQuery.append(" and UserStatus in (2,1,0)");
                break;
            }
            default: {
                alertUserQuery.append(" and UserStatus = 2");
            }
        }
        return alertUserQuery;
    }

    private void setNotificationMailBody(int enailAlertUserStatus, StringBuilder emailBody) {
        emailBody.append("<html>\n    <body>\n        <table  width='100%' class='sample'>\n            <tr><td>Dear All,</td></tr>\n            <tr><td><br />\n            <tr><td> <br />\n");
        switch (enailAlertUserStatus) {
            case 2: {
                emailBody.append("This notification is to inform you on the deletion of the following users from the AD.");
                break;
            }
            case 1: {
                emailBody.append("This notification is to inform you on the disabling of the following users from the AD.");
                break;
            }
            case 0: {
                emailBody.append("This notification is to inform you on the addition of the following users from the AD.");
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + enailAlertUserStatus);
            }
        }
        emailBody.append("<br /><br /></td></tr>\n<table  width='100%' class='sample', border='1'>\n    <tr><td width='25%'><b> User Name </b></td>\n        <td width='25%'><b> OU </b></td>\n        <td width='25%'><b> Domain </b></td>\n    </tr>\n");
    }

    private void setUserDetailsIntoMailBody(StringBuilder emailBody, String userName, String ouName, String emailContent, String domainName) {
        if (emailContent.contains(LDAP_ORGANIZATION_UNIT)) {
            if (((String)ouName).isEmpty()) {
                ouName = "<br />";
            } else if (((String)ouName).length() >= 64) {
                ouName = ((String)ouName).substring(0, 63) + "<br />";
            }
        }
        emailBody.append("<tr><td width='25%'>");
        emailBody.append(userName);
        emailBody.append("</td><td width='25%'>");
        if (emailContent.contains(LDAP_ORGANIZATION_UNIT)) {
            emailBody.append((String)ouName);
        } else {
            emailBody.append("--");
        }
        emailBody.append("</td><td width='25%'>");
        if (emailContent.contains("$$Domain$$")) {
            emailBody.append(domainName);
        } else {
            emailBody.append("--");
        }
        emailBody.append("</td></tr>");
    }

    private Set<String> getRecipientsEmailAddress(AdServerConfigurationModel serverConfigData, Connection conn) throws SQLException {
        HashSet<String> recipientEmails = new HashSet<String>();
        String userIds = "0";
        String accessIds = "0";
        try (PreparedStatement pstmt = conn.prepareStatement("SELECT AccessIDs, UserIDs from notify_detail where NotifyID = ?");){
            pstmt.setInt(1, serverConfigData.getNotifyDetailsId());
            try (ResultSet res = pstmt.executeQuery();){
                if (res.next()) {
                    userIds = res.getString("UserIDs");
                    accessIds = res.getString("AccessIDs");
                }
            }
        }
        this.getUserEmailIds(userIds, conn, recipientEmails);
        this.getAccessEmailIds(accessIds, conn, recipientEmails);
        return recipientEmails;
    }

    private void insertStatusMail(StringBuilder emailNotifyBody, String emailSubject, String recipients, Connection conn) throws SQLException {
        emailNotifyBody.append("</table></td></tr>");
        emailSubject = emailSubject == null || emailSubject.isEmpty() ? "User status Information" : emailSubject.replace("$$UserName$$", "").replace(LDAP_ORGANIZATION_UNIT, "").replace("$$Domain$$", "");
        try (PreparedStatement master = conn.prepareStatement("insert into Generic_EmailNotifications_Master (Subject, Body, MessageCreatedTime, SentStatus, Retries, MessageScheduledTime, ModuleID, ModuleReferenceID) Values (?,?,NOW(),0,0,NOW(),8,0)", 1);
             PreparedStatement details = conn.prepareStatement("insert into Generic_EmailNotifications_Details (EmailNotificationID, SendTo, Status) Values (?,?,0)");){
            int emailNotificationID;
            master.setString(1, emailSubject);
            master.setString(2, emailNotifyBody.toString());
            master.executeUpdate();
            try (ResultSet res = master.getGeneratedKeys();){
                emailNotificationID = res.next() ? res.getInt(1) : 0;
            }
            details.setInt(1, emailNotificationID);
            details.setString(2, recipients);
            details.executeUpdate();
        }
    }

    public void updateUserPresyncStatus(int domainId, String schema) throws SQLException {
        try (Connection conn = new JdbCConnection().getConnection(schema);
             PreparedStatement pstmt = conn.prepareStatement("Update UserDetails set UserPreSyncStatus = UserStatus where domainID = ?");){
            pstmt.setInt(1, domainId);
            pstmt.executeUpdate();
        }
    }

    public Map<String, String> getSettingKeys(Connection conn) throws SQLException {
        HashMap<String, String> configSettingKeys = HashMap.newHashMap(10);
        String query = "select SettingValue, SettingKEY from configsettings where SettingKEY in\n ('RESTRICT_LOCATION_AND_DEPARTMENT_INFO_FROM_ADSYNC', 'ATTACHMENTSPATH', 'GSS_AUTHENTICATION',\n 'LDAP_OU_LISTING', 'LDAP_CUSTOM_FILTER', 'LDAP_SCOPE_LEVEL_USERIMPORT','MODULES_Enabled',\n 'PASSWORDVAULT_INTEGRATION','AD_PROJECTROLE_REMOVAL')\n";
        try (PreparedStatement pstmt = conn.prepareStatement(query);
             ResultSet res = pstmt.executeQuery();){
            while (res.next()) {
                configSettingKeys.put(res.getString("SettingKEY"), res.getString(LDAP_SETTING_VALUE));
            }
        }
        return configSettingKeys;
    }

    private void updateUserNotifiedCount(int domainId, Map<String, Integer> paramObject, Connection conn) throws SQLException {
        try (PreparedStatement pstmt = conn.prepareStatement("Update UserDetails set NotifiedAlertCount = ? where domainID = ? and UserName = ?");){
            int batchCount = 0;
            for (Map.Entry<String, Integer> entry : paramObject.entrySet()) {
                pstmt.setInt(1, entry.getValue());
                pstmt.setInt(2, domainId);
                pstmt.setString(3, entry.getKey());
                pstmt.addBatch();
                if (++batchCount != 20) continue;
                pstmt.executeBatch();
                pstmt.clearBatch();
                batchCount = 0;
            }
            if (batchCount > 0) {
                pstmt.executeBatch();
            }
        }
    }

    private String getLanguage(AdUserDetails adUser, AdServerConfigurationModel ldapConfig, String schema) {
        String language = adUser.getLanguageCode() != null ? (String)adUser.getLanguageCode() : "en_gb";
        if ((language = this.getLanguageCode(language, schema)).trim().isEmpty()) {
            language = ldapConfig.getLanguageCode() != null && !ldapConfig.getLanguageCode().trim().isEmpty() ? ldapConfig.getLanguageCode() : "en_gb";
        }
        return language;
    }

    private void insertServiceReqMaster(AdUserDetails adUser, PreparedStatement insertServiceRequest, AdServerConfigurationModel ldapConfig, String schema) throws SQLException {
        String language = this.getLanguage(adUser, ldapConfig, schema);
        insertServiceRequest.setString(1, adUser.getUserName());
        insertServiceRequest.setString(2, "ProblemId,Title,Owner,CurrentStatus,CreationTime,SubmittedBy");
        insertServiceRequest.setInt(3, 1);
        insertServiceRequest.setString(4, language);
        insertServiceRequest.addBatch();
    }

    private void updateServiceReqMaster(AdUserDetails adUser, PreparedStatement updateServiceRequest, AdServerConfigurationModel ldapConfig, String schema) throws SQLException {
        String language = this.getLanguage(adUser, ldapConfig, schema);
        updateServiceRequest.setString(1, language);
        updateServiceRequest.setString(2, adUser.getUserName());
        updateServiceRequest.addBatch();
    }

    private void importAdditionalFieldValues(Connection conn, AdUserDetails adUser, Map<Integer, String> userAdditionalFieldIdValues, List<UserAuditlogConfigDetail> userAuditConfigList, boolean isConflictedUser, boolean isNewUser) {
        block8: {
            try {
                this.logTraceLog(String.format("importing/updating user additional Fields for user %s  ", adUser.getUserName()));
                String strQuery = "insert into user_additionalFieldValues(userID, additionalFieldID, additionalFieldValue) values(?, ?, ?)  ON DUPLICATE KEY UPDATE additionalFieldValue = ?";
                if (userAdditionalFieldIdValues == null || userAdditionalFieldIdValues.isEmpty()) break block8;
                for (Map.Entry<Integer, String> entry : userAdditionalFieldIdValues.entrySet()) {
                    String addV = entry.getValue() != null ? entry.getValue() : "";
                    UserAuditLogDao.insertAdditinalFieldToLog(adUser.getUserId(), entry.getKey(), addV, adUser.getFullName(), conn, userAuditConfigList, isConflictedUser, isNewUser);
                    PreparedStatement pstmt = conn.prepareStatement(strQuery);
                    try {
                        pstmt.setInt(1, adUser.getUserId());
                        pstmt.setInt(2, entry.getKey());
                        pstmt.setString(3, addV);
                        pstmt.setString(4, addV);
                        pstmt.executeUpdate();
                    }
                    finally {
                        if (pstmt == null) continue;
                        pstmt.close();
                    }
                }
            }
            catch (Exception uadd) {
                LOG.error("while updating additional values  exception causht  {}", (Object)uadd.getMessage(), (Object)uadd);
            }
        }
    }

    private int determineLocationId(int isUserDisabled, AdUserDetails adUser, int restrictLocationDepartment, Connection conn, String schema) throws SQLException {
        String locationName = adUser.getLocationName();
        int locationId = 1;
        if (locationName != null && !locationName.isEmpty()) {
            if (isUserDisabled == 1 && restrictLocationDepartment == 1) {
                LOG.trace("AD IMPORT : fetched default locationId for user {}", (Object)adUser.getUserName());
            } else {
                Map<String, Integer> locationMap = LOCATION_CACHE.get(schema);
                if (locationMap.containsKey(locationName)) {
                    locationId = locationMap.get(locationName);
                } else {
                    String strQuery = "insert into servicedesklocationmaster(LocationName) values(?)";
                    ArrayList<Object> queryParamValues = new ArrayList<Object>(2);
                    queryParamValues.add(locationName);
                    locationId = this.executeInsertUpdateSqlQuery(strQuery, queryParamValues, true, conn);
                    locationMap.put(locationName, locationId);
                }
                LOG.trace("AD IMPORT : fetched locationId for the location {} for user {}", (Object)locationName, (Object)adUser.getUserName());
            }
        }
        return locationId;
    }

    private int determineDepartmentId(int isUserDisabled, AdUserDetails adUser, int restrictLocationDepartment, Connection conn, String schema) throws SQLException {
        int departmentId = 1;
        String departmentName = adUser.getDepartmentName();
        if (departmentName != null && !departmentName.isEmpty()) {
            if (isUserDisabled == 1 && restrictLocationDepartment == 1) {
                LOG.trace("AD IMPORT : fetched default departmentId for user {}", (Object)adUser.getUserName());
            } else {
                Map<String, Integer> departmentMap = DEPARTMENT_CACHE.get(schema);
                if (departmentMap.containsKey(departmentName)) {
                    departmentId = departmentMap.get(departmentName);
                } else {
                    String strQuery = "insert into departmentmaster(DepartmentName) values(?)";
                    ArrayList<Object> queryParamValues = new ArrayList<Object>(2);
                    queryParamValues.add(departmentName);
                    departmentId = this.executeInsertUpdateSqlQuery(strQuery, queryParamValues, true, conn);
                    departmentMap.put(departmentName, departmentId);
                }
                LOG.trace("AD IMPORT : fetched departmentId for the department {} for user {}", (Object)departmentName, (Object)adUser.getUserName());
            }
        }
        return departmentId;
    }

    private void generateUserName(AdUserDetails adUser, String udUserPrincipalName, AdServerConfigurationModel ldapConfig, Connection conn, String udEmail, String udDomainName) throws SQLException {
        Object userName = adUser.getUserName();
        if (userName == null || ((String)userName).isEmpty()) {
            userName = this.generateInitialUserName(adUser, ldapConfig, udUserPrincipalName);
        }
        UserDbDetails userDetails = this.queryUserDetailsFromDb(conn, (String)userName, adUser);
        LOG.debug("Checking if Username is already exists for username {}", userName);
        if (userDetails != null && udDomainName != null && !udDomainName.trim().isEmpty() && !this.shouldIgnoreDomainSuffix(ldapConfig, userDetails, udEmail, conn, (String)userName, adUser)) {
            this.logTraceLog("AD IMPORT : Ad user " + (String)userName + " is a multi domain User");
            userName = udDomainName + "\\" + (String)userName;
            LOG.debug("User is a multidomain User, updating username as {} ", userName);
        }
        adUser.setUserName((String)userName);
    }

    private boolean shouldIgnoreDomainSuffix(AdServerConfigurationModel ldapConfig, UserDbDetails userDetails, String udEmail, Connection conn, String userName, AdUserDetails adUser) throws SQLException {
        boolean isMultiDomainUser = this.checkIfUserIsMultiDomain(ldapConfig, userDetails, udEmail, conn, userName, adUser);
        if (isMultiDomainUser && userDetails.userStatus == 2) {
            return true;
        }
        return !isMultiDomainUser;
    }

    private String generateInitialUserName(AdUserDetails adUser, AdServerConfigurationModel ldapConfig, String udUserPrincipalName) {
        String tempUserName = ldapConfig.getAdProtocolType() == 5 ? adUser.getEmailAddress() : udUserPrincipalName;
        return tempUserName.substring(0, tempUserName.indexOf("@"));
    }

    private UserDbDetails queryUserDetailsFromDb(Connection conn, String userName, AdUserDetails adUser) throws SQLException {
        String strQuery = "select ud.UserName, ud.DomainID, um.EmailAddress, ud.userstatus from userdetails ud, usermgmt_master um where ud.UserID = um.UserID AND ud.UserName = ? AND ud.Guid <> ? ";
        try (PreparedStatement pst = conn.prepareStatement(strQuery);){
            UserDbDetails userDbDetails;
            block12: {
                pst.setString(1, userName);
                pst.setString(2, adUser.getGuid());
                ResultSet res = pst.executeQuery();
                try {
                    UserDbDetails userDbDetails2 = userDbDetails = res.next() ? new UserDbDetails(res.getString("UserName"), res.getString("EmailAddress"), res.getInt("DomainID"), res.getInt(USER_STATUS_PROPERTY)) : null;
                    if (res == null) break block12;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return userDbDetails;
        }
    }

    private boolean checkIfUserIsMultiDomain(AdServerConfigurationModel ldapConfig, UserDbDetails userDbDetails, String udEmail, Connection conn, String userName, AdUserDetails adUser) throws SQLException {
        boolean isMultiDomainUser = true;
        if (ldapConfig.getIsUserImportJob() && (ldapConfig.getAdProtocolType() == 3 || ldapConfig.getAdProtocolType() == 5) && userDbDetails.domainId == 0 && userDbDetails.emailAddress.equals(udEmail)) {
            isMultiDomainUser = false;
        }
        String strQuery = "select UserName, Guid from conflictuserdetails where UserName = ? AND Guid = ?";
        try (PreparedStatement pst = conn.prepareStatement(strQuery);){
            pst.setString(1, userName);
            pst.setString(2, adUser.getGuid());
            try (ResultSet res = pst.executeQuery();){
                if (res.next()) {
                    isMultiDomainUser = Boolean.FALSE;
                }
            }
        }
        return isMultiDomainUser;
    }

    private String determineDomainName(AdServerConfigurationModel ldapConfig, AdUserDetails adUser, String udUserPrincipalName) {
        String udDomainName = Optional.ofNullable(ldapConfig.getServerCredential().getAdDomainName()).orElse("");
        if (udDomainName.isEmpty() && (udDomainName = Optional.ofNullable(adUser.getDomainName()).orElse("")).isEmpty()) {
            udDomainName = this.getDomainNameBasedOnProtocol(ldapConfig, adUser, udUserPrincipalName, udDomainName);
        }
        return udDomainName;
    }

    private String getDomainNameBasedOnProtocol(AdServerConfigurationModel ldapConfig, AdUserDetails adUser, String udUserPrincipalName, String udDomainName) {
        switch (ldapConfig.getAdProtocolType()) {
            case 4: {
                udDomainName = ONELOGIN_DEFAULT_DOMAIN_NAME;
                break;
            }
            case 3: {
                udDomainName = udUserPrincipalName.isBlank() ? udDomainName : this.parseDomainName(udUserPrincipalName);
                break;
            }
            case 5: {
                udDomainName = adUser.getEmailAddress().isBlank() ? udDomainName : this.parseDomainName(adUser.getEmailAddress());
                break;
            }
            default: {
                this.logTraceLog(" default case protocol type not found ");
            }
        }
        return udDomainName;
    }

    private String parseDomainName(String inputString) {
        return inputString.substring(inputString.indexOf("@") + 1).replace(".", " ").split(" ")[0].toUpperCase();
    }

    private int getUserDisabledStatus(AdServerConfigurationModel ldapConfig, AdUserDetails adUserDetails) {
        int isUserDisabled = switch (ldapConfig.getAdProtocolType()) {
            case 2 -> this.getUserDisabledStatusFromLdap(adUserDetails.getUserAccountControl()).equals("2") ? 1 : 0;
            case 3 -> adUserDetails.isAzureAccountEnabled() ? 0 : 1;
            case 4 -> adUserDetails.getUserStatus() == 0 ? 1 : 0;
            case 5 -> adUserDetails.isAccountSuspended() ? 1 : 0;
            default -> 0;
        };
        if (isUserDisabled == 1) {
            LOG.info("{} user is disabled", (Object)adUserDetails.getUserName());
        }
        return isUserDisabled;
    }

    private void saveAdUsersProfilePhoto(List<AdUserDetails> adUsers, int domainId, String schema) {
        try (Connection conn = new JdbCConnection().getConnection(schema);){
            for (AdUserDetails adUser : adUsers) {
                if (adUser.getUserProfilePhotoByteArr() == null && !adUser.isUserProfilePhotoImportedUsingCloudConnector()) continue;
                String query = "select um.profilepicture as outputValue from usermgmt_master um inner join userdetails ud on ud.userid = um.userid where ud.username=? and ud.domainId=?";
                ArrayList<Object> queryParamValues = new ArrayList<Object>(3);
                queryParamValues.add(adUser.getUserName());
                queryParamValues.add(domainId);
                String fileNameInDb = this.getUniqueValueFromSQLQuery(query, queryParamValues, conn);
                if (!fileNameInDb.isEmpty() && !fileNameInDb.toLowerCase().contains((adUser.getUserName() + "_SAPP_").toLowerCase())) continue;
                String fileName = adUser.getUserName().replace("\\", "_") + "_SAPP_" + domainId + ".jpg";
                this.saveUserProfileImageInFile(fileName, adUser.getUserProfilePhotoByteArr(), schema, Boolean.FALSE, adUser.isUserProfilePhotoImportedUsingCloudConnector());
                PreparedStatement pst = conn.prepareStatement("update usermgmt_master set ProfilePicture=? where UserID=?");
                try {
                    pst.setString(1, fileName);
                    pst.setInt(2, adUser.getUserId());
                    pst.executeUpdate();
                }
                finally {
                    if (pst == null) continue;
                    pst.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception Occurred in LdapUserImportDao method : saveAdUsersProfilePhoto :: ", (Throwable)e);
        }
    }

    private String determineAttachmentLocation(String schema, boolean isFromCloudConnector) {
        String attachmentsFolderPath = isFromCloudConnector ? "" : SapphireUserImportUtil.configSettingMap.get(schema).get("ATTACHMENTSPATH");
        File attachmentsPath = new File(attachmentsFolderPath);
        File filePath = new File(".");
        Object attachmentLocation = filePath.getAbsolutePath().substring(0, filePath.getAbsolutePath().length() - 5);
        if (isFromCloudConnector) {
            attachmentLocation = ((String)attachmentLocation).replace("ConsoleManagement", "WebManagement");
        }
        attachmentLocation = attachmentsPath.exists() ? attachmentsFolderPath + File.separator + (String)(SapphireUserImportUtil.isServer ? schema + File.separator : "") : (String)attachmentLocation + "SapphireUploadFiles" + File.separator + (String)(SapphireUserImportUtil.isServer ? schema + File.separator : "");
        return attachmentLocation;
    }

    private void logTraceLog(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
    }

    public Map<String, Integer> getDefaultLdapAttributeStatusMap() {
        HashMap<String, Integer> adLdapAttributesMap = HashMap.newHashMap(20);
        adLdapAttributesMap.put("Logon Name", 0);
        adLdapAttributesMap.put("whenChanged Time", 0);
        adLdapAttributesMap.put("User Control", 0);
        adLdapAttributesMap.put("Cell_No", 0);
        adLdapAttributesMap.put("GUID", 0);
        adLdapAttributesMap.put("Fullname", 0);
        adLdapAttributesMap.put("Wing", 0);
        adLdapAttributesMap.put("EmailAddress", 0);
        adLdapAttributesMap.put("City", 0);
        adLdapAttributesMap.put("EmployeeID", 0);
        adLdapAttributesMap.put("TelephoneNumber", 0);
        adLdapAttributesMap.put("BaseDN", 0);
        adLdapAttributesMap.put("AccountExpireDate", 0);
        adLdapAttributesMap.put("IsAccountLocked", 0);
        adLdapAttributesMap.put("BadLoginCount", 0);
        adLdapAttributesMap.put("DepartmentID", 0);
        adLdapAttributesMap.put("LocationID", 0);
        adLdapAttributesMap.put("UserPrincipalName", 0);
        adLdapAttributesMap.put("PasswordLastSet", 0);
        return adLdapAttributesMap;
    }

    private AdUserDetails getAdUserDetailsFromQuery(String query, int isFromConflictedUsers, List<Object> paramValues, Connection conn) throws SQLException {
        AdUserDetails adUserDetails = null;
        try (PreparedStatement pstmt = conn.prepareStatement(query);){
            if (paramValues != null && !paramValues.isEmpty()) {
                int paramPos = 1;
                for (Object paramValue : paramValues) {
                    if (paramValue instanceof Integer) {
                        Integer param1 = (Integer)paramValue;
                        pstmt.setInt(paramPos, param1);
                    } else {
                        pstmt.setString(paramPos, paramValue.toString());
                    }
                    ++paramPos;
                }
            }
            try (ResultSet res = pstmt.executeQuery();){
                if (res.next()) {
                    adUserDetails = new AdUserDetails();
                    if (isFromConflictedUsers == 0) {
                        adUserDetails.setUserId(res.getInt("userId"));
                        adUserDetails.setUserAccessType(res.getInt("accessId"));
                    }
                    adUserDetails.setUserName(res.getString("userName"));
                    adUserDetails.setUserStatus(res.getInt("UserStatus"));
                    adUserDetails.setDomainName(res.getString(DOMAINNAME));
                    adUserDetails.setWhenChanged(res.getString("whenChanged"));
                    adUserDetails.setFullName(res.getString("FullName"));
                    adUserDetails.setEmailAddress(res.getString("EmailAddress"));
                    adUserDetails.setCellNo(res.getString("Cell_No"));
                    adUserDetails.setEmployeeId(res.getString("EmployeeID"));
                    adUserDetails.setWing(res.getString("Wing"));
                    adUserDetails.setTelephoneNumber(res.getString("TelephoneNumber"));
                    adUserDetails.setCity(res.getString("City"));
                    adUserDetails.setUserPrincipalName(res.getString("userprincipalname"));
                    adUserDetails.setBaseDn(res.getString("BaseDN"));
                    adUserDetails.setAccountExpireDate(res.getString("AccountExpireDate"));
                    adUserDetails.setIsAccountLocked(res.getString("IsAccountLocked"));
                    adUserDetails.setBadLoginCount(res.getInt("BadLoginCount"));
                    adUserDetails.setDepartmentId(res.getInt("DepartmentID"));
                    adUserDetails.setLocationId(res.getInt("LocationID"));
                    adUserDetails.setGuid(res.getString("Guid"));
                    adUserDetails.setOuName(res.getString("OUName"));
                    adUserDetails.setPasswordLastSetTime(res.getString("ad_password_reset_time"));
                    adUserDetails.setPasswordNeverExpires(res.getInt("ad_password_never_expires"));
                }
            }
        }
        return adUserDetails;
    }

    private int getUserStatus(AdServerConfigurationModel ldapConfig, int totalUsersImported, int isUserDisabled) {
        int udUserStatus = 1;
        if (isUserDisabled == 0) {
            udUserStatus = ldapConfig.getTotalUserLicense() == -2 || ldapConfig.getTotalUserLicense() > totalUsersImported ? 0 : 3;
        }
        return udUserStatus;
    }

    private void processUserFields(AdUserDetails adUser, AdServerConfigurationModel ldapConfig, int totalUsersImported, Connection conn, int isUserDisabled, int restrictLocationDepartment, String schema) throws SQLException {
        String udFullName;
        String udUserPrincipalName = adUser.getUserPrincipalName() == null ? "" : adUser.getUserPrincipalName();
        adUser.setUserPrincipalName(udUserPrincipalName);
        String udDomainName = this.determineDomainName(ldapConfig, adUser, udUserPrincipalName);
        int udUserStatus = this.getUserStatus(ldapConfig, totalUsersImported, isUserDisabled);
        adUser.setUserStatus(udUserStatus);
        adUser.setDomainName(udDomainName);
        String udTelephoneNumber = adUser.getTelephoneNumber() == null ? "" : (String)adUser.getTelephoneNumber();
        String udCellNo = adUser.getCellNo() == null ? "" : adUser.getCellNo();
        String udEmail = adUser.getEmailAddress() == null ? "" : adUser.getEmailAddress();
        adUser.setEmailAddress(udEmail);
        adUser.setTelephoneNumber(udTelephoneNumber);
        String udEmployeeId = adUser.getEmployeeId() == null ? "" : adUser.getEmployeeId();
        adUser.setEmployeeId(udEmployeeId);
        String udWing = adUser.getWing() == null ? "" : adUser.getWing();
        String udCity = adUser.getCity() == null ? "" : adUser.getCity();
        Pattern p = Pattern.compile(MOBILENUMBER_REGEX);
        if (!p.matcher(udCellNo).find()) {
            udCellNo = "";
        }
        adUser.setWing(udWing);
        adUser.setCity(udCity);
        adUser.setCellNo(udCellNo);
        LdapUserImportDao.processWhenChanged(adUser, ldapConfig);
        String accountExpireDate = adUser.getAccountExpireDate() == null ? EMPTY_DATE : adUser.getAccountExpireDate();
        String isAccountLocked = adUser.getIsAccountLocked() == null ? EMPTY_DATE : adUser.getIsAccountLocked();
        adUser.setIsAccountLocked(isAccountLocked);
        adUser.setAccountExpireDate(accountExpireDate);
        this.generateUserName(adUser, udUserPrincipalName, ldapConfig, conn, udEmail, udDomainName);
        String string = udFullName = ldapConfig.getAdProtocolType() == 4 ? adUser.getFirstName() + " " + adUser.getLastName() : adUser.getFullName();
        if (udFullName == null) {
            udFullName = adUser.getUserName();
        }
        adUser.setFullName(udFullName);
        String ouName = adUser.getOuName() == null ? "" : adUser.getOuName();
        String udBaseDn = adUser.getBaseDn() == null ? "" : adUser.getBaseDn();
        adUser.setBaseDn(udBaseDn);
        adUser.setOuName(ouName);
        int departmentId = this.determineDepartmentId(isUserDisabled, adUser, restrictLocationDepartment, conn, schema);
        int locationId = this.determineLocationId(isUserDisabled, adUser, restrictLocationDepartment, conn, schema);
        adUser.setLocationId(locationId);
        adUser.setDepartmentId(departmentId);
        String passwordLastSetDate = adUser.getPasswordLastSetTime() == null ? EMPTY_DATE : adUser.getPasswordLastSetTime();
        adUser.setPasswordLastSetTime(passwordLastSetDate);
    }

    private static void processWhenChanged(AdUserDetails adUser, AdServerConfigurationModel ldapConfig) {
        String udWhenChanged = adUser.getWhenChanged();
        if (ldapConfig.getAdProtocolType() == 3 || ldapConfig.getAdProtocolType() == 4 || ldapConfig.getAdProtocolType() == 5) {
            udWhenChanged = udWhenChanged == null || udWhenChanged.isBlank() ? adUser.getUserCreatedDateTime() : udWhenChanged;
            udWhenChanged = udWhenChanged.replace("-", "").replace(":", "").replace("T", "");
        }
        adUser.setWhenChanged(udWhenChanged);
    }

    private void mergeAdUserDetailsWithDbUser(Map<String, Integer> adLdapAttributes, AdUserDetails adUser, AdUserDetails dbUser) {
        if (dbUser == null) {
            return;
        }
        LdapUserImportDao.setUserValue("Fullname", adLdapAttributes, adUser::setFullName, dbUser.getFullName());
        LdapUserImportDao.setUserValue("EmailAddress", adLdapAttributes, adUser::setEmailAddress, dbUser.getEmailAddress());
        LdapUserImportDao.setUserValue("Cell_No", adLdapAttributes, adUser::setCellNo, dbUser.getCellNo());
        LdapUserImportDao.setUserValue("Wing", adLdapAttributes, adUser::setWing, dbUser.getWing());
        LdapUserImportDao.setUserValue("EmployeeID", adLdapAttributes, adUser::setEmployeeId, dbUser.getEmployeeId());
        LdapUserImportDao.setUserValue("City", adLdapAttributes, adUser::setCity, dbUser.getCity());
        LdapUserImportDao.setUserValue("TelephoneNumber", adLdapAttributes, adUser::setTelephoneNumber, (String)dbUser.getTelephoneNumber());
        LdapUserImportDao.setUserValue("UserPrincipalName", adLdapAttributes, adUser::setUserPrincipalName, dbUser.getUserPrincipalName());
        LdapUserImportDao.setUserValue("whenChanged Time", adLdapAttributes, adUser::setWhenChanged, dbUser.getWhenChanged());
        LdapUserImportDao.setUserValue("OU Name", adLdapAttributes, adUser::setOuName, dbUser.getOuName());
        LdapUserImportDao.setUserValue("BaseDN", adLdapAttributes, adUser::setBaseDn, dbUser.getBaseDn());
        if (adLdapAttributes.containsKey("LocationID") && adLdapAttributes.get("LocationID") == 0) {
            adUser.setLocationId(dbUser.getLocationId());
        }
        if (adLdapAttributes.containsKey("DepartmentID") && adLdapAttributes.get("DepartmentID") == 0) {
            adUser.setDepartmentId(dbUser.getDepartmentId());
        }
        LdapUserImportDao.setUserValue("AccountExpireDate", adLdapAttributes, adUser::setAccountExpireDate, dbUser.getAccountExpireDate());
        LdapUserImportDao.setUserValue("IsAccountLocked", adLdapAttributes, adUser::setIsAccountLocked, dbUser.getIsAccountLocked());
    }

    private static void setUserValue(String attrName, Map<String, Integer> adUserAttrs, Consumer<String> setter, String value) {
        if (adUserAttrs.containsKey(attrName) && adUserAttrs.get(attrName) == 0) {
            setter.accept(value);
        }
    }

    public long saveUserProfileImageInFile(String fileName, byte[] userProfilePhotoByteArr, String schema, boolean isFromCloudConnector, boolean isProfilePhotoimported) throws IOException {
        if (!isProfilePhotoimported) {
            String attachmentLocation = this.determineAttachmentLocation(schema, isFromCloudConnector);
            File profileImageFile = new File(attachmentLocation + fileName);
            try (ByteArrayInputStream bis = new ByteArrayInputStream(userProfilePhotoByteArr);){
                BufferedImage profileImage = ImageIO.read(bis);
                ImageIO.write((RenderedImage)profileImage, "jpg", profileImageFile);
            }
            return profileImageFile.length();
        }
        return 0L;
    }

    public void updateUserDeletionStatus(Connection conn, AdServerConfigurationModel adServerData) throws SQLException {
        String strQuery = " update userdetails set DeletionAllowed = 0 where DeletionAllowed != 1 and DomainID = ?";
        this.logTraceLog(String.format("updating user deletion status before syncing the users ::  update userdetails set DeletionAllowed = 0 where DeletionAllowed != 1 and DomainID = %s", adServerData.getSchedularId()));
        try (PreparedStatement pstmt = conn.prepareStatement(strQuery);){
            pstmt.setInt(1, adServerData.getSchedularId());
            pstmt.executeUpdate();
        }
    }

    public List<Object[]> getListFromSQLQuery(String strQuery, List<String> columnNames, List<Object> paramValues, Connection conn) throws SQLException {
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        try (PreparedStatement pstmt = conn.prepareStatement(strQuery);){
            this.setParameters(paramValues, pstmt);
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    Object[] rows = new Object[columnNames.size()];
                    int index = 0;
                    for (String column : columnNames) {
                        rows[index++] = res.getString(column);
                    }
                    resultList.add(rows);
                }
            }
        }
        return resultList;
    }

    private String getUserDisabledStatusFromLdap(int userAccountControl) {
        if (userAccountControl != 0) {
            String userAccountDisabled = Integer.toString(userAccountControl, 16);
            return String.valueOf(userAccountDisabled.charAt(userAccountDisabled.length() - 1));
        }
        return "0";
    }

    public void updateUserRoles(int domainId, Connection connection, int roleId) throws SQLException {
        String query = "INSERT INTO groupdetail (GroupId, UserID) SELECT\n" + roleId + " , ud.UserID FROM userdetails ud WHERE ud.DomainID = ?\n  AND NOT EXISTS (SELECT  distinct ud.UserID\n    FROM groupdetail  gd  WHERE gd.UserID = ud.UserID and gd.GroupID = ? );\n";
        try (PreparedStatement pst = connection.prepareStatement(query);){
            pst.setInt(1, domainId);
            pst.setInt(2, roleId);
            pst.executeUpdate();
        }
    }

    public void loadDepartmentCache(String schema, Connection connection) throws SQLException {
        HashMap<String, Integer> departmemtMap = new HashMap<String, Integer>();
        try (PreparedStatement pst = connection.prepareStatement("select DepartmentName, DepartmentID  from departmentmaster");
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                departmemtMap.put(rs.getString(1), rs.getInt(2));
            }
        }
        DEPARTMENT_CACHE.put(schema, departmemtMap);
    }

    public void clearDeparmentCache(String schema) {
        DEPARTMENT_CACHE.remove(schema);
    }

    public void loadLocationCache(String schema, Connection connection) throws SQLException {
        HashMap<String, Integer> locationMap = new HashMap<String, Integer>();
        try (PreparedStatement pst = connection.prepareStatement("select LocationName, LocationID  from servicedesklocationmaster");
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                locationMap.put(rs.getString(1), rs.getInt(2));
            }
        }
        LOCATION_CACHE.put(schema, locationMap);
    }

    public void clearLocationCache(String schema) {
        LOCATION_CACHE.remove(schema);
    }

    public void loadI18nData(Connection conn, String schema) {
        Set<I18nRecord> i18nRecords = I18N_LANGUAGE.get(schema);
        if (i18nRecords == null || i18nRecords.isEmpty()) {
            i18nRecords = new HashSet<I18nRecord>(6);
            try (PreparedStatement pst = conn.prepareStatement("Select LanguageCode,LanguageName from i18n_language_master");
                 ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    i18nRecords.add(new I18nRecord(rs.getString("LanguageCode"), rs.getString("LanguageName")));
                }
                I18N_LANGUAGE.put(schema, i18nRecords);
            }
            catch (SQLException se) {
                LOG.error(se.getMessage(), (Throwable)se);
            }
        }
    }

    public void unloadI18nData(String schema) {
        I18N_LANGUAGE.remove(schema);
    }

    private String getLanguageCode(String language, String schema) {
        String tempL = "";
        Set<I18nRecord> records = I18N_LANGUAGE.get(schema);
        for (I18nRecord i18nRecord : records) {
            if (!i18nRecord.languageCode().equalsIgnoreCase(language) && !i18nRecord.languageName().equalsIgnoreCase(language)) continue;
            tempL = language;
            break;
        }
        return tempL;
    }

    private void getUserEmailIds(String userIds, Connection connection, Set<String> emails) {
        if (userIds.isEmpty() || userIds.equals("0")) {
            return;
        }
        int[] intArray = Arrays.stream(userIds.split(",")).mapToInt(Integer::parseInt).toArray();
        String placeholders = String.join((CharSequence)",", Collections.nCopies(intArray.length, "?"));
        String query = "select um.EmailAddress from usermgmt_master um inner join userdetails ud on ud.UserID = um.UserID where ud.UserID in (" + placeholders + ") and EmailAddress != '' and ud.UserStatus = 0";
        try (PreparedStatement pst = connection.prepareStatement(query);){
            for (int i = 0; i < intArray.length; ++i) {
                pst.setInt(i + 1, intArray[i]);
            }
            try (ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    emails.add(rs.getString(1));
                }
            }
        }
        catch (SQLException se) {
            LOG.error(se.getMessage(), (Throwable)se);
        }
    }

    private void getAccessEmailIds(String accessIds, Connection connection, Set<String> emails) {
        if (accessIds.isEmpty() || accessIds.equals("0")) {
            return;
        }
        int[] intArray = Arrays.stream(accessIds.split(",")).mapToInt(Integer::parseInt).toArray();
        String placeholders = String.join((CharSequence)",", Collections.nCopies(intArray.length, "?"));
        String query = "select um.EmailAddress from usermgmt_master um inner join groupdetail gd inner join userdetails ud on ud.UserID = um.UserID and gd.GroupID = um.GroupID on gd.userId = um.userId where gd.GroupID in (" + placeholders + ") and  um.EmailAddress != '' and ud.UserStatus = 0";
        try (PreparedStatement pst = connection.prepareStatement(query);){
            for (int i = 0; i < intArray.length; ++i) {
                pst.setInt(i + 1, intArray[i]);
            }
            try (ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    emails.add(rs.getString(1));
                }
            }
        }
        catch (SQLException se) {
            LOG.error(se.getMessage(), (Throwable)se);
        }
    }

    private void updateUserDeleationStatus(Connection conn, String userName, String domainName) {
        String query = "Update userdetails set DeletionAllowed = ? where UserName = ? and DomainName = ?";
        try (PreparedStatement pst = conn.prepareStatement(query);){
            pst.setInt(1, 103);
            pst.setString(2, userName);
            pst.setString(3, domainName);
            pst.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error("Exception Occurred in LdapUserImportService method : updateUserDeleationStatus :: ", (Throwable)e);
        }
    }

    private static class UserDbDetails {
        String username;
        String emailAddress;
        Integer domainId;
        Integer userStatus;

        UserDbDetails(String username, String emailAddress, Integer domainId, Integer userStatus) {
            this.username = username;
            this.emailAddress = emailAddress;
            this.domainId = domainId;
            this.userStatus = userStatus;
        }
    }

    private record I18nRecord(String languageCode, String languageName) {
    }
}

