/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.dao;

import com.sapphireims.user.model.AdUserDetails;
import com.sapphireims.user.model.UserAuditlogConfigDetail;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class UserAuditLogDao {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.sapphireims.user");
    public static final String AD_USER_IMPORT = "AD User Import";
    public static final String EXCEL_USER_IMPORT = "Excel User Import";
    public static final String UI_USER = "UI User";
    private static final int BATCH_SIZE = 25;

    public static void insertAuditLog(List<UserAuditlogConfigDetail> userAuditlogConfigDetailList, Connection connection) throws SQLException {
        Instant start = Instant.now();
        String query = "insert into user_auditlog_detail(user_reference_id,configuration_parameter,old_value,new_value,actions_performed_by,ip_address,nature_of_change,user_profile_name,is_date_field,type_of_user_import) values (?,?,?,?,?,?,?,?,?,?)";
        try (PreparedStatement insertAuditLogDetails = connection.prepareStatement(query);){
            int batchCounter = 0;
            for (UserAuditlogConfigDetail userAuditlogConfigDetail : userAuditlogConfigDetailList) {
                insertAuditLogDetails.setInt(1, userAuditlogConfigDetail.getUserReferenceId());
                insertAuditLogDetails.setString(2, userAuditlogConfigDetail.getConfigParameter());
                insertAuditLogDetails.setString(3, userAuditlogConfigDetail.getOldValue());
                insertAuditLogDetails.setString(4, userAuditlogConfigDetail.getNewValue());
                insertAuditLogDetails.setString(5, userAuditlogConfigDetail.getActionPerformedBy());
                insertAuditLogDetails.setString(6, userAuditlogConfigDetail.getIpAddress());
                insertAuditLogDetails.setInt(7, userAuditlogConfigDetail.getNatureOfChange());
                insertAuditLogDetails.setString(8, userAuditlogConfigDetail.getProfileName());
                insertAuditLogDetails.setInt(9, userAuditlogConfigDetail.getIsDateField());
                insertAuditLogDetails.setString(10, userAuditlogConfigDetail.getTypeOfUserImport());
                insertAuditLogDetails.addBatch();
                if (++batchCounter < 25) continue;
                insertAuditLogDetails.executeBatch();
                batchCounter = 0;
            }
            if (batchCounter > 0) {
                insertAuditLogDetails.executeBatch();
            }
        }
        Instant end = Instant.now();
        long durationInSeconds = Duration.between(start, end).getSeconds();
        logger.trace("Time taken to insert audit log details for {} users is {} seconds", (Object)userAuditlogConfigDetailList.size(), (Object)durationInSeconds);
    }

    public static void userAuditLogCheck(AdUserDetails oldAdUserDetails, int userAccessType, AdUserDetails newAdUserDetails, List<UserAuditlogConfigDetail> userAuditConfigList, Connection connection) throws UnknownHostException {
        UserAuditlogConfigDetail userAuditLogConfig;
        String newValue;
        String oldValue;
        UserAuditlogConfigDetail userAuditLogConfig2;
        if (!oldAdUserDetails.getUserName().equals(newAdUserDetails.getUserName())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "User Name", oldAdUserDetails.getUserName(), newAdUserDetails.getUserName(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getFullName().equals(newAdUserDetails.getFullName())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Full Name", oldAdUserDetails.getFullName(), newAdUserDetails.getFullName(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getEmailAddress().equals(newAdUserDetails.getEmailAddress())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Email Address", oldAdUserDetails.getEmailAddress(), newAdUserDetails.getEmailAddress(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getCellNo().equals(newAdUserDetails.getCellNo())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Cell Number", oldAdUserDetails.getCellNo(), newAdUserDetails.getCellNo(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getEmployeeId().equals(newAdUserDetails.getEmployeeId())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Employee Id", oldAdUserDetails.getEmployeeId(), newAdUserDetails.getEmployeeId(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getWing().equals(newAdUserDetails.getWing())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Wing", oldAdUserDetails.getWing(), newAdUserDetails.getWing(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getTelephoneNumber().equals(newAdUserDetails.getTelephoneNumber())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Telephone Number", oldAdUserDetails.getTelephoneNumber().toString(), newAdUserDetails.getTelephoneNumber().toString(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getCity().equals(newAdUserDetails.getCity())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "City", oldAdUserDetails.getCity(), newAdUserDetails.getCity(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getUserPrincipalName().equals(newAdUserDetails.getUserPrincipalName())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "User Principal Name", oldAdUserDetails.getUserPrincipalName(), newAdUserDetails.getUserPrincipalName(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getBaseDn().equals(newAdUserDetails.getBaseDn())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Base Dn", oldAdUserDetails.getBaseDn(), newAdUserDetails.getBaseDn(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getAccountExpireDate().equals(newAdUserDetails.getAccountExpireDate())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Account Expire Date", oldAdUserDetails.getAccountExpireDate(), newAdUserDetails.getAccountExpireDate(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 1, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getIsAccountLocked().equals(newAdUserDetails.getIsAccountLocked())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Is Account Locked", oldAdUserDetails.getIsAccountLocked(), newAdUserDetails.getIsAccountLocked(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 1, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (oldAdUserDetails.getBadLoginCount() != newAdUserDetails.getBadLoginCount()) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Bad Login Count", String.valueOf(oldAdUserDetails.getBadLoginCount()), String.valueOf(newAdUserDetails.getBadLoginCount()), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getDomainName().equals(newAdUserDetails.getDomainName())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Domain Name", oldAdUserDetails.getDomainName(), newAdUserDetails.getDomainName(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getGuid().equals(newAdUserDetails.getGuid())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "GUID", oldAdUserDetails.getGuid(), newAdUserDetails.getGuid(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getWhenChanged().equals(newAdUserDetails.getWhenChanged())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "When Changed", oldAdUserDetails.getWhenChanged(), newAdUserDetails.getWhenChanged(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getOuName().equals(newAdUserDetails.getOuName())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "OU Name", oldAdUserDetails.getOuName(), newAdUserDetails.getOuName(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (!oldAdUserDetails.getPasswordLastSetTime().equals(newAdUserDetails.getPasswordLastSetTime())) {
            userAuditLogConfig2 = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "AD Password Reset Time", oldAdUserDetails.getPasswordLastSetTime(), newAdUserDetails.getPasswordLastSetTime(), "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 1, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig2);
        }
        if (oldAdUserDetails.getPasswordNeverExpires() != newAdUserDetails.getPasswordNeverExpires()) {
            oldValue = oldAdUserDetails.getPasswordNeverExpires() == 0 ? "Password Expires" : "Password Never Expires";
            newValue = newAdUserDetails.getPasswordNeverExpires() == 0 ? "Password Expires" : "Password Never Expires";
            userAuditLogConfig = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "AD Password Never Expires", oldValue, newValue, "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig);
        }
        if (oldAdUserDetails.getUserStatus() != newAdUserDetails.getUserStatus()) {
            oldValue = UserAuditLogDao.checkUserStatus(oldAdUserDetails.getUserStatus());
            newValue = UserAuditLogDao.checkUserStatus(newAdUserDetails.getUserStatus());
            userAuditLogConfig = UserAuditLogDao.getUserAuditLog(newAdUserDetails, oldValue, newValue, newValue);
            userAuditConfigList.add(userAuditLogConfig);
        }
        if (oldAdUserDetails.getUserAccessType() != userAccessType) {
            oldValue = UserAuditLogDao.checkAccessType(oldAdUserDetails.getUserAccessType(), connection);
            newValue = UserAuditLogDao.checkAccessType(userAccessType, connection);
            userAuditLogConfig = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Access Type", oldValue, newValue, "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig);
        }
        if (oldAdUserDetails.getLocationId() != newAdUserDetails.getLocationId()) {
            oldValue = UserAuditLogDao.checkLocation(oldAdUserDetails.getLocationId(), connection);
            newValue = UserAuditLogDao.checkLocation(newAdUserDetails.getLocationId(), connection);
            userAuditLogConfig = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Location", oldValue, newValue, "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig);
        }
        if (oldAdUserDetails.getDepartmentId() != newAdUserDetails.getDepartmentId()) {
            oldValue = UserAuditLogDao.checkDepartment(oldAdUserDetails.getDepartmentId(), connection);
            newValue = UserAuditLogDao.checkDepartment(newAdUserDetails.getDepartmentId(), connection);
            userAuditLogConfig = new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "Department", oldValue, newValue, "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
            userAuditConfigList.add(userAuditLogConfig);
        }
    }

    private static String checkUserStatus(int userStatus) {
        switch (userStatus) {
            case 0: {
                return "Active";
            }
            case 1: {
                return "Deactive";
            }
            case 2: {
                return "Deleted";
            }
        }
        return "";
    }

    private static UserAuditlogConfigDetail getUserAuditLog(AdUserDetails newAdUserDetails, String oldValue, String newValue, String userStatus) throws UnknownHostException {
        UserAuditlogConfigDetail userAuditLogConfig = userStatus.equals("Deleted") ? new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "", "", "", "", InetAddress.getLocalHost().getHostAddress(), 3, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT) : new UserAuditlogConfigDetail(newAdUserDetails.getUserId(), "User Status", oldValue, newValue, "", InetAddress.getLocalHost().getHostAddress(), 2, newAdUserDetails.getFullName(), 0, AD_USER_IMPORT);
        return userAuditLogConfig;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String checkAccessType(int accessId, Connection conn) {
        try (PreparedStatement pst = conn.prepareStatement("select AccessType FROM usermgmt_details where AccessID=?");){
            String string;
            block18: {
                ResultSet rst;
                block16: {
                    String string2;
                    block17: {
                        pst.setInt(1, accessId);
                        rst = pst.executeQuery();
                        try {
                            if (!rst.next()) break block16;
                            string2 = rst.getString("AccessType");
                            if (rst == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rst != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rst.close();
                    }
                    return string2;
                }
                string = "";
                if (rst == null) break block18;
                rst.close();
            }
            return string;
        }
        catch (SQLException sqlException) {
            logger.error("Exception caught while checking access type for given access id ************** {}", (Object)sqlException.getMessage(), (Object)sqlException);
            return "";
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String checkLocation(int locationId, Connection conn) {
        try (PreparedStatement pst = conn.prepareStatement("select LocationName FROM Servicedesklocationmaster where LocationID=?");){
            String string;
            block18: {
                ResultSet rst;
                block16: {
                    String string2;
                    block17: {
                        pst.setInt(1, locationId);
                        rst = pst.executeQuery();
                        try {
                            if (!rst.next()) break block16;
                            string2 = rst.getString("LocationName");
                            if (rst == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rst != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rst.close();
                    }
                    return string2;
                }
                string = "";
                if (rst == null) break block18;
                rst.close();
            }
            return string;
        }
        catch (SQLException sqlException) {
            logger.error("Exception caught while checking location name for given location id ************** {}", (Object)sqlException.getMessage(), (Object)sqlException);
            return "";
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String checkDepartment(int departmentId, Connection conn) {
        try (PreparedStatement pst = conn.prepareStatement("select DepartmentName FROM Departmentmaster where DepartmentID=?");){
            String string;
            block18: {
                ResultSet rst;
                block16: {
                    String string2;
                    block17: {
                        pst.setInt(1, departmentId);
                        rst = pst.executeQuery();
                        try {
                            if (!rst.next()) break block16;
                            string2 = rst.getString("DepartmentName");
                            if (rst == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rst != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rst.close();
                    }
                    return string2;
                }
                string = "";
                if (rst == null) break block18;
                rst.close();
            }
            return string;
        }
        catch (SQLException sqlException) {
            logger.error("Exception caught while checking department name for given department id ************** {}", (Object)sqlException.getMessage(), (Object)sqlException);
            return "";
        }
    }

    public static void insertAuditLogForDeletedUsers(int domainId, boolean deletedRuleConfig, String actionPerformedBy, Connection conn, int syncType, String whenChanged, boolean isFromUI) {
        String typeOfUser = isFromUI ? UI_USER : AD_USER_IMPORT;
        ArrayList<UserAuditlogConfigDetail> userAuditConfigList = new ArrayList<UserAuditlogConfigDetail>();
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        Object query = "Select ud.userID,um.FullName from userDetails ud inner join usermgmt_master um on ud.userid = um.userid where ud.domainId = ?";
        if (!deletedRuleConfig) {
            query = (String)query + " and ud.DeletionAllowed = 0 and ud.UserStatus = 0";
            if (syncType == 1) {
                query = (String)query + " AND whenChanged >= ?";
            }
        }
        try (PreparedStatement pst = conn.prepareStatement((String)query);){
            pst.setInt(1, domainId);
            if (syncType == 1) {
                pst.setString(2, whenChanged);
            }
            try (ResultSet rst = pst.executeQuery();){
                while (rst.next()) {
                    if (!deletedRuleConfig) {
                        userIds.add(rst.getInt("userID"));
                    }
                    UserAuditlogConfigDetail userAuditLogConfig = new UserAuditlogConfigDetail(rst.getInt("userId"), "", "", "", actionPerformedBy, InetAddress.getLocalHost().getHostAddress(), 3, rst.getString("FullName"), 0, typeOfUser);
                    userAuditConfigList.add(userAuditLogConfig);
                }
            }
            UserAuditLogDao.insertAuditLog(userAuditConfigList, conn);
            if (!deletedRuleConfig && !userIds.isEmpty()) {
                logger.info("The {} users are went to delete state", userIds);
            }
        }
        catch (Exception ex) {
            logger.error("Exception caught while inserting audit log for deleted users ************** {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public static void insertAdditinalFieldToLog(int userId, int additionalFiledId, String additionalValue, String fullName, Connection connection, List<UserAuditlogConfigDetail> userAuditConfigList, boolean isConflictedUser, boolean isNewUser) {
        block29: {
            String getExistingDetails = "Select uafv.userID, uafv.additionalFieldValue, uaf.FieldDisplayName from user_additionalFieldValues uafv  inner join user_additionalfields uaf \nwhere uafv.additionalFieldID = uaf.additionalFieldID and uafv.userId = ? and uafv.additionalFieldID = ?";
            String additionalFieldQuery = "Select uaf.FieldDisplayName from user_additionalFieldValues uafv  inner join user_additionalfields uaf \nwhere uafv.additionalFieldID = uaf.additionalFieldID and uafv.additionalFieldID = ?";
            try (PreparedStatement pst = connection.prepareStatement(getExistingDetails);){
                pst.setInt(1, userId);
                pst.setInt(2, additionalFiledId);
                try (ResultSet rst = pst.executeQuery();){
                    if (rst.next()) {
                        if (!(rst.getString("additionalFieldValue").equals(additionalValue) || isConflictedUser || isNewUser)) {
                            UserAuditlogConfigDetail userAuditLog = new UserAuditlogConfigDetail(userId, rst.getString("FieldDisplayName"), rst.getString("additionalFieldValue"), additionalValue, "", InetAddress.getLocalHost().getHostAddress(), 2, fullName, 0, AD_USER_IMPORT);
                            userAuditConfigList.add(userAuditLog);
                        }
                        break block29;
                    }
                    if (isConflictedUser || isNewUser) break block29;
                    try (PreparedStatement pst1 = connection.prepareStatement(additionalFieldQuery);){
                        pst1.setInt(1, additionalFiledId);
                        try (ResultSet rst1 = pst1.executeQuery();){
                            if (rst1.next()) {
                                UserAuditlogConfigDetail userAuditLog = new UserAuditlogConfigDetail(userId, rst1.getString("FieldDisplayName"), "", additionalValue, "", InetAddress.getLocalHost().getHostAddress(), 2, fullName, 0, AD_USER_IMPORT);
                                userAuditConfigList.add(userAuditLog);
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Exception caught while inserting auditlog for additional field values ************** {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }
}

