/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.jobprocessor;

import com.sapphireims.user.cloudconnector.jobprocessor.CloudConnectorUserImportJobProcessor;
import com.sapphireims.user.cloudconnector.ldap.service.CloudConnectorLdapService;
import com.sapphireims.user.controller.LdapUserImportController;
import com.sapphireims.user.dao.JobConfigurationDao;
import com.sapphireims.user.dao.LdapUserImportDao;
import com.sapphireims.user.dao.LicenseConfigurationDao;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.JobDetailModel;
import com.sapphireims.user.mysql.JdbCConnection;
import com.sapphireims.user.util.SapphireUserImportUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdUserImportJobProcessor {
    private final String tenantName;
    private final LdapUserImportController userImportController = SapphireUserImportUtil.getLdapUserImportController();
    private final LdapUserImportDao userImportDao = SapphireUserImportUtil.getBean(LdapUserImportDao.class);
    private final LicenseConfigurationDao licenseConfigDao = SapphireUserImportUtil.getBean(LicenseConfigurationDao.class);
    private final JobConfigurationDao jobConfigurationDao = SapphireUserImportUtil.getBean(JobConfigurationDao.class);
    private final CloudConnectorUserImportJobProcessor cloudConnectorUserImportJobProcessor = SapphireUserImportUtil.getBean(CloudConnectorUserImportJobProcessor.class);
    private final CloudConnectorLdapService cloudConnectorLdapService = SapphireUserImportUtil.getBean(CloudConnectorLdapService.class);
    private static final Logger IMPORT_LOG = LoggerFactory.getLogger((String)"com.sapphireims.user");

    public AdUserImportJobProcessor(String tenantName) {
        this.tenantName = tenantName;
    }

    public void runTask() {
        try {
            IMPORT_LOG.info("AD IMPORT Job Processor : Checking user import jobs to process");
            List<JobDetailModel> jobsToProcess = this.checkForAdUserImportResyncJob();
            if (jobsToProcess.isEmpty()) {
                IMPORT_LOG.info("AD IMPORT Job Processor : No user import jobs to process");
            } else {
                jobsToProcess.forEach(this::processAdUserImportResyncJob);
            }
            this.userImportDao.unloadI18nData(this.tenantName);
            this.userImportDao.clearDeparmentCache(this.tenantName);
            this.userImportDao.clearLocationCache(this.tenantName);
        }
        catch (Exception e) {
            IMPORT_LOG.error("Exception occurred in AdUserImportJobProcessor : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<JobDetailModel> checkForAdUserImportResyncJob() {
        ArrayList<JobDetailModel> pendingJobsToProcess = new ArrayList<JobDetailModel>(5);
        try {
            try (Connection conn = new JdbCConnection().getConnection(this.tenantName);){
                String strQuery = "select  jm.SchedularID as SchedularID, jm.JobName as JobName, jd.JobID as jobId from jobsmaster jm\n INNER JOIN jobdetails jd ON jm.SchedularID=jd.SchedularID and jd.JobTypeID=17016 and jd.Status not in(1,-1)\n INNER JOIN jobsmasterlookup jml ON jm.SchedularID=jml.SchedularID and jml.JobParamID=267 order by jd.SubmissionTime\n";
                try (PreparedStatement pstmt = conn.prepareStatement(strQuery);
                     ResultSet rs = pstmt.executeQuery();){
                    while (rs.next()) {
                        JobDetailModel jobModel = new JobDetailModel(rs.getInt("jobId"), rs.getInt("SchedularID"), rs.getString("JobName"), false);
                        pendingJobsToProcess.add(jobModel);
                    }
                }
                this.userImportDao.loadLocationCache(this.tenantName, conn);
                this.userImportDao.loadDepartmentCache(this.tenantName, conn);
                this.userImportDao.loadI18nData(conn, this.tenantName);
            }
            JobDetailModel cloudConnectorJob = this.cloudConnectorUserImportJobProcessor.checkForUserImportJobEntry(this.tenantName);
            if (cloudConnectorJob != null) {
                pendingJobsToProcess.add(cloudConnectorJob);
            }
        }
        catch (Exception e) {
            IMPORT_LOG.error("Exception Occurred in AdUserImportJobProcessor method : checkForAdUserImportResyncJob :: ", (Throwable)e);
        }
        return pendingJobsToProcess;
    }

    private void processAdUserImportResyncJob(JobDetailModel jobDetailModel) {
        Instant startTime = Instant.now();
        String jobStatusDescriptionFailed = "Job failed.";
        String jobStatusDescriptionSuccess = "Job completed successfully.";
        try {
            String result;
            this.logTraceLog(String.format("Processing the User import job scheduler id is %s and Job Name is %s", jobDetailModel.getSchedularId(), jobDetailModel.getJobName()));
            AdServerConfigurationModel adServerData = new AdServerConfigurationModel();
            try (Connection conn = new JdbCConnection().getConnection(this.tenantName);){
                this.jobConfigurationDao.setJobProcessModelData(adServerData, jobDetailModel.getSchedularId(), conn);
                SapphireUserImportUtil.configSettingMap.remove(this.tenantName);
                SapphireUserImportUtil.configSettingMap.put(this.tenantName, this.userImportDao.getSettingKeys(conn));
                int adAuthenticationType = NumberUtils.toInt((String)SapphireUserImportUtil.configSettingMap.get(this.tenantName).get("GSS_AUTHENTICATION"), (int)0);
                if ((adServerData.getAdProtocolType() == 1 || adServerData.getAdProtocolType() == 2) && adAuthenticationType == 1) {
                    this.logTraceLog("AD IMPORT Job Processor : GSS API Enabled, AD Users will be imported from Engine");
                    return;
                }
                if (!jobDetailModel.isProcessUsersFromCCRespone()) {
                    try (PreparedStatement pstmt = conn.prepareStatement("SELECT LdapConfigurationName FROM ldapconfigmaster WHERE LdapConfigMasterID = ? AND CollectorType = 0 AND CollectorID = 0");){
                        pstmt.setInt(1, adServerData.getLdapConfigMasterId());
                        try (ResultSet res = pstmt.executeQuery();){
                            if (!res.next()) {
                                this.logTraceLog("AD IMPORT Job Processor : CC/Probe JobProcessor will be processed by CloudConnector");
                                return;
                            }
                        }
                    }
                }
                IMPORT_LOG.info("User Job Processing started, Job id is {} and Job Name is {}", (Object)jobDetailModel.getJobId(), (Object)jobDetailModel.getJobName());
                this.updateJobStatusAsStarted(jobDetailModel, conn);
                int credentialProfileId = this.jobConfigurationDao.getCredentialProfileId(conn, adServerData);
                adServerData.setCredentialProfileID(credentialProfileId);
                this.jobConfigurationDao.setAdServerConfigurationDetails(adServerData, conn, this.tenantName);
                if (adServerData.getUserAccessType() == 0) {
                    adServerData.setUserAccessType(5);
                }
                this.licenseConfigDao.setUserLicenseCount(adServerData, conn);
                String jobName = jobDetailModel.getJobName();
                IMPORT_LOG.trace("Updating Deletion allowed to '0' for the Domain id: {} ", (Object)adServerData.getSchedularId());
                this.userImportDao.updateUserDeletionStatus(conn, adServerData);
                boolean isUserImportJob = jobName.endsWith("_Resync") ? Boolean.TRUE : Boolean.FALSE;
                adServerData.setIsUserImportJob(isUserImportJob);
                this.licenseConfigDao.checkAndUpdateUserLicense(adServerData, conn);
            }
            if (jobDetailModel.isProcessUsersFromCCRespone()) {
                List<String> organizationalUnitList = this.cloudConnectorUserImportJobProcessor.getOrganizationalUnitFromCloudOutputDataForJob(adServerData.getSchedularId(), this.tenantName);
                result = this.cloudConnectorLdapService.processCCUsersIntoDatabase(organizationalUnitList, adServerData, this.tenantName);
            } else {
                result = this.userImportController.processImportAdUsers(adServerData, this.tenantName);
            }
            int jobStatus = "SUCCESS".equals(result) ? 1 : -1;
            try (Connection conn = new JdbCConnection().getConnection(this.tenantName);){
                this.jobConfigurationDao.updateJobStatus(jobDetailModel.getJobId(), conn, jobStatus, jobStatusDescriptionSuccess, jobStatusDescriptionFailed);
            }
            this.logJobStatus(jobStatus);
        }
        catch (Exception e) {
            this.updateJobStatusAsFailed(jobDetailModel, jobStatusDescriptionSuccess, jobStatusDescriptionFailed);
            IMPORT_LOG.error("Exception Occurred in AdUserImportJobProcessor method : processAdUserImportResyncJob :: ", (Throwable)e);
        }
        Instant endTime = Instant.now();
        Duration elapsedTime = Duration.between(startTime, endTime);
        IMPORT_LOG.info("Time Taken to Complete the Job {} seconds", (Object)elapsedTime.toSeconds());
    }

    private void logJobStatus(int jobStatus) {
        if (jobStatus == 1) {
            IMPORT_LOG.info("AD IMPORT Job Processor : User import/sync job completed successfully");
        } else {
            IMPORT_LOG.info("AD IMPORT Job Processor : User import/sync job failed");
        }
    }

    private void updateJobStatusAsFailed(JobDetailModel jobDetailModel, String jobStatusDescriptionSuccess, String jobStatusDescriptionFailed) {
        this.logJobStatus(-1);
        try (Connection conn = new JdbCConnection().getConnection(this.tenantName);){
            this.jobConfigurationDao.updateJobStatus(jobDetailModel.getJobId(), conn, -1, jobStatusDescriptionSuccess, jobStatusDescriptionFailed);
        }
        catch (SQLException se) {
            IMPORT_LOG.debug(se.getMessage(), (Throwable)se);
        }
    }

    private void updateJobStatusAsStarted(JobDetailModel jobDetails, Connection conn) throws SQLException {
        String strQuery = "update jobdetails set LastAttemptTime = now() , StatusDescription = ? ,Status = 3 where JobTypeID = 17016 and JobId = ?";
        this.logTraceLog(String.format("updating Job Status:: update jobdetails set LastAttemptTime = %s , StatusDescription = %s ,Status = 3 where JobTypeID = 17016 and JobId = %s", new Date(), "Job processing started.", jobDetails.getJobId()));
        try (PreparedStatement pstmt = conn.prepareStatement(strQuery);){
            pstmt.setString(1, "Job processing started.");
            pstmt.setInt(2, jobDetails.getJobId());
            pstmt.executeUpdate();
        }
    }

    private void logTraceLog(String message) {
        IMPORT_LOG.debug(message);
    }
}

