/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.ldap.service;

import com.sapphireims.user.ldap.service.LdapTemplateService;
import com.sapphireims.user.ldap.service.LdapUserImportService;
import com.sapphireims.user.model.ActiveDirectoryPasswordPolicy;
import com.sapphireims.user.model.AdServerConfigurationModel;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.InvalidAttributeIdentifierException;
import org.springframework.ldap.InvalidAttributeValueException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.stereotype.Service;

@Service
public class LdapForgotPasswordUnlockAccountService {
    private static final Log LOGGER = LogFactory.getLog((String)"com.sapphireims.user");
    private static final String UNICODE_PASSWORD_ATTRIBUTE = "unicodePwd";
    private static final String PASSWORD_RESET_SUCCESS = "Password is reset successfully.";
    private static final String ERROR_WHILE_PROCESSING = "Error while processing";
    private static final String SUCCESS = "SUCCESS";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String SEARCH_FILTER = "(&(objectClass=user)(objectCategory=person))";
    private final LdapTemplateService ldapTemplateService;
    private static final String SEPARATOR = "SAPP";
    private final LdapUserImportService ldapUserImportService;

    public LdapForgotPasswordUnlockAccountService(LdapTemplateService ldapTemplateService, LdapUserImportService ldapUserImportService) {
        this.ldapTemplateService = ldapTemplateService;
        this.ldapUserImportService = ldapUserImportService;
    }

    public String resetAdUserPasswordUsingLDAP(AdServerConfigurationModel configData, String userBaseDn, boolean validationRequired, boolean isCCProcessing, String customerName, String newPassword, String ldapPasswordObjectIdentifiers, String passwordPolicyErrorMessage) {
        String statusResult = ERROR_WHILE_PROCESSING;
        try {
            LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isCCProcessing, configData, customerName, Boolean.TRUE);
            if (validationRequired) {
                statusResult = this.validatePasswordAgainstADPasswordPolicy(ldapTemplate, userBaseDn, newPassword);
            }
            if (!validationRequired || SUCCESS.equalsIgnoreCase(statusResult)) {
                LdapName userCN = LdapUtils.newLdapName((String)userBaseDn);
                userBaseDn = userBaseDn.substring(userBaseDn.indexOf("OU="));
                this.configureLdapContext(ldapTemplate, userBaseDn);
                DirContextOperations ctx1 = ldapTemplate.lookupContext(userCN.getSuffix(userCN.size() - 1));
                byte[] value = new byte[]{48, 3, 2, 1, 1};
                Control[] controls = new Control[]{new BasicControl(ldapPasswordObjectIdentifiers, true, value)};
                InitialLdapContext ctx = (InitialLdapContext)ldapTemplate.getContextSource().getReadWriteContext();
                if (validationRequired) {
                    ctx.setRequestControls(controls);
                }
                byte[] newUnicodePassword = LdapForgotPasswordUnlockAccountService.getPasswordByteArray(newPassword);
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(UNICODE_PASSWORD_ATTRIBUTE, newUnicodePassword))};
                ctx.modifyAttributes(ctx1.getDn().toString().replace("\"", "\\\""), mods);
                return PASSWORD_RESET_SUCCESS;
            }
        }
        catch (Exception ex) {
            return this.setPasswordPolicyErrorMsg(ex, passwordPolicyErrorMessage);
        }
        return statusResult;
    }

    public String changePasswordADUser(AdServerConfigurationModel configData, String userBaseDn, boolean isCCProcessing, String customerName, String oldPassword, String newPassword, String passwordPolicyErrorMessage) {
        String statusResult;
        try {
            LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isCCProcessing, configData, customerName, Boolean.TRUE);
            statusResult = this.validatePasswordAgainstADPasswordPolicy(ldapTemplate, userBaseDn, newPassword);
            if (SUCCESS.equalsIgnoreCase(statusResult)) {
                AndFilter andFilter = new AndFilter();
                andFilter.and((Filter)new EqualsFilter("objectClass", "user"));
                andFilter.and((Filter)new EqualsFilter("distinguishedname", String.valueOf(new LdapName(userBaseDn))));
                String tuserBaseDn = userBaseDn.substring(0, userBaseDn.toUpperCase().indexOf("DC=") - 1);
                String adBaseDn = userBaseDn.substring(userBaseDn.toUpperCase().indexOf("DC="));
                ldapTemplate.search("", andFilter.encode(), attributes -> {
                    BasicAttribute passwordAttribute = new BasicAttribute(UNICODE_PASSWORD_ATTRIBUTE, LdapForgotPasswordUnlockAccountService.getPasswordByteArray(newPassword));
                    BasicAttribute oldAt = new BasicAttribute(UNICODE_PASSWORD_ATTRIBUTE, LdapForgotPasswordUnlockAccountService.getPasswordByteArray(oldPassword));
                    ModificationItem attributeToRemoveOldPassword = new ModificationItem(3, oldAt);
                    ModificationItem passwordChangeModificationItem = new ModificationItem(1, passwordAttribute);
                    this.configureLdapContext(ldapTemplate, adBaseDn);
                    ldapTemplate.modifyAttributes((Name)new LdapName(tuserBaseDn), new ModificationItem[]{attributeToRemoveOldPassword, passwordChangeModificationItem});
                    return null;
                });
                return PASSWORD_RESET_SUCCESS;
            }
        }
        catch (Exception ex) {
            return this.setPasswordPolicyErrorMsg(ex, passwordPolicyErrorMessage);
        }
        return statusResult;
    }

    public String updateADAttributes(AdServerConfigurationModel configData, String userBaseDn, boolean isCCProcessing, String customerName, Map<String, String> windowsAttributes, Map<String, String> unixAttributes) {
        String attributeName = "";
        HashMap<String, String> attributes = new HashMap<String, String>();
        try {
            LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isCCProcessing, configData, customerName, true);
            if (userBaseDn.contains("uid")) {
                userBaseDn = userBaseDn.replace("uid=", "cn=");
            }
            LdapName userCN = LdapUtils.newLdapName((String)userBaseDn);
            userBaseDn = userBaseDn.substring(userBaseDn.indexOf("OU="));
            if (windowsAttributes.size() != 0) {
                attributes.putAll(windowsAttributes);
            } else if (unixAttributes.size() != 0) {
                attributes.putAll(unixAttributes);
            }
            for (Map.Entry entry : attributes.entrySet()) {
                if (((String)entry.getKey()).isEmpty() || ((String)entry.getValue()).isEmpty()) continue;
                attributeName = (String)entry.getKey();
                BasicAttribute attribute = new BasicAttribute((String)entry.getKey(), entry.getValue());
                ModificationItem modificationAttr = new ModificationItem(2, attribute);
                this.configureLdapContext(ldapTemplate, userBaseDn);
                ldapTemplate.modifyAttributes(userCN.getSuffix(userCN.size() - 1), new ModificationItem[]{modificationAttr});
            }
            return "Attributes updated successfully.";
        }
        catch (Exception ex) {
            if (ex instanceof InvalidAttributeIdentifierException) {
                return attributeName + " failed to update.";
            }
            LOGGER.error((Object)("Exception caught while updating attributes in LdapForgotPasswordUnlockAccountService updateADAttributes method " + ex.getMessage()), (Throwable)ex);
            return "Attributes updated successfully.";
        }
    }

    public String unlockLdapUserAccount(AdServerConfigurationModel configData, String userBaseDn, boolean isCCProcessing, String customerName) {
        try {
            LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isCCProcessing, configData, customerName, true);
            BasicAttribute lockoutTimeAttribute = new BasicAttribute("lockoutTime", "0");
            ModificationItem lockoutTimeModification = new ModificationItem(2, lockoutTimeAttribute);
            LdapName userCN = LdapUtils.newLdapName((String)userBaseDn);
            userBaseDn = userBaseDn.substring(userBaseDn.indexOf("OU="));
            this.configureLdapContext(ldapTemplate, userBaseDn);
            ldapTemplate.modifyAttributes(userCN.getSuffix(userCN.size() - 1), new ModificationItem[]{lockoutTimeModification});
            return "Account is Unlocked successfully.";
        }
        catch (Exception ex) {
            Object statusResult = "Unlocking the account Failed; Error Description: ";
            statusResult = ex instanceof CommunicationException ? (String)statusResult + " The connection to the LDAP server failed." : (ex instanceof NamingException ? (String)statusResult + " Bind to LDAP server failed(Unknown Username/Bad Password)" : " Unlocking the account failed.");
            LOGGER.error((Object)("Exception caught while unlocking account in LdapForgotPasswordUnlockAccountService unlockLdapUserAccount method " + ex.getMessage()), (Throwable)ex);
            return statusResult;
        }
    }

    public ActiveDirectoryPasswordPolicy getLdapServerPasswordPolicyFromAD(LdapTemplate ldapTemplate) {
        String ldapFilter = "(&(objectClass=domainDNS))";
        String[] passwordPolicyADAttributes = new String[]{"pwdProperties", "minpwdlength", "maxPwdAge", "minPwdAge"};
        SearchControls searchControl = this.createSearchControls(2, passwordPolicyADAttributes);
        List policies = ldapTemplate.search("", ldapFilter, searchControl, this::extractPasswordPolicy);
        return policies.isEmpty() ? null : (ActiveDirectoryPasswordPolicy)policies.get(0);
    }

    private String validatePasswordAgainstADPasswordPolicy(LdapTemplate ldapTemplate, String ouName, String newPassword) throws ParseException {
        ActiveDirectoryPasswordPolicy passwordPolicy = this.getLdapServerPasswordPolicyFromAD(ldapTemplate);
        Map<String, Object> userAdAttributes = this.getUserAttributesFromActiveDirectory(ldapTemplate, ouName, new String[]{"pwdLastSet", "displayName"});
        String userDisplayName = userAdAttributes.get("displayName").toString();
        String passLastResetDate = this.ldapUserImportService.parseLdapDate(userAdAttributes.get("pwdLastSet").toString());
        Date nextPassResetDate = this.calculateNextPasswordResetDate(passLastResetDate, passwordPolicy.getMinPasswordAge());
        if (this.isPasswordResetTooSoon(new Date(), nextPassResetDate, passwordPolicy.getMinPasswordAge())) {
            return this.getResetTooSoonMessage(passLastResetDate, nextPassResetDate, passwordPolicy.getMinPasswordAge());
        }
        if (this.isPasswordTooShort(newPassword, passwordPolicy.getMinPasswordLength())) {
            return "Password must contain at least " + passwordPolicy.getMinPasswordLength() + " characters";
        }
        if (passwordPolicy.getPasswordProperties() == 1 && this.validatePasswordAgainstDisplayName(newPassword, userDisplayName)) {
            return "Password should not contain the part of user display name";
        }
        if (passwordPolicy.getPasswordProperties() == 1 && !this.isPasswordComplexEnough(newPassword)) {
            return "Password complexity does not meet active directory password policy. Password should be combination of digits, alphabets, and special characters";
        }
        return SUCCESS;
    }

    private boolean validatePasswordAgainstDisplayName(String newPassword, String userDisplayName) {
        String[] splitDisplayNames;
        for (String name : splitDisplayNames = userDisplayName.split(" ")) {
            if (name.length() <= 1 || !newPassword.toLowerCase().contains(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private Date calculateNextPasswordResetDate(String passLastResetDate, Long minPassAge) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return new Date(sdf.parse(passLastResetDate).getTime() + Math.abs(minPassAge / 10000L));
    }

    private boolean isPasswordResetTooSoon(Date currentDate, Date nextPassResetDate, Long minPassAge) {
        return this.getAdPasswordAgeInDays(String.valueOf(minPassAge)) != 0L && currentDate.before(nextPassResetDate);
    }

    private String getResetTooSoonMessage(String passLastResetDate, Date nextPassResetDate, Long minPassAge) {
        long hoursCycle = 24L * this.getAdPasswordAgeInDays(String.valueOf(minPassAge));
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return "You have already reset your password once in a " + hoursCycle + " hrs Cycle on \"" + passLastResetDate + "\". As per policy, you are allowed to reset your password only once in " + hoursCycle + " hrs. You can reset your password after \"" + sdf.format(nextPassResetDate) + "\" or reach out to IT for a password reset.";
    }

    private boolean isPasswordTooShort(String newPassword, int minLength) {
        return newPassword.length() < minLength;
    }

    private boolean isPasswordComplexEnough(String newPassword) {
        int complexityCount = 0;
        complexityCount += Pattern.compile(".*[A-Z].*").matcher(newPassword).matches() ? 1 : 0;
        complexityCount += Pattern.compile(".*[a-z].*").matcher(newPassword).matches() ? 1 : 0;
        complexityCount += Pattern.compile(".*\\d.*").matcher(newPassword).matches() ? 1 : 0;
        return (complexityCount += Pattern.compile(".*[`~!@#$%^&*()\\-_=+\\\\|\\[{\\]};:'\",<.>/?].*").matcher(newPassword).matches() ? 1 : 0) >= 3;
    }

    private SearchControls createSearchControls(int scope, String[] toFetchAttributes) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(scope);
        searchControls.setReturningAttributes(toFetchAttributes);
        return searchControls;
    }

    private void configureLdapContext(LdapTemplate ldapTemplate, String ouName) {
        LdapContextSource ldapContextSource = (LdapContextSource)ldapTemplate.getContextSource();
        ldapContextSource.setBase(ouName);
        ldapContextSource.afterPropertiesSet();
    }

    private Map<String, Object> getUserAttributesFromActiveDirectory(LdapTemplate ldapTemplate, String ouName, String[] toFetchAttributes) {
        SearchControls searchControls = this.createSearchControls(0, toFetchAttributes);
        this.configureLdapContext(ldapTemplate, ouName);
        List attributeList = ldapTemplate.search("", SEARCH_FILTER, searchControls, attributes -> this.mapAttributes(attributes, toFetchAttributes));
        return (Map)attributeList.get(0);
    }

    private Map<String, Object> mapAttributes(Attributes attributes, String[] toFetchAttributes) throws javax.naming.NamingException {
        HashMap<String, Object> userAttributes = new HashMap<String, Object>(toFetchAttributes.length);
        for (String attr : toFetchAttributes) {
            Attribute attribute = attributes.get(attr);
            Object attributeValue = attribute != null ? attribute.get() : null;
            userAttributes.put(attr, attributeValue);
        }
        return userAttributes;
    }

    private ActiveDirectoryPasswordPolicy extractPasswordPolicy(Attributes attributes) throws javax.naming.NamingException {
        ActiveDirectoryPasswordPolicy policy = new ActiveDirectoryPasswordPolicy();
        policy.setMaxPasswordAge(this.parseLongAttribute(attributes.get("maxPwdAge")));
        policy.setMinPasswordAge(this.parseLongAttribute(attributes.get("minPwdAge")));
        policy.setMinPasswordLength(this.parseIntAttribute(attributes.get("minpwdlength")));
        policy.setPasswordProperties(this.parseIntAttribute(attributes.get("pwdProperties")));
        return policy;
    }

    private long parseLongAttribute(Attribute attribute) throws javax.naming.NamingException {
        return Long.parseLong(attribute.get().toString());
    }

    private int parseIntAttribute(Attribute attribute) throws javax.naming.NamingException {
        return Integer.parseInt(attribute.get().toString());
    }

    public long getAdPasswordAgeInDays(String pwdAge) {
        if (pwdAge == null || pwdAge.isEmpty()) {
            return 0L;
        }
        return Math.abs(Long.parseLong(pwdAge) / 10000L / 1000L / 60L / 60L / 24L);
    }

    private static byte[] getPasswordByteArray(String password) {
        String quotedPassword = "\"" + password + "\"";
        return quotedPassword.getBytes(StandardCharsets.UTF_16LE);
    }

    private String setPasswordPolicyErrorMsg(Exception exception, String errorMessage) {
        if (exception instanceof OperationNotSupportedException) {
            if (exception.getMessage().contains("WILL_NOT_PERFORM")) {
                LOGGER.error((Object)("Exception:: Password did not meet password policy configuration in LDAP " + exception.getMessage()), (Throwable)exception);
                return errorMessage;
            }
        } else if (exception instanceof InvalidAttributeValueException) {
            if (Objects.requireNonNull(exception.getMessage()).contains("CONSTRAINT_ATT_TYPE")) {
                LOGGER.error((Object)("Exception:: Password did not meet password policy configuration in LDAP " + exception.getMessage()), (Throwable)exception);
                return errorMessage;
            }
        } else {
            if (exception instanceof CommunicationException) {
                LOGGER.error((Object)("Communication exception caught while resetting password " + exception.getMessage()), (Throwable)exception);
                return "Failed to reset the password; Error Description:  The SSL connection to the LDAP server failed.";
            }
            if (exception instanceof NamingException) {
                LOGGER.error((Object)("Naming exception caught while resetting password  " + exception.getMessage()), (Throwable)exception);
                return "Failed to reset the password; Error Description:  Bind to LDAP server failed(Unknown Username/Bad Password)";
            }
        }
        LOGGER.error((Object)("Exception caught while resetting password in LdapForgotPasswordUnlockAccountService changePasswordADUser method " + exception.getMessage()), (Throwable)exception);
        return ERROR_WHILE_PROCESSING;
    }

    public String getLdapServerPasswordPolicy(AdServerConfigurationModel configData) {
        LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(true, configData, null, true);
        ActiveDirectoryPasswordPolicy passPolicy = this.getLdapServerPasswordPolicyFromAD(ldapTemplate);
        if (passPolicy != null) {
            return passPolicy.getMinPasswordLength() + SEPARATOR + passPolicy.getPasswordProperties() + SEPARATOR + passPolicy.getMinPasswordAge() + SEPARATOR + passPolicy.getMaxPasswordAge();
        }
        return "0SAPP0SAPP0SAPP0";
    }
}

