/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.ldap.service;

import com.sapphire.security.encryption.EncryptionUtil;
import com.sapphireims.user.dao.LdapUserImportDao;
import com.sapphireims.user.ldap.service.LdapOuService;
import com.sapphireims.user.ldap.service.LdapSearch;
import com.sapphireims.user.ldap.service.LdapTemplateService;
import com.sapphireims.user.ldap.service.SdRoleManager;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.AdUserAdditionFieldsModel;
import com.sapphireims.user.model.AdUserDetails;
import com.sapphireims.user.model.LdapAttributeListingModel;
import com.sapphireims.user.model.OuTreeModel;
import com.sapphireims.user.model.ServerCredential;
import com.sapphireims.user.mysql.JdbCConnection;
import com.sapphireims.user.util.SapphireUserImportUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.stereotype.Service;

@Service
public class LdapUserImportService {
    private final LdapUserImportDao userImportDao;
    private final LdapTemplateService ldapTemplateService;
    private final LdapOuService ldapOuService;
    private final Logger logger = LoggerFactory.getLogger((String)"com.sapphireims.user");
    private static final String jpegPhotoFileSize = "jpegPhotoFileSize";

    public LdapUserImportService(LdapUserImportDao userImportDao, LdapTemplateService ldapTemplateService, LdapOuService ldapOuService) {
        this.userImportDao = userImportDao;
        this.ldapTemplateService = ldapTemplateService;
        this.ldapOuService = ldapOuService;
    }

    public String importUsersFromAD(AdServerConfigurationModel ldapConfig, String schema) {
        long startTime = System.currentTimeMillis();
        ArrayList<Object> queryParamValues = new ArrayList<Object>(5);
        try {
            this.logger.info("AD IMPORT : Started importing Ad users for DomainId {}", (Object)ldapConfig.getSchedularId());
            List<LdapAttributeListingModel> adLdapAttributes = this.userImportDao.getAdLdapAttibutes(ldapConfig, schema);
            this.logTraceLog("Configured LDAP attributes are " + String.valueOf(adLdapAttributes));
            int domainId = ldapConfig.getSchedularId();
            String maxWhenChanged = this.getMaxWhenChanged(queryParamValues, domainId, schema);
            if (ldapConfig.getImportType() == 1) {
                this.logTraceLog("Maximum when changed value is " + maxWhenChanged);
                if (maxWhenChanged == null || maxWhenChanged.trim().isEmpty()) {
                    return "SUCCESS";
                }
            }
            int scopeLevelUserImport = NumberUtils.toInt((String)SapphireUserImportUtil.configSettingMap.get(schema).get("LDAP_SCOPE_LEVEL_USERIMPORT"), (int)2);
            this.logTraceLog("Scope level configured for user import is " + scopeLevelUserImport);
            String ldapSearchFilter = this.buildLdapFilter(ldapConfig, adLdapAttributes, maxWhenChanged);
            this.logTraceLog("LDAP User Search filter is " + ldapSearchFilter);
            List<AdUserAdditionFieldsModel> addAttrUser = this.userImportDao.getUserAdditionalFields(ldapConfig.getAdProtocolType(), ldapConfig.getAdServerOperatingSystem(), schema);
            Map<String, Integer> adLdapAttributesMap = this.userImportDao.getDefaultLdapAttributeStatusMap();
            SearchControls searchControls = this.getUserImportSearchControls(scopeLevelUserImport, ldapConfig, adLdapAttributes, addAttrUser, adLdapAttributesMap);
            HashSet<String> organizationalUnits = new HashSet<String>(ldapConfig.getOrganizationalUnit());
            long ldapUserTotalCount = 0L;
            this.logTraceLog("Users importing Organization units are " + String.valueOf(organizationalUnits));
            LdapContextSource contextSource = this.ldapTemplateService.buildLdapContextSource(ldapConfig, ldapConfig.getServerCredential(), Boolean.TRUE, SapphireUserImportUtil.getAesPath(schema), schema, Boolean.FALSE);
            for (String organizationalUnit : organizationalUnits) {
                this.logTraceLog(String.format("User importing started for %s  OU ", organizationalUnit));
                if (ldapConfig.getSecondaryServerCredential() != null && !ldapConfig.getSecondaryServerCredential().isEmpty() && this.ldapTemplateService.checkIfADServerDown(contextSource, ldapConfig.getAdServerOperatingSystem())) {
                    for (ServerCredential secondaryServer : ldapConfig.getSecondaryServerCredential()) {
                        contextSource = this.ldapTemplateService.buildLdapContextSource(ldapConfig, secondaryServer, Boolean.TRUE, SapphireUserImportUtil.getAesPath(schema), schema, Boolean.FALSE);
                    }
                }
                Object tempLdapFilter = ldapSearchFilter;
                if (ldapConfig.getUserImportType() == 2) {
                    if (!ldapConfig.getOuGuids().equals("1")) {
                        tempLdapFilter = ((String)tempLdapFilter).substring(0, ((String)tempLdapFilter).length() - 1);
                        tempLdapFilter = (String)tempLdapFilter + "(&(memberOf=" + LdapUserImportService.getOrganisationUnit(organizationalUnit) + ")))";
                    }
                    this.logger.debug("Search filter for importing users using group {}", tempLdapFilter);
                } else {
                    ldapConfig.getOrganizationalUnit().clear();
                    ldapConfig.getOrganizationalUnit().add(organizationalUnit);
                    contextSource.setBase(LdapUserImportService.getOrganisationUnit(organizationalUnit));
                    contextSource.afterPropertiesSet();
                }
                LdapName baseName = new LdapName("");
                PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(1000);
                LdapSearch ldapSearch = new LdapSearch(baseName, (String)tempLdapFilter, searchControls, adLdapAttributes, schema, false, null);
                ldapSearch.setProcessor(processor);
                ldapSearch.setLdapConfig(ldapConfig);
                ldapSearch.setAdLdapAttributesMap(adLdapAttributesMap);
                ldapSearch.setAddAttrUser(addAttrUser);
                ldapSearch.setDomainId(domainId);
                ldapSearch.setUserImportService(this);
                ldapSearch.setUserImportDao(this.userImportDao);
                long userCount = ldapSearch.doWithSingleContext(contextSource, LdapUserImportService.getOrganisationUnit(organizationalUnit));
                this.logTraceLog(String.format("User importing completed for %s  OU and total users are %s  ", organizationalUnit, userCount));
                ldapUserTotalCount += userCount;
            }
            this.updateUsersTablesPostProcess(ldapConfig, schema, ldapUserTotalCount, domainId, maxWhenChanged);
            this.logger.info("Status After AD IMPORT :: Domain Id {}, Total No of users {}", (Object)ldapConfig.getSchedularId(), (Object)ldapUserTotalCount);
            SdRoleManager sdRoleManager = SdRoleManager.getInstance();
            sdRoleManager.mapRolesToUsers(domainId, schema);
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.logger.trace("Time taken while executing 'importUsersFromAD' method is {} milliseconds", (Object)timeTaken);
        }
        catch (Exception e) {
            this.logger.error("Exception Occurred in LdapUserImportService method : importUsersFromAD : {}", (Object)e.getMessage(), (Object)e);
            return "FAILURE";
        }
        return "SUCCESS";
    }

    public void processAdditionalAttributes(List<AdUserAdditionFieldsModel> addAttrUser, Object attr, AdUserDetails ldapUserModel) throws NamingException {
        HashMap<Integer, String> userAttrAddi = new HashMap<Integer, String>(5);
        for (AdUserAdditionFieldsModel addFieldId : addAttrUser) {
            String addFieldValue = "";
            if (attr instanceof Attributes) {
                Attributes attributes = (Attributes)attr;
                Attribute addUserField = attributes.get(addFieldId.getMappedAttribute());
                if (addUserField != null) {
                    addFieldValue = (String)addUserField.get();
                }
            } else {
                addFieldValue = (String)((Map)attr).get(addFieldId.getMappedAttribute());
            }
            userAttrAddi.put(addFieldId.getAdditionalFieldId(), addFieldValue);
        }
        if (!userAttrAddi.isEmpty()) {
            ldapUserModel.setUserAdditionalAttributes(userAttrAddi);
        }
    }

    public AdUserDetails getAdUserDetails(AdServerConfigurationModel ldapConfig, Map<String, Object> adLdapUserAttributeValues) {
        AdUserDetails ldapUserModel = new AdUserDetails();
        LdapUserImportService.setUserProps("Logon Name", adLdapUserAttributeValues, ldapUserModel::setUserName);
        LdapUserImportService.setUserProps("whenChanged Time", adLdapUserAttributeValues, ldapUserModel::setWhenChanged);
        LdapUserImportService.setUserProps("User Control", adLdapUserAttributeValues, attribute -> ldapUserModel.setUserAccountControl(NumberUtils.toInt((String)((String)attribute))));
        if (ldapUserModel.getUserAccountControl() != 0) {
            String passwordExpire = Integer.toString(ldapUserModel.getUserAccountControl(), 16);
            ldapUserModel.setPasswordNeverExpires(0);
            int passwordExpireLength = passwordExpire.length();
            if (passwordExpireLength >= 5 && "1".contains(String.valueOf(passwordExpire.charAt(passwordExpireLength - 5)))) {
                ldapUserModel.setPasswordNeverExpires(1);
            }
        }
        LdapUserImportService.setUserProps("Cell_No", adLdapUserAttributeValues, ldapUserModel::setCellNo);
        LdapUserImportService.setUserProps("GUID", adLdapUserAttributeValues, ldapUserModel::setGuid);
        LdapUserImportService.setUserProps("Fullname", adLdapUserAttributeValues, ldapUserModel::setFullName);
        LdapUserImportService.setUserProps("Wing", adLdapUserAttributeValues, ldapUserModel::setWing);
        LdapUserImportService.setUserProps("EmailAddress", adLdapUserAttributeValues, ldapUserModel::setEmailAddress);
        LdapUserImportService.setUserProps("City", adLdapUserAttributeValues, ldapUserModel::setCity);
        LdapUserImportService.setUserProps("EmployeeID", adLdapUserAttributeValues, ldapUserModel::setEmployeeId);
        LdapUserImportService.setUserProps("TelephoneNumber", adLdapUserAttributeValues, ldapUserModel::setTelephoneNumber);
        if (adLdapUserAttributeValues.get("BaseDN") != null) {
            ldapUserModel.setBaseDn((String)adLdapUserAttributeValues.get("BaseDN"));
            ldapUserModel.setOuName(ldapUserModel.getBaseDn().trim().substring(ldapUserModel.getBaseDn().trim().indexOf(44) + 1));
        } else if (ldapConfig.getAdServerOperatingSystem() == 1) {
            String baseDn = "uid=" + ldapUserModel.getUserName() + "," + ldapConfig.getOrganizationalUnit().getFirst();
            ldapUserModel.setBaseDn(baseDn);
            ldapUserModel.setOuName(ldapConfig.getOrganizationalUnit().getFirst());
            ldapUserModel.setPasswordNeverExpires(1);
        }
        LdapUserImportService.setUserProps("AccountExpireDate", adLdapUserAttributeValues, ldapUserModel::setAccountExpireDate);
        LdapUserImportService.setUserProps("IsAccountLocked", adLdapUserAttributeValues, ldapUserModel::setIsAccountLocked);
        LdapUserImportService.setUserProps("BadLoginCount", adLdapUserAttributeValues, attribute -> ldapUserModel.setBadLoginCount(NumberUtils.toInt((String)((String)attribute))));
        LdapUserImportService.setUserProps("DepartmentID", adLdapUserAttributeValues, ldapUserModel::setDepartmentName);
        LdapUserImportService.setUserProps("LocationID", adLdapUserAttributeValues, ldapUserModel::setLocationName);
        LdapUserImportService.setUserProps("UserPrincipalName", adLdapUserAttributeValues, ldapUserModel::setUserPrincipalName);
        LdapUserImportService.setUserProps("PasswordLastSet", adLdapUserAttributeValues, ldapUserModel::setPasswordLastSetTime);
        if (adLdapUserAttributeValues.containsKey(jpegPhotoFileSize) && !((String)adLdapUserAttributeValues.get(jpegPhotoFileSize)).isEmpty()) {
            ldapUserModel.setUserProfilePhotoImportedUsingCloudConnector(Boolean.TRUE);
        }
        return ldapUserModel;
    }

    public static <T> void setUserProps(String attrName, Map<String, Object> adUserAttrs, Consumer<T> setter) {
        if (adUserAttrs.get(attrName) != null) {
            setter.accept(adUserAttrs.get(attrName));
        }
    }

    public Map<String, Object> mapAdLdapUserAttributeValues(String schema, List<LdapAttributeListingModel> adLdapAttributes, Object attr, boolean isFromCloudConnector) throws NamingException {
        HashMap<String, Object> adLdapUserAttributeValues = new HashMap<String, Object>();
        for (LdapAttributeListingModel ldapAttributeList : adLdapAttributes) {
            String attributeKey;
            if (ldapAttributeList.getIsConsiderForCollection() != 1) continue;
            Object attributeValue = null;
            String string = attributeKey = ldapAttributeList.getIsMandatory() == 2 ? ldapAttributeList.getAdDisplayAttribute() : ldapAttributeList.getLdapColumnName();
            if (attr instanceof Attributes) {
                Attributes attributes = (Attributes)attr;
                Attribute adAttribute = attributes.get(ldapAttributeList.getAdLdapAttribute());
                if (adAttribute != null) {
                    attributeValue = adAttribute.get();
                }
            } else {
                attributeValue = ((Map)attr).get(ldapAttributeList.getAdLdapAttribute());
            }
            if (ldapAttributeList.getIsMandatory() == 2 && ldapAttributeList.getAdDisplayAttribute().equals("GUID") && attributeValue != null && attributeValue instanceof byte[]) {
                byte[] imageAttribute = (byte[])attributeValue;
                attributeValue = this.getUserGuidFromByteArray(imageAttribute);
            }
            if (!isFromCloudConnector) {
                if (ldapAttributeList.getConversionType() == 1) {
                    if (attributeValue != null) {
                        attributeValue = EncryptionUtil.encrypt((String)SapphireUserImportUtil.getAesPath(schema), (String)((String)attributeValue));
                    }
                } else if (ldapAttributeList.getConversionType() == 2) {
                    attributeValue = this.parseLdapDate((String)attributeValue);
                }
            }
            adLdapUserAttributeValues.put(isFromCloudConnector ? ldapAttributeList.getAdLdapAttribute() : attributeKey, attributeValue);
        }
        return adLdapUserAttributeValues;
    }

    private String getUserGuidFromByteArray(byte[] bytes) {
        StringBuilder guid = new StringBuilder();
        for (byte b : bytes) {
            guid.append(String.format("%02x", b));
        }
        return guid.toString();
    }

    public String parseLdapDate(String ldapDate) {
        if (ldapDate == null) {
            return "0000-00-00 00:00:00";
        }
        char[] ldapDateArr = ldapDate.toCharArray();
        char[] ldapDateCharArr = new char[18];
        for (int i = 0; i < ldapDateCharArr.length; ++i) {
            ldapDateCharArr[i] = i < ldapDateArr.length ? ldapDateArr[i] : 48;
        }
        long ldapDateTime = Long.parseLong(new String(ldapDateCharArr));
        long ldapTimeInNanoSec = ldapDateTime / 10000000L;
        long utcTimeStandardInterval = 11644473600L;
        long timeStamp = ldapTimeInNanoSec - utcTimeStandardInterval;
        Date date = new Date(timeStamp * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public List<String> getAllOrganizationalUnit(LdapTemplate ldapTemplate, Map<String, String> configSettingMap) {
        this.logger.trace("Executing 'getAllOrganizationalUnit' method");
        long startTime = System.currentTimeMillis();
        ArrayList<String> allOrganizationUnitNames = new ArrayList<String>();
        try {
            int searchType = 2;
            int ouListType = NumberUtils.toInt((String)configSettingMap.get("LDAP_OU_LISTING"), (int)1);
            List<OuTreeModel> ouTreeList = this.ldapOuService.getLdapSearchResult(ldapTemplate, searchType, ouListType, configSettingMap.get("LDAP_CUSTOM_FILTER"));
            ouTreeList.forEach(ouModel -> allOrganizationUnitNames.addAll(this.getALLOuFromTreeStructure((OuTreeModel)ouModel)));
            this.logger.trace("No. of Organizational Units retrieved: {}", (Object)allOrganizationUnitNames.size());
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.logger.trace("Time taken while executing 'getAllOrganizationalUnit' method is {} milliseconds", (Object)timeTaken);
        }
        catch (Exception e) {
            this.logger.error("Exception Occurred in LdapUserImportService method : getAllOrganizationalUnit : ");
        }
        return allOrganizationUnitNames;
    }

    public static List<String> buildUserAttributes(Map<String, Integer> adLdapAttributesMap, List<LdapAttributeListingModel> adLdapAttributes, List<AdUserAdditionFieldsModel> addAttrUser) {
        ArrayList<String> attrList = new ArrayList<String>();
        adLdapAttributes.forEach(attrName -> {
            if (attrName.getIsConsiderForCollection() == 1) {
                attrList.add(attrName.getAdLdapAttribute());
            }
            adLdapAttributesMap.put(attrName.getIsMandatory() == 2 ? attrName.getAdDisplayAttribute() : attrName.getLdapColumnName(), attrName.getIsConsiderForCollection());
        });
        for (AdUserAdditionFieldsModel userAddModel : addAttrUser) {
            attrList.add(userAddModel.getMappedAttribute());
        }
        return attrList;
    }

    private List<String> getALLOuFromTreeStructure(OuTreeModel ouModel) {
        this.logger.trace("Executing 'getALLOuFromTreeStructure' method");
        long startTime = System.currentTimeMillis();
        ArrayList<String> allOrganizationUnitNames = new ArrayList<String>(5);
        allOrganizationUnitNames.add(ouModel.getBase());
        if (!ouModel.getChildren().isEmpty()) {
            ouModel.getChildren().forEach(model -> allOrganizationUnitNames.addAll(this.getALLOuFromTreeStructure((OuTreeModel)model)));
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        this.logger.trace("Time taken while executing 'getALLOuFromTreeStructure' method is {} milliseconds", (Object)timeTaken);
        return allOrganizationUnitNames;
    }

    public String buildLdapFilter(AdServerConfigurationModel ldapConfig, List<LdapAttributeListingModel> adLdapAttributes, String maxWhenChanged) {
        StringBuilder ldapFilter = new StringBuilder("(&(objectClass=user)(objectCategory=person))");
        if (ldapConfig.getLdapFilter() != null && !ldapConfig.getLdapFilter().trim().isEmpty()) {
            ldapFilter.deleteCharAt(ldapFilter.length() - 1);
            ldapFilter.append("(&(").append(ldapConfig.getLdapFilter()).append(")))");
        }
        if (ldapConfig.getAdServerOperatingSystem() == 1) {
            ldapFilter = new StringBuilder("(&(");
            if (ldapConfig.getLdapFilter() != null && !ldapConfig.getLdapFilter().trim().isEmpty()) {
                ldapFilter.append(ldapConfig.getLdapFilter());
            } else {
                ldapFilter.append("cn");
            }
            ldapFilter.append("=*))");
        }
        if (ldapConfig.getImportType() == 1) {
            ldapFilter.deleteCharAt(ldapFilter.length() - 1);
            String whenChangedAttr = this.getWhenChangedAdAttribute(adLdapAttributes);
            ldapFilter.append("(&(").append(whenChangedAttr).append(">=").append(maxWhenChanged).append(")))");
        }
        return ldapFilter.toString();
    }

    public SearchControls getUserImportSearchControls(int scopeLevelUserImport, AdServerConfigurationModel ldapConfig, List<LdapAttributeListingModel> adLdapAttributes, List<AdUserAdditionFieldsModel> addAttrUser, Map<String, Integer> adLdapAttributesMap) {
        SearchControls searchControls = new SearchControls();
        if (scopeLevelUserImport == 1) {
            searchControls.setSearchScope(1);
        } else {
            searchControls.setSearchScope(2);
        }
        String[] attrArr = this.buildAttributeList(ldapConfig, adLdapAttributesMap, adLdapAttributes, addAttrUser);
        searchControls.setReturningAttributes(attrArr);
        return searchControls;
    }

    private String[] buildAttributeList(AdServerConfigurationModel ldapConfig, Map<String, Integer> adLdapAttributesMap, List<LdapAttributeListingModel> adLdapAttributes, List<AdUserAdditionFieldsModel> addAttrUser) {
        List<String> attrList = LdapUserImportService.buildUserAttributes(adLdapAttributesMap, adLdapAttributes, addAttrUser);
        if (ldapConfig.getIsImageImportEnabled() == 1) {
            attrList.add("jpegPhoto");
            adLdapAttributes.add(new LdapAttributeListingModel("jpegPhoto", "jpegPhoto", 1, 2));
        }
        String[] attrArr = new String[attrList.size()];
        attrArr = attrList.toArray(attrArr);
        return attrArr;
    }

    public String getWhenChanged(List<Object> queryParamValues, int domainId, Connection conn) throws SQLException {
        String query = "select MAX(whenChanged) as outputValue FROM userdetails where DomainID = ?";
        queryParamValues.add(domainId);
        return this.userImportDao.getUniqueValueFromSQLQuery(query, queryParamValues, conn);
    }

    private void logTraceLog(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        }
    }

    private String getWhenChangedAdAttribute(List<LdapAttributeListingModel> ldapAttributeListingModelList) {
        for (LdapAttributeListingModel ldapAttributeListingModel : ldapAttributeListingModelList) {
            if (ldapAttributeListingModel.getAdDisplayAttribute() == null || !ldapAttributeListingModel.getAdDisplayAttribute().equals("whenChanged Time")) continue;
            return ldapAttributeListingModel.getAdLdapAttribute();
        }
        return "";
    }

    private String getMaxWhenChanged(List<Object> queryParamValues, int domainId, String schema) throws SQLException {
        try (Connection conn = new JdbCConnection().getConnection(schema);){
            String string = this.getWhenChanged(queryParamValues, domainId, conn);
            return string;
        }
    }

    private void updateUsersTablesPostProcess(AdServerConfigurationModel ldapConfig, String schema, long ldapUserTotalCount, int domainId, String maxWhenChanged) throws SQLException {
        try (Connection conn = new JdbCConnection().getConnection(schema);){
            int roleId = ldapConfig.getUserAccessType() == 0 ? 5 : ldapConfig.getUserAccessType();
            this.userImportDao.updateUserRoles(domainId, conn, roleId);
            if (roleId != 5) {
                this.userImportDao.updateUserRoles(domainId, conn, 5);
            }
            if (ldapUserTotalCount != 0L) {
                this.userImportDao.updateDeletedUsersFromADinDb(domainId, ldapConfig.getImportType(), maxWhenChanged, conn);
                this.userImportDao.sendUserImportNotification(ldapConfig, schema);
            }
            this.userImportDao.updateUserPresyncStatus(ldapConfig.getSchedularId(), schema);
        }
    }

    public static String getOrganisationUnit(String dn) {
        String attributeToUse;
        String combinedValue;
        String[] parts = dn.split("(?<!\\\\),");
        ArrayList<String> cnValues = new ArrayList<String>();
        ArrayList<String> ouValues = new ArrayList<String>();
        ArrayList<String> otherParts = new ArrayList<String>();
        boolean lastWasOU = false;
        for (String part : parts) {
            if ((part = part.trim()).startsWith("CN=")) {
                cnValues.add(part.substring(3));
                lastWasOU = false;
                continue;
            }
            if (part.startsWith("OU=")) {
                ouValues.add(part.substring(3));
                lastWasOU = true;
                continue;
            }
            if (!part.contains("=") && lastWasOU) {
                ouValues.add(part);
                continue;
            }
            otherParts.add(part);
            lastWasOU = false;
        }
        if (!cnValues.isEmpty()) {
            ArrayList<String> combined = new ArrayList<String>(cnValues);
            combined.addAll(ouValues);
            combinedValue = String.join((CharSequence)",", combined);
            combinedValue = combinedValue.replaceAll("\\\\,", "\\\\\\\\,");
            combinedValue = combinedValue.replaceAll("(?<!\\\\),", "\\\\\\\\,");
            attributeToUse = "CN";
        } else if (!ouValues.isEmpty()) {
            combinedValue = String.join((CharSequence)",", ouValues);
            combinedValue = combinedValue.replaceAll("(?<!\\\\),", "\\\\,");
            attributeToUse = "OU";
        } else {
            return dn;
        }
        StringBuilder result = new StringBuilder();
        result.append(attributeToUse).append("=").append(combinedValue);
        for (String other : otherParts) {
            result.append(",").append(other);
        }
        return result.toString();
    }
}

