/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.ldap.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PasswordValutService {
    private final Log log = LogFactory.getLog((String)"com.sapphireims.user");
    @Autowired
    @Qualifier(value="restTemplate")
    private RestTemplate restTemplate;

    public Map<String, Object> getPasswordFromVault(Connection connection, int profileId, int passwordVaultType, String customerName) {
        Map returnData = null;
        StringBuilder columnNames = new StringBuilder();
        StringBuilder urlString = new StringBuilder();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            String[] profileColumnValues;
            String lookUpQuery = "SELECT meaning FROM lookuptablesdetail WHERE tableID =? and value =?";
            try (PreparedStatement pstm = connection.prepareStatement(lookUpQuery);){
                pstm.setInt(1, 165);
                pstm.setInt(2, passwordVaultType);
                try (ResultSet rs = pstm.executeQuery();){
                    while (rs.next()) {
                        columnNames.append(rs.getString(1)).append(",");
                    }
                    columnNames = new StringBuilder(columnNames.substring(0, columnNames.length() - 1));
                }
                profileColumnValues = columnNames.toString().split(",");
            }
            String paramQuery = "SELECT " + String.valueOf(columnNames) + " FROM password_vault_profile pv WHERE pv.profileId = ?";
            try (PreparedStatement pstm = connection.prepareStatement(paramQuery);){
                pstm.setInt(1, profileId);
                try (ResultSet resultSet = pstm.executeQuery();){
                    if (resultSet.next()) {
                        for (int i = 1; i <= profileColumnValues.length; ++i) {
                            map.put(profileColumnValues[i - 1], resultSet.getString(i));
                        }
                    }
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                urlString.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            Object baseUrl = this.getVaultUrlString(connection, customerName);
            baseUrl = (String)baseUrl + "&vaultType=" + passwordVaultType + String.valueOf(urlString);
            returnData = (Map)this.restTemplate.getForObject((String)baseUrl, Map.class, new Object[0]);
        }
        catch (Exception exp) {
            this.log.error((Object)("Exception Occured in PasswordValutService method : getPasswordFromVault : " + exp.getMessage()), (Throwable)exp);
        }
        return returnData;
    }

    public String getVaultUrlString(Connection connection, String customerName) {
        String ipaddress = "";
        Object baseUrl = "";
        int port = 0;
        String authKey = "";
        String authToken = "";
        int isSSL = 0;
        String vaultQuery = "SELECT auth_key,auth_token,ipAddress,isSSL,port FROM password_vault_configuration WHERE siteID = 1";
        try (PreparedStatement pstm = connection.prepareStatement(vaultQuery);){
            try (ResultSet result = pstm.executeQuery();){
                if (result.next()) {
                    authKey = result.getString("auth_key");
                    authToken = result.getString("auth_token");
                    ipaddress = result.getString("ipAddress");
                    isSSL = result.getInt("isSSL");
                    port = result.getInt("port");
                }
            }
            String httpSchema = isSSL == 1 ? "https" : "http";
            baseUrl = httpSchema + "://" + ipaddress + ":" + port + "/PasswordVault/getVaultDetails.do?schemaName=" + customerName + "&siteId=1&authKey=" + authKey + "&authToken=" + authToken;
        }
        catch (Exception exp) {
            this.log.error((Object)("Exception Occurred in PasswordValutService method : getVaultUrlString : " + exp.getMessage()), (Throwable)exp);
        }
        return baseUrl;
    }
}

