/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.ldap.service;

import com.sapphireims.user.mysql.JdbCConnection;
import com.sapphireims.user.util.SapphireUserImportUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SdRoleManager {
    private final Logger logger = LoggerFactory.getLogger((String)"com.sapphireims.user");
    private static final int RETAIN_ROLES_FOR_ALL_USERS = 0;
    private static final int REMOVE_INACTIVE_USER_ROLES = 1;
    private static final int REMOVE_DELETED_USER_ROLES = 2;
    private static final int REMOVE_ALL_USER_ROLES = 3;
    private static final SdRoleManager instance = new SdRoleManager();

    public static SdRoleManager getInstance() {
        return instance;
    }

    private SdRoleManager() {
    }

    public void mapRolesToUsers(int domainId, String tenantName) {
        int moduleEnabled = NumberUtils.toInt((String)SapphireUserImportUtil.configSettingMap.get(tenantName).get("MODULES_Enabled"), (int)3);
        if (moduleEnabled == 2) {
            this.logger.info("SD project Roles mapping not applicable for ITOM hence skipping the roles mapping to users");
            return;
        }
        Instant start = Instant.now();
        try (Connection connection = new JdbCConnection().getConnection(tenantName);){
            this.unAllocateSDLicense(connection, domainId, tenantName);
            this.logger.debug("SD default project Roles mapping is Started");
            List<Role> roles = this.getRoles(connection);
            for (Role role : roles) {
                String query = "INSERT INTO sd_project_roles_details (ProjectRoleID, UserID) SELECT\n " + role.roleId() + ",ud.UserID  FROM userdetails ud\n WHERE ud.DomainID = ? and ud.UserStatus = 0\n AND NOT EXISTS (\n    SELECT  distinct ud.UserID\n    FROM sd_project_roles_details sdrd inner join sd_project_roles spd on spd.ProjectRoleid = sdrd.ProjectRoleID\n    WHERE sdrd.UserID = ud.UserID AND spd.ProjectId = ?\n)\n";
                PreparedStatement pst = connection.prepareStatement(query);
                try {
                    pst.setInt(1, domainId);
                    pst.setInt(2, role.projectId());
                    int count = pst.executeUpdate();
                    this.logger.info("for Domain Id {} , {} users mapped to SD roles and Project Id {} ", new Object[]{domainId, count, role.projectId()});
                }
                finally {
                    if (pst == null) continue;
                    pst.close();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception caught while mapping SD roles to Users, domainId {}", (Object)domainId, (Object)e);
        }
        Instant endTime = Instant.now();
        Duration elapsedTime = Duration.between(start, endTime);
        this.logger.debug("SD default project Roles mapping is completed and time taken is {} seconds", (Object)elapsedTime.toSeconds());
    }

    private List<Role> getRoles(Connection connection) throws SQLException {
        ArrayList<Role> roles = new ArrayList<Role>(5);
        String sql = "select distinct spd.parametervalue as sdRole, spm.projectId as projectId from sd_project_details spd\n    inner join sd_project_master spm on spd.ProjectID = spm.ProjectID where spd.parameterid = 2 and spm.Status = 0\n";
        try (PreparedStatement pst = connection.prepareStatement(sql);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                roles.add(new Role(rs.getInt("sdRole"), rs.getInt("projectId")));
            }
        }
        return roles;
    }

    private void unAllocateSDLicense(Connection connection, int domainId, String tenantName) {
        String whereCondition;
        this.logger.debug("SD  project roles un-allocation is started");
        int roleRemoval = NumberUtils.toInt((String)SapphireUserImportUtil.configSettingMap.get(tenantName).get("AD_PROJECTROLE_REMOVAL"), (int)0);
        this.logger.debug("AD_PROJECTROLE_REMOVAL setting value is {} ", (Object)roleRemoval);
        if (roleRemoval == 0) {
            this.logger.debug("Project Role removal is disabled hence no roles will be unallocated");
            return;
        }
        if (roleRemoval == 1) {
            whereCondition = " AND um.domainid = ? AND  um.Userstatus = 1";
        } else if (roleRemoval == 2) {
            whereCondition = " AND um.domainid = ? AND  um.Userstatus = 2";
        } else if (roleRemoval == 3) {
            whereCondition = " AND um.domainid = ? AND  um.Userstatus <> 0";
        } else {
            this.logger.warn("AD_PROJECTROLE_REMOVAL setting value is invalid: {}", (Object)roleRemoval);
            return;
        }
        String query = "Delete sprd from sd_project_roles_details sprd inner join sd_project_roles spr\n on spr.ProjectRoleid = sprd.ProjectRoleid inner join sd_project_master spm on spm.projectid=spr.projectid\n inner join userdetails um on um.userID = sprd.userId where spm.status = 0\n" + whereCondition;
        try (PreparedStatement pst = connection.prepareStatement(query);){
            pst.setInt(1, domainId);
            int count = pst.executeUpdate();
            this.logger.info("");
        }
        catch (SQLException se) {
            this.logger.error("while removing SD project user roles {} ", (Object)se.getMessage(), (Object)se);
        }
        this.logger.debug("SD project roles un-allocation is completed");
    }

    private record Role(int roleId, int projectId) {
    }
}

