/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.mysql;

import com.sapphireims.user.util.SapphireUserImportUtil;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbCConnection {
    private static final String DATASOURCENAME = "datasourcename";
    public static final String EXCEPTION_OCCURRED_DURING_CREATING_CONNECTION = "Exception occurred during creating connection ::";
    private static String defaultDataSourceName = null;
    private static DataSource defaultDataSource = null;
    private static final Map<String, DataSource> DATASOURCE_MAP = new ConcurrentHashMap<String, DataSource>();
    private static final Log logger = LogFactory.getLog((String)"com.sapphireims.user");

    private static void initDataSource() {
        if (defaultDataSource == null) {
            defaultDataSource = JdbCConnection.getDataSource();
        }
    }

    private static String getDataSourceName() {
        String dataSourceName = "";
        try {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(SapphireUserImportUtil.warFilePath + "/WEB-INF/classes/IMSPackage/db.properties");){
                props.load(fis);
            }
            if (props.getProperty(DATASOURCENAME) != null) {
                dataSourceName = props.getProperty(DATASOURCENAME);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred during getting data source name ::" + e.getMessage()), (Throwable)e);
        }
        if (dataSourceName == null || dataSourceName.trim().equalsIgnoreCase("")) {
            dataSourceName = "java:/MySqlIMS";
        }
        return dataSourceName;
    }

    public Connection getConnection(String tenantName) {
        try {
            DataSource dataSource;
            String dataSourceNameStr;
            JdbCConnection.initDataSource();
            if (SapphireUserImportUtil.installType != 3) {
                return defaultDataSource.getConnection();
            }
            if (!DATASOURCE_MAP.containsKey(tenantName = tenantName.toLowerCase()) && (dataSourceNameStr = this.getDataSourceName(tenantName)) != null && (dataSource = this.getDataSource(dataSourceNameStr)) != null) {
                DATASOURCE_MAP.put(tenantName, dataSource);
            }
            return DATASOURCE_MAP.get(tenantName).getConnection();
        }
        catch (SQLException e) {
            logger.error((Object)(EXCEPTION_OCCURRED_DURING_CREATING_CONNECTION + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getDataSourceName(String tenantName) {
        String dataSource = "";
        try {
            Object path = "";
            if (!tenantName.equalsIgnoreCase("ims")) {
                path = tenantName + "_";
            }
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(SapphireUserImportUtil.warFilePath + "/WEB-INF/classes/IMSPackage/" + (String)path + "db.properties");){
                props.load(fis);
            }
            if (props.getProperty(DATASOURCENAME) != null) {
                dataSource = props.getProperty(DATASOURCENAME);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred during getting data source name ::" + e.getMessage()), (Throwable)e);
        }
        return dataSource;
    }

    private static DataSource getDataSource() {
        try {
            if (defaultDataSourceName == null) {
                defaultDataSourceName = JdbCConnection.getDataSourceName();
            }
            return (DataSource)new InitialContext().lookup(defaultDataSourceName);
        }
        catch (Exception e1) {
            logger.error((Object)(EXCEPTION_OCCURRED_DURING_CREATING_CONNECTION + e1.getMessage()), (Throwable)e1);
            return null;
        }
    }

    private DataSource getDataSource(String dataSourceName1) {
        try {
            return (DataSource)new InitialContext().lookup(dataSourceName1);
        }
        catch (Exception e1) {
            logger.error((Object)(EXCEPTION_OCCURRED_DURING_CREATING_CONNECTION + e1.getMessage()), (Throwable)e1);
            return null;
        }
    }
}

