/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.apilogin.api;

import com.sapphire.security.encryption.EncryptionUtil;
import com.sapphireims.user.apilogin.util.UserApiUtil;
import com.sapphireims.user.model.AdGroupDetails;
import com.sapphireims.user.model.AdGroupList;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.AdUserDetails;
import com.sapphireims.user.model.AdUserList;
import com.sapphireims.user.model.ApiAuthToken;
import com.sapphireims.user.model.GsuiteMemberList;
import com.sapphireims.user.model.GsuiteUserPhoto;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class ApiHelper {
    private static final String AZURE_ONELOGIN_TOKEKN_GRANT_TYPE = "client_credentials";
    private static final String GSUITE_TOKEN_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String SCOPE = "https://graph.microsoft.com/.default";
    private static final String AZURE_BEARER_TOKEN_API = "https://login.microsoftonline.com/MACRO_TENENT_ID/oauth2/v2.0/token";
    private static final String ONELOGIN_BEARER_TOKEN_API = "https://api.MACRO_REGION.onelogin.com/auth/oauth2/v2/token";
    private static final String AZURE_GRAPH_API_URL = "https://graph.microsoft.com/v1.0";
    private static final String ONELOGIN_AD_API_URL = "https://api.MACRO_REGION.onelogin.com/api/1";
    private static final String GSUITE_ACCESS_TOKEN_API = "https://oauth2.googleapis.com/token";
    private static final String GSUITE_GOOGLEAPI = "https://admin.googleapis.com/admin/directory/v1";
    private static final String AZURE_USERS_FROM_GROUP_API_URL = "https://graph.microsoft.com/v1.0/groups/MACRO_GROUP_GUID/members/microsoft.graph.user";
    private static final String AZURE_USER_PHOTO_SYNC_URL = "https://graph.microsoft.com/v1.0/users/MACRO_USER_ID/photo/$value";
    private static final String ONELOGIN_SET_USER_PASSWORD_API_URL = "https://api.MACRO_REGION.onelogin.com/api/1/users/set_password_clear_text/MACRO_USER_ID";
    private static final String GSUITE_USER_PHOTO_URL = "https://admin.googleapis.com/admin/directory/v1/users/MACRO_USER_ID/photos/thumbnail";
    private static final String GSUITE_GROUP_MEMBERS_API = "https://admin.googleapis.com/admin/directory/v1/groups/MACRO_GROUP_GUID/members";
    public static final String PASSWORD = "password";
    public static final String AD_IMPORT_NUMBER_OF_AD_USERS_FROM_RESPONSE = "AD IMPORT : Number of Ad users from response : ";
    public static final String USERS_URI = "/users/";
    public static final String EXPAND_URL_PARAM = "&$expand=";
    public static final String MANAGER = "manager";
    public static final String MAX_RESULTS = "&maxResults=";
    public static final String USERS_CUSTOMER = "/users?customer=";
    public static final String PROJECTION_FULL = "&projection=full";
    private final Logger log = LoggerFactory.getLogger((String)"com.sapphireims.user");
    private final String className = this.getClass().getName();
    private static final String ONE_LOGIN_API_REGION = "us";
    private static final int MAX_USERS_TO_RETRIEVE = 500;
    private static final int MAX_GROUPS_TO_RETRIEVE = 500;
    private static final String MACRO_TENENT_ID = "MACRO_TENENT_ID";
    private static final String MACRO_REGION = "MACRO_REGION";
    private static final String MACRO_GROUP_GUID = "MACRO_GROUP_GUID";
    private static final String MACRO_USER_ID = "MACRO_USER_ID";
    private static final String GRANT_TYPE = "grant_type";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String SCOPE_CONSTANT = "scope";
    private static final String CLIENT_ID = "client_id";
    private static final String AUTHORIZATION = "Authorization";
    private static final String ASSERTION = "assertion";
    private RestTemplate restTemplate;

    @Autowired
    @Qualifier(value="restTemplate")
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private HttpEntity<MultiValueMap<String, String>> getOauth2RequestEntity(AdServerConfigurationModel adConfig) {
        HttpHeaders requestHeaders = new HttpHeaders();
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        if (adConfig.getAdProtocolType() == 5) {
            formData.add((Object)GRANT_TYPE, (Object)GSUITE_TOKEN_GRANT_TYPE);
        } else {
            formData.add((Object)GRANT_TYPE, (Object)AZURE_ONELOGIN_TOKEKN_GRANT_TYPE);
        }
        if (adConfig.getAdProtocolType() == 3) {
            this.log.debug("{} Adding Client secret and client id for Azure", (Object)this.className);
            formData.add((Object)CLIENT_SECRET, (Object)adConfig.getAdClientSecretKey());
            formData.add((Object)SCOPE_CONSTANT, (Object)SCOPE);
            formData.add((Object)CLIENT_ID, (Object)adConfig.getAdAppId());
        } else if (adConfig.getAdProtocolType() == 4) {
            this.log.debug("{} Adding Client secret and client id for One-login ", (Object)this.className);
            String authorization = String.format("%s:%s", adConfig.getAdAppId(), adConfig.getAdClientSecretKey());
            byte[] base64EncodedAuthorization = Base64.getEncoder().encode(authorization.getBytes());
            requestHeaders.set(AUTHORIZATION, "Basic " + new String(base64EncodedAuthorization));
        } else if (adConfig.getAdProtocolType() == 5) {
            String signedJwtToken = UserApiUtil.generateSignedJwt(adConfig);
            this.log.debug("{} Generating G-SUITE JWT Token ", (Object)this.className);
            formData.add((Object)ASSERTION, (Object)signedJwtToken);
        }
        return new HttpEntity((Object)formData, (MultiValueMap)requestHeaders);
    }

    private <T> T getApiRequestEntity(int adProtocolType, String bearerAuthToken, T requestEntity, Object requestBody) {
        HttpHeaders requestHeaders = new HttpHeaders();
        if (adProtocolType == 3) {
            requestHeaders.set(AUTHORIZATION, bearerAuthToken);
        } else if (adProtocolType == 4) {
            requestHeaders.set(AUTHORIZATION, "bearer:" + bearerAuthToken);
        } else if (adProtocolType == 5) {
            requestHeaders.set(AUTHORIZATION, "Bearer " + bearerAuthToken);
        }
        if (requestBody == null) {
            return (T)new HttpEntity((MultiValueMap)requestHeaders);
        }
        requestHeaders.setContentType(MediaType.APPLICATION_JSON);
        return (T)new HttpEntity(requestBody, (MultiValueMap)requestHeaders);
    }

    public ApiAuthToken getBearerAuthToken(AdServerConfigurationModel adConfig) {
        ApiAuthToken bearerAuthToken = null;
        try {
            String bearerAuthApi = "";
            if (adConfig.getAdProtocolType() == 3) {
                this.log.debug("{} Getting bearer auth token for Azure ", (Object)this.className);
                bearerAuthApi = AZURE_BEARER_TOKEN_API.replace(MACRO_TENENT_ID, adConfig.getAdDirectoryId());
            } else if (adConfig.getAdProtocolType() == 4) {
                this.log.debug("{} Getting bearer auth token for One-Login ", (Object)this.className);
                bearerAuthApi = ONELOGIN_BEARER_TOKEN_API.replace(MACRO_REGION, ONE_LOGIN_API_REGION);
            } else if (adConfig.getAdProtocolType() == 5) {
                this.log.debug("{} Getting bearer auth token for Google Workspace ", (Object)this.className);
                bearerAuthApi = GSUITE_ACCESS_TOKEN_API;
            }
            this.log.debug("{} AD IMPORT : Inside getBearerAuthToken custId :{}  : email : {} : service emaill {}: ", new Object[]{this.className, adConfig.getGsuiteCustomerId(), adConfig.getGsuiteEmail(), adConfig.getGsuiteServiceEmail()});
            HttpEntity<MultiValueMap<String, String>> requestEntity = this.getOauth2RequestEntity(adConfig);
            this.log.debug("{} AD IMPORT : Requesting for Api Auth token : url = {}", (Object)this.className, (Object)bearerAuthApi);
            ResponseEntity responseEntity = this.restTemplate.exchange(bearerAuthApi, HttpMethod.POST, requestEntity, ApiAuthToken.class, new Object[0]);
            bearerAuthToken = (ApiAuthToken)responseEntity.getBody();
            this.log.debug("{} AD IMPORT : Api Auth Token received", (Object)this.className);
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getBearerAuthToken : {}", (Object)e.getMessage(), (Object)e);
        }
        return bearerAuthToken;
    }

    public boolean isBearerTokenExpired(AdServerConfigurationModel serverConfig) {
        if (serverConfig.getAccessToken() == null || serverConfig.getAccessToken().isEmpty()) {
            this.log.debug("{} AD IMPORT : Invalid Auth Token", (Object)this.className);
            return true;
        }
        try {
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            String getAdUserApiUrl = ApiHelper.buildGetAdUserApiUrl(serverConfig);
            this.restTemplate.exchange(getAdUserApiUrl, HttpMethod.GET, requestEntity, AdUserList.class, new Object[0]);
            return false;
        }
        catch (Exception e) {
            this.log.debug("{} AD IMPORT : Auth token expired", (Object)this.className);
            return true;
        }
    }

    private static String buildGetAdUserApiUrl(AdServerConfigurationModel serverConfig) {
        Object getAdUserApiUrl = "";
        if (serverConfig.getAdProtocolType() == 3) {
            getAdUserApiUrl = "https://graph.microsoft.com/v1.0/users?$top=1&$select=id";
        } else if (serverConfig.getAdProtocolType() == 4) {
            getAdUserApiUrl = ONELOGIN_AD_API_URL.replace(MACRO_REGION, ONE_LOGIN_API_REGION) + "/users?limit=1&fields=id";
        } else if (serverConfig.getAdProtocolType() == 5) {
            getAdUserApiUrl = "https://admin.googleapis.com/admin/directory/v1/users?customer=" + serverConfig.getGsuiteCustomerId() + "&maxResults=1&projection=full";
        }
        return getAdUserApiUrl;
    }

    public AdUserList getAdUserList(AdServerConfigurationModel serverConfig, List<String> userAttributeList) {
        AdUserList adUserListResponse = null;
        try {
            String adUserListApiUrl;
            ResponseEntity responseEntity;
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            StringBuilder adUserAttributes = new StringBuilder();
            StringBuilder expandList = ApiHelper.getExpandList(userAttributeList, adUserAttributes);
            StringBuilder expandParameter = new StringBuilder();
            if (!expandList.isEmpty()) {
                expandParameter.append(EXPAND_URL_PARAM).append((CharSequence)expandList.deleteCharAt(expandList.length() - 1));
            }
            if ((adUserListResponse = (AdUserList)(responseEntity = this.restTemplate.exchange(adUserListApiUrl = ApiHelper.getApiUrl(serverConfig, adUserAttributes, expandParameter), HttpMethod.GET, requestEntity, AdUserList.class, new Object[0])).getBody()) != null && adUserListResponse.getUsers() != null) {
                this.log.debug("{} AD IMPORT : Number of Ad users from response : {}", (Object)this.className, (Object)adUserListResponse.getUsers().size());
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getAdUserList : {}", (Object)e.getMessage(), (Object)e);
        }
        return adUserListResponse;
    }

    private static StringBuilder getExpandList(List<String> userAttributeList, StringBuilder adUserAttributes) {
        StringBuilder expandList = new StringBuilder();
        if (userAttributeList != null) {
            for (String column : userAttributeList) {
                String[] attributeProperty = null;
                if (column.contains(".")) {
                    attributeProperty = column.split("\\.");
                    column = attributeProperty[0];
                }
                if (column.equals(MANAGER)) {
                    expandList.append(column);
                    if (attributeProperty != null && attributeProperty.length > 1) {
                        expandList.append("($select=").append(attributeProperty[1]).append(')');
                    }
                    expandList.append(',');
                    continue;
                }
                adUserAttributes.append(column).append(",");
            }
            if (!adUserAttributes.isEmpty()) {
                adUserAttributes.deleteCharAt(adUserAttributes.length() - 1);
            }
        }
        return expandList;
    }

    private static String getApiUrl(AdServerConfigurationModel serverConfig, StringBuilder adUserAttributes, StringBuilder expandParameter) {
        if (serverConfig.getAdProtocolType() == 3) {
            return "https://graph.microsoft.com/v1.0/users?$top=500&$select=" + String.valueOf(adUserAttributes) + String.valueOf(expandParameter);
        }
        if (serverConfig.getAdProtocolType() == 4) {
            return ONELOGIN_AD_API_URL.replace(MACRO_REGION, ONE_LOGIN_API_REGION) + "/users?limit=50&fields=" + String.valueOf(adUserAttributes);
        }
        if (serverConfig.getAdProtocolType() == 5) {
            return "https://admin.googleapis.com/admin/directory/v1/users?customer=" + serverConfig.getGsuiteCustomerId() + "&maxResults=500&projection=full";
        }
        return "";
    }

    public AdUserList getAdUserListFromGroup(AdServerConfigurationModel serverConfig, String groupId, List<String> userAttributeList) {
        AdUserList adUserListResponse = null;
        try {
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            Object adUserListApiUrl = "";
            StringBuilder adUserAttributes = new StringBuilder();
            userAttributeList.forEach(colums -> {
                if (colums.contains(".")) {
                    colums = colums.replace('.', ' ').split(" ")[0];
                }
                adUserAttributes.append((String)colums).append(",");
            });
            adUserAttributes.deleteCharAt(adUserAttributes.length() - 1);
            if (serverConfig.getAdProtocolType() == 3) {
                adUserListApiUrl = AZURE_USERS_FROM_GROUP_API_URL.replace(MACRO_GROUP_GUID, groupId) + "?$select=id,givenName,userPrincipalName&$top=500";
            } else if (serverConfig.getAdProtocolType() == 4) {
                adUserListApiUrl = ONELOGIN_AD_API_URL.replace(MACRO_REGION, ONE_LOGIN_API_REGION) + "/users?fields=" + String.valueOf(adUserAttributes) + "&limit=50";
            }
            ResponseEntity responseEntity = this.restTemplate.exchange((String)adUserListApiUrl, HttpMethod.GET, requestEntity, AdUserList.class, new Object[0]);
            adUserListResponse = (AdUserList)responseEntity.getBody();
            if (adUserListResponse != null && adUserListResponse.getUsers() != null) {
                this.log.debug("{} AD IMPORT : Number of Ad users from response : : {} ", (Object)this.className, (Object)adUserListResponse.getUsers().size());
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getAdUserListFromGroup : {}", (Object)e.getMessage(), (Object)e);
        }
        return adUserListResponse;
    }

    public AdUserList getUsersFromNextLink(AdServerConfigurationModel serverConfig, String nextLink) {
        AdUserList adUserListResponse = null;
        try {
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            if (serverConfig.getAdProtocolType() == 3 || serverConfig.getAdProtocolType() == 4) {
                nextLink = URLDecoder.decode((String)nextLink, StandardCharsets.UTF_8);
            } else if (serverConfig.getAdProtocolType() == 5) {
                nextLink = "https://admin.googleapis.com/admin/directory/v1/users?customer=" + serverConfig.getGsuiteCustomerId() + "&maxResults=500&projection=full&pageToken=" + (String)nextLink;
            }
            ResponseEntity responseEntity = this.restTemplate.exchange((String)nextLink, HttpMethod.GET, requestEntity, AdUserList.class, new Object[0]);
            adUserListResponse = (AdUserList)responseEntity.getBody();
            if (adUserListResponse != null && adUserListResponse.getUsers() != null) {
                this.log.debug("AD IMPORT : Number of Ad users from response : {}", (Object)adUserListResponse.getUsers().size());
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getUsersFromNextLink : {}", (Object)e.getMessage(), (Object)e);
        }
        return adUserListResponse;
    }

    public Map<String, Object> getAdUser(AdServerConfigurationModel serverConfig, String userGuid, List<String> userAttributeList) {
        Map adUser = null;
        try {
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            StringBuilder adUserAttributes = new StringBuilder();
            StringBuilder expandList = ApiHelper.getExpandList(userAttributeList, adUserAttributes);
            StringBuilder expandParameter = new StringBuilder();
            if (!expandList.isEmpty()) {
                expandParameter.append(EXPAND_URL_PARAM).append((CharSequence)expandList.deleteCharAt(expandList.length() - 1));
            }
            String adUserListApiUrl = "https://graph.microsoft.com/v1.0/users/" + userGuid + "?$select=" + String.valueOf(adUserAttributes) + String.valueOf(expandParameter);
            ResponseEntity responseEntity = this.restTemplate.exchange(adUserListApiUrl, HttpMethod.GET, requestEntity, Object.class, new Object[0]);
            adUser = (Map)responseEntity.getBody();
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getAdUserList : {}", (Object)e.getMessage(), (Object)e);
        }
        return adUser;
    }

    public AdGroupList getAdGroupList(AdServerConfigurationModel serverConfig) {
        AdGroupList adGroupListResponse = null;
        try {
            Object adGroupListApiUrl = "";
            if (serverConfig.getAdProtocolType() == 3) {
                adGroupListApiUrl = "https://graph.microsoft.com/v1.0/groups?$top=500";
            } else if (serverConfig.getAdProtocolType() == 4) {
                adGroupListApiUrl = ONELOGIN_AD_API_URL.replace(MACRO_REGION, ONE_LOGIN_API_REGION) + "/groups?limit=50";
            } else if (serverConfig.getAdProtocolType() == 5) {
                adGroupListApiUrl = "https://admin.googleapis.com/admin/directory/v1/groups?customer=" + serverConfig.getGsuiteCustomerId() + "&maxResults=200";
            }
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            ResponseEntity responseEntity = this.restTemplate.exchange((String)adGroupListApiUrl, HttpMethod.GET, requestEntity, AdGroupList.class, new Object[0]);
            adGroupListResponse = (AdGroupList)responseEntity.getBody();
            if (adGroupListResponse != null && adGroupListResponse.getGroups() != null) {
                this.log.debug("{} AD IMPORT : Number of Ad groups from response : {}", (Object)this.className, (Object)adGroupListResponse.getGroups().size());
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getAdGroupList : {}", (Object)e.getMessage(), (Object)e);
        }
        return adGroupListResponse;
    }

    public AdGroupList getGroupsFromNextLink(AdServerConfigurationModel serverConfig, String nextLink) {
        AdGroupList adGroupListResponse = null;
        try {
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            if (serverConfig.getAdProtocolType() == 3 || serverConfig.getAdProtocolType() == 4) {
                nextLink = URLDecoder.decode((String)nextLink, StandardCharsets.UTF_8);
                this.log.debug("{} AD IMPORT : Requesting groups from AD using nextlink **", (Object)this.className);
            } else if (serverConfig.getAdProtocolType() == 5) {
                nextLink = "https://admin.googleapis.com/admin/directory/v1/groups?customer=" + serverConfig.getGsuiteCustomerId() + "&maxResults=200&pageToken=" + (String)nextLink;
                this.log.debug("{} AD IMPORT : Requesting groups from AD using nextPageToken", (Object)this.className);
            }
            ResponseEntity responseEntity = this.restTemplate.exchange((String)nextLink, HttpMethod.GET, requestEntity, AdGroupList.class, new Object[0]);
            adGroupListResponse = (AdGroupList)responseEntity.getBody();
            if (adGroupListResponse != null && adGroupListResponse.getGroups() != null) {
                this.log.debug("{} AD IMPORT : Number of Ad groups from response : {}", (Object)this.className, (Object)adGroupListResponse.getGroups().size());
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getGroupsFromNextLink : {}", (Object)e.getMessage(), (Object)e);
        }
        return adGroupListResponse;
    }

    public AdGroupDetails getAdGroupByName(AdServerConfigurationModel serverConfig, String groupName) {
        AdGroupDetails adGroupResponse = null;
        try {
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            String displayName = groupName.replace("'", "''");
            if (serverConfig.getAdProtocolType() == 3) {
                String requestUri = "https://graph.microsoft.com/v1.0/groups?$filter=displayName eq '{displayName}'";
                ResponseEntity responseEntity = this.restTemplate.exchange(requestUri, HttpMethod.GET, requestEntity, AdGroupList.class, new Object[]{displayName});
                AdGroupList groupList = (AdGroupList)responseEntity.getBody();
                if (groupList != null && groupList.getGroups() != null && !groupList.getGroups().isEmpty()) {
                    adGroupResponse = groupList.getGroups().get(0);
                }
            } else if (serverConfig.getAdProtocolType() == 5) {
                String requestUri = "https://admin.googleapis.com/admin/directory/v1/groups/" + groupName + "?maxResults=1&customer=" + serverConfig.getGsuiteCustomerId();
                ResponseEntity responseEntity = this.restTemplate.exchange(requestUri, HttpMethod.GET, requestEntity, AdGroupDetails.class, new Object[0]);
                adGroupResponse = (AdGroupDetails)responseEntity.getBody();
            }
            if (adGroupResponse != null) {
                this.log.debug("{} AD IMPORT : AD Group from response {}", (Object)this.className, adGroupResponse);
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getAdGroupByName : {}", (Object)e.getMessage(), (Object)e);
        }
        return adGroupResponse;
    }

    public AdUserList getUserListUpdatedAfter(AdServerConfigurationModel serverConfig, List<String> userAttributeList, String strDateTime) {
        AdUserList adUserListResponse = null;
        try {
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            Object requestUri = "";
            StringBuilder adUserAttributes = new StringBuilder();
            StringBuilder expandList = new StringBuilder();
            userAttributeList.forEach(colums -> {
                if (colums.contains(".")) {
                    colums = colums.replace('.', ' ').split(" ")[0];
                }
                if (colums.equals(MANAGER)) {
                    expandList.append((String)colums).append(",");
                } else {
                    adUserAttributes.append((String)colums).append(",");
                }
            });
            StringBuilder expandParameter = new StringBuilder();
            if (!expandList.isEmpty()) {
                expandParameter.append(EXPAND_URL_PARAM).append((CharSequence)expandList.deleteCharAt(expandList.length() - 1));
            }
            adUserAttributes.deleteCharAt(adUserAttributes.length() - 1);
            Object[] queryParams = new Object[]{};
            if (serverConfig.getAdProtocolType() == 3) {
                requestUri = "https://graph.microsoft.com/v1.0/users?$filter=((onPremisesLastSyncDateTime ge {strDateTime}) or (createdDateTime ge {strDateTime}))&$select={adUserAttributes}" + String.valueOf(expandParameter);
                queryParams = new Object[]{strDateTime, strDateTime, adUserAttributes};
            } else if (serverConfig.getAdProtocolType() == 4) {
                requestUri = ONELOGIN_AD_API_URL.replace(MACRO_REGION, ONE_LOGIN_API_REGION) + "/users?fields={adUserAttributes}";
                queryParams = new Object[]{adUserAttributes};
            } else if (serverConfig.getAdProtocolType() == 5) {
                requestUri = "https://admin.googleapis.com/admin/directory/v1/users?customer=" + serverConfig.getGsuiteCustomerId() + "&maxResults=500&projection=full";
            }
            ResponseEntity responseEntity = this.restTemplate.exchange((String)requestUri, HttpMethod.GET, requestEntity, AdUserList.class, queryParams);
            adUserListResponse = (AdUserList)responseEntity.getBody();
            if (adUserListResponse != null && adUserListResponse.getUsers() != null) {
                this.log.debug("{} AD IMPORT : Number of Ad users from response :  {}", (Object)this.className, (Object)adUserListResponse.getUsers().size());
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getUserListUpdatedAfter : {}", (Object)e.getMessage(), (Object)e);
        }
        return adUserListResponse;
    }

    public byte[] getUserPhoto(AdServerConfigurationModel serverConfig, String userId) {
        byte[] userPhotoByteArray;
        block6: {
            userPhotoByteArray = null;
            HttpEntity requestEntity = null;
            try {
                ResponseEntity photoResponse;
                GsuiteUserPhoto userPhoto;
                requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
                if (serverConfig.getAdProtocolType() == 3) {
                    ResponseEntity photoResponse2 = this.restTemplate.exchange(AZURE_USER_PHOTO_SYNC_URL.replace(MACRO_USER_ID, userId), HttpMethod.GET, requestEntity, byte[].class, new Object[0]);
                    userPhotoByteArray = (byte[])photoResponse2.getBody();
                } else if (serverConfig.getAdProtocolType() == 5 && (userPhoto = (GsuiteUserPhoto)(photoResponse = this.restTemplate.exchange(GSUITE_USER_PHOTO_URL.replace(MACRO_USER_ID, userId), HttpMethod.GET, requestEntity, GsuiteUserPhoto.class, new Object[0])).getBody()) != null) {
                    userPhotoByteArray = Base64.getDecoder().decode(userPhoto.getPhotoData().replace('_', '/').replace('-', '+'));
                }
                if (userPhotoByteArray != null) {
                    this.log.debug("{} AD IMPORT : Profile image found for the user : {}", (Object)this.className, (Object)userId);
                    this.log.trace("{} AD IMPORT : Profile image found for the user : {}", (Object)this.className, (Object)userId);
                }
            }
            catch (Exception e) {
                if (e instanceof HttpClientErrorException) break block6;
                this.log.error("Exception Occurred in ApiHelper method : getUserPhoto : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return userPhotoByteArray;
    }

    public String resetApiUserPassword(AdServerConfigurationModel serverConfig, AdUserDetails azureUser, String newPasswordEncrypted, String aesPath) {
        String result = "FAILURE";
        try {
            JSONObject passwordChangeRequestBodyObj = new JSONObject();
            Object userUpdateUrl = "";
            HttpMethod httpMethod = HttpMethod.PATCH;
            HttpEntity requestEntity = null;
            if (serverConfig.getAdProtocolType() == 3) {
                JSONObject passwordProfileDataObj = new JSONObject();
                passwordProfileDataObj.put((Object)PASSWORD, (Object)EncryptionUtil.decrypt((String)aesPath, (String)newPasswordEncrypted));
                passwordProfileDataObj.put((Object)"forceChangePasswordNextSignIn", (Object)false);
                passwordChangeRequestBodyObj.put((Object)"passwordProfile", (Object)passwordProfileDataObj);
                userUpdateUrl = "https://graph.microsoft.com/v1.0/users/" + azureUser.getGuid();
            } else if (serverConfig.getAdProtocolType() == 4) {
                passwordChangeRequestBodyObj.put((Object)PASSWORD, (Object)EncryptionUtil.decrypt((String)aesPath, (String)newPasswordEncrypted));
                passwordChangeRequestBodyObj.put((Object)"password_confirmation", (Object)EncryptionUtil.decrypt((String)aesPath, (String)newPasswordEncrypted));
                userUpdateUrl = ONELOGIN_SET_USER_PASSWORD_API_URL.replace(MACRO_REGION, ONE_LOGIN_API_REGION).replace(MACRO_USER_ID, azureUser.getGuid());
            } else if (serverConfig.getAdProtocolType() == 5) {
                passwordChangeRequestBodyObj.put((Object)"id", (Object)azureUser.getGuid());
                passwordChangeRequestBodyObj.put((Object)PASSWORD, (Object)EncryptionUtil.decrypt((String)aesPath, (String)newPasswordEncrypted));
                httpMethod = HttpMethod.PUT;
                userUpdateUrl = "https://admin.googleapis.com/admin/directory/v1/users/" + azureUser.getGuid() + "?customer=" + serverConfig.getGsuiteCustomerId();
            }
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, passwordChangeRequestBodyObj);
            ResponseEntity responseEntity = this.restTemplate.exchange((String)userUpdateUrl, httpMethod, requestEntity, String.class, new Object[0]);
            if (responseEntity.getStatusCodeValue() == 204 || responseEntity.getStatusCodeValue() == 200) {
                result = "SUCCESS";
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : resetApiUserPassword : {}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    public GsuiteMemberList getGsuiteMemberListFromGroup(AdServerConfigurationModel serverConfig, String groupId, String pageToken) {
        GsuiteMemberList gsuiteMemberList = null;
        try {
            ResponseEntity responseEntity;
            HttpEntity requestEntity = null;
            requestEntity = this.getApiRequestEntity(serverConfig.getAdProtocolType(), serverConfig.getAccessToken(), requestEntity, null);
            StringBuilder adUserListApiUrl = new StringBuilder(GSUITE_GROUP_MEMBERS_API.replace(MACRO_GROUP_GUID, groupId));
            if (pageToken != null && !pageToken.isEmpty()) {
                adUserListApiUrl.append("?pageToken=").append(pageToken);
            }
            if ((gsuiteMemberList = (GsuiteMemberList)(responseEntity = this.restTemplate.exchange(adUserListApiUrl.toString(), HttpMethod.GET, requestEntity, GsuiteMemberList.class, new Object[0])).getBody()) != null && gsuiteMemberList.getMembers() != null) {
                this.log.debug("{} AD IMPORT : Number of Google Workspace Members from response : {}", (Object)this.className, (Object)gsuiteMemberList.getMembers().size());
            }
        }
        catch (Exception e) {
            this.log.error("Exception Occurred in ApiHelper method : getGsuiteMemberListFromGroup : {}", (Object)e.getMessage(), (Object)e);
        }
        return gsuiteMemberList;
    }
}

