/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.cloudconnector.util;

import com.sapphire.base64util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class CloudConnectorUserImportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudConnectorUserImportUtil.class);
    private static String installedPath = "";
    public static Map<String, String> cloudConnectorConfigSettingMap = new ConcurrentHashMap<String, String>(5);

    public static String getInstalledPath() {
        return installedPath;
    }

    public static void setInstalledPath(String installedPath) {
        CloudConnectorUserImportUtil.installedPath = installedPath;
    }

    public static HttpHeaders createHeaders(String userName, String pwd) {
        String plainCreds = userName + ":" + pwd;
        byte[] plainCredsBytes = plainCreds.getBytes();
        byte[] base64Bytes = Base64.encode((byte[])plainCredsBytes);
        String base64Creds = new String(base64Bytes);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Creds);
        return headers;
    }

    public static RestTemplate restTemplateInstance() {
        HttpComponentsClientHttpRequestFactory factory = null;
        try {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            sslContextBuilder.loadTrustMaterial((chain, authType) -> true);
            HttpClientBuilder clientBuilder = HttpClients.custom();
            SSLContext sslContext = sslContextBuilder.build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)600000L)).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connectionManager.setDefaultSocketConfig(socketConfig);
            connectionManager.setMaxTotal(100);
            clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            factory = new HttpComponentsClientHttpRequestFactory();
            factory.setHttpClient((HttpClient)clientBuilder.build());
            factory.setConnectTimeout(180000);
            factory.setConnectionRequestTimeout(180000);
        }
        catch (Exception exception) {
            LOGGER.error("exception caught while initializing Rest Template {} ", (Object)exception.getMessage(), (Object)exception);
        }
        RestTemplate restTemplate = factory == null ? new RestTemplate() : new RestTemplate(factory);
        restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        restTemplate.getMessageConverters().add(new StringHttpMessageConverter());
        return restTemplate;
    }
}

