/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.dao;

import com.sapphire.license.License;
import com.sapphireims.user.dao.LdapUserImportDao;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.util.SapphireUserImportUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class LicenseConfigurationDao {
    private LdapUserImportDao userImportDao;
    private static final Log LOGGER = LogFactory.getLog((String)"com.sapphireims.user");

    @Autowired
    public void setUserImportDao(LdapUserImportDao userImportDao) {
        this.userImportDao = userImportDao;
    }

    private void logTraceLog(String message) {
        LOGGER.trace((Object)message);
    }

    public void setUserLicenseCount(AdServerConfigurationModel ldapConfig, Connection conn) throws SQLException {
        int userLicenseCount;
        if (SapphireUserImportUtil.isServer) {
            String strQuery = "SELECT CustomerID as outputValue FROM customermaster";
            int customerId = NumberUtils.toInt((String)this.userImportDao.getUniqueValueFromSQLQuery(strQuery, null, conn));
            userLicenseCount = License.getNumberOfUsers((String)SapphireUserImportUtil.consolePath, (int)customerId);
        } else {
            userLicenseCount = Integer.parseInt(License.getLicenseInfo((String)SapphireUserImportUtil.consolePath, (int)8));
        }
        this.logTraceLog("User license count is " + userLicenseCount);
        ldapConfig.setTotalUserLicense(userLicenseCount);
    }

    public void checkAndUpdateUserLicense(AdServerConfigurationModel configModel, Connection conn) {
        try {
            Object strQuery = "select count(userId)-8 as outputValue from userdetails where UserStatus=0";
            int totalUsersImported = NumberUtils.toInt((String)this.userImportDao.getUniqueValueFromSQLQuery((String)strQuery, null, conn), (int)0);
            this.logTraceLog("Users license consumed is " + totalUsersImported);
            strQuery = "select count(UserId) as outputValue from userdetails where UserStatus = ? and DeletionAllowed=0";
            ArrayList<Object> queryParamValues = new ArrayList<Object>(2);
            queryParamValues.add(0);
            int totalActiveUsers = NumberUtils.toInt((String)this.userImportDao.getUniqueValueFromSQLQuery((String)strQuery, queryParamValues, conn), (int)0);
            this.logTraceLog("Total active users is  " + totalActiveUsers);
            if (configModel.getTotalUserLicense() == -2 || configModel.getTotalUserLicense() > totalActiveUsers) {
                queryParamValues.clear();
                queryParamValues.add(3);
                int unlicensedUserCount = NumberUtils.toInt((String)this.userImportDao.getUniqueValueFromSQLQuery((String)strQuery, queryParamValues, conn), (int)0);
                if (unlicensedUserCount > 0) {
                    strQuery = "update userdetails set UserStatus = 0 where UserStatus = 3 order by UserID asc";
                    if (configModel.getTotalUserLicense() != -2) {
                        strQuery = (String)strQuery + " limit ?";
                    }
                    queryParamValues.clear();
                    if (configModel.getTotalUserLicense() != -2) {
                        queryParamValues.add(configModel.getTotalUserLicense() - totalActiveUsers);
                    }
                    this.logTraceLog("updating userdetails based on the license allocated");
                    this.userImportDao.executeInsertUpdateSqlQuery((String)strQuery, queryParamValues, false, conn);
                }
            } else if (configModel.getTotalUserLicense() < totalActiveUsers) {
                strQuery = "update userdetails set UserStatus = 3 where userId in ( select UserID from ( select UserID from userdetails where UserStatus = 0 and DeletionAllowed = 0 order by UserID asc limit ?, ?) usrIds)";
                queryParamValues.clear();
                queryParamValues.add(configModel.getTotalUserLicense() - 1);
                queryParamValues.add(totalUsersImported);
                this.userImportDao.executeInsertUpdateSqlQuery((String)strQuery, queryParamValues, false, conn);
                this.logTraceLog(String.format("updating userdetails based on the license allocated:: %s   :: The parameters are %s, %s ", strQuery, configModel.getTotalUserLicense() - 1, totalUsersImported));
            }
        }
        catch (SQLException sqlExp) {
            LOGGER.error((Object)("Exception Occurred in LdapUserImportService method : checkAndUpdateUserLicense :: " + sqlExp.getMessage()), (Throwable)sqlExp);
        }
    }
}

