/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.ldap.service;

import com.sapphireims.user.ldap.service.LdapTemplateService;
import com.sapphireims.user.model.AdServerConfigurationModel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.AuthenticationErrorCallback;
import org.springframework.ldap.core.CollectingAuthenticationErrorCallback;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.stereotype.Service;

@Service
public class LdapAuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.sapphireims.login");
    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";
    private static final String ACCOUNT_LOCKED = "ACCOUNT_LOCKED";
    private static final String PASSWORD_EXPIRED = "PASSWORD_EXPIRED";
    private static final String LOGON_WORKSTATION = "LOGON_WORKSTATION";
    private final LdapTemplateService ldapTemplateService;
    private static final Pattern SUB_ERROR_CODE = Pattern.compile(".*data\\s([0-9a-f]{3,4}).*");
    private static final int USERNAME_NOT_FOUND = 1317;
    private static final int INVALID_PASSWORD = 1326;
    private static final int NOT_PERMITTED = 1328;
    private static final int AD_PASSWORD_EXPIRED = 1330;
    private static final int ACCOUNT_DISABLED = 1331;
    private static final int ACCOUNT_EXPIRED = 1793;
    private static final int PASSWORD_NEEDS_RESET = 1907;
    private static final int AD_ACCOUNT_LOCKED = 1909;
    private static final int AD_NOT_ALLOWED = 1329;

    public LdapAuthenticationService(LdapTemplateService ldapTemplateService) {
        this.ldapTemplateService = ldapTemplateService;
    }

    public String userAuthenticationProcess(AdServerConfigurationModel configData, String userBaseDn, String password, boolean isCCProcessing, String customerName) {
        LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isCCProcessing, configData, customerName, Boolean.TRUE);
        AndFilter filter = this.setupFilters(configData, userBaseDn);
        CollectingAuthenticationErrorCallback callback = new CollectingAuthenticationErrorCallback();
        boolean resultOutput = ldapTemplate.authenticate("", filter.toString(), password, (AuthenticationErrorCallback)callback);
        if (resultOutput) {
            return SUCCESS;
        }
        if (callback.hasError()) {
            String errorMessage = callback.getError().getMessage();
            logger.error("Exception while authenticating using AD/LDAP {}", (Object)errorMessage, (Object)callback.getError());
            int subErrorCode = this.parseSubErrorCode(errorMessage);
            this.handleBindException(userBaseDn, errorMessage, subErrorCode);
            if (1329 == subErrorCode || errorMessage.contains("data 531")) {
                return LOGON_WORKSTATION;
            }
            if (1330 == subErrorCode || errorMessage.contains("data 532")) {
                return PASSWORD_EXPIRED;
            }
            if (1909 == subErrorCode || errorMessage.contains("data 775")) {
                return ACCOUNT_LOCKED;
            }
        }
        return FAIL;
    }

    private AndFilter setupFilters(AdServerConfigurationModel configData, String userBaseDn) {
        EqualsFilter objectClassEqualFilter = new EqualsFilter("objectclass", "user");
        EqualsFilter baseEqualFilter = new EqualsFilter("distinguishedname", userBaseDn);
        if (configData.getAdServerOperatingSystem() == 1) {
            objectClassEqualFilter = new EqualsFilter("objectclass", "inetOrgPerson");
            if (userBaseDn.toUpperCase().startsWith("UID")) {
                String uid = userBaseDn.split("=")[1];
                uid = uid.substring(0, uid.length() - 3);
                baseEqualFilter = new EqualsFilter("uid", uid);
            }
        }
        return new AndFilter().and((Filter)objectClassEqualFilter).and((Filter)baseEqualFilter);
    }

    private int parseSubErrorCode(String message) {
        Matcher matcher = SUB_ERROR_CODE.matcher(message);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1), 16);
        }
        return -1;
    }

    private void handleBindException(String bindPrincipal, String message, int errorCode) {
        logger.debug("Authentication for %s failed:{} and error {}", (Object)bindPrincipal, (Object)message);
        if (errorCode <= 0) {
            logger.debug("Failed to locate AD-specific sub-error code in message");
            return;
        }
        logger.info("Active Directory authentication failed: {}", (Object)this.subCodeToLogMessage(errorCode));
    }

    private String subCodeToLogMessage(int code) {
        return switch (code) {
            case 1317 -> "User was not found in directory";
            case 1326 -> "Supplied password was invalid";
            case 1328 -> "User not permitted to logon at this time";
            case 1330 -> "Password has expired";
            case 1331 -> "Account is disabled";
            case 1793 -> "Account expired";
            case 1907 -> "User must reset password";
            case 1909 -> "Account locked";
            case 1329 -> "User not allowed to login";
            default -> "Unknown (error code " + Integer.toHexString(code) + ")";
        };
    }
}

