/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.ldap.service;

import com.sapphireims.user.ldap.service.LdapTemplateService;
import com.sapphireims.user.ldap.service.LdapUserImportService;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.OuTreeModel;
import com.sapphireims.user.util.CreateXmlFile;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.query.SearchScope;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.stereotype.Service;

@Service
public class LdapOuService {
    public static final String OBJECT_CLASS = "objectClass";
    private static final Log LOGGER = LogFactory.getLog((String)"com.sapphireims.user");
    public static final String OBJECTGUID = "objectguid";
    public static final String DISTINGUISHEDNAME = "distinguishedname";
    private static final String SUCESS_MESSAGE = "SUCCESS";
    private static final String FAIL_MESSAGE = "FAIL";
    public static final String SEPARAT0R = "5EPARAT0R";
    public static final String NO_OU_S_FOUND = "No OU's Found";
    public static final String CC_ERROR_MSG = "LDAP::";
    public static final String EXCEPTION_OCCURRED_IN_LDAPOU_LIST_SERVICE_GET_OU_LIST_TREE = "Exception occurred in LDAPOuListService of getOuListFromLdap method ";
    public static final String FOLLOW = "follow";
    public static final String FAILED_TO_GET_ORGANIZATION_UNIT_OU_THE_SSL_CONNECTION_TO_THE_LDAP_SERVER_FAILED = "Failed to get organization unit(OU). The SSL connection to the ldap server failed.";
    public static final String FAILED_TO_GET_ORGANIZATION_UNIT_OU_THE_CONNECTION_TO_THE_LDAP_SERVER_FAILED = "Failed to get organization unit(OU). The connection to the ldap server failed.";
    private final LdapTemplateService ldapTemplateService;

    public LdapOuService(LdapTemplateService ldapTemplateService) {
        this.ldapTemplateService = ldapTemplateService;
    }

    public List<OuTreeModel> getLdapSearchResult(LdapTemplate ldapTemplate, int searchType, int ouListType, String ouListTypeFilter) {
        SearchCriteria searchCriteria = this.searchCriteria(searchType, ouListType, ouListTypeFilter);
        LdapQuery query = LdapQueryBuilder.query().attributes(new String[]{OBJECTGUID, DISTINGUISHEDNAME, "name"}).searchScope(searchCriteria.searchScope()).filter(searchCriteria.searchFilter());
        LOGGER.debug((Object)"OUListing First level Started");
        ((LdapContextSource)ldapTemplate.getContextSource()).setReferral(FOLLOW);
        List<OuTreeModel> model = this.getOuLdapSearch(ldapTemplate, query, searchType);
        LOGGER.debug((Object)"OUListing First level completed");
        if (searchType == 2 && ouListType != 2) {
            ((LdapContextSource)ldapTemplate.getContextSource()).setReferral("ignore");
            this.getAllSubOus(model, ldapTemplate, searchCriteria.searchFilter());
        }
        LOGGER.debug((Object)"OU list getting from LDAP is completed");
        return model;
    }

    private void listOrganizationalUnit(OuTreeModel ouTreeModel, LdapTemplate ldapTemplate, int searchType, int ouListType, String ouListTypeFilter) {
        Instant start = Instant.now();
        SearchCriteria searchCriteria = this.searchCriteria(searchType, ouListType, ouListTypeFilter);
        if (searchType == 2 && ouListType != 2) {
            LdapContextSource ldapContextSource = (LdapContextSource)ldapTemplate.getContextSource();
            ldapContextSource.setBase("");
            ldapContextSource.afterPropertiesSet();
            try {
                ldapTemplate.afterPropertiesSet();
            }
            catch (Exception ex) {
                LOGGER.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            this.getOUTree(ouTreeModel.getBase(), ouTreeModel, 0, searchCriteria, ldapTemplate, searchType);
        } else {
            LdapQuery query = LdapQueryBuilder.query().attributes(new String[]{OBJECTGUID, DISTINGUISHEDNAME, "name"}).searchScope(searchCriteria.searchScope()).filter(searchCriteria.searchFilter());
            ((LdapContextSource)ldapTemplate.getContextSource()).setReferral(FOLLOW);
            List<OuTreeModel> model = this.getOuLdapSearch(ldapTemplate, query, searchType);
            ouTreeModel.setChildren(model);
        }
        Instant end = Instant.now();
        LOGGER.info((Object)String.format("fetching of the OU from LDAP took %d seconds", Duration.between(start, end).getSeconds()));
    }

    private OuTreeModel getOUTree(String baseDN, OuTreeModel ouTreeModel, int levelCounter, SearchCriteria searchCriteria, LdapTemplate ldapTemplate, int searchType) {
        try {
            LOGGER.info((Object)String.format("Getting OU Level %d", levelCounter));
            SearchControls searchControls = this.getDefaultSearchControls(SearchScope.ONELEVEL.getId(), new String[]{OBJECTGUID, DISTINGUISHEDNAME, "name"});
            List entries = ldapTemplate.search((Name)LdapUtils.newLdapName((String)baseDN), searchCriteria.searchFilter(), searchControls, (AttributesMapper)new LdapOUAttributesMapper(searchType));
            if (!entries.isEmpty()) {
                ouTreeModel.getChildren().addAll(entries);
                ouTreeModel.setLeaf(false);
            } else {
                ouTreeModel.setLeaf(true);
            }
            for (OuTreeModel entry : entries) {
                entry.setParent(ouTreeModel);
                LOGGER.debug((Object)("getting BaseDn " + entry.getBase()));
                this.getOUTree(entry.getBase(), entry, levelCounter + 1, searchCriteria, ldapTemplate, searchType);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error occurred while fetching OU tree: " + e.getMessage()), (Throwable)e);
        }
        return ouTreeModel;
    }

    private SearchControls getDefaultSearchControls(int searchScope, String[] attrs) {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(searchScope);
        controls.setTimeLimit(0);
        controls.setCountLimit(0L);
        controls.setReturningObjFlag(false);
        controls.setReturningAttributes(attrs);
        return controls;
    }

    private SearchCriteria searchCriteria(int searchType, int ouListType, String ouListTypeFilter) {
        SearchScope searchScope;
        String searchFilter = "(|(objectCategory=Container) (&(objectCategory=groupPolicyContainer)) (objectCategory=organizationalunit) )";
        switch (searchType) {
            case 1: {
                searchScope = SearchScope.OBJECT;
                searchFilter = "(&(objectClass=top))";
                break;
            }
            case 2: {
                searchScope = SearchScope.ONELEVEL;
                if (ouListType == 2) {
                    searchFilter = "(|(objectCategory=organizationalunit)(objectClass=BuiltinDomain)(&(objectCategory=Container)(|(name=users)(name=built-in)(name=builtin))))";
                    break;
                }
                if (ouListType != 3) break;
                searchFilter = ouListTypeFilter;
                break;
            }
            case 3: {
                searchScope = SearchScope.OBJECT;
                searchFilter = "(&(objectCategory=organizationalunit)(objectClass=organizationalunit))";
                break;
            }
            default: {
                searchScope = SearchScope.ONELEVEL;
            }
        }
        return new SearchCriteria(searchFilter, searchScope);
    }

    void getAllSubOus(List<OuTreeModel> model, LdapTemplate ldapTemplate, String searchFilter) {
        LOGGER.debug((Object)"LDAP Sub OU listing Started ");
        model.forEach(s -> {
            s.setLeaf(false);
            this.getSubOu((OuTreeModel)s, ldapTemplate, s.getBase(), searchFilter);
            if (s.getChildren().isEmpty()) {
                s.setLeaf(true);
            }
        });
        LOGGER.debug((Object)"LDAP Sub OU listing completed ");
    }

    public List<OuTreeModel> getOuLdapSearch(LdapTemplate ldapTemplate, LdapQuery query, int searchType) {
        return ldapTemplate.search(query, (AttributesMapper)new LdapOUAttributesMapper(searchType));
    }

    private List<OuTreeModel> searchGroups(LdapTemplate ldapTemplate) {
        Instant start = Instant.now();
        ContainerCriteria query = LdapQueryBuilder.query().base("").attributes(new String[]{OBJECTGUID, DISTINGUISHEDNAME, "name"}).searchScope(SearchScope.SUBTREE).where(OBJECT_CLASS).is("group");
        List ouTreeModels = ldapTemplate.search((LdapQuery)query, (AttributesMapper)new LdapOUAttributesMapper(2));
        Instant end = Instant.now();
        LOGGER.info((Object)String.format("fetching of the Groups from LDAP took %d seconds", Duration.between(start, end).getSeconds()));
        return ouTreeModels;
    }

    private void getSubOu(OuTreeModel parent, LdapTemplate ldapTemplate, String base, String searchFilter) {
        LOGGER.debug((Object)String.format("GetSubOUList for OU %s", base));
        LdapContextSource ldapContextSource = (LdapContextSource)ldapTemplate.getContextSource();
        ldapContextSource.setBase(LdapUserImportService.getOrganisationUnit(base));
        LdapQuery query = LdapQueryBuilder.query().base((Name)LdapUtils.emptyLdapName()).attributes(new String[]{OBJECTGUID, DISTINGUISHEDNAME, "name"}).searchScope(SearchScope.SUBTREE).filter(searchFilter);
        List<OuTreeModel> model = this.getOuLdapSearch(ldapTemplate, query, 2);
        if (!model.isEmpty()) {
            this.getSubOuListTree(parent, model);
        }
        if (parent.getChildren().isEmpty()) {
            parent.setLeaf(true);
        }
    }

    private void getSubOuListTree(OuTreeModel parent, List<OuTreeModel> model) {
        model.sort((o1, o2) -> {
            int o2OusCount;
            int o1OusCount = o1.getBase().split("=").length;
            if (o1OusCount > (o2OusCount = o2.getBase().split("=").length)) {
                return 1;
            }
            if (o1OusCount < o2OusCount) {
                return -1;
            }
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        });
        for (OuTreeModel outerOU : model) {
            if (parent.getBase().equals(outerOU.getBase())) continue;
            outerOU.setLeaf(false);
            List<OuTreeModel> innerOus = model.stream().filter(ouModel -> ouModel.getBase().contains(outerOU.getBase()) && !ouModel.getBase().equals(outerOU.getBase())).toList();
            for (OuTreeModel innerOu : innerOus) {
                String childOu = innerOu.getBase();
                if ((childOu = childOu.replace(outerOU.getBase(), "")).split("=").length != 2) continue;
                outerOU.getChildren().add(innerOu);
                innerOu.setParent(outerOU);
            }
            if (outerOU.getChildren().isEmpty()) {
                outerOU.setLeaf(true);
            }
            if (outerOU.getParent() != null) continue;
            String childOu = outerOU.getBase();
            if ((childOu = childOu.replace(parent.getBase(), "")).split("=").length != 2) continue;
            outerOU.setParent(parent);
            parent.getChildren().add(outerOU);
        }
    }

    public static String getDomainName(String domainFullName, int type) {
        StringBuilder tempBaseName = new StringBuilder(domainFullName);
        if (tempBaseName.toString().contains("DC=") && type == 1) {
            tempBaseName = new StringBuilder(tempBaseName.substring(tempBaseName.indexOf("DC=")).replace("DC=", "").replace(",", "."));
        } else if (!tempBaseName.toString().contains("DC=") && type == 2) {
            String[] arrStrings = domainFullName.split("\\.");
            boolean isFirst = true;
            for (String s : arrStrings) {
                if (isFirst) {
                    tempBaseName = new StringBuilder("DC=" + s);
                    isFirst = false;
                    continue;
                }
                tempBaseName.append(",DC=").append(s);
            }
        }
        return tempBaseName.toString();
    }

    public String getOuListFromLdap(AdServerConfigurationModel serverConfigData, String ouValue, String xmlFilePath, int ouListType, String ouListTypeFilter, boolean isProcessingThroughCC, String customerName) {
        int searchType = 2;
        String ldapMessage = this.precedingErrorMessage(isProcessingThroughCC);
        String domainFullName = serverConfigData.getAdDomainFullName();
        int isSSLEnabled = serverConfigData.getIsSSLEnabled();
        String hostName = serverConfigData.getServerCredential().getAdHostName();
        try {
            LdapTemplate ldapTemplate;
            List<OuTreeModel> ouListingParentNode;
            boolean aNull;
            if (hostName.trim().isEmpty()) {
                return ldapMessage + "Failed to get organization unit(OU). Configure proper hostname and try again.";
            }
            String failedMessage = this.getRootDSE(serverConfigData, domainFullName, isSSLEnabled, ldapMessage, isProcessingThroughCC, customerName);
            if (failedMessage != null) {
                return failedMessage;
            }
            boolean bl = aNull = !ouValue.trim().isEmpty() && !ouValue.trim().equals("NULL");
            if (aNull) {
                ouValue = LdapOuService.getOrganisationUnit(ouValue);
                serverConfigData.setAdDomainFullName(ouValue);
                searchType = 3;
            }
            if ((ouListingParentNode = this.getLdapSearchResult(ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isProcessingThroughCC, serverConfigData, customerName, Boolean.FALSE), 1, ouListType, ouListTypeFilter)) == null || ouListingParentNode.isEmpty()) {
                return ldapMessage + NO_OU_S_FOUND;
            }
            OuTreeModel ouTreeModel = ouListingParentNode.getFirst();
            ouTreeModel.setLeaf(false);
            this.listOrganizationalUnit(ouTreeModel, ldapTemplate, searchType, ouListType, ouListTypeFilter);
            boolean xmlCreated = CreateXmlFile.createOuTreeModelXmlDocument(ouTreeModel, xmlFilePath);
            if (!xmlCreated) {
                return ldapMessage + "Failed to get organization unit(OU). Unknown error occurred while forming XML file.";
            }
        }
        catch (AuthenticationException ae) {
            LOGGER.error((Object)(EXCEPTION_OCCURRED_IN_LDAPOU_LIST_SERVICE_GET_OU_LIST_TREE + ae.getMessage()), (Throwable)ae);
            return ldapMessage + "Failed to get organization unit(OU). Bind to LDAP server failed(Unknown Username/Bad Password).";
        }
        catch (CommunicationException cme) {
            String exceptionMessage = FAILED_TO_GET_ORGANIZATION_UNIT_OU_THE_CONNECTION_TO_THE_LDAP_SERVER_FAILED;
            if (isSSLEnabled == 1) {
                exceptionMessage = FAILED_TO_GET_ORGANIZATION_UNIT_OU_THE_SSL_CONNECTION_TO_THE_LDAP_SERVER_FAILED;
            }
            LOGGER.error((Object)(EXCEPTION_OCCURRED_IN_LDAPOU_LIST_SERVICE_GET_OU_LIST_TREE + cme.getMessage()), (Throwable)cme);
            return ldapMessage + exceptionMessage;
        }
        catch (Exception ex) {
            LOGGER.error((Object)(EXCEPTION_OCCURRED_IN_LDAPOU_LIST_SERVICE_GET_OU_LIST_TREE + ex.getMessage()), (Throwable)ex);
            return ldapMessage + "Failed to retrieve OU's";
        }
        return "SUCCESS5EPARAT0RSUCCESS";
    }

    public AdResult getAdGroups(AdServerConfigurationModel serverConfigData, String ouValue, int ouListType, String ouListTypeFilter, boolean isProcessingThroughCC, String customerName) {
        OuTreeModel ouTreeModel;
        String ldapMessage = this.precedingErrorMessage(isProcessingThroughCC);
        String domainFullName = serverConfigData.getAdDomainFullName();
        int isSSLEnabled = serverConfigData.getIsSSLEnabled();
        String hostName = serverConfigData.getServerCredential().getAdHostName();
        try {
            boolean aNull;
            if (hostName.trim().isEmpty()) {
                return new AdResult(ldapMessage + "Failed to get groups. Configure proper hostname and try again.", false, null);
            }
            String failedMessage = this.getRootDSE(serverConfigData, domainFullName, isSSLEnabled, ldapMessage, isProcessingThroughCC, customerName);
            if (failedMessage != null) {
                return new AdResult(failedMessage, false, null);
            }
            boolean bl = aNull = !ouValue.trim().isEmpty() && !ouValue.trim().equals("NULL");
            if (aNull) {
                ouValue = LdapOuService.getOrganisationUnit(ouValue);
                String dn = ouValue.substring(ouValue.indexOf(",DC=") + 1);
                serverConfigData.setAdDomainFullName(dn);
                LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isProcessingThroughCC, serverConfigData, customerName, Boolean.FALSE);
                return new AdResult("", this.groupExistsByDn(ouValue, ldapTemplate), null);
            }
            LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isProcessingThroughCC, serverConfigData, customerName, Boolean.FALSE);
            List<OuTreeModel> ouListingParentNode = this.getLdapSearchResult(ldapTemplate, 1, ouListType, ouListTypeFilter);
            if (ouListingParentNode == null || ouListingParentNode.isEmpty()) {
                return new AdResult(ldapMessage + "No groups found", false, null);
            }
            ouTreeModel = ouListingParentNode.get(0);
            ouTreeModel.setLeaf(false);
            List<OuTreeModel> groups = this.searchGroups(ldapTemplate);
            ouTreeModel.getChildren().addAll(groups);
        }
        catch (AuthenticationException ae) {
            LOGGER.error((Object)(EXCEPTION_OCCURRED_IN_LDAPOU_LIST_SERVICE_GET_OU_LIST_TREE + ae.getMessage()), (Throwable)ae);
            return new AdResult(ldapMessage + "Failed to get groups. Bind to LDAP server failed(Unknown Username/Bad Password).", false, null);
        }
        catch (CommunicationException cme) {
            String exceptionMessage = FAILED_TO_GET_ORGANIZATION_UNIT_OU_THE_CONNECTION_TO_THE_LDAP_SERVER_FAILED;
            if (isSSLEnabled == 1) {
                exceptionMessage = FAILED_TO_GET_ORGANIZATION_UNIT_OU_THE_SSL_CONNECTION_TO_THE_LDAP_SERVER_FAILED;
            }
            LOGGER.error((Object)(EXCEPTION_OCCURRED_IN_LDAPOU_LIST_SERVICE_GET_OU_LIST_TREE + cme.getMessage()), (Throwable)cme);
            return new AdResult(ldapMessage + exceptionMessage, false, null);
        }
        catch (Exception ex) {
            LOGGER.error((Object)(EXCEPTION_OCCURRED_IN_LDAPOU_LIST_SERVICE_GET_OU_LIST_TREE + ex.getMessage()), (Throwable)ex);
            return new AdResult(ldapMessage + "Failed to retrieve groups", false, null);
        }
        return new AdResult(SUCESS_MESSAGE, true, ouTreeModel);
    }

    private String getRootDSE(AdServerConfigurationModel serverConfigData, String domainFullName, int isSSLEnabled, String ldapMessage, boolean isProcessingThroughCC, String customerName) {
        if (domainFullName.trim().isEmpty() || "NULL".equals(domainFullName) || "SAPP_IMS_NODATA".equals(domainFullName)) {
            try {
                int osType = serverConfigData.getAdServerOperatingSystem() == 0 ? 2 : serverConfigData.getAdServerOperatingSystem();
                String namingContext = osType == 2 ? "defaultnamingcontext" : "namingcontexts";
                LdapTemplate ldapTemplate = this.ldapTemplateService.getLdapTemplateBasedJobProcessor(isProcessingThroughCC, serverConfigData, customerName, Boolean.FALSE);
                LdapContextSource contextSource = (LdapContextSource)ldapTemplate.getContextSource();
                contextSource.setReferral(FOLLOW);
                contextSource.afterPropertiesSet();
                String[] returnedAtts = new String[]{namingContext};
                SearchControls controls = new SearchControls(0, 0L, 0, returnedAtts, false, false);
                LikeFilter likeFilter = new LikeFilter(OBJECT_CLASS, "*");
                List result = ldapTemplate.search("", likeFilter.encode(), controls, atrbts -> atrbts.get(namingContext).get().toString());
                if (result == null || result.isEmpty()) {
                    return ldapMessage + "LDAP Search Failed. Unable to get root DSE.";
                }
                domainFullName = (String)result.getFirst();
                serverConfigData.setAdDomainFullName(domainFullName);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Exception occurred in LDAPOuService getRootDSE method" + ex.getMessage()), (Throwable)ex);
                if (isSSLEnabled == 1) {
                    return ldapMessage + FAILED_TO_GET_ORGANIZATION_UNIT_OU_THE_SSL_CONNECTION_TO_THE_LDAP_SERVER_FAILED;
                }
                return ldapMessage + FAILED_TO_GET_ORGANIZATION_UNIT_OU_THE_CONNECTION_TO_THE_LDAP_SERVER_FAILED;
            }
        }
        return null;
    }

    private String precedingErrorMessage(boolean isProcessingThroughCC) {
        if (isProcessingThroughCC) {
            return CC_ERROR_MSG;
        }
        return "FAIL5EPARAT0R";
    }

    private String getGroupDn(String groupDn) {
        String tempGroupDn = groupDn.toUpperCase();
        int index = tempGroupDn.indexOf("DC=");
        if (index != -1) {
            groupDn = groupDn.substring(0, index);
        }
        if (groupDn.endsWith(",")) {
            groupDn = groupDn.substring(0, groupDn.length() - 1);
        }
        return groupDn;
    }

    private boolean groupExistsByDn(String groupDn, LdapTemplate ldapTemplate) {
        try {
            groupDn = this.getGroupDn(groupDn);
            LOGGER.info((Object)("Group Dn after Extracting: " + groupDn));
            ContainerCriteria query = LdapQueryBuilder.query().base(groupDn).where(OBJECT_CLASS).is("group");
            return !ldapTemplate.search((LdapQuery)query, Objects::nonNull).isEmpty();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String getOrganisationUnit(String ou) {
        String[] parts = ou.split(",");
        StringBuilder result = new StringBuilder();
        String cnKey = null;
        StringBuilder cnValue = new StringBuilder();
        ArrayList<String> remainingParts = new ArrayList<String>();
        for (String part : parts) {
            if ((part = part.trim()).startsWith("CN=")) {
                cnKey = "CN";
                cnValue.append(part.substring(3));
                continue;
            }
            if (part.startsWith("OU=")) {
                if (cnKey != null) {
                    cnValue.append(",").append(part.substring(3));
                    continue;
                }
                remainingParts.add(part);
                continue;
            }
            remainingParts.add(part);
        }
        if (cnKey != null) {
            result.append(LdapOuService.escapeDnComponent(cnKey + "=" + cnValue.toString()));
        }
        for (String part : remainingParts) {
            result.append(",");
            result.append(LdapOuService.escapeDnComponent(part));
        }
        return result.toString();
    }

    private static String escapeDnComponent(String rdn) {
        int idx = rdn.indexOf(61);
        if (idx == -1) {
            return rdn;
        }
        String key = rdn.substring(0, idx).trim();
        String value = rdn.substring(idx + 1).trim();
        StringBuilder escaped = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c == ',') {
                escaped.append('\\');
            }
            escaped.append(c);
        }
        return key + "=" + escaped.toString();
    }

    private record SearchCriteria(String searchFilter, SearchScope searchScope) implements Serializable
    {
    }

    private static class LdapOUAttributesMapper
    implements AttributesMapper<OuTreeModel> {
        int searchType;

        public LdapOUAttributesMapper(int serachType) {
            this.searchType = serachType;
        }

        public OuTreeModel mapFromAttributes(Attributes atrbts) throws NamingException {
            OuTreeModel ouTreeModel = new OuTreeModel();
            if (this.searchType == 1) {
                ouTreeModel.setGuid("1");
            } else {
                byte[] sid = (byte[])atrbts.get(LdapOuService.OBJECTGUID).get();
                ouTreeModel.setGuid(this.toHex(sid));
            }
            String base1 = atrbts.get(LdapOuService.DISTINGUISHEDNAME).get().toString();
            ouTreeModel.setBase(base1);
            ouTreeModel.setLeaf(true);
            ouTreeModel.setDistinguishedName(this.escapXMlDn(base1));
            try {
                ouTreeModel.setName(this.escapXMlName(atrbts.get("name").get().toString()));
            }
            catch (NamingException ex) {
                LOGGER.warn((Object)("NamingException exception caught " + ex.getMessage()));
                LOGGER.debug((Object)"", (Throwable)ex);
            }
            return ouTreeModel;
        }

        private String escapXMlDn(String str) {
            return str.replace("&", "&amp;").replace("\\,", "\\&#44;").replace("\\=", "\\&#61;").replace("\\<", "\\&#60;").replace("\\>", "\\&gt;").replace("\"", "&quot;").replace("'", "&#39;").replace("\\#", "#").replace("\\+", "+").replace("\\;", ";").replace("]", "&#93;");
        }

        private String escapXMlName(String str) {
            return str.replace("&", "&amp;").replace("\n", "").replace("=", "&#61;").replace("\\,", "\\&#44;").replace("<", "&#60;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;").replace("]", "&#93;").replace("\\", "\\\\");
        }

        private String toHex(byte[] guidBytes) {
            char[] hexArray = "0123456789abcdef".toCharArray();
            char[] hexChars = new char[guidBytes.length];
            for (int i = 0; i < guidBytes.length; ++i) {
                int v = guidBytes[i] & 0xFF;
                hexChars[i] = hexArray[v >>> 4];
            }
            return new String(hexChars);
        }
    }

    public record AdResult(String message, boolean success, OuTreeModel ouTreeModel) {
        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public OuTreeModel getOuTreeModel() {
            return this.ouTreeModel;
        }
    }
}

