/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.ldap.service;

import com.sapphireims.user.dao.LdapUserImportDao;
import com.sapphireims.user.ldap.service.LdapUserImportService;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.AdUserAdditionFieldsModel;
import com.sapphireims.user.model.AdUserDetails;
import com.sapphireims.user.model.LdapAttributeListingModel;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.LdapOperationsCallback;
import org.springframework.ldap.core.support.SingleContextSource;

public class LdapSearch
implements LdapOperationsCallback<Long> {
    private final Logger logger = LoggerFactory.getLogger((String)"com.sapphireims.user");
    private static final String jpegPhotoFileSize = "jpegPhotoFileSize";
    private final LdapName baseName;
    private final String ldapSearchFilter;
    private final SearchControls searchControls;
    private final List<LdapAttributeListingModel> adLdapAttributes;
    private final String schema;
    boolean isFromCloudConnector;
    Connection sqlUtilConn;
    AdServerConfigurationModel ldapConfig;
    List<AdUserAdditionFieldsModel> addAttrUser;
    PagedResultsDirContextProcessor processor;
    int domainId;
    Map<String, Integer> adLdapAttributesMap;
    private LdapUserImportDao userImportDao;
    private LdapUserImportService userImportService;

    public LdapSearch(LdapName baseName, String ldapSearchFilter, SearchControls searchControls, List<LdapAttributeListingModel> adLdapAttributes, String schema, boolean isFromCloudConnector, Connection sqlUtilConn) {
        this.baseName = baseName;
        this.ldapSearchFilter = ldapSearchFilter;
        this.searchControls = searchControls;
        this.adLdapAttributes = adLdapAttributes;
        this.schema = schema;
        this.isFromCloudConnector = isFromCloudConnector;
        this.sqlUtilConn = sqlUtilConn;
    }

    public void setLdapConfig(AdServerConfigurationModel ldapConfig) {
        this.ldapConfig = ldapConfig;
    }

    public void setAddAttrUser(List<AdUserAdditionFieldsModel> addAttrUser) {
        this.addAttrUser = addAttrUser;
    }

    public void setProcessor(PagedResultsDirContextProcessor processor) {
        this.processor = processor;
    }

    public void setDomainId(int domainId) {
        this.domainId = domainId;
    }

    public void setAdLdapAttributesMap(Map<String, Integer> adLdapAttributesMap) {
        this.adLdapAttributesMap = adLdapAttributesMap;
    }

    public void setUserImportDao(LdapUserImportDao userImportDao) {
        this.userImportDao = userImportDao;
    }

    public void setUserImportService(LdapUserImportService userImportService) {
        this.userImportService = userImportService;
    }

    public Long doWithSingleContext(LdapContextSource contextSource, String organizationalUnit) {
        try {
            return (Long)SingleContextSource.doWithSingleContext((ContextSource)contextSource, (LdapOperationsCallback)this, (boolean)true, (boolean)true, (boolean)false);
        }
        catch (NameNotFoundException ne) {
            this.logger.warn("The configured {} OU is not available in the Active Directory/LDAP, so ignoring user import from this OU and proceeding", (Object)organizationalUnit);
            return 0L;
        }
    }

    public Long doWithLdapOperations(LdapOperations operations) {
        long userCount = 0L;
        try (ExecutorService executor = Executors.newFixedThreadPool(5, Thread.ofVirtual().factory());){
            do {
                Instant startTime = Instant.now();
                List oneResult = operations.search((Name)this.baseName, this.ldapSearchFilter, this.searchControls, attr -> {
                    Map<String, Object> adLdapUserAttributeValues = this.userImportService.mapAdLdapUserAttributeValues(this.schema, this.adLdapAttributes, attr, this.isFromCloudConnector);
                    AdUserDetails ldapUserModel = this.userImportService.getAdUserDetails(this.ldapConfig, adLdapUserAttributeValues);
                    this.processImage(this.ldapConfig, attr, ldapUserModel);
                    this.userImportService.processAdditionalAttributes(this.addAttrUser, attr, ldapUserModel);
                    this.processUserImportForCC(ldapUserModel, adLdapUserAttributeValues);
                    return ldapUserModel;
                }, (DirContextProcessor)this.processor);
                if (oneResult != null && !oneResult.isEmpty()) {
                    userCount += (long)oneResult.size();
                }
                Instant endTime = Instant.now();
                this.logger.trace("getting the user from AD took {} seconds", (Object)Duration.between(startTime, endTime).getSeconds());
                if (this.isFromCloudConnector || oneResult == null) continue;
                executor.submit(() -> this.userImportDao.importAdUsers(oneResult, this.domainId, this.ldapConfig, this.schema, this.adLdapAttributesMap));
            } while (this.processor.hasMore());
            executor.shutdown();
        }
        return userCount;
    }

    private void processUserImportForCC(AdUserDetails ldapUserModel, Map<String, Object> adLdapUserAttributeValues) {
        if (this.isFromCloudConnector) {
            if (ldapUserModel.getUserAdditionalAttributes() != null) {
                for (Integer key : ldapUserModel.getUserAdditionalAttributes().keySet()) {
                    if (ldapUserModel.getUserAdditionalAttributes().get(key) == null || ldapUserModel.getUserAdditionalAttributes().get(key).isEmpty()) continue;
                    adLdapUserAttributeValues.put("" + key, ldapUserModel.getUserAdditionalAttributes().get(key));
                }
            }
            this.insertAttributeDataInCLoudOutputData(this.ldapConfig, adLdapUserAttributeValues, this.sqlUtilConn);
        }
    }

    private void processImage(AdServerConfigurationModel ldapConfig, Attributes attr, AdUserDetails ldapUserModel) throws NamingException {
        Attribute profilePictureAttr;
        if (ldapConfig.getIsImageImportEnabled() == 1 && (profilePictureAttr = attr.get("jpegPhoto")) != null) {
            ldapUserModel.setUserProfilePhotoByteArr((byte[])profilePictureAttr.get());
        }
    }

    private void insertAttributeDataInCLoudOutputData(AdServerConfigurationModel ldapConfig, Map<String, Object> adLdapUserAttributeValues, Connection sqlUtilConn) {
        try {
            String insertQuery = "Insert into cloud_outputdata (Type, UniqueID, GenericData) Values (?, ?, ?)";
            ArrayList<Object> paramValues = new ArrayList<Object>();
            paramValues.add("1");
            paramValues.add("" + ldapConfig.getSchedularId());
            StringBuilder strBuild = new StringBuilder("OUName####").append(ldapConfig.getOrganizationalUnit().getFirst());
            adLdapUserAttributeValues.keySet().forEach(ldapAttribute -> {
                if (adLdapUserAttributeValues.get(ldapAttribute) != null) {
                    if ("jpegPhoto".equals(ldapAttribute)) {
                        try {
                            String userNameAttribute = this.getAttributeName("Logon Name");
                            String whenChangedAttribute = this.getAttributeName("whenChanged Time");
                            String userName = (String)adLdapUserAttributeValues.get(userNameAttribute);
                            String whenChanged = (String)adLdapUserAttributeValues.get(whenChangedAttribute);
                            String fileName = userName.replace("\\", "_") + "_SAPP_" + ldapConfig.getSchedularId() + ".jpg";
                            long imageSize = this.userImportDao.saveUserProfileImageInFile(fileName, (byte[])adLdapUserAttributeValues.get("jpegPhoto"), null, Boolean.TRUE, Boolean.FALSE);
                            this.logger.debug("importing profile image username = {}, fileName = {} and image size = {}", new Object[]{userName, fileName, imageSize});
                            this.updateLdapUserImageInDB(userName, fileName, ldapConfig.getSchedularId(), whenChanged, sqlUtilConn);
                            strBuild.append("$$$$").append(jpegPhotoFileSize).append("####").append(imageSize);
                        }
                        catch (IOException | SQLException exp) {
                            this.logger.trace("Exception Occurred in LdapUserImportService while saving profile image  {}", (Object)exp.getMessage(), (Object)exp);
                        }
                    } else {
                        strBuild.append("$$$$").append((String)ldapAttribute).append("####").append(adLdapUserAttributeValues.get(ldapAttribute));
                    }
                }
            });
            paramValues.add(strBuild.toString());
            this.userImportDao.executeInsertUpdateSqlQuery(insertQuery, paramValues, false, sqlUtilConn);
        }
        catch (SQLException exp) {
            this.logger.error("Exception Occurred in LdapUserImportService(insertAttributeDataInCLoudOutputData) {} ", (Object)exp.getMessage(), (Object)exp);
        }
    }

    private String getAttributeName(String attributeName) {
        Optional<LdapAttributeListingModel> optional = this.adLdapAttributes.stream().filter(adLdapAttr -> adLdapAttr.getIsMandatory() == 2 && adLdapAttr.getAdDisplayAttribute().equals(attributeName)).findFirst();
        return optional.isPresent() ? optional.get().getAdLdapAttribute() : "";
    }

    private void updateLdapUserImageInDB(String userName, String fileName, int schedularId, String whenChanged, Connection sqlUtilConn) throws SQLException {
        String query = "select userimage as outputValue from cloud_ldapuserimage where domainid=? and username=?";
        ArrayList<Object> paramValues = new ArrayList<Object>();
        paramValues.add(schedularId);
        paramValues.add(userName);
        String tempUserImage = this.userImportDao.getUniqueValueFromSQLQuery(query, paramValues, sqlUtilConn);
        if (tempUserImage == null || tempUserImage.isEmpty()) {
            query = "insert into cloud_LDAPUserImage (Domainid, UserImage, Flag, UserName, WhenChanged) values (?, ?, ?, ?, ?)";
            paramValues.clear();
            paramValues.add("" + schedularId);
            paramValues.add(fileName);
            paramValues.add("0");
            paramValues.add(userName);
            paramValues.add(whenChanged);
            this.userImportDao.executeInsertUpdateSqlQuery(query, paramValues, false, sqlUtilConn);
        }
    }
}

