/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.ldap.service;

import com.sapphire.base64util.Base64;
import com.sapphire.security.encryption.EncryptionUtil;
import com.sapphireims.user.ldap.service.LdapOuService;
import com.sapphireims.user.ldap.service.LdapUserImportService;
import com.sapphireims.user.model.AdServerConfigurationModel;
import com.sapphireims.user.model.ServerCredential;
import com.sapphireims.user.util.SapphireUserImportUtil;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.directory.SearchControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.core.support.SingleContextSource;
import org.springframework.stereotype.Service;

@Service
public class LdapTemplateService {
    private final Logger log = LoggerFactory.getLogger((String)"com.sapphireims.user");
    private final String className = this.getClass().getName();

    public LdapContextSource buildLdapContextSource(AdServerConfigurationModel ldapConfig, ServerCredential serverCredential, boolean isFromUserImport, String aesPath, String tenantName, boolean isFromCloudConnector) {
        this.log.trace("{} Executing 'buildLdapContextSource' method", (Object)this.className);
        long startTime = System.currentTimeMillis();
        LdapContextSource contextSource = this.initializeContextSource(ldapConfig, serverCredential, isFromUserImport, aesPath, tenantName, isFromCloudConnector);
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        this.log.trace("{} Time taken while executing 'buildLdapContextSource' method is {} milliseconds", (Object)this.className, (Object)timeTaken);
        return contextSource;
    }

    private LdapContextSource initializeContextSource(AdServerConfigurationModel ldapConfig, ServerCredential serverCredential, boolean isFromUserImport, String aesPath, String tenantName, boolean isFromCloudConnector) {
        String server = serverCredential.getAdHostName();
        int port = ldapConfig.getPortNumber();
        String organizationalUnit = this.getOrganizationalUnit(ldapConfig);
        String domainUserName = serverCredential.getAdUserName();
        String adPassword = serverCredential.getAdPassword();
        int sslEnabled = ldapConfig.getIsSSLEnabled();
        this.log.debug("{} Getting LDAP Context source for the host: {}, on port: {}, for the organizational unit: {}", new Object[]{this.className, server, port, organizationalUnit});
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.getUrl(sslEnabled, server, port));
        String userDn = domainUserName;
        String base = organizationalUnit;
        if (isFromUserImport) {
            userDn = this.getUserDnForUserImport(domainUserName, organizationalUnit, ldapConfig);
        }
        if (isFromUserImport || this.isLdapDomainConfigured(ldapConfig)) {
            if (!isFromUserImport) {
                userDn = this.getUserDnForNonUserImport(domainUserName, ldapConfig);
                base = LdapOuService.getDomainName(ldapConfig.getAdDomainFullName(), 2);
            } else {
                base = this.refineBaseForUserImport(base);
            }
            if (base.startsWith(",")) {
                base = base.substring(1);
            }
            contextSource.setBase(LdapUserImportService.getOrganisationUnit(base));
            contextSource.setUserDn(userDn.toLowerCase());
            adPassword = this.getDecryptedPassword(isFromCloudConnector, aesPath, tenantName, adPassword);
            contextSource.setPassword(adPassword);
        }
        contextSource.setReferral("ignore");
        this.setEnvironmentProperties(sslEnabled, contextSource);
        contextSource.afterPropertiesSet();
        return contextSource;
    }

    private boolean isLdapDomainConfigured(AdServerConfigurationModel ldapConfig) {
        String adDomainFullName = ldapConfig.getAdDomainFullName();
        return adDomainFullName != null && !adDomainFullName.isEmpty() && !"NULL".equals(adDomainFullName) && !"SAPP_IMS_NODATA".equals(adDomainFullName);
    }

    private String refineBaseForUserImport(String base) {
        int index = base.trim().toUpperCase().indexOf("DC=");
        return index > 0 ? base.substring(index) : base;
    }

    private String getDecryptedPassword(boolean isFromCloudConnector, String aesPath, String tenantName, String adPassword) {
        if (!isFromCloudConnector) {
            if (aesPath == null || aesPath.isEmpty()) {
                aesPath = SapphireUserImportUtil.getAesPath(tenantName);
            }
            return EncryptionUtil.decrypt((String)aesPath, (String)adPassword);
        }
        return Base64.decode((String)adPassword);
    }

    public LdapTemplate getLdapTemplate(AdServerConfigurationModel ldapConfig, boolean isUserImport, String aesPath, String tenantName, Boolean isFromCloudConnector) {
        this.log.trace("{} Executing 'getLdapTemplate' method", (Object)this.className);
        long startTime = System.currentTimeMillis();
        this.log.debug("{} Getting LDAP Template for the host: {}", (Object)this.className, (Object)ldapConfig.getServerCredential().getAdHostName());
        LdapContextSource contextSource = this.buildLdapContextSource(ldapConfig, ldapConfig.getServerCredential(), isUserImport, aesPath, tenantName, isFromCloudConnector);
        if (ldapConfig.getSecondaryServerCredential() != null && !ldapConfig.getSecondaryServerCredential().isEmpty() && this.checkIfADServerDown(contextSource, ldapConfig.getAdServerOperatingSystem())) {
            ServerCredential secondaryCredential;
            Iterator<ServerCredential> iterator = ldapConfig.getSecondaryServerCredential().iterator();
            while (iterator.hasNext() && this.checkIfADServerDown(contextSource = this.buildLdapContextSource(ldapConfig, secondaryCredential = iterator.next(), isUserImport, aesPath, tenantName, isFromCloudConnector), ldapConfig.getAdServerOperatingSystem())) {
            }
        }
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)contextSource);
        ldapTemplate.setIgnorePartialResultException(true);
        ldapTemplate.setIgnoreNameNotFoundException(true);
        ldapTemplate.setIgnoreSizeLimitExceededException(true);
        try {
            ldapTemplate.afterPropertiesSet();
        }
        catch (Exception ex) {
            this.log.error("Exception occurred in LdapTemplateService method : getLdapTemplate :{} ", (Object)ex.getMessage(), (Object)ex);
        }
        long endTime = System.currentTimeMillis();
        long timeTaken = endTime - startTime;
        this.log.trace("{} Time taken while executing 'getLdapTemplate' method is {} milliseconds", (Object)this.className, (Object)timeTaken);
        return ldapTemplate;
    }

    public boolean checkIfADServerDown(LdapContextSource ldapTemplate, int adOperatingSystem) {
        this.log.trace("{} Executing 'checkIfADServerDown' method", (Object)this.className);
        long startTime = System.currentTimeMillis();
        try {
            String ldapQueryFilter;
            String toReturnAttribute;
            this.log.debug("{} Checking if AD Server is Down ", (Object)this.className);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            if (adOperatingSystem == 1) {
                toReturnAttribute = "uid";
                ldapQueryFilter = "(&(uid=*))";
            } else {
                toReturnAttribute = "samaccountname";
                ldapQueryFilter = "(&(objectClass=top)(objectCategory=person))";
            }
            searchControls.setReturningAttributes(new String[]{toReturnAttribute});
            PagedResultsDirContextProcessor processor = new PagedResultsDirContextProcessor(1);
            SingleContextSource.doWithSingleContext((ContextSource)ldapTemplate, operations -> {
                this.log.debug("checking LDAP secondary start");
                operations.search("", ldapQueryFilter, searchControls, attr -> {
                    attr.get(toReturnAttribute);
                    this.log.debug("checking LDAP secondary done");
                    return "";
                }, (DirContextProcessor)processor);
                return "";
            }, (boolean)true, (boolean)true, (boolean)true);
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.log.trace("{} Time taken while executing 'checkIfADServerDown' method is {} milliseconds", (Object)this.className, (Object)timeTaken);
        }
        catch (CommunicationException ce) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String getOrganizationalUnit(AdServerConfigurationModel ldapConfig) {
        if (ldapConfig.getOrganizationalUnit() != null && !ldapConfig.getOrganizationalUnit().isEmpty()) {
            return ldapConfig.getOrganizationalUnit().getFirst();
        }
        return "";
    }

    private String getUserDnForUserImport(String domainUserName, String organizationalUnit, AdServerConfigurationModel ldapConfig) {
        if (ldapConfig.getAdServerOperatingSystem() == 2) {
            return domainUserName + "@" + organizationalUnit.substring(organizationalUnit.indexOf("DC=")).replace("DC=", "").replace(",", ".");
        }
        return domainUserName;
    }

    private String getUrl(int sslEnabled, String server, int port) {
        if (sslEnabled == 0) {
            return "ldap://" + server + ":" + port;
        }
        return "ldaps://" + server + ":" + port;
    }

    private String getUserDnForNonUserImport(String domainUserName, AdServerConfigurationModel ldapConfig) {
        String tempBaseName = LdapOuService.getDomainName(ldapConfig.getAdDomainFullName(), 1);
        return domainUserName + "@" + tempBaseName;
    }

    private void setEnvironmentProperties(int sslEnabled, LdapContextSource contextSource) {
        HashMap<String, String> baseEnvironmentProperties = new HashMap<String, String>();
        baseEnvironmentProperties.put("java.naming.ldap.attributes.binary", "objectGUID");
        if (sslEnabled == 1) {
            baseEnvironmentProperties.put("java.naming.ldap.factory.socket", "com.sapphireims.user.ldap.service.CustomSSLSocketFactory");
        }
        baseEnvironmentProperties.put("com.sun.jndi.ldap.read.timeout", Integer.toString(1200000));
        contextSource.setBaseEnvironmentProperties(baseEnvironmentProperties);
    }

    public LdapTemplate getLdapTemplateBasedJobProcessor(boolean isProcessingThroughCC, AdServerConfigurationModel serverConfigData, String schema, boolean isUserImport) {
        if (isProcessingThroughCC) {
            return this.getLdapTemplate(serverConfigData, isUserImport, null, null, true);
        }
        return this.getLdapTemplate(serverConfigData, isUserImport, SapphireUserImportUtil.getAesPath(schema), schema, false);
    }
}

