/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.user.util;

import com.sapphireims.user.model.OuTreeModel;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateXmlFile {
    private static final Log LOGGER = LogFactory.getLog((String)"com.sapphireims.user");

    private CreateXmlFile() {
    }

    public static boolean createOuTreeModelXmlDocument(OuTreeModel ouTreeModelList, String filePath) {
        boolean bl;
        BufferedWriter bw = new BufferedWriter(new FileWriter(filePath));
        try {
            String line = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>";
            bw.write(line);
            CreateXmlFile.writeChildNodes(bw, ouTreeModelList);
            bw.write("\n</root>");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception occurred in parseXML(createOuTreeModelXmlDocument) " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        bw.close();
        return bl;
    }

    private static void writeChildNodes(BufferedWriter bw, OuTreeModel ouTreeModelList) throws IOException {
        String line = "\n<node>" + ("<name>" + ouTreeModelList.getName() + "</name>") + ("<value>" + ouTreeModelList.getDistinguishedName() + "</value>") + ("<GUID>" + ouTreeModelList.getGuid() + "</GUID>") + ("<leaf>" + ouTreeModelList.isLeaf() + "</leaf>");
        bw.write(line);
        if (!ouTreeModelList.getChildren().isEmpty()) {
            for (OuTreeModel childOuModel : ouTreeModelList.getChildren()) {
                CreateXmlFile.writeChildNodes(bw, childOuModel);
            }
        }
        bw.write("\n</node>");
    }
}

