/*
 * Decompiled with CFR 0.152.
 */
package com.sapphire.itsm.mailrouting.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import com.sapphire.itsm.mailrouting.dto.MacrodetailsCalendareventGriddataDTO;
import com.sapphire.itsm.mailrouting.dto.MacrodetailsDTO;
import com.sapphire.itsm.mailrouting.dto.MacrodetailsGriddataDTO;
import com.sapphire.itsm.mailrouting.model.Macromaster;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.itsm.model.Macrodetails;
import com.sapphireims.itsm.model.MacrodetailsGriddata;
import com.sapphireims.itsm.model.enummodel.FieldType;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MacromasterDTO
extends BaseDTO {
    private static final long serialVersionUID = 6395316262002512528L;
    private Integer macroid;
    private String macroName;
    private String macroDesc;
    private int macroHtmlType;
    private FieldType fieldType;
    private String macroDefaultValue;
    private String macroQuery;
    private int isDeletionAllowed;
    private byte macroDatasourceType;
    private byte isCalendarEventColumn;
    private byte isinbuilt;
    private int macroAssetModuleId;
    private int sortdir;
    private List<MacrodetailsDTO> macrodetailses;
    private List<MacrodetailsGriddataDTO> macrodetailsGriddatas;
    private List<MacrodetailsCalendareventGriddataDTO> calendareventGridData;
    @JsonIgnore
    private boolean presentInDb;

    private MacromasterDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.macroid = builder.macroid;
        this.macroName = builder.macroName;
        this.macroDesc = builder.macroDesc;
        this.macroHtmlType = builder.macroHtmlType;
        this.fieldType = builder.fieldType;
        this.macroDefaultValue = builder.macroDefaultValue;
        this.macroQuery = builder.macroQuery;
        this.isDeletionAllowed = builder.isDeletionAllowed;
        this.macroDatasourceType = builder.macroDatasourceType;
        this.isCalendarEventColumn = builder.isCalendarEventColumn;
        this.isinbuilt = builder.isinbuilt;
        this.macroAssetModuleId = builder.macroAssetModuleId;
        this.sortdir = builder.sortdir;
        this.macrodetailses = builder.macrodetailses;
        this.macrodetailsGriddatas = builder.macrodetailsGriddatas;
        this.calendareventGridData = builder.calendareventGridData;
        this.presentInDb = builder.presentInDb;
    }

    public MacromasterDTO() {
    }

    public MacromasterDTO(Macromaster macro) {
        this(macro, macro.getMacrodetailses(), macro.getMacrodetailsGriddatas());
    }

    public MacromasterDTO(Macromaster macro, Set<Macrodetails> macrodetailses, Set<MacrodetailsGriddata> macrodetailsGriddatas) {
        this(macro.getMacroid(), macro.getMacroName(), macro.getMacroDesc(), macro.getMacroHtmlType(), macro.getMacroDefaultValue(), macro.getMacroQuery(), macro.getIsDeletionAllowed(), macro.getMacroDatasourceType(), macro.getIsCalendarEventColumn(), macro.getIsinbuilt(), null, null, macro.getMacroAssetModuleId(), macro.getSortdir());
        if (CollectionUtil.isNotEmpty(macrodetailses)) {
            this.macrodetailses = new ArrayList<MacrodetailsDTO>(macrodetailses.size());
            for (Macrodetails macrodetails : macrodetailses) {
                this.macrodetailses.add(new MacrodetailsDTO(macrodetails, macro));
            }
        }
        if (CollectionUtil.isNotEmpty(macrodetailsGriddatas)) {
            this.macrodetailsGriddatas = new ArrayList<MacrodetailsGriddataDTO>(macrodetailsGriddatas.size());
            for (MacrodetailsGriddata macrodetailsGriddata : macrodetailsGriddatas) {
                this.macrodetailsGriddatas.add(new MacrodetailsGriddataDTO(macrodetailsGriddata, macro));
            }
        }
    }

    public MacromasterDTO(Integer macroid, String macroName, String macroDesc, int macroHtmlType, String macroDefaultValue, String macroQuery, int isDeletionAllowed, byte macroDatasourceType, byte isCalendarEventColumn, byte isinbuilt, List<MacrodetailsDTO> macrodetailses, List<MacrodetailsGriddataDTO> macrodetailsGriddatas, int macroAssetModuleId, Integer sortdir) {
        this.macroid = macroid;
        this.macroName = macroName;
        this.macroDesc = macroDesc;
        this.macroHtmlType = macroHtmlType;
        this.fieldType = FieldType.getFieldType(macroHtmlType);
        this.macroDefaultValue = macroDefaultValue;
        this.macroQuery = macroQuery;
        this.isDeletionAllowed = isDeletionAllowed;
        this.macroDatasourceType = macroDatasourceType;
        this.isCalendarEventColumn = isCalendarEventColumn;
        this.isinbuilt = isinbuilt;
        this.macrodetailses = macrodetailses;
        this.macrodetailsGriddatas = macrodetailsGriddatas;
        this.macroAssetModuleId = macroAssetModuleId;
        this.sortdir = sortdir;
    }

    @JsonIgnore
    public Macromaster getMacromasterEntity() {
        return new Macromaster(this.macroName, this.macroDesc, this.macroHtmlType, this.macroDefaultValue, this.macroQuery, this.isDeletionAllowed, this.macroDatasourceType, this.isCalendarEventColumn, this.isinbuilt, this.macroAssetModuleId, this.sortdir, null, null, null);
    }

    public void addMacrodetailsCalendareventGriddataDTO(MacrodetailsCalendareventGriddataDTO dto) {
        if (this.calendareventGridData == null) {
            this.calendareventGridData = new ArrayList<MacrodetailsCalendareventGriddataDTO>();
        }
        this.calendareventGridData.add(dto);
    }

    public Integer getMacroid() {
        return this.macroid;
    }

    public void setMacroid(Integer macroid) {
        this.macroid = macroid;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void setMacroName(String macroName) {
        this.macroName = macroName;
    }

    public String getMacroDesc() {
        return this.macroDesc;
    }

    public void setMacroDesc(String macroDesc) {
        this.macroDesc = macroDesc;
    }

    public int getMacroHtmlType() {
        return this.macroHtmlType;
    }

    public void setMacroHtmlType(int macroHtmlType) {
        this.macroHtmlType = macroHtmlType;
    }

    public String getMacroDefaultValue() {
        return this.macroDefaultValue;
    }

    public void setMacroDefaultValue(String macroDefaultValue) {
        this.macroDefaultValue = macroDefaultValue;
    }

    public String getMacroQuery() {
        return this.macroQuery;
    }

    public void setMacroQuery(String macroQuery) {
        this.macroQuery = macroQuery;
    }

    public int getIsDeletionAllowed() {
        return this.isDeletionAllowed;
    }

    public void setIsDeletionAllowed(int isDeletionAllowed) {
        this.isDeletionAllowed = isDeletionAllowed;
    }

    public byte getMacroDatasourceType() {
        return this.macroDatasourceType;
    }

    public void setMacroDatasourceType(byte macroDatasourceType) {
        this.macroDatasourceType = macroDatasourceType;
    }

    public byte getIsCalendarEventColumn() {
        return this.isCalendarEventColumn;
    }

    public void setIsCalendarEventColumn(byte isCalendarEventColumn) {
        this.isCalendarEventColumn = isCalendarEventColumn;
    }

    public byte getIsinbuilt() {
        return this.isinbuilt;
    }

    public void setIsinbuilt(byte isinbuilt) {
        this.isinbuilt = isinbuilt;
    }

    public List<MacrodetailsDTO> getMacrodetailses() {
        return this.macrodetailses;
    }

    public void setMacrodetailses(List<MacrodetailsDTO> macrodetailses) {
        this.macrodetailses = macrodetailses;
    }

    public List<MacrodetailsGriddataDTO> getMacrodetailsGriddatas() {
        return this.macrodetailsGriddatas;
    }

    public void setMacrodetailsGriddatas(List<MacrodetailsGriddataDTO> macrodetailsGriddatas) {
        this.macrodetailsGriddatas = macrodetailsGriddatas;
    }

    public boolean isPresentInDb() {
        return this.presentInDb;
    }

    public void setPresentInDb(boolean presentInDb) {
        this.presentInDb = presentInDb;
    }

    public List<MacrodetailsCalendareventGriddataDTO> getCalendareventGridData() {
        return this.calendareventGridData;
    }

    public void setCalendareventGridData(List<MacrodetailsCalendareventGriddataDTO> calendareventGridData) {
        this.calendareventGridData = calendareventGridData;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public int getMacroAssetModuleId() {
        return this.macroAssetModuleId;
    }

    public void setMacroAssetModuleId(int macroAssetModuleId) {
        this.macroAssetModuleId = macroAssetModuleId;
    }

    public int getSortdir() {
        return this.sortdir;
    }

    public void setSortdir(int sortdir) {
        this.sortdir = sortdir;
    }

    public Integer getId() {
        return this.getMacroid();
    }

    public void setId(Integer id) {
        this.setMacroid(id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 6395316262002512528L).add("macroid", (Object)this.macroid).add("macroName", (Object)this.macroName).add("macroDesc", (Object)this.macroDesc).add("macroHtmlType", this.macroHtmlType).add("fieldType", (Object)this.fieldType).add("macroDefaultValue", (Object)this.macroDefaultValue).add("macroQuery", (Object)this.macroQuery).add("isDeletionAllowed", this.isDeletionAllowed).add("macroDatasourceType", (int)this.macroDatasourceType).add("isCalendarEventColumn", (int)this.isCalendarEventColumn).add("isinbuilt", (int)this.isinbuilt).add("macrodetailses", this.macrodetailses).add("macrodetailsGriddatas", this.macrodetailsGriddatas).add("calendareventGridData", this.calendareventGridData).add("presentInDb", this.presentInDb).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.macroid, this.macroName, this.macroDesc, this.macroHtmlType, this.fieldType, this.macroDefaultValue, this.macroQuery, this.isDeletionAllowed, this.macroDatasourceType, this.isCalendarEventColumn, this.isinbuilt, this.macrodetailses, this.macrodetailsGriddatas, this.calendareventGridData, this.presentInDb});
    }

    public boolean equals(Object object) {
        if (object instanceof MacromasterDTO) {
            if (!super.equals(object)) {
                return false;
            }
            MacromasterDTO that = (MacromasterDTO)((Object)object);
            return Objects.equals(this.macroid, that.macroid) && Objects.equals(this.macroName, that.macroName) && Objects.equals(this.macroDesc, that.macroDesc) && this.macroHtmlType == that.macroHtmlType && Objects.equals((Object)this.fieldType, (Object)that.fieldType) && Objects.equals(this.macroDefaultValue, that.macroDefaultValue) && Objects.equals(this.macroQuery, that.macroQuery) && this.isDeletionAllowed == that.isDeletionAllowed && this.macroDatasourceType == that.macroDatasourceType && this.isCalendarEventColumn == that.isCalendarEventColumn && this.isinbuilt == that.isinbuilt && Objects.equals(this.macrodetailses, that.macrodetailses) && Objects.equals(this.macrodetailsGriddatas, that.macrodetailsGriddatas) && Objects.equals(this.calendareventGridData, that.calendareventGridData) && this.presentInDb == that.presentInDb;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private Integer macroid;
        private String macroName;
        private String macroDesc;
        private int macroHtmlType;
        private FieldType fieldType;
        private String macroDefaultValue;
        private String macroQuery;
        private int isDeletionAllowed;
        private byte macroDatasourceType;
        private byte isCalendarEventColumn;
        private byte isinbuilt;
        private int macroAssetModuleId;
        private int sortdir;
        private List<MacrodetailsDTO> macrodetailses = Collections.emptyList();
        private List<MacrodetailsGriddataDTO> macrodetailsGriddatas = Collections.emptyList();
        private List<MacrodetailsCalendareventGriddataDTO> calendareventGridData = Collections.emptyList();
        private boolean presentInDb;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withMacroid(Integer macroid) {
            this.macroid = macroid;
            return this;
        }

        public Builder withMacroName(String macroName) {
            this.macroName = macroName;
            return this;
        }

        public Builder withMacroDesc(String macroDesc) {
            this.macroDesc = macroDesc;
            return this;
        }

        public Builder withMacroHtmlType(int macroHtmlType) {
            this.macroHtmlType = macroHtmlType;
            return this;
        }

        public Builder withFieldType(FieldType fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder withMacroDefaultValue(String macroDefaultValue) {
            this.macroDefaultValue = macroDefaultValue;
            return this;
        }

        public Builder withMacroQuery(String macroQuery) {
            this.macroQuery = macroQuery;
            return this;
        }

        public Builder withIsDeletionAllowed(int isDeletionAllowed) {
            this.isDeletionAllowed = isDeletionAllowed;
            return this;
        }

        public Builder withMacroDatasourceType(byte macroDatasourceType) {
            this.macroDatasourceType = macroDatasourceType;
            return this;
        }

        public Builder withIsCalendarEventColumn(byte isCalendarEventColumn) {
            this.isCalendarEventColumn = isCalendarEventColumn;
            return this;
        }

        public Builder withIsinbuilt(byte isinbuilt) {
            this.isinbuilt = isinbuilt;
            return this;
        }

        public Builder withMacrodetailses(List<MacrodetailsDTO> macrodetailses) {
            this.macrodetailses = macrodetailses;
            return this;
        }

        public Builder withMacrodetailsGriddatas(List<MacrodetailsGriddataDTO> macrodetailsGriddatas) {
            this.macrodetailsGriddatas = macrodetailsGriddatas;
            return this;
        }

        public Builder withCalendareventGridData(List<MacrodetailsCalendareventGriddataDTO> calendareventGridData) {
            this.calendareventGridData = calendareventGridData;
            return this;
        }

        public Builder withMacroAssetModuleId(int macroAssetModuleId) {
            this.macroAssetModuleId = macroAssetModuleId;
            return this;
        }

        public Builder withSortdir(int sortdir) {
            this.sortdir = sortdir;
            return this;
        }

        public Builder withPresentInDb(boolean presentInDb) {
            this.presentInDb = presentInDb;
            return this;
        }

        public MacromasterDTO build() {
            return new MacromasterDTO(this);
        }
    }
}

