/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dao.impl;

import com.sapphire.itsm.mailrouting.model.AssetitemtypeMaster;
import com.sapphire.itsm.mailrouting.model.AssetitemtypeMasterId;
import com.sapphireims.cmdb.dao.IAssetItemtypeMasterDAO;
import com.sapphireims.cmdb.dto.AssetModuleExportDTO;
import com.sapphireims.dao.GenericHibernateRepository;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.NativeQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AssetItemtypeMasterDAO
extends GenericHibernateRepository<AssetitemtypeMaster, AssetitemtypeMasterId>
implements IAssetItemtypeMasterDAO {
    private final SessionFactory sessionFactory;

    @Autowired
    public AssetItemtypeMasterDAO(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<AssetitemtypeMaster> getAssetTypes(Integer moduleId) {
        String queryString = "from AssetitemtypeMaster where assetModuleId= :moduleId and id.itemTypeId <> 20000";
        String[] paramNames = new String[]{"moduleId"};
        Object[] values = new Object[]{moduleId};
        return this.hibernateDaoOperations.findByNamedParam(queryString, paramNames, values, AssetitemtypeMaster.class);
    }

    @Override
    public AssetitemtypeMaster getAssetTypesById(Integer itemTypeId) {
        String queryString = "from AssetitemtypeMaster where id.itemTypeId= :itemTypeId";
        String[] paramNames = new String[]{"itemTypeId"};
        Object[] values = new Object[]{itemTypeId};
        return (AssetitemtypeMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(queryString, paramNames, values, AssetitemtypeMaster.class));
    }

    @Override
    public List<AssetitemtypeMaster> getAllAssetTypes() {
        String queryString = "from AssetitemtypeMaster";
        String[] paramNames = new String[]{};
        Object[] values = new Object[]{};
        return this.hibernateDaoOperations.findByNamedParam(queryString, paramNames, values, AssetitemtypeMaster.class);
    }

    @Override
    public AssetitemtypeMaster getAssetTypeByName(String name, int moduleId) {
        String queryString = "from AssetitemtypeMaster where itemType= :name and assetModuleId=:moduleId";
        String[] paramNames = new String[]{"name", "moduleId"};
        Object[] values = new Object[]{name, moduleId};
        return (AssetitemtypeMaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(queryString, paramNames, values, AssetitemtypeMaster.class));
    }

    @Override
    public List<AssetitemtypeMaster> getAssetitemtypeMasterByItemTypeIds(List<Integer> itemtypeIds, int moduleId) {
        String queryString = "from AssetitemtypeMaster where assetModuleId= :moduleId and id.itemTypeId in (:itemtypeIds)";
        String[] paramNames = new String[]{"moduleId", "itemtypeIds"};
        Object[] values = new Object[]{moduleId, itemtypeIds};
        return this.hibernateDaoOperations.findByNamedParam(queryString, paramNames, values, AssetitemtypeMaster.class);
    }

    @Override
    public AssetModuleExportDTO saveAssetItemTypeMaster(AssetModuleExportDTO req) {
        Session session = this.sessionFactory.getCurrentSession();
        int i = 0;
        String Query2 = "insert into assetitemtype_master(SiteID,ItemTypeID,ItemType,Description,AssetModule_ID,MappingKeyType,cmdbViewPrefix,Format,IsDisplay,IsInBuilt,Reconciliation_Mandate) value(:SiteID,:ItemTypeID,:ItemType,:Description,:AssetModule_ID,:MappingKeyType,:cmdbViewPrefix,:Format,:IsDisplay,:IsInBuilt,:ReconMandate)";
        if (!req.getOldIdItemTypes().isEmpty()) {
            for (Map.Entry<Integer, AssetitemtypeMaster> entry : req.getOldIdItemTypes().entrySet()) {
                AssetitemtypeMaster sdsf = entry.getValue();
                int oldId = entry.getKey();
                MutationQuery sqlQuery = session.createNativeMutationQuery(Query2);
                sqlQuery.setParameter("SiteID", (Object)1);
                sqlQuery.setParameter("ItemType", (Object)sdsf.getItemType());
                sqlQuery.setParameter("Description", (Object)sdsf.getDescription());
                sqlQuery.setParameter("AssetModule_ID", (Object)req.getAssetModuleMaster().getModuleId());
                sqlQuery.setParameter("MappingKeyType", (Object)sdsf.getMappingKeyType());
                sqlQuery.setParameter("cmdbViewPrefix", (Object)"");
                sqlQuery.setParameter("Format", (Object)sdsf.getFormat());
                sqlQuery.setParameter("IsDisplay", (Object)sdsf.getIsDisplay());
                sqlQuery.setParameter("IsInBuilt", (Object)sdsf.getIsInBuilt());
                sqlQuery.setParameter("ReconMandate", (Object)sdsf.getReconciliationMandate());
                int itemTypeId = 0;
                itemTypeId = i == 0 ? sdsf.getId().getItemTypeId() : this.AssetitemtypeMasterIncDAO().intValue();
                sqlQuery.setParameter("ItemTypeID", (Object)itemTypeId);
                sqlQuery.executeUpdate();
                if (i == 0) {
                    BigInteger result = (BigInteger)session.createNativeQuery("SELECT LAST_INSERT_ID()", BigInteger.class).uniqueResult();
                    sdsf.getId().setItemTypeId(result.intValue());
                } else {
                    sdsf.getId().setItemTypeId(itemTypeId);
                }
                ++i;
                sdsf.setAssetModuleId(req.getAssetModuleMaster().getModuleId());
                sdsf.getId().setSiteId(1);
                req.getOldIdItemTypes().put(oldId, sdsf);
                req.getItemTypes().add(sdsf);
            }
        }
        return req;
    }

    public Integer AssetitemtypeMasterIncDAO() {
        Session session = this.sessionFactory.getCurrentSession();
        String Query2 = "Select max(ItemTypeID)+1 from assetitemtype_master";
        NativeQuery sqlQuery = session.createNativeQuery(Query2, Integer.class);
        return (Integer)sqlQuery.uniqueResult();
    }

    @Override
    public List<AssetitemtypeMaster> getAssetTypesWithModuleIds(List<Integer> moduleIds) {
        String queryString = "from AssetitemtypeMaster where assetModuleId in (:moduleIds)";
        String[] paramNames = new String[]{"moduleIds"};
        Object[] values = new Object[]{moduleIds};
        return this.hibernateDaoOperations.findByNamedParam(queryString, paramNames, values, AssetitemtypeMaster.class);
    }

    @Override
    public List<Integer> getAssetTypesByModuleId(Integer moduleId) {
        String queryString = "select am.id.itemTypeId from AssetitemtypeMaster am where am.assetModuleId= :moduleId and am.id.itemTypeId <> 20000 and isDisplay=1";
        String[] paramNames = new String[]{"moduleId"};
        Object[] values = new Object[]{moduleId};
        return this.hibernateDaoOperations.findByNamedParam(queryString, paramNames, values, Integer.class);
    }
}

