/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dao.impl;

import com.sapphireims.cmdb.dao.IAssetNotificationTemplateDetailsDAO;
import com.sapphireims.cmdb.dto.AssetNotificationTemplateDetailsDTO;
import com.sapphireims.cmdb.dto.AssetNotificationTemplateMasterDTO;
import com.sapphireims.cmdb.model.AssetNotificationTemplateDetails;
import com.sapphireims.cmdb.model.AssetNotificationTemplateMaster;
import com.sapphireims.dao.GenericHibernateRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class AssetNotificationTemplateDetailsDAO
extends GenericHibernateRepository<AssetNotificationTemplateDetails, AssetNotificationTemplateMaster>
implements IAssetNotificationTemplateDetailsDAO {
    private static final String QUERY_ASSET_NOTIFICATION_TEMPLATE_DETAILS = "from AssetNotificationTemplateDetails where assetnotificationTemplatemaster.templateId= :templateId";

    @Override
    public List<AssetNotificationTemplateDetailsDTO> getAssetNotificationTemplateDetails(Integer templateId) {
        List<AssetNotificationTemplateDetails> result = this.fetchAssetNotificationTemplateDetails(templateId);
        return this.mapToDTOList(result);
    }

    private List<AssetNotificationTemplateDetails> fetchAssetNotificationTemplateDetails(Integer templateId) {
        Query query = this.hibernateDaoOperations.getSessionFactory().getCurrentSession().createQuery(QUERY_ASSET_NOTIFICATION_TEMPLATE_DETAILS, AssetNotificationTemplateDetails.class);
        query.setParameter("templateId", (Object)templateId);
        return query.list();
    }

    private List<AssetNotificationTemplateDetailsDTO> mapToDTOList(List<AssetNotificationTemplateDetails> entities) {
        return entities.stream().map(this::convertToDTO).collect(Collectors.toList());
    }

    private AssetNotificationTemplateDetailsDTO convertToDTO(AssetNotificationTemplateDetails detail) {
        AssetNotificationTemplateMasterDTO masterDTO = new AssetNotificationTemplateMasterDTO(detail.getAssetnotificationTemplatemaster().getTemplateId(), detail.getAssetnotificationTemplatemaster().getTemplateName(), detail.getAssetnotificationTemplatemaster().getTemplateDescription(), detail.getAssetnotificationTemplatemaster().getTemplateType(), detail.getAssetnotificationTemplatemaster().getFixedTemplateType(), detail.getAssetnotificationTemplatemaster().getModuleId(), detail.getAssetnotificationTemplatemaster().getNotificationTemplateType(), detail.getAssetnotificationTemplatemaster().getIsDefault());
        return new AssetNotificationTemplateDetailsDTO(masterDTO, detail.getTemplateDetailsId(), detail.getFieldType(), detail.getFieldValue(), detail.getAssetType(), detail.getDisplayOrder());
    }
}

