/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dao.impl;

import com.google.common.collect.ImmutableMap;
import com.sapphireims.cmdb.dao.IAssetmasterDAO;
import com.sapphireims.cmdb.model.Assetmaster;
import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.util.CollectionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository
public class AssetmasterDAO
extends GenericHibernateRepository<Assetmaster, Integer>
implements IAssetmasterDAO {
    private static final String SQL = " SELECT a.`AssetID` FROM `assetmaster` a ORDER BY a.`AssetID`  LIMIT :startindex , :pageSize ";

    @Override
    public List<Integer> getAsssetIds(Integer startindex, Integer pageSize) {
        ImmutableMap ma = ImmutableMap.of((Object)"startindex", (Object)startindex, (Object)"pageSize", (Object)pageSize);
        List lsts = this.hibernateDaoOperations.sqlQuery(SQL, (Map)ma, Integer.class);
        ArrayList<Integer> sts = null;
        if (CollectionUtil.isNotEmpty(lsts)) {
            sts = new ArrayList<Integer>(lsts.size());
            for (int i = 0; i < lsts.size(); ++i) {
                Integer o = (Integer)lsts.get(i);
                sts.add(o);
            }
        }
        return sts;
    }

    @Override
    public List<Assetmaster> getChildAssets(Integer parentId) {
        String query = " from Assetmaster where parentAsset = :parentId ";
        String[] paramNames = new String[]{"parentId"};
        Object[] values = new Object[]{parentId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, Assetmaster.class);
    }

    @Override
    public String getGeneratedAssetNumber(int itemTypeId, String prefix) {
        Session session = this.hibernateDaoOperations.getSessionFactory().getCurrentSession();
        return (String)session.doReturningWork(connection -> this.generatedAssetNumber(connection, itemTypeId, prefix));
    }

    private String generatedAssetNumber(Connection connection, int itemTypeId, String recordParameters) throws SQLException {
        String assetNumber = "";
        PreparedStatement pst = null;
        ResultSet rs = null;
        String procedure = "call AssetNumberGenerator( ?,? ,2)";
        pst = connection.prepareStatement(procedure);
        pst.setInt(1, itemTypeId);
        pst.setString(2, recordParameters);
        rs = pst.executeQuery();
        while (rs.next()) {
            assetNumber = rs.getString(1);
        }
        rs.close();
        pst.close();
        return assetNumber;
    }

    @Override
    public Assetmaster getAssetByAssetNumberAndItemTypeId(String assetNumber, Integer itemTypeId) {
        String query = " from Assetmaster where assetNumber = :assetNumber and itemTypeId=:itemTypeId and status=0";
        String[] paramNames = new String[]{"assetNumber", "itemTypeId"};
        Object[] values = new Object[]{assetNumber, itemTypeId};
        return (Assetmaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, Assetmaster.class));
    }

    @Override
    public Assetmaster getAssetByAssetNumber(String assetNumber) {
        String query = " from Assetmaster where assetNumber = :assetNumber and status=0";
        String[] paramNames = new String[]{"assetNumber"};
        Object[] values = new Object[]{assetNumber};
        return (Assetmaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, Assetmaster.class));
    }

    @Override
    public List<Assetmaster> getAllAssetsOfUser(Integer userId) {
        String query = " from Assetmaster where status = 0 and userId = :userId ";
        String[] paramNames = new String[]{"userId"};
        Object[] values = new Object[]{userId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, Assetmaster.class);
    }

    @Override
    public List<Assetmaster> getAllAssets(Integer pageNo, String searchString) {
        Object query = " from Assetmaster where status = 0";
        String[] paramNames = new String[]{};
        Object[] values = new Object[]{};
        if (!searchString.isEmpty()) {
            query = (String)query + "and (systemName LIKE '%" + searchString + "%' or assetNumber LIKE '%" + searchString + "%')";
        }
        return this.hibernateDaoOperations.findByNamedParam((String)query, paramNames, values, pageNo, Integer.valueOf(100), Assetmaster.class);
    }

    @Override
    public List<Object[]> getImpactedCIForReact(Integer userId, Integer impactValue, List<Integer> moduleIds, List<Integer> blockedAssets, String searchString, Boolean isOtherAssets, Integer pageNo) {
        StringBuilder assetQuery = new StringBuilder();
        Object whereClause = "";
        String userCondition = "";
        String[] params = new String[]{};
        Object[] values = new Object[]{};
        if (!isOtherAssets.booleanValue()) {
            userCondition = " AND am.UserID=:userId AND im.AssetModule_Id in (:moduleIds) ";
        }
        int startIndex = 0;
        int endIndex = 101;
        if (pageNo > 1) {
            startIndex = 100 * pageNo;
            endIndex = startIndex + 101;
        }
        String limitCondition = " LIMIT " + startIndex + ", " + endIndex;
        switch (impactValue) {
            case 1: {
                if (!searchString.isEmpty()) {
                    whereClause = " and am.AssetNumber like '%" + searchString + "%' ";
                }
                assetQuery.append("select AssetID,if((AssetNumber='' or AssetNumber='null'),AssetID,AssetNumber),im.AssetModule_Id from assetmaster am, assetitemtype_master im").append(" where am.itemtypeid = im.itemTypeId AND am.ItemTypeID NOT IN (:blockedAssets) and status=0 ").append(userCondition).append((String)whereClause).append(" and AssetNumber <> '' and IsArchived=0 order by AssetNumber").append(limitCondition);
                if (!isOtherAssets.booleanValue()) {
                    params = new String[]{"userId", "blockedAssets", "moduleIds"};
                    values = new Object[]{userId, blockedAssets, moduleIds};
                    break;
                }
                params = new String[]{"blockedAssets"};
                values = new Object[]{blockedAssets};
                break;
            }
            case 2: {
                if (!searchString.isEmpty()) {
                    whereClause = " and ivm.hostName like '%" + searchString + "%' ";
                }
                assetQuery.append("SELECT am.AssetID,ivm.hostName,im.AssetModule_Id FROM Assetmaster am,inventorymaster ivm, assetitemtype_master im").append(" where ivm.systemid=am.systemid AND am.itemtypeid = im.itemTypeId AND ivm.SiteID=am.SiteID").append(" AND am.ItemTypeID NOT IN (:blockedAssets)").append(userCondition).append((String)whereClause).append(" AND ivm.hostName <> '' AND ivm.hostName IS NOT NULL ").append(" AND am.status=0 AND am.IsArchived=0 ORDER BY ivm.hostName").append(limitCondition);
                if (!isOtherAssets.booleanValue()) {
                    params = new String[]{"userId", "blockedAssets", "moduleIds"};
                    values = new Object[]{userId, blockedAssets, moduleIds};
                    break;
                }
                params = new String[]{"blockedAssets"};
                values = new Object[]{blockedAssets};
                break;
            }
            case 3: {
                if (!searchString.isEmpty()) {
                    whereClause = " and SystemName like '%" + searchString + "%'";
                }
                assetQuery.append("select AssetID,SystemName,im.AssetModule_Id from assetmaster am, assetitemtype_master im where  am.itemtypeid = im.itemTypeId AND am.itemtypeid not in (:blockedAssets) ").append((String)whereClause).append(userCondition).append(" and SystemName <> '' and status=0 and IsArchived=0 order by SystemName").append(limitCondition);
                if (!isOtherAssets.booleanValue()) {
                    params = new String[]{"userId", "blockedAssets"};
                    values = new Object[]{userId, blockedAssets};
                    break;
                }
                params = new String[]{"blockedAssets"};
                values = new Object[]{blockedAssets};
            }
        }
        return this.hibernateDaoOperations.findByNamedParamSql(assetQuery.toString(), params, values, Object[].class);
    }

    @Override
    public Assetmaster getActiveAssetByAssetNumber(String assetNumber) {
        String query = " from Assetmaster where assetNumber = :assetNumber and status=0 and isArchived=0";
        String[] paramNames = new String[]{"assetNumber"};
        Object[] values = new Object[]{assetNumber};
        return (Assetmaster)((Object)this.hibernateDaoOperations.findByNamedParamUniqueResult(query, paramNames, values, Assetmaster.class));
    }
}

