/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphireims.cmdb.dto.AssetDTO;
import com.sapphireims.cmdb.model.AssetamcWarranty;
import com.sapphireims.cmdb.model.Assetcontrolflowdetails;
import com.sapphireims.cmdb.model.AssetcostDetails;
import com.sapphireims.cmdb.model.Assetdetails;
import com.sapphireims.cmdb.model.AssethardwareOscomponents;
import com.sapphireims.cmdb.model.AssetmakeManufacturer;
import com.sapphireims.cmdb.model.Assetmaster;
import com.sapphireims.cmdb.model.Assetpurchase;
import com.sapphireims.cmdb.model.Assetstatus;
import com.sapphireims.cmdb.model.enummodel.Components;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.StringUtil;
import java.io.Serializable;
import java.util.List;

public class AssetContext
implements Serializable {
    private Assetmaster master;
    private AssethardwareOscomponents assetHardwareOsComponents;
    private AssetmakeManufacturer assetmakeManufacturer;
    private Assetpurchase assetpurchase;
    private AssetamcWarranty assetamcWarranty;
    private AssetcostDetails assetcostDetails;
    private List<Assetdetails> addionalParms;
    private List<Assetcontrolflowdetails> status;
    private Assetstatus assetStatus;
    private AssetDTO asset;

    public AssetContext(AssetDTO asset) {
        this.asset = asset;
        this.master = new Assetmaster();
        this.master.setDepartment(0);
        this.master.setLocation(0);
    }

    public void chckComponentsIsNullAndIntilize(Components c, boolean isUpdate) {
        switch (c) {
            case AMC: {
                if (this.assetamcWarranty != null) break;
                this.assetamcWarranty = new AssetamcWarranty(this.asset.getSiteId());
                if (!isUpdate) break;
                this.assetamcWarranty.setAssetmaster(this.master);
                break;
            }
            case COST: {
                if (this.assetcostDetails != null) break;
                this.assetcostDetails = new AssetcostDetails(this.asset.getSiteId());
                if (!isUpdate) break;
                this.assetcostDetails.setAssetId(this.master.getAssetId());
                break;
            }
            case HARDWARE: {
                if (this.assetHardwareOsComponents != null) break;
                this.assetHardwareOsComponents = new AssethardwareOscomponents(this.asset.getSiteId());
                if (!isUpdate) break;
                this.assetHardwareOsComponents.setAssetId(this.master.getAssetId());
                break;
            }
            case MAKE: {
                if (this.assetmakeManufacturer != null) break;
                this.assetmakeManufacturer = new AssetmakeManufacturer(this.asset.getSiteId());
                if (!isUpdate) break;
                this.assetmakeManufacturer.setAssetId(this.master.getAssetId());
                break;
            }
            case PURCHASE: {
                if (this.assetpurchase != null) break;
                this.assetpurchase = new Assetpurchase(this.asset.getSiteId());
                if (!isUpdate) break;
                this.assetpurchase.setAssetmaster(this.master);
                break;
            }
        }
    }

    @JsonIgnore
    public Assetdetails getAssetdetails(int assetDetailsId) {
        if (CollectionUtil.isNotEmpty(this.addionalParms)) {
            for (Assetdetails a : this.addionalParms) {
                if (a.getId().getAssetDetailsId() != assetDetailsId) continue;
                return a;
            }
            return null;
        }
        return null;
    }

    @JsonIgnore
    public Assetcontrolflowdetails getAssetFlowdetails(int assetDetailsId) {
        if (CollectionUtil.isNotEmpty(this.status)) {
            for (Assetcontrolflowdetails a : this.status) {
                if (a.getAssetDetailsId() != assetDetailsId) continue;
                return a;
            }
            return null;
        }
        return null;
    }

    public AssetDTO getAsset() {
        return this.asset;
    }

    public void setAsset(AssetDTO asset) {
        this.asset = asset;
    }

    public Assetmaster getMaster() {
        if (this.asset.getUserAcceptanceStatus() != null) {
            this.master.setUserApproveStatus((byte)this.asset.getUserAcceptanceStatus().getValue());
        }
        if (this.asset.getUserAcceptanceStatus() == null && this.asset.getUserApproveStatus() != null && this.asset.getUserApproveStatus() != 0) {
            this.master.setUserApproveStatus((byte)this.asset.getUserApproveStatus().intValue());
        }
        if (this.asset.getSystemId() != null && this.asset.getSystemId() != 0) {
            this.master.setSystemId(this.asset.getSystemId());
        }
        if (!StringUtil.isEmpty((String)this.asset.getSystemName())) {
            this.master.setSystemName(this.asset.getSystemName());
        }
        return this.master;
    }

    public void setMaster(Assetmaster master) {
        this.master = master;
    }

    public AssethardwareOscomponents getAssetHardwareOsComponents() {
        if (this.assetHardwareOsComponents == null) {
            return null;
        }
        this.assetHardwareOsComponents.setProcessor(this.assetHardwareOsComponents.getProcessor() != null ? this.assetHardwareOsComponents.getProcessor() : null);
        this.assetHardwareOsComponents.setRamsize(this.assetHardwareOsComponents.getRamsize() != null ? this.assetHardwareOsComponents.getRamsize() : null);
        this.assetHardwareOsComponents.setHardDiskSize(this.assetHardwareOsComponents.getHardDiskSize() != null ? this.assetHardwareOsComponents.getHardDiskSize() : null);
        this.assetHardwareOsComponents.setOperatingSystem(this.assetHardwareOsComponents.getOperatingSystem() != null ? this.assetHardwareOsComponents.getOperatingSystem() : null);
        this.assetHardwareOsComponents.setBatterySerialNumber(this.assetHardwareOsComponents.getBatterySerialNumber() != null ? this.assetHardwareOsComponents.getBatterySerialNumber() : null);
        this.assetHardwareOsComponents.setDisplaySize(this.assetHardwareOsComponents.getDisplaySize() != null ? this.assetHardwareOsComponents.getDisplaySize() : null);
        this.assetHardwareOsComponents.setInternalStorage(this.assetHardwareOsComponents.getInternalStorage() != null ? this.assetHardwareOsComponents.getInternalStorage() : null);
        this.assetHardwareOsComponents.setExternalStorageMake(this.assetHardwareOsComponents.getExternalStorageMake() != null ? this.assetHardwareOsComponents.getExternalStorageMake() : null);
        this.assetHardwareOsComponents.setExternalStorageCapacity(this.assetHardwareOsComponents.getExternalStorageCapacity() != null ? this.assetHardwareOsComponents.getExternalStorageCapacity() : null);
        this.assetHardwareOsComponents.setOsversion(this.assetHardwareOsComponents.getOsversion() != null ? this.assetHardwareOsComponents.getOsversion() : null);
        this.assetHardwareOsComponents.setImeinumber(this.assetHardwareOsComponents.getImeinumber() != null ? this.assetHardwareOsComponents.getImeinumber() : null);
        this.assetHardwareOsComponents.setTotalPorts(this.assetHardwareOsComponents.getTotalPorts() != null ? this.assetHardwareOsComponents.getTotalPorts() : null);
        this.assetHardwareOsComponents.setConnectivityType(this.assetHardwareOsComponents.getConnectivityType() != null ? this.assetHardwareOsComponents.getConnectivityType() : null);
        this.assetHardwareOsComponents.setPrinterType(this.assetHardwareOsComponents.getPrinterType() != null ? this.assetHardwareOsComponents.getPrinterType() : null);
        this.assetHardwareOsComponents.setPrintMode(this.assetHardwareOsComponents.getPrintMode() != null ? this.assetHardwareOsComponents.getPrintMode() : null);
        return this.assetHardwareOsComponents;
    }

    public void setAssetHardwareOsComponents(AssethardwareOscomponents assetHardwareOsComponents) {
        this.assetHardwareOsComponents = assetHardwareOsComponents;
    }

    public AssetmakeManufacturer getAssetmakeManufacturer() {
        if (this.assetmakeManufacturer == null) {
            return null;
        }
        this.assetmakeManufacturer.setManufacturer(this.assetmakeManufacturer.getManufacturer() != null ? this.assetmakeManufacturer.getManufacturer() : null);
        this.assetmakeManufacturer.setModel(this.assetmakeManufacturer.getModel() != null ? this.assetmakeManufacturer.getModel() : null);
        this.assetmakeManufacturer.setSerialNumber(this.assetmakeManufacturer.getSerialNumber() != null ? this.assetmakeManufacturer.getSerialNumber() : null);
        return this.assetmakeManufacturer;
    }

    public void setAssetmakeManufacturer(AssetmakeManufacturer assetmakeManufacturer) {
        this.assetmakeManufacturer = assetmakeManufacturer;
    }

    public Assetpurchase getAssetpurchase() {
        if (this.assetpurchase == null) {
            return null;
        }
        this.assetpurchase.setVendor(this.assetpurchase.getVendor() != null ? this.assetpurchase.getVendor() : null);
        this.assetpurchase.setGrndate(this.assetpurchase.getGrndate() != null ? this.assetpurchase.getGrndate() : null);
        this.assetpurchase.setGrnnumber(this.assetpurchase.getGrnnumber() != null ? this.assetpurchase.getGrnnumber() : null);
        this.assetpurchase.setInvoiceDate(this.assetpurchase.getInvoiceDate() != null ? this.assetpurchase.getInvoiceDate() : null);
        this.assetpurchase.setInvoiceNumber(this.assetpurchase.getInvoiceNumber() != null ? this.assetpurchase.getInvoiceNumber() : null);
        this.assetpurchase.setPurchaseDate(this.assetpurchase.getPurchaseDate() != null ? this.assetpurchase.getPurchaseDate() : null);
        this.assetpurchase.setPonumber(this.assetpurchase.getPonumber() != null ? this.assetpurchase.getPonumber() : null);
        return this.assetpurchase;
    }

    public void setAssetpurchase(Assetpurchase assetpurchase) {
        this.assetpurchase = assetpurchase;
    }

    public AssetamcWarranty getAssetamcWarranty() {
        if (this.assetamcWarranty == null) {
            return null;
        }
        this.assetamcWarranty.setWarrantyEndDate(this.assetamcWarranty.getWarrantyEndDate() != null ? this.assetamcWarranty.getWarrantyEndDate() : null);
        this.assetamcWarranty.setWarrantyStartDate(this.assetamcWarranty.getWarrantyStartDate() != null ? this.assetamcWarranty.getWarrantyStartDate() : null);
        this.assetamcWarranty.setAmcendDate(this.assetamcWarranty.getAmcendDate() != null ? this.assetamcWarranty.getAmcendDate() : null);
        this.assetamcWarranty.setAmcstartDate(this.assetamcWarranty.getAmcstartDate() != null ? this.assetamcWarranty.getAmcstartDate() : null);
        this.assetamcWarranty.setDeploymentDate(this.assetamcWarranty.getDeploymentDate() != null ? this.assetamcWarranty.getDeploymentDate() : null);
        return this.assetamcWarranty;
    }

    public void setAssetamcWarranty(AssetamcWarranty assetamcWarranty) {
        this.assetamcWarranty = assetamcWarranty;
    }

    public AssetcostDetails getAssetcostDetails() {
        if (this.assetcostDetails == null) {
            return null;
        }
        this.assetcostDetails.setCurrentCost(this.assetcostDetails.getCurrentCost() != null ? this.assetcostDetails.getCurrentCost() : null);
        this.assetcostDetails.setAssetCost(this.assetcostDetails.getAssetCost() != null ? this.assetcostDetails.getAssetCost() : null);
        this.assetcostDetails.setSalvageValue(this.assetcostDetails.getSalvageValue() != null ? this.assetcostDetails.getSalvageValue() : null);
        return this.assetcostDetails;
    }

    public void setAssetcostDetails(AssetcostDetails assetcostDetails) {
        this.assetcostDetails = assetcostDetails;
    }

    public List<Assetdetails> getAddionalParms() {
        return this.addionalParms;
    }

    public void setAddionalParms(List<Assetdetails> addionalParms) {
        this.addionalParms = addionalParms;
    }

    public List<Assetcontrolflowdetails> getStatus() {
        return this.status;
    }

    public void setStatus(List<Assetcontrolflowdetails> status) {
        this.status = status;
    }

    public Assetstatus getAssetStatus() {
        return this.assetStatus;
    }

    public void setAssetStatus(Assetstatus assetStatus) {
        this.assetStatus = assetStatus;
    }

    public Assetstatus getAssetStatusDetails() {
        return this.assetStatus;
    }
}

