/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import com.sapphireims.cmdb.dto.AssetComponentFieldsNameDTO;
import com.sapphireims.cmdb.dto.AssetFlowDetailsDTO;
import com.sapphireims.cmdb.dto.AssetItemtypeMasterDTO;
import com.sapphireims.cmdb.dto.AssetamcWarrantyDTO;
import com.sapphireims.cmdb.dto.AssetcostDetailsDTO;
import com.sapphireims.cmdb.dto.AssethardwareOscomponentsDTO;
import com.sapphireims.cmdb.dto.AssethistoryDTO;
import com.sapphireims.cmdb.dto.AssetmakeManufacturerDTO;
import com.sapphireims.cmdb.dto.AssetpurchaseDTO;
import com.sapphireims.cmdb.dto.AssetstatusDTO;
import com.sapphireims.cmdb.dto.MiscDetailsDTO;
import com.sapphireims.cmdb.dto.UserAcceptanceConfigDTO;
import com.sapphireims.cmdb.dto.UserAcceptanceStatus;
import com.sapphireims.cmdb.dto.asset.AssetAdditionalParams;
import com.sapphireims.cmdb.dto.asset.AssetStatusAdditionalParams;
import com.sapphireims.cmdb.model.enummodel.Components;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.itsm.dto.user.UserDTO;
import com.sapphireims.itsm.mindto.DepartmentMinDTO;
import com.sapphireims.itsm.mindto.LocationMinDTO;
import com.sapphireims.util.Validate;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssetDTO
extends BaseDTO {
    private static final long serialVersionUID = -8775558699209789573L;
    private AssetItemtypeMasterDTO itemType;
    private Integer assetId;
    private Integer siteId;
    private String assetNumber;
    private AssetFlowDetailsDTO filter;
    private UserDTO allocatedUser;
    private MiscDetailsDTO project;
    private Integer systemId;
    private boolean isChildAsset;
    private Integer parentAsset;
    private String systemName;
    private LocationMinDTO location;
    private DepartmentMinDTO department;
    private MiscDetailsDTO siteName;
    private String extensionNumber;
    private byte isArchived;
    private String mappingKeyValueOne;
    private String mappingKeyValueTwo;
    private Integer tempSystemID;
    private Integer assetImportTempID;
    private Integer status;
    private Date assetCreationTime;
    private Integer userApproveStatus;
    private Date lastUpdatedTime;
    private String assetDenyRemarks;
    private Byte auditStatus;
    private AssetAdditionalParams additionalParams;
    private AssetStatusAdditionalParams flowDetails;
    private AssethardwareOscomponentsDTO assetHardwareOsComponents;
    private AssetmakeManufacturerDTO assetmakeManufacturer;
    private AssetpurchaseDTO assetpurchase;
    private AssetamcWarrantyDTO assetamcWarranty;
    private AssetcostDetailsDTO assetcostDetails;
    private AssetComponentFieldsNameDTO assetComponentFieldsName;
    private AssetDTO parent;
    private List<AssetDTO> childs;
    private AssetstatusDTO assetStatus;
    private UserAcceptanceConfigDTO acceptanceTemplate;
    private UserAcceptanceConfigDTO auditTemplate;
    private List<AssethistoryDTO> assetHistory;
    private List<AssethistoryDTO> lcfAssetHistory;
    private int iteration = 0;
    private boolean rpaEvent = false;
    private UserAcceptanceStatus userAcceptanceStatus;
    private String hostName;

    private AssetDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.itemType = builder.itemType;
        this.assetId = builder.assetId;
        this.siteId = builder.siteId;
        this.assetNumber = builder.assetNumber;
        this.filter = builder.filter;
        this.allocatedUser = builder.allocatedUser;
        this.project = builder.project;
        this.systemId = builder.systemId;
        this.isChildAsset = builder.isChildAsset;
        this.parentAsset = builder.parentAsset;
        this.systemName = builder.systemName;
        this.location = builder.location;
        this.department = builder.department;
        this.siteName = builder.siteName;
        this.extensionNumber = builder.extensionNumber;
        this.isArchived = builder.isArchived;
        this.mappingKeyValueOne = builder.mappingKeyValueOne;
        this.mappingKeyValueTwo = builder.mappingKeyValueTwo;
        this.tempSystemID = builder.tempSystemID;
        this.assetImportTempID = builder.assetImportTempID;
        this.status = builder.status;
        this.assetCreationTime = builder.assetCreationTime;
        this.userApproveStatus = builder.userApproveStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.assetDenyRemarks = builder.assetDenyRemarks;
        this.auditStatus = builder.auditStatus;
        this.additionalParams = builder.additionalParams;
        this.flowDetails = builder.flowDetails;
        this.assetHardwareOsComponents = builder.assetHardwareOsComponents;
        this.assetmakeManufacturer = builder.assetmakeManufacturer;
        this.assetpurchase = builder.assetpurchase;
        this.assetamcWarranty = builder.assetamcWarranty;
        this.assetcostDetails = builder.assetcostDetails;
        this.assetComponentFieldsName = builder.assetComponentFieldsName;
        this.parent = builder.parent;
        this.childs = builder.childs;
        this.assetStatus = builder.assetStatus;
        this.acceptanceTemplate = builder.acceptanceTemplate;
        this.auditTemplate = builder.auditTemplate;
        this.userAcceptanceStatus = builder.userAcceptanceStatus;
        this.iteration = builder.iteration;
        this.rpaEvent = builder.rpaEvent;
        this.hostName = builder.hostName;
    }

    public AssetDTO() {
        this.additionalParams = new AssetAdditionalParams();
        this.flowDetails = new AssetStatusAdditionalParams();
        this.assetHardwareOsComponents = new AssethardwareOscomponentsDTO();
        this.assetmakeManufacturer = new AssetmakeManufacturerDTO();
        this.assetpurchase = new AssetpurchaseDTO();
        this.assetamcWarranty = new AssetamcWarrantyDTO();
        this.assetcostDetails = new AssetcostDetailsDTO();
        this.assetStatus = new AssetstatusDTO();
        this.filter = new AssetFlowDetailsDTO();
    }

    public AssetDTO(Integer id) {
        super(id);
        this.assetId = id;
        this.additionalParams = new AssetAdditionalParams();
    }

    public void chckComponentsIsNullAndIntilize(Components c) {
        switch (c) {
            case AMC: {
                if (this.assetamcWarranty != null) break;
                this.assetamcWarranty = new AssetamcWarrantyDTO();
                break;
            }
            case COST: {
                if (this.assetcostDetails != null) break;
                this.assetcostDetails = new AssetcostDetailsDTO();
                break;
            }
            case HARDWARE: {
                if (this.assetHardwareOsComponents != null) break;
                this.assetHardwareOsComponents = new AssethardwareOscomponentsDTO();
                break;
            }
            case MAKE: {
                if (this.assetmakeManufacturer != null) break;
                this.assetmakeManufacturer = new AssetmakeManufacturerDTO();
                break;
            }
            case PURCHASE: {
                if (this.assetpurchase != null) break;
                this.assetpurchase = new AssetpurchaseDTO();
                break;
            }
        }
    }

    public void validateItemType() throws DomainException {
        Validate.notNull((Object)((Object)this.getItemType()), (String)"Asset Item Type can't be empty ", (Object[])new Object[0]);
        if (this.itemType.getItemTypeId() == 0 && this.itemType.getItemType() == null) {
            throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Item Type id and name is empty ");
        }
    }

    @JsonIgnore
    public void addHistory(AssethistoryDTO ahDTO) throws DomainException {
        if (this.assetHistory == null) {
            this.assetHistory = new LinkedList<AssethistoryDTO>();
        }
        this.assetHistory.add(ahDTO);
    }

    @JsonIgnore
    public void addLCFHistory(AssethistoryDTO ahDTO) throws DomainException {
        if (this.lcfAssetHistory == null) {
            this.lcfAssetHistory = new LinkedList<AssethistoryDTO>();
        }
        this.lcfAssetHistory.add(ahDTO);
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public AssetItemtypeMasterDTO getItemType() {
        return this.itemType;
    }

    public void setItemType(AssetItemtypeMasterDTO itemType) {
        this.itemType = itemType;
    }

    public Integer getAssetId() {
        return this.assetId;
    }

    public void setAssetId(Integer assetId) {
        this.assetId = assetId;
    }

    public Integer getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Integer siteId) {
        this.siteId = siteId;
    }

    public String getAssetNumber() {
        return this.assetNumber;
    }

    public void setAssetNumber(String assetNumber) {
        this.assetNumber = assetNumber;
    }

    public AssetFlowDetailsDTO getFilter() {
        return this.filter;
    }

    public void setFilter(AssetFlowDetailsDTO filter) {
        this.filter = filter;
    }

    public UserDTO getAllocatedUser() {
        return this.allocatedUser;
    }

    public void setAllocatedUser(UserDTO allocatedUser) {
        this.allocatedUser = allocatedUser;
    }

    public MiscDetailsDTO getProject() {
        return this.project;
    }

    public void setProject(MiscDetailsDTO project) {
        this.project = project;
    }

    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer systemId) {
        this.systemId = systemId;
    }

    public boolean isChildAsset() {
        return this.isChildAsset;
    }

    public void setChildAsset(boolean isChildAsset) {
        this.isChildAsset = isChildAsset;
    }

    public Integer getParentAsset() {
        return this.parentAsset;
    }

    public void setParentAsset(Integer parentAsset) {
        this.parentAsset = parentAsset;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public LocationMinDTO getLocation() {
        return this.location;
    }

    public void setLocation(LocationMinDTO location) {
        this.location = location;
    }

    public DepartmentMinDTO getDepartment() {
        return this.department;
    }

    public void setDepartment(DepartmentMinDTO department) {
        this.department = department;
    }

    public MiscDetailsDTO getSiteName() {
        return this.siteName;
    }

    public void setSiteName(MiscDetailsDTO siteName) {
        this.siteName = siteName;
    }

    public String getExtensionNumber() {
        return this.extensionNumber;
    }

    public void setExtensionNumber(String extensionNumber) {
        this.extensionNumber = extensionNumber;
    }

    public byte getIsArchived() {
        return this.isArchived;
    }

    public void setIsArchived(byte isArchived) {
        this.isArchived = isArchived;
    }

    public String getMappingKeyValueOne() {
        return this.mappingKeyValueOne;
    }

    public void setMappingKeyValueOne(String mappingKeyValueOne) {
        this.mappingKeyValueOne = mappingKeyValueOne;
    }

    public String getMappingKeyValueTwo() {
        return this.mappingKeyValueTwo;
    }

    public void setMappingKeyValueTwo(String mappingKeyValueTwo) {
        this.mappingKeyValueTwo = mappingKeyValueTwo;
    }

    public Integer getTempSystemID() {
        return this.tempSystemID;
    }

    public void setTempSystemID(Integer tempSystemID) {
        this.tempSystemID = tempSystemID;
    }

    public Integer getAssetImportTempID() {
        return this.assetImportTempID;
    }

    public void setAssetImportTempID(Integer assetImportTempID) {
        this.assetImportTempID = assetImportTempID;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getAssetCreationTime() {
        return this.assetCreationTime;
    }

    public void setAssetCreationTime(Date assetCreationTime) {
        this.assetCreationTime = assetCreationTime;
    }

    public Integer getUserApproveStatus() {
        return this.userApproveStatus;
    }

    public void setUserApproveStatus(Integer userApproveStatus) {
        this.userApproveStatus = userApproveStatus;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public String getAssetDenyRemarks() {
        return this.assetDenyRemarks;
    }

    public void setAssetDenyRemarks(String assetDenyRemarks) {
        this.assetDenyRemarks = assetDenyRemarks;
    }

    public Byte getAuditStatus() {
        return this.auditStatus;
    }

    public void setAuditStatus(Byte auditStatus) {
        this.auditStatus = auditStatus;
    }

    public AssetAdditionalParams getAdditionalParams() {
        return this.additionalParams;
    }

    public void setAdditionalParams(AssetAdditionalParams additionalParams) {
        this.additionalParams = additionalParams;
    }

    public AssetStatusAdditionalParams getFlowDetails() {
        return this.flowDetails;
    }

    public void setFlowDetails(AssetStatusAdditionalParams flowDetails) {
        this.flowDetails = flowDetails;
    }

    public AssethardwareOscomponentsDTO getAssetHardwareOsComponents() {
        return this.assetHardwareOsComponents;
    }

    public void setAssetHardwareOsComponents(AssethardwareOscomponentsDTO assetHardwareOsComponents) {
        this.assetHardwareOsComponents = assetHardwareOsComponents;
    }

    public AssetmakeManufacturerDTO getAssetmakeManufacturer() {
        return this.assetmakeManufacturer;
    }

    public void setAssetmakeManufacturer(AssetmakeManufacturerDTO assetmakeManufacturer) {
        this.assetmakeManufacturer = assetmakeManufacturer;
    }

    public AssetpurchaseDTO getAssetpurchase() {
        return this.assetpurchase;
    }

    public void setAssetpurchase(AssetpurchaseDTO assetpurchase) {
        this.assetpurchase = assetpurchase;
    }

    public AssetamcWarrantyDTO getAssetamcWarranty() {
        return this.assetamcWarranty;
    }

    public void setAssetamcWarranty(AssetamcWarrantyDTO assetamcWarranty) {
        this.assetamcWarranty = assetamcWarranty;
    }

    public AssetcostDetailsDTO getAssetcostDetails() {
        return this.assetcostDetails;
    }

    public void setAssetcostDetails(AssetcostDetailsDTO assetcostDetails) {
        this.assetcostDetails = assetcostDetails;
    }

    public AssetComponentFieldsNameDTO getAssetComponentFieldsName() {
        return this.assetComponentFieldsName;
    }

    public void setAssetComponentFieldsName(AssetComponentFieldsNameDTO assetComponentFieldsNameDTO) {
        this.assetComponentFieldsName = assetComponentFieldsNameDTO;
    }

    public AssetDTO getParent() {
        return this.parent;
    }

    public void setParent(AssetDTO parent) {
        this.parent = parent;
    }

    public List<AssetDTO> getChilds() {
        return this.childs;
    }

    public void setChilds(List<AssetDTO> childs) {
        this.childs = childs;
    }

    public UserAcceptanceConfigDTO getAcceptanceTemplate() {
        return this.acceptanceTemplate;
    }

    public void setAcceptanceTemplate(UserAcceptanceConfigDTO acceptanceTemplate) {
        this.acceptanceTemplate = acceptanceTemplate;
    }

    public UserAcceptanceConfigDTO getAuditTemplate() {
        return this.auditTemplate;
    }

    public void setAuditTemplate(UserAcceptanceConfigDTO auditTemplate) {
        this.auditTemplate = auditTemplate;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Integer getId() {
        return this.getAssetId();
    }

    public void setId(Integer id) {
        this.setAssetId(id);
    }

    public AssetstatusDTO getAssetStatus() {
        return this.assetStatus;
    }

    public void setAssetStatus(AssetstatusDTO assetStatus) {
        this.assetStatus = assetStatus;
    }

    public boolean isRpaEvent() {
        return this.rpaEvent;
    }

    public void setRpaEvent(boolean rpaEvent) {
        this.rpaEvent = rpaEvent;
    }

    public UserAcceptanceStatus getUserAcceptanceStatus() {
        return this.userAcceptanceStatus;
    }

    public void setUserAcceptanceStatus(UserAcceptanceStatus userAcceptanceStatus) {
        this.userAcceptanceStatus = userAcceptanceStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.itemType, this.assetId, this.siteId, this.assetNumber, this.filter, this.allocatedUser, this.project, this.systemId, this.isChildAsset, this.parentAsset, this.systemName, this.location, this.department, this.siteName, this.extensionNumber, this.isArchived, this.mappingKeyValueOne, this.mappingKeyValueTwo, this.tempSystemID, this.assetImportTempID, this.status, this.assetCreationTime, this.userApproveStatus, this.lastUpdatedTime, this.assetDenyRemarks, this.auditStatus, this.additionalParams, this.flowDetails, this.assetHardwareOsComponents, this.assetmakeManufacturer, this.assetpurchase, this.assetamcWarranty, this.assetcostDetails, this.parent, this.childs, this.assetStatus, this.acceptanceTemplate, this.auditTemplate, this.userAcceptanceStatus, this.iteration, this.rpaEvent});
    }

    public boolean equals(Object object) {
        if (object instanceof AssetDTO) {
            AssetDTO that = (AssetDTO)((Object)object);
            if (!super.equals(object)) {
                return false;
            }
            return Objects.equals((Object)this.itemType, (Object)that.itemType) && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.siteId, that.siteId) && Objects.equals(this.assetNumber, that.assetNumber) && Objects.equals((Object)this.filter, (Object)that.filter) && Objects.equals(this.allocatedUser, that.allocatedUser) && Objects.equals((Object)this.project, (Object)that.project) && Objects.equals(this.systemId, that.systemId) && this.isChildAsset == that.isChildAsset && Objects.equals(this.parentAsset, that.parentAsset) && Objects.equals(this.systemName, that.systemName) && Objects.equals(this.location, that.location) && Objects.equals(this.department, that.department) && Objects.equals((Object)this.siteName, (Object)that.siteName) && Objects.equals(this.extensionNumber, that.extensionNumber) && this.isArchived == that.isArchived && Objects.equals(this.mappingKeyValueOne, that.mappingKeyValueOne) && Objects.equals(this.mappingKeyValueTwo, that.mappingKeyValueTwo) && Objects.equals(this.tempSystemID, that.tempSystemID) && Objects.equals(this.assetImportTempID, that.assetImportTempID) && Objects.equals(this.status, that.status) && Objects.equals(this.assetCreationTime, that.assetCreationTime) && Objects.equals(this.userApproveStatus, that.userApproveStatus) && Objects.equals(this.lastUpdatedTime, that.lastUpdatedTime) && Objects.equals(this.assetDenyRemarks, that.assetDenyRemarks) && Objects.equals(this.auditStatus, that.auditStatus) && Objects.equals((Object)this.additionalParams, (Object)that.additionalParams) && Objects.equals((Object)this.flowDetails, (Object)that.flowDetails) && Objects.equals((Object)this.assetHardwareOsComponents, (Object)that.assetHardwareOsComponents) && Objects.equals((Object)this.assetmakeManufacturer, (Object)that.assetmakeManufacturer) && Objects.equals((Object)this.assetpurchase, (Object)that.assetpurchase) && Objects.equals((Object)this.assetamcWarranty, (Object)that.assetamcWarranty) && Objects.equals((Object)this.assetcostDetails, (Object)that.assetcostDetails) && Objects.equals((Object)this.parent, (Object)that.parent) && Objects.equals(this.childs, that.childs) && Objects.equals((Object)this.assetStatus, (Object)that.assetStatus) && Objects.equals((Object)this.acceptanceTemplate, (Object)that.acceptanceTemplate) && Objects.equals((Object)this.auditTemplate, (Object)that.auditTemplate) && Objects.equals((Object)this.userAcceptanceStatus, (Object)that.userAcceptanceStatus) && this.iteration == that.iteration && this.rpaEvent == that.rpaEvent;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", -8775558699209789573L).add("itemType", (Object)this.itemType).add("assetId", (Object)this.assetId).add("siteId", (Object)this.siteId).add("assetNumber", (Object)this.assetNumber).add("filter", (Object)this.filter).add("allocatedUser", (Object)this.allocatedUser).add("project", (Object)this.project).add("systemId", (Object)this.systemId).add("isChildAsset", this.isChildAsset).add("parentAsset", (Object)this.parentAsset).add("systemName", (Object)this.systemName).add("location", (Object)this.location).add("department", (Object)this.department).add("siteName", (Object)this.siteName).add("extensionNumber", (Object)this.extensionNumber).add("isArchived", (int)this.isArchived).add("mappingKeyValueOne", (Object)this.mappingKeyValueOne).add("mappingKeyValueTwo", (Object)this.mappingKeyValueTwo).add("tempSystemID", (Object)this.tempSystemID).add("assetImportTempID", (Object)this.assetImportTempID).add("status", (Object)this.status).add("assetCreationTime", (Object)this.assetCreationTime).add("userApproveStatus", (Object)this.userApproveStatus).add("lastUpdatedTime", (Object)this.lastUpdatedTime).add("assetDenyRemarks", (Object)this.assetDenyRemarks).add("auditStatus", (Object)this.auditStatus).add("additionalParams", (Object)this.additionalParams).add("flowDetails", (Object)this.flowDetails).add("assetHardwareOsComponents", (Object)this.assetHardwareOsComponents).add("assetmakeManufacturer", (Object)this.assetmakeManufacturer).add("assetpurchase", (Object)this.assetpurchase).add("assetamcWarranty", (Object)this.assetamcWarranty).add("assetcostDetails", (Object)this.assetcostDetails).add("parent", (Object)this.parent).add("childs", this.childs).add("assetStatus", (Object)this.assetStatus).add("acceptanceTemplate", (Object)this.acceptanceTemplate).add("auditTemplate", (Object)this.auditTemplate).add("userAcceptanceStatus", (Object)this.userAcceptanceStatus).add("iteration", this.iteration).add("rpaEvent", this.rpaEvent).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<AssethistoryDTO> getAssetHistory() {
        return this.assetHistory;
    }

    public void setAssetHistory(List<AssethistoryDTO> assetHistory) {
        this.assetHistory = assetHistory;
    }

    public List<AssethistoryDTO> getLcfAssetHistory() {
        return this.lcfAssetHistory;
    }

    public void setLcfAssetHistory(List<AssethistoryDTO> lcfAssetHistory) {
        this.lcfAssetHistory = lcfAssetHistory;
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private AssetItemtypeMasterDTO itemType;
        private Integer assetId;
        private Integer siteId;
        private String assetNumber;
        private AssetFlowDetailsDTO filter;
        private UserDTO allocatedUser;
        private MiscDetailsDTO project;
        private Integer systemId;
        private boolean isChildAsset;
        private Integer parentAsset;
        private String systemName;
        private LocationMinDTO location;
        private DepartmentMinDTO department;
        private MiscDetailsDTO siteName;
        private String extensionNumber;
        private byte isArchived;
        private String mappingKeyValueOne;
        private String mappingKeyValueTwo;
        private Integer tempSystemID;
        private Integer assetImportTempID;
        private Integer status;
        private Date assetCreationTime;
        private Integer userApproveStatus;
        private Date lastUpdatedTime;
        private String assetDenyRemarks;
        private Byte auditStatus;
        private AssetAdditionalParams additionalParams;
        private AssetStatusAdditionalParams flowDetails;
        private AssethardwareOscomponentsDTO assetHardwareOsComponents;
        private AssetmakeManufacturerDTO assetmakeManufacturer;
        private AssetpurchaseDTO assetpurchase;
        private AssetamcWarrantyDTO assetamcWarranty;
        private AssetcostDetailsDTO assetcostDetails;
        private AssetComponentFieldsNameDTO assetComponentFieldsName;
        private AssetDTO parent;
        private List<AssetDTO> childs = Collections.emptyList();
        private AssetstatusDTO assetStatus;
        private UserAcceptanceConfigDTO acceptanceTemplate;
        private UserAcceptanceConfigDTO auditTemplate;
        private UserAcceptanceStatus userAcceptanceStatus;
        private int iteration;
        private boolean rpaEvent;
        private String hostName;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withItemType(AssetItemtypeMasterDTO itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder withAssetId(Integer assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder withSiteId(Integer siteId) {
            this.siteId = siteId;
            return this;
        }

        public Builder withAssetNumber(String assetNumber) {
            this.assetNumber = assetNumber;
            return this;
        }

        public Builder withFilter(AssetFlowDetailsDTO filter) {
            this.filter = filter;
            return this;
        }

        public Builder withAllocatedUser(UserDTO allocatedUser) {
            this.allocatedUser = allocatedUser;
            return this;
        }

        public Builder withProject(MiscDetailsDTO project) {
            this.project = project;
            return this;
        }

        public Builder withSystemId(Integer systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder withIsChildAsset(boolean isChildAsset) {
            this.isChildAsset = isChildAsset;
            return this;
        }

        public Builder withParentAsset(Integer parentAsset) {
            this.parentAsset = parentAsset;
            return this;
        }

        public Builder withSystemName(String systemName) {
            this.systemName = systemName;
            return this;
        }

        public Builder withLocation(LocationMinDTO location) {
            this.location = location;
            return this;
        }

        public Builder withDepartment(DepartmentMinDTO department) {
            this.department = department;
            return this;
        }

        public Builder withSiteName(MiscDetailsDTO siteName) {
            this.siteName = siteName;
            return this;
        }

        public Builder withExtensionNumber(String extensionNumber) {
            this.extensionNumber = extensionNumber;
            return this;
        }

        public Builder withIsArchived(byte isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public Builder withMappingKeyValueOne(String mappingKeyValueOne) {
            this.mappingKeyValueOne = mappingKeyValueOne;
            return this;
        }

        public Builder withMappingKeyValueTwo(String mappingKeyValueTwo) {
            this.mappingKeyValueTwo = mappingKeyValueTwo;
            return this;
        }

        public Builder withTempSystemID(Integer tempSystemID) {
            this.tempSystemID = tempSystemID;
            return this;
        }

        public Builder withAssetImportTempID(Integer assetImportTempID) {
            this.assetImportTempID = assetImportTempID;
            return this;
        }

        public Builder withStatus(Integer status) {
            this.status = status;
            return this;
        }

        public Builder withAssetCreationTime(Date assetCreationTime) {
            this.assetCreationTime = assetCreationTime;
            return this;
        }

        public Builder withUserApproveStatus(Integer userApproveStatus) {
            this.userApproveStatus = userApproveStatus;
            return this;
        }

        public Builder withLastUpdatedTime(Date lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public Builder withAssetDenyRemarks(String assetDenyRemarks) {
            this.assetDenyRemarks = assetDenyRemarks;
            return this;
        }

        public Builder withAuditStatus(Byte auditStatus) {
            this.auditStatus = auditStatus;
            return this;
        }

        public Builder withAdditionalParams(AssetAdditionalParams additionalParams) {
            this.additionalParams = additionalParams;
            return this;
        }

        public Builder withFlowDetails(AssetStatusAdditionalParams flowDetails) {
            this.flowDetails = flowDetails;
            return this;
        }

        public Builder withAssetHardwareOsComponents(AssethardwareOscomponentsDTO assetHardwareOsComponents) {
            this.assetHardwareOsComponents = assetHardwareOsComponents;
            return this;
        }

        public Builder withAssetmakeManufacturer(AssetmakeManufacturerDTO assetmakeManufacturer) {
            this.assetmakeManufacturer = assetmakeManufacturer;
            return this;
        }

        public Builder withAssetpurchase(AssetpurchaseDTO assetpurchase) {
            this.assetpurchase = assetpurchase;
            return this;
        }

        public Builder withAssetamcWarranty(AssetamcWarrantyDTO assetamcWarranty) {
            this.assetamcWarranty = assetamcWarranty;
            return this;
        }

        public Builder withAssetcostDetails(AssetcostDetailsDTO assetcostDetails) {
            this.assetcostDetails = assetcostDetails;
            return this;
        }

        public Builder withParent(AssetDTO parent) {
            this.parent = parent;
            return this;
        }

        public Builder withChilds(List<AssetDTO> childs) {
            this.childs = childs;
            return this;
        }

        public Builder withAssetStatus(AssetstatusDTO assetStatus) {
            this.assetStatus = assetStatus;
            return this;
        }

        public Builder withAcceptanceTemplate(UserAcceptanceConfigDTO acceptanceTemplate) {
            this.acceptanceTemplate = acceptanceTemplate;
            return this;
        }

        public Builder withAuditTemplate(UserAcceptanceConfigDTO auditTemplate) {
            this.auditTemplate = auditTemplate;
            return this;
        }

        public Builder withUserAcceptanceStatus(UserAcceptanceStatus userAcceptanceStatus) {
            this.userAcceptanceStatus = userAcceptanceStatus;
            return this;
        }

        public Builder withIteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public Builder withRpaEvent(boolean rpaEvent) {
            this.rpaEvent = rpaEvent;
            return this;
        }

        public Builder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder withAssetComponentsFieldNames(AssetComponentFieldsNameDTO assetComponentFieldsNameDTO) {
            this.assetComponentFieldsName = assetComponentFieldsNameDTO;
            return this;
        }

        public AssetDTO build() {
            return new AssetDTO(this);
        }
    }
}

