/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphireims.cmdb.dto.AssetControlFlowConfigDetailsDTO;
import com.sapphireims.cmdb.dto.AssetFlowDetailsIdDTO;
import com.sapphireims.cmdb.model.AssetControlFlowConfigDetails;
import com.sapphireims.cmdb.model.Assetflowdetails;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AssetFlowDetailsDTO
extends BaseDTO {
    private static final long serialVersionUID = 3453112814797092800L;
    private AssetFlowDetailsIdDTO assetFlowDetailsId;
    private String value;
    private int moduleId;
    private List<AssetControlFlowConfigDetailsDTO> assetControlFlowConfigDetails;

    private AssetFlowDetailsDTO(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.assetFlowDetailsId = builder.assetFlowDetailsId;
        this.value = builder.value;
        this.moduleId = builder.moduleId;
        this.assetControlFlowConfigDetails = builder.assetControlFlowConfigDetails;
    }

    public AssetFlowDetailsDTO() {
    }

    public AssetFlowDetailsDTO(AssetFlowDetailsIdDTO id, String value, int moduleId) {
        this.assetFlowDetailsId = id;
        this.value = value;
        this.moduleId = moduleId;
    }

    public AssetFlowDetailsDTO(Assetflowdetails a, List<AssetControlFlowConfigDetails> list) {
        AssetFlowDetailsIdDTO dto = new AssetFlowDetailsIdDTO();
        dto.setFlowDetailsId(a.getId().getFlowDetailsId());
        dto.setSiteId(a.getId().getSiteId());
        this.assetFlowDetailsId = dto;
        this.value = a.getValue();
        this.moduleId = a.getModuleId();
        if (CollectionUtil.isNotEmpty(list)) {
            this.assetControlFlowConfigDetails = new ArrayList<AssetControlFlowConfigDetailsDTO>(list.size());
            for (AssetControlFlowConfigDetails details : list) {
                this.assetControlFlowConfigDetails.add(new AssetControlFlowConfigDetailsDTO(details));
            }
        }
    }

    public AssetFlowDetailsDTO(int filterId, int siteId) {
        this.assetFlowDetailsId = new AssetFlowDetailsIdDTO(filterId, siteId);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public List<AssetControlFlowConfigDetailsDTO> getAssetControlFlowConfigDetails() {
        return this.assetControlFlowConfigDetails;
    }

    public void setAssetControlFlowConfigDetails(List<AssetControlFlowConfigDetailsDTO> assetControlFlowConfigDetails) {
        this.assetControlFlowConfigDetails = assetControlFlowConfigDetails;
    }

    public void setAssetFlowDetailsIdDTO(AssetFlowDetailsIdDTO assetFlowDetailsIdDTO) {
        this.assetFlowDetailsId = assetFlowDetailsIdDTO;
    }

    public AssetFlowDetailsIdDTO getAssetFlowDetailsId() {
        return this.assetFlowDetailsId;
    }

    public void setAssetFlowDetailsId(AssetFlowDetailsIdDTO assetFlowDetailsId) {
        this.assetFlowDetailsId = assetFlowDetailsId;
    }

    @JsonIgnore
    public Integer getId() {
        return this.id != null ? this.assetFlowDetailsId.getFlowDetailsId() : 0;
    }

    @JsonIgnore
    public void setId(Integer id) {
    }

    public String toString() {
        return "AssetFlowDetailsDTO [assetFlowDetailsIdDTO=" + this.id + ", value=" + this.value + ", moduleId=" + this.moduleId + "]";
    }

    public AssetFlowDetailsIdDTO getAssetFlowDetailsIdDTO() {
        return this.assetFlowDetailsId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private AssetFlowDetailsIdDTO assetFlowDetailsId;
        private String value;
        private int moduleId;
        private List<AssetControlFlowConfigDetailsDTO> assetControlFlowConfigDetails = Collections.emptyList();

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withAssetFlowDetailsId(AssetFlowDetailsIdDTO assetFlowDetailsId) {
            this.assetFlowDetailsId = assetFlowDetailsId;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withModuleId(int moduleId) {
            this.moduleId = moduleId;
            return this;
        }

        public Builder withAssetControlFlowConfigDetails(List<AssetControlFlowConfigDetailsDTO> assetControlFlowConfigDetails) {
            this.assetControlFlowConfigDetails = assetControlFlowConfigDetails;
            return this;
        }

        public AssetFlowDetailsDTO build() {
            return new AssetFlowDetailsDTO(this);
        }
    }
}

