/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto;

import com.sapphireims.cmdb.dto.AssetItemtypeConfigurationDTO;
import com.sapphireims.cmdb.dto.AssetdetailsIdDTO;
import com.sapphireims.cmdb.dto.assetcopy.AssetTypeDTO;
import com.sapphireims.cmdb.model.Assetdetails;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.exception.DomainException;

public class AssetdetailsDTO
extends BaseDTO {
    private static final long serialVersionUID = -6134928099110685821L;
    private AssetdetailsIdDTO assetdetailsIdDTO;
    private int assetId;
    private int itemTypeId;
    private int itemDetailsId;
    private String assetValue;
    private int flowType;
    private int groupType;
    private AssetItemtypeConfigurationDTO assetItemtypeConfiguration;

    private AssetdetailsDTO(Builder builder) {
        this.updated = builder.updated;
        this.assetdetailsIdDTO = builder.assetdetailsIdDTO;
        this.assetId = builder.assetId;
        this.itemTypeId = builder.itemTypeId;
        this.itemDetailsId = builder.itemDetailsId;
        this.assetValue = builder.assetValue;
        this.flowType = builder.flowType;
        this.groupType = builder.groupType;
        this.assetItemtypeConfiguration = builder.assetItemtypeConfiguration;
    }

    public AssetdetailsDTO() {
    }

    public AssetdetailsDTO(AssetdetailsIdDTO assetdetailsIdDTO, int assetId, int itemTypeId, int itemDetailsId, String assetValue, int flowType, int groupType, AssetItemtypeConfigurationDTO assetItemtypeConfiguration) {
        this.assetdetailsIdDTO = assetdetailsIdDTO;
        this.assetId = assetId;
        this.itemTypeId = itemTypeId;
        this.itemDetailsId = itemDetailsId;
        this.assetValue = assetValue;
        this.flowType = flowType;
        this.groupType = groupType;
        this.assetItemtypeConfiguration = assetItemtypeConfiguration;
    }

    public AssetdetailsDTO(Assetdetails details, AssetTypeDTO assetType) throws DomainException {
        this.assetdetailsIdDTO = new AssetdetailsIdDTO(details);
        this.assetId = details.getAssetId();
        this.itemTypeId = details.getItemTypeId();
        this.itemDetailsId = details.getItemDetailsId();
        this.assetValue = details.getAssetValue();
        this.flowType = details.getFlowType();
        this.groupType = details.getGroupType();
        this.assetItemtypeConfiguration = assetType.getAssetItemtypeConfiguration(details.getItemDetailsId());
    }

    public AssetdetailsIdDTO getAssetdetailsIdDTO() {
        return this.assetdetailsIdDTO;
    }

    public void setAssetdetailsIdDTO(AssetdetailsIdDTO assetdetailsIdDTO) {
        this.assetdetailsIdDTO = assetdetailsIdDTO;
    }

    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public int getItemTypeId() {
        return this.itemTypeId;
    }

    public void setItemTypeId(int itemTypeId) {
        this.itemTypeId = itemTypeId;
    }

    public int getItemDetailsId() {
        return this.itemDetailsId;
    }

    public void setItemDetailsId(int itemDetailsId) {
        this.itemDetailsId = itemDetailsId;
    }

    public String getAssetValue() {
        return this.assetValue;
    }

    public void setAssetValue(String assetValue) {
        this.assetValue = assetValue;
    }

    public int getFlowType() {
        return this.flowType;
    }

    public void setFlowType(int flowType) {
        this.flowType = flowType;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public Integer getId() {
        return this.assetdetailsIdDTO.getAssetDetailsId();
    }

    public void setId(Integer id) {
        this.assetdetailsIdDTO.setAssetDetailsId(id);
    }

    public AssetItemtypeConfigurationDTO getAssetItemtypeConfiguration() {
        return this.assetItemtypeConfiguration;
    }

    public void setAssetItemtypeConfiguration(AssetItemtypeConfigurationDTO assetItemtypeConfiguration) {
        this.assetItemtypeConfiguration = assetItemtypeConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean updated;
        private AssetdetailsIdDTO assetdetailsIdDTO;
        private int assetId;
        private int itemTypeId;
        private int itemDetailsId;
        private String assetValue;
        private int flowType;
        private int groupType;
        private AssetItemtypeConfigurationDTO assetItemtypeConfiguration;

        private Builder() {
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withAssetdetailsIdDTO(AssetdetailsIdDTO assetdetailsIdDTO) {
            this.assetdetailsIdDTO = assetdetailsIdDTO;
            return this;
        }

        public Builder withAssetId(int assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder withItemTypeId(int itemTypeId) {
            this.itemTypeId = itemTypeId;
            return this;
        }

        public Builder withItemDetailsId(int itemDetailsId) {
            this.itemDetailsId = itemDetailsId;
            return this;
        }

        public Builder withAssetValue(String assetValue) {
            this.assetValue = assetValue;
            return this;
        }

        public Builder withFlowType(int flowType) {
            this.flowType = flowType;
            return this;
        }

        public Builder withGroupType(int groupType) {
            this.groupType = groupType;
            return this;
        }

        public Builder withAssetItemtypeConfiguration(AssetItemtypeConfigurationDTO assetItemtypeConfiguration) {
            this.assetItemtypeConfiguration = assetItemtypeConfiguration;
            return this;
        }

        public AssetdetailsDTO build() {
            return new AssetdetailsDTO(this);
        }
    }
}

