/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.sapphireims.cmdb.dto.AssetpurchaseIdDTO;
import com.sapphireims.cmdb.model.Assetpurchase;
import com.sapphireims.dto.BaseDTO;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssetpurchaseDTO
extends BaseDTO {
    private static final long serialVersionUID = 5783700327441088577L;
    private AssetpurchaseIdDTO assetpurchaseIdDTO;
    private Integer assetId;
    private String vendor;
    private String purchaseDate;
    private String ponumber;
    private String invoiceNumber;
    private String invoiceDate;
    private String grnnumber;
    private String grndate;

    private AssetpurchaseDTO(Builder builder) {
        this.updated = builder.updated;
        this.assetpurchaseIdDTO = builder.assetpurchaseIdDTO;
        this.assetId = builder.assetId;
        this.vendor = builder.vendor;
        this.purchaseDate = builder.purchaseDate;
        this.ponumber = builder.ponumber;
        this.invoiceNumber = builder.invoiceNumber;
        this.invoiceDate = builder.invoiceDate;
        this.grnnumber = builder.grnnumber;
        this.grndate = builder.grndate;
    }

    public AssetpurchaseDTO() {
    }

    public AssetpurchaseDTO(Assetpurchase assetpurchase) {
        this.assetpurchaseIdDTO = new AssetpurchaseIdDTO(assetpurchase);
        this.assetId = assetpurchase.getAssetmaster() != null ? assetpurchase.getAssetmaster().getAssetId() : null;
        this.vendor = assetpurchase.getVendor();
        this.purchaseDate = assetpurchase.getPurchaseDate();
        this.ponumber = assetpurchase.getPonumber();
        this.invoiceNumber = assetpurchase.getInvoiceNumber();
        this.invoiceDate = assetpurchase.getInvoiceDate();
        this.grnnumber = assetpurchase.getGrnnumber();
        this.grndate = assetpurchase.getGrndate();
    }

    public AssetpurchaseIdDTO getAssetpurchaseIdDTO() {
        return this.assetpurchaseIdDTO;
    }

    public void setAssetpurchaseIdDTO(AssetpurchaseIdDTO assetpurchaseIdDTO) {
        this.assetpurchaseIdDTO = assetpurchaseIdDTO;
    }

    public Integer getAssetId() {
        return this.assetId;
    }

    public void setAssetId(Integer assetId) {
        this.assetId = assetId;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setPurchaseDate(String purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public String getPonumber() {
        return this.ponumber;
    }

    public void setPonumber(String ponumber) {
        this.ponumber = ponumber;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getGrnnumber() {
        return this.grnnumber;
    }

    public void setGrnnumber(String grnnumber) {
        this.grnnumber = grnnumber;
    }

    public String getGrndate() {
        return this.grndate;
    }

    public void setGrndate(String grndate) {
        this.grndate = grndate;
    }

    @JsonIgnore
    public Integer getId() {
        return this.assetpurchaseIdDTO.getDetailsId();
    }

    @JsonIgnore
    public void setId(Integer id) {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean updated;
        private AssetpurchaseIdDTO assetpurchaseIdDTO;
        private Integer assetId;
        private String vendor;
        private String purchaseDate;
        private String ponumber;
        private String invoiceNumber;
        private String invoiceDate;
        private String grnnumber;
        private String grndate;

        private Builder() {
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withAssetpurchaseIdDTO(AssetpurchaseIdDTO assetpurchaseIdDTO) {
            this.assetpurchaseIdDTO = assetpurchaseIdDTO;
            return this;
        }

        public Builder withAssetId(Integer assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder withVendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder withPurchaseDate(String purchaseDate) {
            this.purchaseDate = purchaseDate;
            return this;
        }

        public Builder withPonumber(String ponumber) {
            this.ponumber = ponumber;
            return this;
        }

        public Builder withInvoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            return this;
        }

        public Builder withInvoiceDate(String invoiceDate) {
            this.invoiceDate = invoiceDate;
            return this;
        }

        public Builder withGrnnumber(String grnnumber) {
            this.grnnumber = grnnumber;
            return this;
        }

        public Builder withGrndate(String grndate) {
            this.grndate = grndate;
            return this;
        }

        public AssetpurchaseDTO build() {
            return new AssetpurchaseDTO(this);
        }
    }
}

