/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sapphireims.cmdb.dto.AssetModuleExportDTO;
import com.sapphireims.cmdb.model.GenericNotificationConfigMaster;
import com.sapphireims.dto.BaseDTO;

public class GenericNotificationConfigMasterDTO
extends BaseDTO {
    private static final long serialVersionUID = 4995700746751541969L;
    private Integer genericNotifyId;
    private String genericNotificationProfile;
    private Integer type;
    private Integer isBuiltIn;
    private String query;
    private int moduleId;

    public GenericNotificationConfigMasterDTO() {
    }

    public GenericNotificationConfigMasterDTO(String genericNotificationProfile, Integer type, Integer isBuiltIn, String query) {
        this.genericNotificationProfile = genericNotificationProfile;
        this.type = type;
        this.isBuiltIn = isBuiltIn;
        this.query = query;
    }

    public GenericNotificationConfigMasterDTO(GenericNotificationConfigMaster gncm, Integer moduleId) {
        this.genericNotifyId = gncm.getGenericNotifyId();
        this.genericNotificationProfile = gncm.getGenericNotificationProfile();
        this.type = gncm.getType();
        this.isBuiltIn = gncm.getIsBuiltIn();
        this.query = gncm.getQuery();
        this.moduleId = moduleId;
    }

    @JsonIgnore
    public GenericNotificationConfigMaster getModelObject(AssetModuleExportDTO moduleDTO) {
        GenericNotificationConfigMaster gncm = new GenericNotificationConfigMaster(this.genericNotificationProfile, this.type, this.isBuiltIn, this.query);
        String query = gncm.getQuery();
        Object profile = gncm.getGenericNotificationProfile();
        if (((String)profile).contains("Life Cycle Management")) {
            profile = moduleDTO.getAssetModuleMaster().getModuleName() + " Life Cycle Management";
            query = query.replace("moduleid=" + this.moduleId, "moduleid=" + moduleDTO.getAssetModuleMaster().getModuleId());
        } else {
            profile = moduleDTO.getAssetModuleMaster().getModuleName() + " Management";
            query = query.replace("am.AssetModule_ID = " + this.moduleId, "am.AssetModule_ID = " + moduleDTO.getAssetModuleMaster().getModuleId());
        }
        gncm.setQuery(query);
        gncm.setGenericNotificationProfile((String)profile);
        return gncm;
    }

    public Integer getGenericNotifyId() {
        return this.genericNotifyId;
    }

    public void setGenericNotifyId(Integer genericNotifyId) {
        this.genericNotifyId = genericNotifyId;
    }

    public String getGenericNotificationProfile() {
        return this.genericNotificationProfile;
    }

    public void setGenericNotificationProfile(String genericNotificationProfile) {
        this.genericNotificationProfile = genericNotificationProfile;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getIsBuiltIn() {
        return this.isBuiltIn;
    }

    public void setIsBuiltIn(Integer isBuiltIn) {
        this.isBuiltIn = isBuiltIn;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Integer getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Integer moduleId) {
        this.moduleId = moduleId;
    }

    public Integer getId() {
        return this.getGenericNotifyId();
    }

    public void setId(Integer id) {
        this.setGenericNotifyId(id);
    }
}

