/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto.asset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import com.sapphireims.cmdb.dto.AssetItemtypeConfigurationDTO;
import com.sapphireims.cmdb.dto.asset.AssetGridData;
import com.sapphireims.dto.BaseDTO;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssetAttribute
extends BaseDTO {
    private static final long serialVersionUID = 8667575927902003367L;
    private Integer itemDetailsId;
    private AssetItemtypeConfigurationDTO assetItemtypeConfiguration;
    private String data;
    private AssetGridData assetGrid;
    private String fieldDisplayName;

    private AssetAttribute(Builder builder) {
        this.id = builder.id;
        this.updated = builder.updated;
        this.tenanatId = builder.tenanatId;
        this.history = builder.history;
        this.itemDetailsId = builder.itemDetailsId;
        this.assetItemtypeConfiguration = builder.assetItemtypeConfiguration;
        this.data = builder.data;
        this.assetGrid = builder.assetGrid;
        this.fieldDisplayName = builder.fieldDisplayName;
    }

    public AssetAttribute() {
    }

    public AssetAttribute(Integer id) {
        super(id);
    }

    public AssetAttribute(Integer itemDetailsId, AssetItemtypeConfigurationDTO assetItemtypeConfiguration, String data, AssetGridData assetGrid) {
        this.itemDetailsId = itemDetailsId;
        this.assetItemtypeConfiguration = assetItemtypeConfiguration;
        this.data = data;
        this.assetGrid = assetGrid;
        this.fieldDisplayName = assetItemtypeConfiguration != null ? assetItemtypeConfiguration.getParameterName() : "";
    }

    public void addRow() {
        if (this.assetGrid == null) {
            this.assetGrid = new AssetGridData();
        }
        this.assetGrid.addRow();
    }

    public void addGridData(Integer fieldId, AssetAttribute data) {
        if (this.assetGrid == null) {
            this.assetGrid = new AssetGridData();
        }
        this.assetGrid.addGridData(fieldId, data);
    }

    public Integer getItemDetailsId() {
        return this.itemDetailsId;
    }

    public void setItemDetailsId(Integer itemDetailsId) {
        this.itemDetailsId = itemDetailsId;
    }

    @JsonIgnore
    public AssetItemtypeConfigurationDTO getAssetItemtypeConfiguration() {
        return this.assetItemtypeConfiguration;
    }

    public void setAssetItemtypeConfiguration(AssetItemtypeConfigurationDTO assetItemtypeConfiguration) {
        this.assetItemtypeConfiguration = assetItemtypeConfiguration;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public AssetGridData getAssetGrid() {
        return this.assetGrid;
    }

    public void setAssetGrid(AssetGridData assetGrid) {
        this.assetGrid = assetGrid;
    }

    public void addFirstColumnFieldId(int firstColumnFieldId) {
        if (this.assetGrid == null) {
            this.assetGrid = new AssetGridData();
        }
        this.assetGrid.setFirstColumnFieldId(firstColumnFieldId);
    }

    public String getFieldDisplayName() {
        return this.fieldDisplayName;
    }

    public void setFieldDisplayName(String fieldDisplayName) {
        this.fieldDisplayName = fieldDisplayName;
    }

    public Integer getId() {
        return null;
    }

    public void setId(Integer id) {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("super", (Object)super.toString()).add("serialVersionUID", 8667575927902003367L).add("itemDetailsId", (Object)this.itemDetailsId).add("assetItemtypeConfiguration", (Object)this.assetItemtypeConfiguration).add("data", (Object)this.data).add("assetGrid", (Object)this.assetGrid).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.itemDetailsId, this.assetItemtypeConfiguration, this.data, this.assetGrid});
    }

    public boolean equals(Object object) {
        if (object instanceof AssetAttribute) {
            if (!super.equals(object)) {
                return false;
            }
            AssetAttribute that = (AssetAttribute)((Object)object);
            return Objects.equals(this.itemDetailsId, that.itemDetailsId) && Objects.equals((Object)this.assetItemtypeConfiguration, (Object)that.assetItemtypeConfiguration) && Objects.equals(this.data, that.data) && Objects.equals(this.assetGrid, that.assetGrid);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer id;
        private boolean updated;
        private String tenanatId;
        private Object history;
        private Integer itemDetailsId;
        private AssetItemtypeConfigurationDTO assetItemtypeConfiguration;
        private String data;
        private AssetGridData assetGrid;
        private String fieldDisplayName;

        private Builder() {
        }

        public Builder withId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withTenanatId(String tenanatId) {
            this.tenanatId = tenanatId;
            return this;
        }

        public Builder withHistory(Object history) {
            this.history = history;
            return this;
        }

        public Builder withItemDetailsId(Integer itemDetailsId) {
            this.itemDetailsId = itemDetailsId;
            return this;
        }

        public Builder withAssetItemtypeConfiguration(AssetItemtypeConfigurationDTO assetItemtypeConfiguration) {
            this.assetItemtypeConfiguration = assetItemtypeConfiguration;
            return this;
        }

        public Builder withData(String data) {
            this.data = data;
            return this;
        }

        public Builder withAssetGrid(AssetGridData assetGrid) {
            this.assetGrid = assetGrid;
            return this;
        }

        public Builder withFieldDisplayName(String fieldDisplayName) {
            this.fieldDisplayName = fieldDisplayName;
            return this;
        }

        public AssetAttribute build() {
            return new AssetAttribute(this);
        }
    }
}

