/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto.asset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.sapphireims.cmdb.dto.asset.AssetAttribute;
import com.sapphireims.cmdb.dto.asset.AssetGridRow;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssetGridData
implements Serializable {
    private static final long serialVersionUID = 3275613274754812602L;
    @JsonIgnore
    private Table<Integer, Integer, AssetAttribute> gridData;
    private int noOfRow = 0;
    private int firstColumnFieldId;
    private List<AssetGridRow> rows;

    private AssetGridData(Builder builder) {
        this.gridData = builder.gridData;
        this.noOfRow = builder.noOfRow;
        this.firstColumnFieldId = builder.firstColumnFieldId;
        this.rows = builder.rows;
    }

    public AssetGridData() {
    }

    public AssetGridData(Table<Integer, Integer, AssetAttribute> gridData, int noOfRow, int firstColumnFieldId, List<AssetGridRow> rows) {
        this.gridData = gridData;
        this.noOfRow = noOfRow;
        this.firstColumnFieldId = firstColumnFieldId;
        this.rows = rows;
    }

    public Table<Integer, Integer, AssetAttribute> getGridData() {
        return this.gridData;
    }

    public void setGridData(Table<Integer, Integer, AssetAttribute> gridData) {
        this.gridData = gridData;
    }

    public int getNoOfRow() {
        return this.noOfRow;
    }

    public void setNoOfRow(int noOfRow) {
        this.noOfRow = noOfRow;
    }

    public int getFirstColumnFieldId() {
        return this.firstColumnFieldId;
    }

    public void setFirstColumnFieldId(int firstColumnFieldId) {
        this.firstColumnFieldId = firstColumnFieldId;
    }

    public List<AssetGridRow> getRows() {
        return this.rows;
    }

    public void setRows(List<AssetGridRow> rows) {
        this.rows = rows;
    }

    public static long getSerialversionuid() {
        return 3275613274754812602L;
    }

    public void addRow() {
        ++this.noOfRow;
    }

    public void addGridData(Integer fieldId, AssetAttribute data) {
        if (this.gridData == null) {
            this.gridData = HashBasedTable.create();
        }
        this.gridData.put((Object)this.getNoOfRow(), (Object)fieldId, (Object)data);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Table<Integer, Integer, AssetAttribute> gridData;
        private int noOfRow;
        private int firstColumnFieldId;
        private List<AssetGridRow> rows = Collections.emptyList();

        private Builder() {
        }

        public Builder withGridData(Table<Integer, Integer, AssetAttribute> gridData) {
            this.gridData = gridData;
            return this;
        }

        public Builder withNoOfRow(int noOfRow) {
            this.noOfRow = noOfRow;
            return this;
        }

        public Builder withFirstColumnFieldId(int firstColumnFieldId) {
            this.firstColumnFieldId = firstColumnFieldId;
            return this;
        }

        public Builder withRows(List<AssetGridRow> rows) {
            this.rows = rows;
            return this;
        }

        public AssetGridData build() {
            return new AssetGridData(this);
        }
    }
}

