/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto.asset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.sapphireims.cmdb.dto.asset.AssetGridRow;
import com.sapphireims.cmdb.dto.asset.AssetStatusAttribute;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class AssetStatusGridData
implements Serializable {
    private static final long serialVersionUID = 3275613274754812602L;
    @JsonIgnore
    private Table<Integer, Integer, AssetStatusAttribute> gridData;
    private int noOfRow = 0;
    private int firstColumnFieldId;
    private List<AssetGridRow> rows;

    private AssetStatusGridData(Builder builder) {
        this.gridData = builder.gridData;
        this.noOfRow = builder.noOfRow;
        this.firstColumnFieldId = builder.firstColumnFieldId;
        this.rows = builder.rows;
    }

    public AssetStatusGridData(Table<Integer, Integer, AssetStatusAttribute> gridData, int noOfRow, int firstColumnFieldId, List<AssetGridRow> rows) {
        this.gridData = gridData;
        this.noOfRow = noOfRow;
        this.firstColumnFieldId = firstColumnFieldId;
        this.rows = rows;
    }

    public AssetStatusGridData() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Table<Integer, Integer, AssetStatusAttribute> getGridData() {
        return this.gridData;
    }

    public void setGridData(Table<Integer, Integer, AssetStatusAttribute> gridData) {
        this.gridData = gridData;
    }

    public int getNoOfRow() {
        return this.noOfRow;
    }

    public void setNoOfRow(int noOfRow) {
        this.noOfRow = noOfRow;
    }

    public int getFirstColumnFieldId() {
        return this.firstColumnFieldId;
    }

    public void setFirstColumnFieldId(int firstColumnFieldId) {
        this.firstColumnFieldId = firstColumnFieldId;
    }

    public List<AssetGridRow> getRows() {
        return this.rows;
    }

    public void setRows(List<AssetGridRow> rows) {
        this.rows = rows;
    }

    public void addRow() {
        ++this.noOfRow;
    }

    public void addGridData(Integer fieldId, AssetStatusAttribute data) {
        if (this.gridData == null) {
            this.gridData = HashBasedTable.create();
        }
        this.gridData.put((Object)this.getNoOfRow(), (Object)fieldId, (Object)data);
    }

    public static final class Builder {
        private Table<Integer, Integer, AssetStatusAttribute> gridData;
        private int noOfRow;
        private int firstColumnFieldId;
        private List<AssetGridRow> rows = Collections.emptyList();

        private Builder() {
        }

        public Builder withGridData(Table<Integer, Integer, AssetStatusAttribute> gridData) {
            this.gridData = gridData;
            return this;
        }

        public Builder withNoOfRow(int noOfRow) {
            this.noOfRow = noOfRow;
            return this;
        }

        public Builder withFirstColumnFieldId(int firstColumnFieldId) {
            this.firstColumnFieldId = firstColumnFieldId;
            return this;
        }

        public Builder withRows(List<AssetGridRow> rows) {
            this.rows = rows;
            return this;
        }

        public AssetStatusGridData build() {
            return new AssetStatusGridData(this);
        }
    }
}

