/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.dto.assetcopy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sapphire.itsm.mailrouting.dao.IMacromasterDAO;
import com.sapphire.itsm.mailrouting.dto.MacromasterDTO;
import com.sapphire.itsm.mailrouting.model.AssetModuleMaster;
import com.sapphire.itsm.mailrouting.model.AssetitemtypeConfiguration;
import com.sapphire.itsm.mailrouting.model.AssetitemtypeMaster;
import com.sapphire.itsm.mailrouting.model.Macromaster;
import com.sapphireims.cmdb.dto.AssetControlFlowConfigDetailsDTO;
import com.sapphireims.cmdb.dto.AssetControlFlowConfigMasterDTO;
import com.sapphireims.cmdb.dto.AssetDepreciationDTO;
import com.sapphireims.cmdb.dto.AssetFlowDetailsDTO;
import com.sapphireims.cmdb.dto.AssetFlowDetailsIdDTO;
import com.sapphireims.cmdb.dto.AssetItemtypeConfigurationDTO;
import com.sapphireims.cmdb.dto.AssetItemtypeMasterDTO;
import com.sapphireims.cmdb.dto.AssetModuleExportDTO;
import com.sapphireims.cmdb.dto.AssetModuleMasterDTO;
import com.sapphireims.cmdb.dto.AssetNotificationRuleDetailsDTO;
import com.sapphireims.cmdb.dto.AssetNotificationRuleMasterDTO;
import com.sapphireims.cmdb.dto.AssetNotificationTemplateDetailsDTO;
import com.sapphireims.cmdb.dto.AssetNotificationTemplateMasterDTO;
import com.sapphireims.cmdb.dto.AssetPrepostActionsDTO;
import com.sapphireims.cmdb.dto.AssetRequestNumberFormatDTO;
import com.sapphireims.cmdb.dto.AssetcomponentfixedfieldsMappingDTO;
import com.sapphireims.cmdb.dto.AssetcontrolflowconfigAdditionalparamsDTO;
import com.sapphireims.cmdb.dto.AssetfieldsTemplatemasterDTO;
import com.sapphireims.cmdb.dto.AssetgenerationdetailsDTO;
import com.sapphireims.cmdb.dto.AssetgenerationmasterDTO;
import com.sapphireims.cmdb.dto.AssetmanagementFixedfieldsDTO;
import com.sapphireims.cmdb.dto.AssetrolesDTO;
import com.sapphireims.cmdb.dto.BarcodeConfigurationDTO;
import com.sapphireims.cmdb.dto.BarcodeConfigurationDetailsDTO;
import com.sapphireims.cmdb.dto.CiRelationshipMasterDTO;
import com.sapphireims.cmdb.dto.GenericNotificationConfigDetailsDTO;
import com.sapphireims.cmdb.dto.GenericNotificationConfigMasterDTO;
import com.sapphireims.cmdb.dto.MiscDetailsDTO;
import com.sapphireims.cmdb.dto.PrenotificationRuledetailsDTO;
import com.sapphireims.cmdb.dto.UserAcceptanceConfigDTO;
import com.sapphireims.cmdb.dto.assetcopy.AssetTypeDTO;
import com.sapphireims.cmdb.model.AssetControlFlowConfigDetails;
import com.sapphireims.cmdb.model.AssetDepreciation;
import com.sapphireims.cmdb.model.AssetNotificationRuleDetails;
import com.sapphireims.cmdb.model.AssetNotificationRuleMaster;
import com.sapphireims.cmdb.model.AssetNotificationTemplateDetails;
import com.sapphireims.cmdb.model.AssetNotificationTemplateMaster;
import com.sapphireims.cmdb.model.AssetPrepostActions;
import com.sapphireims.cmdb.model.AssetRequestNumberFormat;
import com.sapphireims.cmdb.model.AssetTemplateAttachmentdetails;
import com.sapphireims.cmdb.model.AssetcomponentfixedfieldsMapping;
import com.sapphireims.cmdb.model.AssetconfigaccessDetails;
import com.sapphireims.cmdb.model.AssetcontrolflowconfigAdditionalparams;
import com.sapphireims.cmdb.model.AssetcontrolflowconfigMaster;
import com.sapphireims.cmdb.model.AssetfieldsTemplatedetails;
import com.sapphireims.cmdb.model.AssetfieldsTemplatemaster;
import com.sapphireims.cmdb.model.Assetflowdetails;
import com.sapphireims.cmdb.model.Assetgenerationdetails;
import com.sapphireims.cmdb.model.Assetgenerationmaster;
import com.sapphireims.cmdb.model.AssetmanagementFixedfields;
import com.sapphireims.cmdb.model.Assetroles;
import com.sapphireims.cmdb.model.AssetrolesPrivilege;
import com.sapphireims.cmdb.model.BarcodeConfiguration;
import com.sapphireims.cmdb.model.CiRelationshipMaster;
import com.sapphireims.cmdb.model.GenericNotificationConfigMaster;
import com.sapphireims.cmdb.model.MiscDetails;
import com.sapphireims.cmdb.model.PrenotificationRuledetails;
import com.sapphireims.cmdb.model.UserAcceptanceConfig;
import com.sapphireims.cmdb.model.enummodel.ModuleType;
import com.sapphireims.dto.BaseDTO;
import com.sapphireims.dto.rpa.RpaEventDTO;
import com.sapphireims.dto.rpa.RpaProcessDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.ims.model.GenericNotificationConfigDetails;
import com.sapphireims.itsm.dto.SdTemplateDTO;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssetModuleDTO
extends BaseDTO {
    private static final long serialVersionUID = 2588879708201125826L;
    private Integer moduleId;
    private String moduleName;
    private ModuleType moduleType;
    private String description;
    private int displayOrder;
    private int isVisible;
    @JsonProperty(value="assetModuleMaster")
    private AssetModuleMasterDTO assetModuleMaster;
    @JsonProperty(value="status")
    private List<AssetFlowDetailsDTO> assetFlowDetails;
    @JsonProperty(value="roles")
    private List<AssetrolesDTO> assetRoles;
    @JsonProperty(value="itemTypes")
    private List<AssetItemtypeMasterDTO> itemTypes;
    @JsonProperty(value="preshippedFixedFields")
    private List<AssetcomponentfixedfieldsMappingDTO> preshippedFixedFields;
    @JsonProperty(value="additionalFields")
    private List<AssetItemtypeConfigurationDTO> additionalFields;
    @JsonProperty(value="assetmanagementFixedfields")
    private List<AssetmanagementFixedfieldsDTO> assetmanagementFixedfields;
    @JsonProperty(value="lifeCycleFields")
    private List<AssetControlFlowConfigMasterDTO> assetControlFlowConfigDetails;
    @JsonProperty(value="assetGenerationDetails")
    private List<AssetgenerationmasterDTO> assetGenerationDetails;
    @JsonProperty(value="assetRequestNumberFormat")
    private List<AssetRequestNumberFormatDTO> assetRequestNumberFormatDetails;
    @JsonProperty(value="miscDetails")
    private List<MiscDetailsDTO> assetMiscDetails;
    @JsonProperty(value="assetFieldsTemplateMaster")
    private List<AssetfieldsTemplatemasterDTO> assetFieldsTemplateMaster;
    @JsonProperty(value="assetNotificationTemplateDetails")
    private List<AssetNotificationTemplateMasterDTO> assetNotificationTemplateDetails;
    @JsonProperty(value="assetNotificatonRuleDetails")
    private List<AssetNotificationRuleMasterDTO> assetNotificatonRuleDetails;
    @JsonProperty(value="assetGenericNotificationConfigMaster")
    private List<GenericNotificationConfigMasterDTO> assetGenericNotificationConfigMaster;
    @JsonProperty(value="assetGenericNotificationCOnfigDetails")
    private List<GenericNotificationConfigDetailsDTO> assetGenericNotificationCOnfigDetails;
    @JsonProperty(value="prenotificationRuledetails")
    private List<PrenotificationRuledetailsDTO> prenotificationRuledetails;
    @JsonProperty(value="assetBarcodeConfigDetails")
    private List<BarcodeConfigurationDTO> assetBarcodeConfigDetails;
    @JsonProperty(value="ciRelationshipMaster")
    private List<CiRelationshipMasterDTO> assetCiRelationshipDetails;
    @JsonProperty(value="assetDepreciation")
    private List<AssetDepreciationDTO> assetDepreciation;
    @JsonProperty(value="userAcceptanceConfig")
    private List<UserAcceptanceConfigDTO> assetUserAcceptanceDetails;
    @JsonProperty
    private List<AssetPrepostActionsDTO> assetPrepostActions;
    @JsonProperty
    private List<AssetTypeDTO> assetTypeDTO;
    @JsonProperty(value="rpaProcess")
    private List<RpaProcessDTO> rpaProcess;
    @JsonProperty(value="rpaEvents")
    private List<RpaEventDTO> rpaEvents;
    @JsonProperty(value="templates")
    private List<SdTemplateDTO> templates;

    private AssetModuleDTO(Builder builder) {
        this.updated = builder.updated;
        this.moduleId = builder.moduleId;
        this.moduleName = builder.moduleName;
        this.moduleType = builder.moduleType;
        this.description = builder.description;
        this.displayOrder = builder.displayOrder;
        this.isVisible = builder.isVisible;
        this.assetModuleMaster = builder.assetModuleMaster;
        this.assetFlowDetails = builder.assetFlowDetails;
        this.assetRoles = builder.assetRoles;
        this.assetControlFlowConfigDetails = builder.assetControlFlowConfigDetails;
        this.assetGenerationDetails = builder.assetGenerationDetails;
        this.assetRequestNumberFormatDetails = builder.assetRequestNumberFormatDetails;
        this.assetMiscDetails = builder.assetMiscDetails;
        this.assetFieldsTemplateMaster = builder.assetFieldsTemplateMaster;
        this.assetNotificationTemplateDetails = builder.assetNotificationTemplateDetails;
        this.assetNotificatonRuleDetails = builder.assetNotificatonRuleDetails;
        this.assetGenericNotificationCOnfigDetails = builder.assetGenericNotificationCOnfigDetails;
        this.assetBarcodeConfigDetails = builder.assetBarcodeConfigDetails;
        this.assetCiRelationshipDetails = builder.assetCiRelationshipDetails;
        this.assetUserAcceptanceDetails = builder.assetUserAcceptanceDetails;
        this.assetPrepostActions = builder.assetPrepostActions;
        this.assetTypeDTO = builder.assetTypeDTO;
        this.rpaProcess = builder.rpaProcess;
        this.rpaEvents = builder.rpaEvents;
        this.templates = builder.templates;
    }

    public AssetModuleDTO() {
    }

    public AssetModuleDTO(Integer moduleId, String moduleName) {
        this.moduleId = moduleId;
        this.moduleName = moduleName;
    }

    @JsonIgnore
    public List<AssetcontrolflowconfigAdditionalparamsDTO> getAdditionalParmsForStatus(Integer statusId) throws DomainException {
        Map<Integer, AssetcontrolflowconfigAdditionalparamsDTO> additionaParms = CollectionUtil.getAssetcontrolflowconfigAdditionalparams(this.assetControlFlowConfigDetails);
        if (CollectionUtil.isNotEmpty(this.assetFlowDetails)) {
            ArrayList<AssetcontrolflowconfigAdditionalparamsDTO> additionalParms = new ArrayList<AssetcontrolflowconfigAdditionalparamsDTO>();
            AssetFlowDetailsDTO matchedFlow = null;
            for (AssetFlowDetailsDTO f : this.assetFlowDetails) {
                if (f.getAssetFlowDetailsId().getFlowDetailsId() != statusId.intValue()) continue;
                matchedFlow = f;
                break;
            }
            Validate.notNull(matchedFlow, (String)" Ivalid stataus id {} ", (Object[])new Object[]{statusId});
            List<AssetControlFlowConfigDetailsDTO> configs = matchedFlow.getAssetControlFlowConfigDetails();
            if (CollectionUtil.isNotEmpty(configs)) {
                for (AssetControlFlowConfigDetailsDTO c : configs) {
                    if (c.getControlFlowCategoryId() != 2) continue;
                    additionalParms.add(additionaParms.get(c.getControlFlowCategoryValue()));
                }
            }
            return additionalParms;
        }
        return null;
    }

    public Integer getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Integer moduleId) {
        this.moduleId = moduleId;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public int getIsVisible() {
        return this.isVisible;
    }

    public void setIsVisible(int isVisible) {
        this.isVisible = isVisible;
    }

    public AssetModuleMasterDTO getAssetModuleMaster() {
        return this.assetModuleMaster;
    }

    public void setAssetModuleMaster(AssetModuleMasterDTO assetModuleMaster) {
        this.assetModuleMaster = assetModuleMaster;
        this.moduleName = assetModuleMaster.getModuleName();
        this.moduleId = assetModuleMaster.getModuleId();
        this.isVisible = assetModuleMaster.getIsVisible();
        this.description = assetModuleMaster.getDescription();
        this.displayOrder = assetModuleMaster.getDisplayOrder();
    }

    public List<AssetFlowDetailsDTO> getAssetFlowDetails() {
        return this.assetFlowDetails;
    }

    public void setAssetFlowDetails(List<AssetFlowDetailsDTO> assetFlowDetails) {
        this.assetFlowDetails = assetFlowDetails;
    }

    public List<AssetrolesDTO> getAssetRoles() {
        return this.assetRoles;
    }

    public void setAssetRoles(List<AssetrolesDTO> assetRoles) {
        this.assetRoles = assetRoles;
    }

    public List<AssetItemtypeMasterDTO> getItemTypes() {
        return this.itemTypes;
    }

    public void setItemTypes(List<AssetItemtypeMasterDTO> itemTypes) {
        this.itemTypes = itemTypes;
    }

    public List<AssetControlFlowConfigMasterDTO> getAssetControlFlowConfigDetails() {
        return this.assetControlFlowConfigDetails;
    }

    public void setAssetControlFlowConfigDetails(List<AssetControlFlowConfigMasterDTO> assetControlFlowConfigDetails) {
        this.assetControlFlowConfigDetails = assetControlFlowConfigDetails;
    }

    public List<AssetgenerationmasterDTO> getAssetGenerationDetails() {
        return this.assetGenerationDetails;
    }

    public void setAssetGenerationDetails(List<AssetgenerationmasterDTO> assetGenerationDetails) {
        this.assetGenerationDetails = assetGenerationDetails;
    }

    public List<AssetRequestNumberFormatDTO> getAssetRequestNumberFormatDetails() {
        return this.assetRequestNumberFormatDetails;
    }

    public void setAssetRequestNumberFormatDetails(List<AssetRequestNumberFormatDTO> assetRequestNumberFormatDetails) {
        this.assetRequestNumberFormatDetails = assetRequestNumberFormatDetails;
    }

    public List<MiscDetailsDTO> getAssetMiscDetails() {
        return this.assetMiscDetails;
    }

    public void setAssetMiscDetails(List<MiscDetailsDTO> assetMiscDetails) {
        this.assetMiscDetails = assetMiscDetails;
    }

    public List<AssetfieldsTemplatemasterDTO> getAssetFieldsTemplateMaster() {
        return this.assetFieldsTemplateMaster;
    }

    public void setAssetFieldsTemplateMaster(List<AssetfieldsTemplatemasterDTO> assetFieldsTemplateMaster) {
        this.assetFieldsTemplateMaster = assetFieldsTemplateMaster;
    }

    public List<AssetNotificationTemplateMasterDTO> getAssetNotificationTemplateDetails() {
        return this.assetNotificationTemplateDetails;
    }

    public void setAssetNotificationTemplateDetails(List<AssetNotificationTemplateMasterDTO> assetNotificationTemplateDetails) {
        this.assetNotificationTemplateDetails = assetNotificationTemplateDetails;
    }

    public List<AssetNotificationRuleMasterDTO> getAssetNotificatonRuleDetails() {
        return this.assetNotificatonRuleDetails;
    }

    public void setAssetNotificatonRuleDetails(List<AssetNotificationRuleMasterDTO> assetNotificatonRuleDetails) {
        this.assetNotificatonRuleDetails = assetNotificatonRuleDetails;
    }

    public List<GenericNotificationConfigDetailsDTO> getAssetGenericNotificationCOnfigDetails() {
        return this.assetGenericNotificationCOnfigDetails;
    }

    public void setAssetGenericNotificationCOnfigDetails(List<GenericNotificationConfigDetailsDTO> assetGenericNotificationCOnfigDetails) {
        this.assetGenericNotificationCOnfigDetails = assetGenericNotificationCOnfigDetails;
    }

    public List<GenericNotificationConfigMasterDTO> getAssetGenericNotificationConfigMaster() {
        return this.assetGenericNotificationConfigMaster;
    }

    public void setAssetGenericNotificationConfigMaster(List<GenericNotificationConfigMasterDTO> assetGenericNotificationConfigMaster) {
        this.assetGenericNotificationConfigMaster = assetGenericNotificationConfigMaster;
    }

    public List<BarcodeConfigurationDTO> getAssetBarcodeConfigDetails() {
        return this.assetBarcodeConfigDetails;
    }

    public void setAssetBarcodeConfigDetails(List<BarcodeConfigurationDTO> assetBarcodeConfigDetails) {
        this.assetBarcodeConfigDetails = assetBarcodeConfigDetails;
    }

    public List<CiRelationshipMasterDTO> getAssetCiRelationshipDetails() {
        return this.assetCiRelationshipDetails;
    }

    public void setAssetCiRelationshipDetails(List<CiRelationshipMasterDTO> assetCiRelationshipDetails) {
        this.assetCiRelationshipDetails = assetCiRelationshipDetails;
    }

    public List<UserAcceptanceConfigDTO> getAssetUserAcceptanceDetails() {
        return this.assetUserAcceptanceDetails;
    }

    public void setAssetUserAcceptanceDetails(List<UserAcceptanceConfigDTO> assetUserAcceptanceDetails) {
        this.assetUserAcceptanceDetails = assetUserAcceptanceDetails;
    }

    public List<AssetDepreciationDTO> getAssetDepreciation() {
        return this.assetDepreciation;
    }

    public void setAssetDepreciation(List<AssetDepreciationDTO> assetDepreciation) {
        this.assetDepreciation = assetDepreciation;
    }

    public List<AssetcomponentfixedfieldsMappingDTO> getPreshippedFixedFields() {
        return this.preshippedFixedFields;
    }

    public void setPreshippedFixedFields(List<AssetcomponentfixedfieldsMappingDTO> preshippedFixedFields) {
        this.preshippedFixedFields = preshippedFixedFields;
    }

    public List<PrenotificationRuledetailsDTO> getPrenotificationRuledetails() {
        return this.prenotificationRuledetails;
    }

    public void setPrenotificationRuledetails(List<PrenotificationRuledetailsDTO> prenotificationRuledetails) {
        this.prenotificationRuledetails = prenotificationRuledetails;
    }

    public Integer getId() {
        return this.getModuleId();
    }

    public void setId(Integer id) {
        this.setModuleId(id);
    }

    public List<AssetTypeDTO> getAssetTypeDTO() {
        return this.assetTypeDTO;
    }

    @JsonIgnore
    public AssetTypeDTO getAssetType(Integer assetTypeId) {
        if (CollectionUtil.isNotEmpty(this.getAssetTypeDTO())) {
            for (AssetTypeDTO a : this.getAssetTypeDTO()) {
                if (a.getItemTypeId() != assetTypeId.intValue()) continue;
                return a;
            }
        }
        return null;
    }

    public void setAssetTypeDTO(List<AssetTypeDTO> assetTypeDTO) {
        this.assetTypeDTO = assetTypeDTO;
    }

    public List<AssetPrepostActionsDTO> getAssetPrepostActions() {
        return this.assetPrepostActions;
    }

    public void setAssetPrepostActions(List<AssetPrepostActionsDTO> assetPrepostActions) {
        this.assetPrepostActions = assetPrepostActions;
    }

    public List<AssetmanagementFixedfieldsDTO> getAssetmanagementFixedfields() {
        return this.assetmanagementFixedfields;
    }

    public void setAssetmanagementFixedfields(List<AssetmanagementFixedfieldsDTO> assetmanagementFixedfields) {
        this.assetmanagementFixedfields = assetmanagementFixedfields;
    }

    public List<AssetItemtypeConfigurationDTO> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(List<AssetItemtypeConfigurationDTO> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public String toString() {
        return "AssetModuleDTO [moduleId=" + this.moduleId + ", moduleName=" + this.moduleName + ", moduleType=" + String.valueOf((Object)this.moduleType) + "AssetModuleMaster" + String.valueOf((Object)this.assetModuleMaster) + ", description=" + this.description + ", displayOrder=" + this.displayOrder + ", isVisible=" + this.isVisible + "itemTypes " + String.valueOf(this.itemTypes) + ", assetFlowDetails=" + String.valueOf(this.assetFlowDetails) + ", assetRoles=" + String.valueOf(this.assetRoles) + ", assetControlFlowConfigDetails=" + String.valueOf(this.assetControlFlowConfigDetails) + ", assetGenerationDetails=" + String.valueOf(this.assetGenerationDetails) + ", assetRequestNumberFormatDetails=" + String.valueOf(this.assetRequestNumberFormatDetails) + ", assetMiscDetails=" + String.valueOf(this.assetMiscDetails) + ", assetFieldsTemplateMaster=" + String.valueOf(this.assetFieldsTemplateMaster) + ", assetNotificationTemplateDetails=" + String.valueOf(this.assetNotificationTemplateDetails) + ", assetNotificatonRuleDetails=" + String.valueOf(this.assetNotificatonRuleDetails) + ", assetGenericNotificationCOnfigDetails=" + String.valueOf(this.assetGenericNotificationCOnfigDetails) + ", assetBarcodeConfigDetails=" + String.valueOf(this.assetBarcodeConfigDetails) + ", assetCiRelationshipDetails=" + String.valueOf(this.assetCiRelationshipDetails) + ", assetUserAcceptanceDetails=" + String.valueOf(this.assetUserAcceptanceDetails) + ", assetPrepostActions=" + String.valueOf(this.assetPrepostActions) + ", assetTypeDTO=" + String.valueOf(this.assetTypeDTO) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnore
    public AssetFlowDetailsDTO getAssetFlowDetails(Integer assetFlowDetailsId) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetFlowDetails)) {
            for (AssetFlowDetailsDTO sub : this.assetFlowDetails) {
                if (sub.getAssetFlowDetailsIdDTO().getFlowDetailsId() != assetFlowDetailsId.intValue()) continue;
                return sub;
            }
        }
        return null;
    }

    @JsonIgnore
    public AssetFlowDetailsDTO getAssetFlowIdByName(String value) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetFlowDetails)) {
            for (AssetFlowDetailsDTO sub : this.assetFlowDetails) {
                if (!sub.getValue().equals(value)) continue;
                return sub;
            }
        }
        throw new DomainException(DomainException.ErrorCode.INVALID_INPUT, " Invalid Asset FlowDetails DTO  Name %s ", new Object[]{value});
    }

    @JsonIgnore
    public AssetrolesDTO getAssetRolesDetails(Integer roleId) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (AssetrolesDTO roles : this.assetRoles) {
                if (!roles.getAssetRoleId().equals(roleId)) continue;
                return roles;
            }
        }
        return null;
    }

    @JsonIgnore
    public MiscDetailsDTO getMiscDetailsDetails(Integer id) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (MiscDetailsDTO misc : this.assetMiscDetails) {
                if (!misc.getCategoryId().equals(id)) continue;
                return misc;
            }
        }
        return null;
    }

    @JsonIgnore
    public UserAcceptanceConfigDTO getUserAcceptanceConfigDetails(Integer id) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (UserAcceptanceConfigDTO userAccept : this.assetUserAcceptanceDetails) {
                if (!userAccept.getId().equals(id)) continue;
                return userAccept;
            }
        }
        return null;
    }

    @JsonIgnore
    public AssetControlFlowConfigMasterDTO getAssetControlFlowConfigDetails(Integer id) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (AssetControlFlowConfigMasterDTO details : this.assetControlFlowConfigDetails) {
                if (!details.getId().equals(id)) continue;
                return details;
            }
        }
        return null;
    }

    @JsonIgnore
    public AssetRequestNumberFormatDTO getAssetRequestNumberFormatDetails(Integer id) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (AssetRequestNumberFormatDTO details : this.assetRequestNumberFormatDetails) {
                if (details.getItemTypeId() != id.intValue()) continue;
                return details;
            }
        }
        return null;
    }

    @JsonIgnore
    public AssetgenerationmasterDTO getAssetGenerationDetails(Integer id) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (AssetgenerationmasterDTO details : this.assetGenerationDetails) {
                if (!details.getId().equals(id)) continue;
                return details;
            }
        }
        return null;
    }

    @JsonIgnore
    public AssetfieldsTemplatemasterDTO getaAssetFieldsTemplateDetails(Integer id) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (AssetfieldsTemplatemasterDTO details : this.assetFieldsTemplateMaster) {
                if (!details.getId().equals(id)) continue;
                return details;
            }
        }
        return null;
    }

    @JsonIgnore
    public BarcodeConfigurationDTO getAssetBarcodeConfigDetails(Integer id) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (BarcodeConfigurationDTO details : this.assetBarcodeConfigDetails) {
                if (!details.getId().equals(id)) continue;
                return details;
            }
        }
        return null;
    }

    @JsonIgnore
    public CiRelationshipMasterDTO getAssetCiRelationshipDetails(Integer id) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.assetRoles)) {
            for (CiRelationshipMasterDTO details : this.assetCiRelationshipDetails) {
                if (!details.getId().equals(id)) continue;
                return details;
            }
        }
        return null;
    }

    @JsonIgnore
    public AssetTypeDTO getAssetTypeByName(String itemType) throws DomainException {
        if (CollectionUtil.isNotEmpty(this.getAssetTypeDTO())) {
            for (AssetTypeDTO a : this.getAssetTypeDTO()) {
                if (!a.getItemType().equals(itemType)) continue;
                return a;
            }
        }
        return null;
    }

    public AssetModuleDTO setAssetModule(AssetModuleExportDTO request) throws DomainException {
        AssetModuleMaster am = request.getAssetModuleMaster();
        if (am != null) {
            AssetModuleMasterDTO moduleDTO = new AssetModuleMasterDTO(am.getModuleName(), am.getModuleType(), am.getDescription(), am.getDisplayOrder(), am.getIsVisible(), am.getAssetNoGen());
            moduleDTO.setModuleId(am.getModuleId());
            this.assetModuleMaster = moduleDTO;
            this.moduleId = this.assetModuleMaster.getModuleId();
        }
        return this;
    }

    public AssetModuleDTO setAssetRole(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getRoles())) {
            this.assetRoles = new ArrayList<AssetrolesDTO>(request.getRoles().size());
            for (Assetroles r : request.getRoles()) {
                Map<Integer, List<AssetrolesPrivilege>> rolesPrivilegeMps = CollectionUtil.getAssetRolesPrivilegeMap(request.getRolesPrivilege());
                AssetrolesDTO rd = new AssetrolesDTO(r, rolesPrivilegeMps.get(r.getAssetRoleId()));
                this.assetRoles.add(rd);
            }
        }
        return this;
    }

    public AssetModuleDTO setAssetControlFlowDetails(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getStatus())) {
            this.assetFlowDetails = new ArrayList<AssetFlowDetailsDTO>(request.getStatus().size());
            for (Assetflowdetails afd : request.getStatus()) {
                AssetFlowDetailsIdDTO assetFlowDetailsId = new AssetFlowDetailsIdDTO(afd.getId().getFlowDetailsId(), afd.getId().getSiteId());
                this.assetFlowDetails.add(new AssetFlowDetailsDTO(assetFlowDetailsId, afd.getValue(), afd.getModuleId()));
            }
        }
        return this;
    }

    public AssetModuleDTO setItemTypeMaster(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getItemTypes())) {
            this.itemTypes = new ArrayList<AssetItemtypeMasterDTO>(request.getItemTypes().size());
            for (AssetitemtypeMaster aim : request.getItemTypes()) {
                this.itemTypes.add(new AssetItemtypeMasterDTO(aim));
            }
        }
        return this;
    }

    public AssetModuleDTO setAssetNumberFormat(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getAssetRequestNumberFormat())) {
            this.assetRequestNumberFormatDetails = new ArrayList<AssetRequestNumberFormatDTO>(request.getAssetRequestNumberFormat().size());
            for (AssetRequestNumberFormat arnf : request.getAssetRequestNumberFormat()) {
                this.assetRequestNumberFormatDetails.add(new AssetRequestNumberFormatDTO(arnf));
            }
        }
        return this;
    }

    public AssetModuleDTO setAssetPrePostActionDetails(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getAssetPrePostActions())) {
            this.assetPrepostActions = new ArrayList<AssetPrepostActionsDTO>(request.getAssetPrePostActions().size());
            for (AssetPrepostActions apa : request.getAssetPrePostActions()) {
                this.assetPrepostActions.add(new AssetPrepostActionsDTO(apa));
            }
        }
        return this;
    }

    public AssetModuleDTO setMiscConfiguration(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getMiscDetails())) {
            this.assetMiscDetails = new ArrayList<MiscDetailsDTO>(request.getMiscDetails().size());
            for (MiscDetails mc : request.getMiscDetails()) {
                this.assetMiscDetails.add(new MiscDetailsDTO(mc));
            }
        }
        return this;
    }

    public AssetModuleDTO setCiRelationtionshipDetails(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getCiRelationshipMaster())) {
            this.assetCiRelationshipDetails = new ArrayList<CiRelationshipMasterDTO>(request.getCiRelationshipMaster().size());
            for (CiRelationshipMaster cirm : request.getCiRelationshipMaster()) {
                this.assetCiRelationshipDetails.add(new CiRelationshipMasterDTO(cirm));
            }
        }
        return this;
    }

    public AssetModuleDTO setUserAcceptanceConfigDetails(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getUserAcceptanceConfig())) {
            this.assetUserAcceptanceDetails = new ArrayList<UserAcceptanceConfigDTO>(request.getUserAcceptanceConfig().size());
            for (UserAcceptanceConfig uac : request.getUserAcceptanceConfig()) {
                this.assetUserAcceptanceDetails.add(new UserAcceptanceConfigDTO(uac));
            }
        }
        return this;
    }

    public AssetModuleDTO setCustomizeBuiltinAttributes(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getAssetmanagementFixedfields())) {
            // empty if block
        }
        this.assetmanagementFixedfields = new ArrayList<AssetmanagementFixedfieldsDTO>(request.getAssetmanagementFixedfields().size());
        for (AssetmanagementFixedfields amf : request.getAssetmanagementFixedfields()) {
            this.assetmanagementFixedfields.add(new AssetmanagementFixedfieldsDTO(amf.getSno(), amf.getFieldId(), amf.getDisplayName(), amf.getIsMandatory(), amf.getIsdisplayed(), amf.getAssetType(), amf.getModuleType(), amf.getReadonly(), amf.getRoleid()));
        }
        return this;
    }

    public AssetModuleDTO setAssetPreshippedFixedFields(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getPreshippedFixedFields())) {
            this.preshippedFixedFields = new ArrayList<AssetcomponentfixedfieldsMappingDTO>(request.getPreshippedFixedFields().size());
            for (AssetcomponentfixedfieldsMapping acf : request.getPreshippedFixedFields()) {
                this.preshippedFixedFields.add(new AssetcomponentfixedfieldsMappingDTO(acf));
            }
        }
        return this;
    }

    public AssetModuleDTO setAssetGenerationMasterDTO(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getAssetGenerationMaster())) {
            this.assetGenerationDetails = new ArrayList<AssetgenerationmasterDTO>(request.getAssetGenerationMaster().size());
            for (Assetgenerationmaster agm : request.getAssetGenerationMaster()) {
                Map<Integer, List<Assetgenerationdetails>> detailsMps = CollectionUtil.getAssetGenerationDetailsMap(request.getAssetGenerationDetails());
                ArrayList<AssetgenerationdetailsDTO> agdDto = new ArrayList<AssetgenerationdetailsDTO>();
                if (detailsMps != null && !detailsMps.get(agm.getCategoryId()).isEmpty()) {
                    for (Assetgenerationdetails agd : detailsMps.get(agm.getCategoryId())) {
                        agdDto.add(new AssetgenerationdetailsDTO(agd));
                    }
                }
                AssetgenerationmasterDTO agmdto = new AssetgenerationmasterDTO(agm, agdDto);
                this.assetGenerationDetails.add(agmdto);
            }
        }
        return this;
    }

    public AssetModuleDTO setAssetAdditionalFields(AssetModuleExportDTO request, IMacromasterDAO macromasterDAO) {
        if (CollectionUtil.isNotEmpty(request.getAdditionalFields())) {
            this.additionalFields = new ArrayList<AssetItemtypeConfigurationDTO>(request.getAdditionalFields().size());
            for (AssetitemtypeConfiguration aic : request.getAdditionalFields()) {
                Map<String, List<AssetconfigaccessDetails>> accessMps = CollectionUtil.getAssetConfigAccessDetailsMap(request.getAssetconfigaccessDetails());
                Macromaster m = (Macromaster)macromasterDAO.get(Integer.valueOf(aic.getMacroId()));
                if (m == null) continue;
                MacromasterDTO mdto1 = new MacromasterDTO(m, m.getMacrodetailses(), m.getMacrodetailsGriddatas());
                this.additionalFields.add(new AssetItemtypeConfigurationDTO(aic, mdto1, accessMps.get(aic.getId().getItemTypeId() + "-" + aic.getId().getItemDetailsId())));
            }
        }
        return this;
    }

    public AssetModuleDTO setAssetNotificationMaster(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getAssetNotificationTemplateMaster())) {
            this.assetNotificationTemplateDetails = new ArrayList<AssetNotificationTemplateMasterDTO>(request.getAssetNotificationTemplateMaster().size());
            for (AssetNotificationTemplateMaster antm : request.getAssetNotificationTemplateMaster()) {
                AssetNotificationTemplateMasterDTO antmDTO = new AssetNotificationTemplateMasterDTO(antm.getTemplateId(), antm.getTemplateName(), antm.getTemplateDescription(), antm.getTemplateType(), antm.getFixedTemplateType(), antm.getModuleId(), antm.getNotificationTemplateType(), antm.getIsDefault());
                ArrayList<AssetNotificationTemplateDetailsDTO> antdDTO = new ArrayList<AssetNotificationTemplateDetailsDTO>();
                if (CollectionUtil.isNotEmpty(antm.getAssetnotificationTemplatedetailses())) {
                    for (AssetNotificationTemplateDetails antd : antm.getAssetnotificationTemplatedetailses()) {
                        antdDTO.add(new AssetNotificationTemplateDetailsDTO(antmDTO, antd.getTemplateDetailsId(), antd.getFieldType(), antd.getFieldValue(), antd.getAssetType(), antd.getDisplayOrder()));
                    }
                }
                antmDTO.setAssetnotificationTemplatedetailses(antdDTO);
                this.assetNotificationTemplateDetails.add(antmDTO);
            }
        }
        return this;
    }

    public AssetModuleDTO setassetNotificatonRuleMaster(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getAssetNotificationRuleMaster())) {
            this.assetNotificatonRuleDetails = new ArrayList<AssetNotificationRuleMasterDTO>(request.getAssetNotificationRuleMaster().size());
            for (AssetNotificationRuleMaster anrm : request.getAssetNotificationRuleMaster()) {
                AssetNotificationRuleMasterDTO anrmDTO = new AssetNotificationRuleMasterDTO(anrm.getRuleName(), anrm.getRuleDescription(), anrm.getRuleType(), anrm.getModuleId());
                ArrayList<AssetNotificationRuleDetailsDTO> anrdDTO = new ArrayList<AssetNotificationRuleDetailsDTO>();
                for (AssetNotificationRuleDetails anrd : anrm.getAssetnotificationRuledetailses()) {
                    anrdDTO.add(new AssetNotificationRuleDetailsDTO(anrmDTO, anrd.getFieldType(), anrd.getFieldValue(), anrd.getNotificationStatus()));
                }
                this.assetNotificatonRuleDetails.add(new AssetNotificationRuleMasterDTO(anrm, anrdDTO));
            }
        }
        return this;
    }

    public AssetModuleDTO setBarcodeConfigDetails(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getBarcodeConfiguration())) {
            this.assetBarcodeConfigDetails = new ArrayList<BarcodeConfigurationDTO>(request.getBarcodeConfiguration().size());
            for (BarcodeConfiguration bc : request.getBarcodeConfiguration()) {
                ArrayList<BarcodeConfigurationDetailsDTO> bcdDTO = new ArrayList<BarcodeConfigurationDetailsDTO>();
                this.assetBarcodeConfigDetails.add(new BarcodeConfigurationDTO(bc, bcdDTO));
            }
        }
        return this;
    }

    public AssetModuleDTO setAssetImport(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getAssetFieldsTemplateMaster())) {
            this.assetFieldsTemplateMaster = new ArrayList<AssetfieldsTemplatemasterDTO>(request.getAssetFieldsTemplateMaster().size());
            for (AssetfieldsTemplatemaster aftm : request.getAssetFieldsTemplateMaster()) {
                Map<Integer, List<AssetfieldsTemplatedetails>> detailsMps = CollectionUtil.getAssetFieldsTemplateDetailsMap(request.getAssetFieldsTemplateDetails());
                Map<Integer, List<AssetTemplateAttachmentdetails>> attachMps = CollectionUtil.getAssetFieldsTemplateAttachmentDetailsMap(request.getAssetTemplateAttachmentDetails());
                AssetfieldsTemplatemasterDTO aftmDTO = new AssetfieldsTemplatemasterDTO(aftm, detailsMps.get(aftm.getTemplateId()), attachMps.get(aftm.getTemplateId()));
                this.assetFieldsTemplateMaster.add(aftmDTO);
            }
        }
        return this;
    }

    public AssetModuleDTO setAssetLifeCycleFields(AssetModuleExportDTO request, IMacromasterDAO macromasterDAO) {
        if (CollectionUtil.isNotEmpty(request.getLifecycleFields())) {
            this.assetControlFlowConfigDetails = new ArrayList<AssetControlFlowConfigMasterDTO>(request.getLifecycleFields().size());
            for (AssetcontrolflowconfigMaster acfm : request.getLifecycleFields()) {
                Map<Integer, List<AssetControlFlowConfigDetails>> detailsMps = CollectionUtil.getAssetControlflowConfigAccessDetailsMap(request.getLifecycleFieldsDetails());
                Map<Integer, List<AssetcontrolflowconfigAdditionalparams>> additionalFieldMps = CollectionUtil.getAssetControlflowConfigAdditionalParamsMap(request.getLifecycleAdditionalFields());
                List<AssetControlFlowConfigDetailsDTO> lifecycleFieldsDetails = this.getAssetLifeCycleFieldsDetails(detailsMps.get(acfm.getId().getControlFlowId()));
                List<AssetcontrolflowconfigAdditionalparamsDTO> lifecycleAdditionalFields = this.getAssetLifeCycleAdditionalFieldDetails(request, additionalFieldMps.get(acfm.getId().getControlFlowId()), macromasterDAO);
                AssetControlFlowConfigMasterDTO acfcmDTO = new AssetControlFlowConfigMasterDTO(acfm, lifecycleFieldsDetails, lifecycleAdditionalFields);
                this.assetControlFlowConfigDetails.add(acfcmDTO);
            }
        }
        return this;
    }

    public List<AssetControlFlowConfigDetailsDTO> getAssetLifeCycleFieldsDetails(List<AssetControlFlowConfigDetails> acfcd) {
        ArrayList<AssetControlFlowConfigDetailsDTO> lifecycleFieldsDetails = new ArrayList<AssetControlFlowConfigDetailsDTO>();
        if (CollectionUtil.isNotEmpty(acfcd)) {
            for (AssetControlFlowConfigDetails acfd : acfcd) {
                lifecycleFieldsDetails.add(new AssetControlFlowConfigDetailsDTO(acfd));
            }
        }
        return lifecycleFieldsDetails;
    }

    public List<AssetcontrolflowconfigAdditionalparamsDTO> getAssetLifeCycleAdditionalFieldDetails(AssetModuleExportDTO request, List<AssetcontrolflowconfigAdditionalparams> lifecycleAdditionalFields, IMacromasterDAO macromasterDAO) {
        ArrayList<AssetcontrolflowconfigAdditionalparamsDTO> lcaf = new ArrayList<AssetcontrolflowconfigAdditionalparamsDTO>();
        if (CollectionUtil.isNotEmpty(lifecycleAdditionalFields)) {
            for (AssetcontrolflowconfigAdditionalparams acfap : lifecycleAdditionalFields) {
                Map<String, List<AssetconfigaccessDetails>> accessMps = CollectionUtil.getAssetConfigAccessDetailsMap(request.getLifecycleFieldAccessDetails());
                Macromaster m = (Macromaster)macromasterDAO.get(Integer.valueOf(acfap.getMacroId()));
                if (m == null) continue;
                MacromasterDTO mdto1 = new MacromasterDTO(m, m.getMacrodetailses(), m.getMacrodetailsGriddatas());
                lcaf.add(new AssetcontrolflowconfigAdditionalparamsDTO(acfap, mdto1, accessMps.get(acfap.getControlFlowId() + "-" + acfap.getId().getAssetDetailsId())));
            }
        }
        return lcaf;
    }

    public AssetModuleDTO setGenericNotificationCOnfigDetails(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getGenericNotificationConfigDetails())) {
            this.assetGenericNotificationCOnfigDetails = new ArrayList<GenericNotificationConfigDetailsDTO>(request.getGenericNotificationConfigDetails().size());
            for (GenericNotificationConfigDetails ancd : request.getGenericNotificationConfigDetails()) {
                this.assetGenericNotificationCOnfigDetails.add(new GenericNotificationConfigDetailsDTO(ancd));
            }
        }
        return this;
    }

    public AssetModuleDTO setGenericNotificationConfigMaster(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getGenericNotificationConfigMaster())) {
            this.assetGenericNotificationConfigMaster = new ArrayList<GenericNotificationConfigMasterDTO>();
            for (GenericNotificationConfigMaster ancd : request.getGenericNotificationConfigMaster()) {
                this.assetGenericNotificationConfigMaster.add(new GenericNotificationConfigMasterDTO(ancd, request.getAssetModuleMaster().getModuleId()));
            }
        }
        return this;
    }

    public AssetModuleDTO setPrenotificationRuleDetails(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getPrenotificationRuledetails())) {
            this.prenotificationRuledetails = new ArrayList<PrenotificationRuledetailsDTO>(request.getPrenotificationRuledetails().size());
            for (PrenotificationRuledetails pnrd : request.getPrenotificationRuledetails()) {
                this.prenotificationRuledetails.add(new PrenotificationRuledetailsDTO(pnrd));
            }
        }
        return this;
    }

    public AssetModuleDTO setDepreciationData(AssetModuleExportDTO request) {
        if (CollectionUtil.isNotEmpty(request.getAssetDepreciation())) {
            this.assetDepreciation = new ArrayList<AssetDepreciationDTO>(request.getAssetDepreciation().size());
            for (AssetDepreciation ad : request.getAssetDepreciation()) {
                this.assetDepreciation.add(new AssetDepreciationDTO(ad));
            }
        }
        return this;
    }

    public String getNewPreNotificationCriteriaId(String oldCriteriaId, AssetModuleExportDTO ameDto) {
        Object newCriteriaId = "";
        if (oldCriteriaId.contains("assetmaster") || oldCriteriaId.contains("|==|")) {
            newCriteriaId = oldCriteriaId;
        } else if (oldCriteriaId.contains("|@@|")) {
            AssetcontrolflowconfigAdditionalparams acfad;
            int fieldId;
            String[] splitCriteria = oldCriteriaId.split("\\|\\@\\@\\|");
            if (splitCriteria.length == 2) {
                fieldId = Integer.parseInt(splitCriteria[1]);
                newCriteriaId = splitCriteria[0];
            } else {
                fieldId = Integer.parseInt(splitCriteria[0]);
            }
            AssetcontrolflowconfigAdditionalparams assetcontrolflowconfigAdditionalparams = acfad = ameDto.getOldIdLifecycleAddiFields().containsKey(fieldId) ? ameDto.getOldIdLifecycleAddiFields().get(fieldId) : null;
            if (acfad != null) {
                fieldId = acfad.getId().getAssetDetailsId();
                newCriteriaId = (String)newCriteriaId + "|@@|" + fieldId;
            }
        } else {
            AssetitemtypeConfiguration aitc;
            AssetitemtypeConfiguration assetitemtypeConfiguration = aitc = ameDto.getOldIdAdditionalFields().containsKey(Integer.parseInt(oldCriteriaId)) ? ameDto.getOldIdAdditionalFields().get(Integer.parseInt(oldCriteriaId)) : null;
            if (aitc != null) {
                newCriteriaId = String.valueOf(aitc.getId().getItemDetailsId());
            }
        }
        return newCriteriaId;
    }

    public List<RpaProcessDTO> getRpaProcess() {
        return this.rpaProcess;
    }

    public void setRpaProcess(List<RpaProcessDTO> rpaProcess) {
        this.rpaProcess = rpaProcess;
    }

    public List<RpaEventDTO> getRpaEvents() {
        return this.rpaEvents;
    }

    public void setRpaEvents(List<RpaEventDTO> rpaEvents) {
        this.rpaEvents = rpaEvents;
    }

    public List<SdTemplateDTO> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<SdTemplateDTO> templates) {
        this.templates = templates;
    }

    public static final class Builder {
        private boolean updated;
        private Integer moduleId;
        private String moduleName;
        private ModuleType moduleType;
        private String description;
        private int displayOrder;
        private int isVisible;
        private List<AssetFlowDetailsDTO> assetFlowDetails = Collections.emptyList();
        private List<AssetrolesDTO> assetRoles = Collections.emptyList();
        private List<AssetControlFlowConfigMasterDTO> assetControlFlowConfigDetails = Collections.emptyList();
        private List<AssetgenerationmasterDTO> assetGenerationDetails = Collections.emptyList();
        private List<AssetRequestNumberFormatDTO> assetRequestNumberFormatDetails = Collections.emptyList();
        private List<MiscDetailsDTO> assetMiscDetails = Collections.emptyList();
        private List<AssetfieldsTemplatemasterDTO> assetFieldsTemplateMaster = Collections.emptyList();
        private List<AssetNotificationTemplateMasterDTO> assetNotificationTemplateDetails = Collections.emptyList();
        private List<AssetNotificationRuleMasterDTO> assetNotificatonRuleDetails = Collections.emptyList();
        private List<GenericNotificationConfigDetailsDTO> assetGenericNotificationCOnfigDetails = Collections.emptyList();
        private List<BarcodeConfigurationDTO> assetBarcodeConfigDetails = Collections.emptyList();
        private List<CiRelationshipMasterDTO> assetCiRelationshipDetails = Collections.emptyList();
        private List<UserAcceptanceConfigDTO> assetUserAcceptanceDetails = Collections.emptyList();
        private List<AssetPrepostActionsDTO> assetPrepostActions = Collections.emptyList();
        private List<AssetTypeDTO> assetTypeDTO = Collections.emptyList();
        private AssetModuleMasterDTO assetModuleMaster;
        private List<RpaProcessDTO> rpaProcess = Collections.emptyList();
        private List<RpaEventDTO> rpaEvents = Collections.emptyList();
        private List<SdTemplateDTO> templates = Collections.emptyList();

        private Builder() {
        }

        public Builder withUpdated(boolean updated) {
            this.updated = updated;
            return this;
        }

        public Builder withModuleId(Integer moduleId) {
            this.moduleId = moduleId;
            return this;
        }

        public Builder withModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder withModuleType(ModuleType moduleType) {
            this.moduleType = moduleType;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withDisplayOrder(int displayOrder) {
            this.displayOrder = displayOrder;
            return this;
        }

        public Builder withIsVisible(int isVisible) {
            this.isVisible = isVisible;
            return this;
        }

        public Builder withAssetFlowDetails(List<AssetFlowDetailsDTO> assetFlowDetails) {
            this.assetFlowDetails = assetFlowDetails;
            return this;
        }

        public Builder withAssetRoles(List<AssetrolesDTO> assetRoles) {
            this.assetRoles = assetRoles;
            return this;
        }

        public Builder withAssetControlFlowConfigDetails(List<AssetControlFlowConfigMasterDTO> assetControlFlowConfigDetails) {
            this.assetControlFlowConfigDetails = assetControlFlowConfigDetails;
            return this;
        }

        public Builder withAssetGenerationDetails(List<AssetgenerationmasterDTO> assetGenerationDetails) {
            this.assetGenerationDetails = assetGenerationDetails;
            return this;
        }

        public Builder withAssetRequestNumberFormatDetails(List<AssetRequestNumberFormatDTO> assetRequestNumberFormatDetails) {
            this.assetRequestNumberFormatDetails = assetRequestNumberFormatDetails;
            return this;
        }

        public Builder withAssetMiscDetails(List<MiscDetailsDTO> assetMiscDetails) {
            this.assetMiscDetails = assetMiscDetails;
            return this;
        }

        public Builder withAssetFieldsTemplateMaster(List<AssetfieldsTemplatemasterDTO> assetFieldsTemplateMaster) {
            this.assetFieldsTemplateMaster = assetFieldsTemplateMaster;
            return this;
        }

        public Builder withAssetNotificationTemplateDetails(List<AssetNotificationTemplateMasterDTO> assetNotificationTemplateDetails) {
            this.assetNotificationTemplateDetails = assetNotificationTemplateDetails;
            return this;
        }

        public Builder withAssetNotificatonRuleDetails(List<AssetNotificationRuleMasterDTO> assetNotificatonRuleDetails) {
            this.assetNotificatonRuleDetails = assetNotificatonRuleDetails;
            return this;
        }

        public Builder withAssetGenericNotificationCOnfigDetails(List<GenericNotificationConfigDetailsDTO> assetGenericNotificationCOnfigDetails) {
            this.assetGenericNotificationCOnfigDetails = assetGenericNotificationCOnfigDetails;
            return this;
        }

        public Builder withAssetBarcodeConfigDetails(List<BarcodeConfigurationDTO> assetBarcodeConfigDetails) {
            this.assetBarcodeConfigDetails = assetBarcodeConfigDetails;
            return this;
        }

        public Builder withAssetCiRelationshipDetails(List<CiRelationshipMasterDTO> assetCiRelationshipDetails) {
            this.assetCiRelationshipDetails = assetCiRelationshipDetails;
            return this;
        }

        public Builder withAssetUserAcceptanceDetails(List<UserAcceptanceConfigDTO> assetUserAcceptanceDetails) {
            this.assetUserAcceptanceDetails = assetUserAcceptanceDetails;
            return this;
        }

        public Builder withAssetPrepostActions(List<AssetPrepostActionsDTO> assetPrepostActions) {
            this.assetPrepostActions = assetPrepostActions;
            return this;
        }

        public Builder withAssetTypeDTO(List<AssetTypeDTO> assetTypeDTO) {
            this.assetTypeDTO = assetTypeDTO;
            return this;
        }

        public Builder withModuleMasterDTO(AssetModuleMasterDTO moduleMasterDTO) {
            this.assetModuleMaster = moduleMasterDTO;
            return this;
        }

        public Builder withRpaProcess(List<RpaProcessDTO> rpaProcess) {
            this.rpaProcess = rpaProcess;
            return this;
        }

        public Builder withRpaEvents(List<RpaEventDTO> rpaEvents) {
            this.rpaEvents = rpaEvents;
            return this;
        }

        public Builder withTemplates(List<SdTemplateDTO> templates) {
            this.templates = templates;
            return this;
        }

        public AssetModuleDTO build() {
            return new AssetModuleDTO(this);
        }
    }
}

