/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.model;

import com.sapphireims.cmdb.dto.AssetContext;
import com.sapphireims.cmdb.dto.AssetItemtypeConfigurationDTO;
import com.sapphireims.cmdb.dto.asset.AssetAttribute;
import com.sapphireims.cmdb.model.AssetdetailsId;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;

@Entity
@Table(name="assetdetails")
public class Assetdetails
extends BaseModel {
    private static final long serialVersionUID = 367182732316794012L;
    private AssetdetailsId id;
    private int assetId;
    private int itemTypeId;
    private int itemDetailsId;
    private String assetValue;
    private int flowType;
    private int groupType;

    public Assetdetails() {
    }

    public Assetdetails(AssetdetailsId id, int assetId, int itemTypeId, int itemDetailsId, String assetValue, int flowType, int groupType) {
        this.id = id;
        this.assetId = assetId;
        this.itemTypeId = itemTypeId;
        this.itemDetailsId = itemDetailsId;
        this.assetValue = assetValue;
        this.flowType = flowType;
        this.groupType = groupType;
    }

    public Assetdetails(AssetAttribute attribute, AssetItemtypeConfigurationDTO a, AssetContext context) {
        this.id = new AssetdetailsId(0, context.getAsset().getSiteId());
        this.assetId = context.getMaster().getAssetId() != null ? context.getMaster().getAssetId() : 0;
        this.itemTypeId = a.getAssetitemtypeConfigurationId().getItemTypeId();
        this.itemDetailsId = a.getAssetitemtypeConfigurationId().getItemDetailsId();
        this.assetValue = attribute.getData();
    }

    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="assetDetailsId", column=@Column(name="AssetDetailsID", nullable=false)), @AttributeOverride(name="siteId", column=@Column(name="SiteID", nullable=false))})
    public AssetdetailsId getId() {
        return this.id;
    }

    public void setId(AssetdetailsId id) {
        this.id = id;
    }

    @Column(name="AssetID", nullable=false)
    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    @Column(name="ItemTypeID", nullable=false)
    public int getItemTypeId() {
        return this.itemTypeId;
    }

    public void setItemTypeId(int itemTypeId) {
        this.itemTypeId = itemTypeId;
    }

    @Column(name="ItemDetailsID", nullable=false)
    public int getItemDetailsId() {
        return this.itemDetailsId;
    }

    public void setItemDetailsId(int itemDetailsId) {
        this.itemDetailsId = itemDetailsId;
    }

    @Column(name="AssetValue", nullable=false, length=2048)
    public String getAssetValue() {
        return this.assetValue;
    }

    public void setAssetValue(String assetValue) {
        this.assetValue = assetValue;
    }

    @Column(name="FlowType", nullable=false)
    public int getFlowType() {
        return this.flowType;
    }

    public void setFlowType(int flowType) {
        this.flowType = flowType;
    }

    @Column(name="GroupType", nullable=false)
    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }
}

