/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.model;

import com.sapphireims.cmdb.dto.AssethistoryDTO;
import com.sapphireims.cmdb.model.AssethistoryId;
import com.sapphireims.cmdb.model.Assetmaster;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="assethistory")
public class Assethistory
extends BaseModel {
    private static final long serialVersionUID = -1720319038711971504L;
    private AssethistoryId id;
    private int assetId;
    private int itemTypeId;
    private int assetDetailsId;
    private int oldValueId;
    private int newValueId;
    private String oldValue;
    private String newValue;
    private String changeType;
    private Date timePeriod;
    private String actionPerformedBy;
    private String fieldDisplayName;
    private int childOf;

    public Assethistory() {
    }

    public Assethistory(AssethistoryId id, int assetId, int itemTypeId, int assetDetailsId, int oldValueId, int newValueId, String oldValue, String newValue, String changeType, Date timePeriod, String actionPerformedBy, String fieldDisplayName, int childOf) {
        this.id = id;
        this.assetId = assetId;
        this.itemTypeId = itemTypeId;
        this.assetDetailsId = assetDetailsId;
        this.oldValueId = oldValueId;
        this.newValueId = newValueId;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.changeType = changeType;
        this.timePeriod = timePeriod;
        this.actionPerformedBy = actionPerformedBy;
        this.fieldDisplayName = fieldDisplayName;
        this.childOf = childOf;
    }

    public Assethistory(int assetHistoryId, int siteID, int assetId, int itemTypeId, int assetDetailsId, int oldValueId, int newValueId, String oldValue, String newValue, String changeType, Date timePeriod, String actionPerformedBy, String fieldDisplayName, int childOf) {
        this.id = new AssethistoryId(assetHistoryId, siteID);
        this.assetId = assetId;
        this.itemTypeId = itemTypeId;
        this.assetDetailsId = assetDetailsId;
        this.oldValueId = oldValueId;
        this.newValueId = newValueId;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.changeType = changeType;
        this.timePeriod = timePeriod;
        this.actionPerformedBy = actionPerformedBy;
        this.fieldDisplayName = fieldDisplayName;
        this.childOf = childOf;
    }

    public Assethistory(Assetmaster am, AssethistoryDTO ahDTO) {
        this.assetId = am.getAssetId();
        this.itemTypeId = am.getItemTypeId();
        this.assetDetailsId = ahDTO.getAssetDetailsId();
        this.oldValueId = ahDTO.getOldValueId();
        this.newValueId = ahDTO.getNewValueId();
        this.oldValue = ahDTO.getOldValue();
        this.newValue = ahDTO.getNewValue();
        this.changeType = ahDTO.getChangeType();
        this.timePeriod = ahDTO.getTimePeriod();
        this.actionPerformedBy = ahDTO.getActionPerformedBy();
        this.fieldDisplayName = ahDTO.getFieldDisplayName();
        this.childOf = ahDTO.getChildOf();
    }

    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="assetHistoryId", column=@Column(name="AssetHistoryID", nullable=false)), @AttributeOverride(name="siteId", column=@Column(name="SiteID", nullable=false))})
    public AssethistoryId getId() {
        return this.id;
    }

    public void setId(AssethistoryId id) {
        this.id = id;
    }

    @Column(name="AssetID", nullable=false)
    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    @Column(name="ItemTypeID", nullable=false)
    public int getItemTypeId() {
        return this.itemTypeId;
    }

    public void setItemTypeId(int itemTypeId) {
        this.itemTypeId = itemTypeId;
    }

    @Column(name="AssetDetailsID", nullable=false)
    public int getAssetDetailsId() {
        return this.assetDetailsId;
    }

    public void setAssetDetailsId(int assetDetailsId) {
        this.assetDetailsId = assetDetailsId;
    }

    @Column(name="OldValueID", nullable=false)
    public int getOldValueId() {
        return this.oldValueId;
    }

    public void setOldValueId(int oldValueId) {
        this.oldValueId = oldValueId;
    }

    @Column(name="NewValueID", nullable=false)
    public int getNewValueId() {
        return this.newValueId;
    }

    public void setNewValueId(int newValueId) {
        this.newValueId = newValueId;
    }

    @Column(name="OldValue", nullable=false, length=2048)
    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    @Column(name="NewValue", nullable=false, length=2048)
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @Column(name="ChangeType", nullable=false, length=512)
    public String getChangeType() {
        return this.changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="TimePeriod", nullable=false, length=19)
    public Date getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(Date timePeriod) {
        this.timePeriod = timePeriod;
    }

    @Column(name="ActionPerformedBy", nullable=false, length=512)
    public String getActionPerformedBy() {
        return this.actionPerformedBy;
    }

    public void setActionPerformedBy(String actionPerformedBy) {
        this.actionPerformedBy = actionPerformedBy;
    }

    @Column(name="FieldDisplayName", nullable=false, length=512)
    public String getFieldDisplayName() {
        return this.fieldDisplayName;
    }

    public void setFieldDisplayName(String fieldDisplayName) {
        this.fieldDisplayName = fieldDisplayName;
    }

    @Column(name="ChildOf", nullable=false)
    public int getChildOf() {
        return this.childOf;
    }

    public void setChildOf(int childOf) {
        this.childOf = childOf;
    }
}

