/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.model;

import com.sapphireims.cmdb.dto.AssetstatusDTO;
import com.sapphireims.cmdb.model.AssetstatusId;
import com.sapphireims.model.BaseModel;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="assetstatus")
public class Assetstatus
extends BaseModel {
    private static final long serialVersionUID = 4869403681050975865L;
    private AssetstatusId id;
    private int assetId;
    private int itemTypeId;
    private int filterId;
    private int userId;
    private int project;
    private Date timePeriod;
    private int actionPerformedBy;

    public Assetstatus() {
    }

    public Assetstatus(AssetstatusDTO assetStatus) {
        this.id = new AssetstatusId(assetStatus);
        this.assetId = assetStatus.getAssetId();
        this.itemTypeId = assetStatus.getItemTypeId();
        this.filterId = assetStatus.getFilterId();
        this.userId = assetStatus.getUserId();
        this.project = assetStatus.getProject();
        this.timePeriod = assetStatus.getTimePeriod();
        this.actionPerformedBy = assetStatus.getActionPerformedBy();
    }

    public Assetstatus(Integer siteId) {
        this.id = new AssetstatusId(siteId);
    }

    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="siteId", column=@Column(name="SiteID", nullable=false)), @AttributeOverride(name="assetStatusId", column=@Column(name="AssetStatus_ID", nullable=false))})
    public AssetstatusId getId() {
        return this.id;
    }

    public void setId(AssetstatusId id) {
        this.id = id;
    }

    @Column(name="AssetID", nullable=false)
    public int getAssetId() {
        return this.assetId;
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    @Column(name="ItemTypeID", nullable=false)
    public int getItemTypeId() {
        return this.itemTypeId;
    }

    public void setItemTypeId(int itemTypeId) {
        this.itemTypeId = itemTypeId;
    }

    @Column(name="FilterID", nullable=false)
    public int getFilterId() {
        return this.filterId;
    }

    public void setFilterId(int filterId) {
        this.filterId = filterId;
    }

    @Column(name="UserID", nullable=false)
    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Column(name="Project", nullable=false)
    public int getProject() {
        return this.project;
    }

    public void setProject(int project) {
        this.project = project;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="TimePeriod", length=19)
    public Date getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(Date timePeriod) {
        this.timePeriod = timePeriod;
    }

    @Column(name="ActionPerformedBy", nullable=false)
    public int getActionPerformedBy() {
        return this.actionPerformedBy;
    }

    public void setActionPerformedBy(int actionPerformedBy) {
        this.actionPerformedBy = actionPerformedBy;
    }

    public String toString() {
        return "Assetstatus [id=" + String.valueOf(this.id) + ", assetId=" + this.assetId + ", itemTypeId=" + this.itemTypeId + ", filterId=" + this.filterId + ", userId=" + this.userId + ", project=" + this.project + ", timePeriod=" + String.valueOf(this.timePeriod) + ", actionPerformedBy=" + this.actionPerformedBy + "]";
    }
}

