/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.model;

import com.sapphireims.cmdb.dto.AssetstatusDTO;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.io.Serializable;

@Embeddable
public class AssetstatusId
implements Serializable {
    private static final long serialVersionUID = 8831780900439868411L;
    private int siteId;
    private int assetStatusId;

    public AssetstatusId() {
    }

    public AssetstatusId(int siteId, int assetStatusId) {
        this.siteId = siteId;
        this.assetStatusId = assetStatusId;
    }

    public AssetstatusId(AssetstatusDTO assetStatus) {
        this.siteId = assetStatus.getAssetstatusId().getSiteId();
    }

    public AssetstatusId(Integer siteId2) {
        this.siteId = siteId2;
    }

    @Column(name="SiteID", nullable=false)
    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteId(int siteId) {
        this.siteId = siteId;
    }

    @Column(name="AssetStatus_ID", nullable=false)
    public int getAssetStatusId() {
        return this.assetStatusId;
    }

    public void setAssetStatusId(int assetStatusId) {
        this.assetStatusId = assetStatusId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AssetstatusId)) {
            return false;
        }
        AssetstatusId castOther = (AssetstatusId)other;
        return this.getSiteId() == castOther.getSiteId() && this.getAssetStatusId() == castOther.getAssetStatusId();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getSiteId();
        result = 37 * result + this.getAssetStatusId();
        return result;
    }

    public String toString() {
        return "AssetstatusId [siteId=" + this.siteId + ", assetStatusId=" + this.assetStatusId + "]";
    }
}

