/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.service.impl;

import com.sapphire.itsm.mailrouting.model.AssetitemtypeConfiguration;
import com.sapphire.itsm.mailrouting.model.AssetitemtypeMaster;
import com.sapphireims.cmdb.dao.IAssetAdditionalParamsDAO;
import com.sapphireims.cmdb.dao.IAssetItemtypeMasterDAO;
import com.sapphireims.cmdb.dto.AssetItemtypeConfigurationDTO;
import com.sapphireims.cmdb.dto.assetcopy.AssetModuleDTO;
import com.sapphireims.cmdb.service.IAssetAdditionalParamsService;
import com.sapphireims.cmdb.service.IAssetMasterDataService;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.service.IMacroService;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssetAdditionalParamsService
implements IAssetAdditionalParamsService {
    private boolean cacheAssetMetaData = false;
    @Autowired
    private IAssetMasterDataService assetMasterDataService;
    @Autowired
    private IMacroService macroService;
    @Autowired
    private IAssetAdditionalParamsDAO assetAdditionalParamsDAO;
    @Autowired
    private IAssetItemtypeMasterDAO assetItemtypeMasterDAO;

    @Override
    public List<AssetItemtypeConfigurationDTO> getAdditionalParmsByItemtypeId(Integer itemtypeId) throws DomainException, ValidationException {
        Validate.notNull((Object)itemtypeId, (String)"Invalid itemtype id %s ", (Object[])new Object[]{itemtypeId});
        if (this.cacheAssetMetaData) {
            AssetModuleDTO masterDataSer = this.assetMasterDataService.getAssetModule(1, (Integer)1);
            List<AssetItemtypeConfigurationDTO> ret = masterDataSer.getAssetTypeDTO().get(itemtypeId).getAssetItemtypeConfigurationDTO();
            AssetItemtypeConfigurationDTO gridColumn = null;
            for (AssetItemtypeConfigurationDTO d : ret) {
                if (d.isGrid()) {
                    gridColumn = d;
                }
                if (d.isGridColumn()) {
                    if (gridColumn == null) continue;
                    gridColumn.addGridColumn(d);
                    continue;
                }
                gridColumn = null;
            }
        } else {
            List<AssetitemtypeConfiguration> additionalParams = this.assetAdditionalParamsDAO.getAssetAdditionalparamsByItemtypeId(itemtypeId);
            ArrayList<AssetItemtypeConfigurationDTO> ret = null;
            if (CollectionUtil.isNotEmpty(additionalParams)) {
                ret = new ArrayList<AssetItemtypeConfigurationDTO>(additionalParams.size());
                AssetItemtypeConfigurationDTO gridColumn = null;
                for (AssetitemtypeConfiguration master : additionalParams) {
                    AssetItemtypeConfigurationDTO d = new AssetItemtypeConfigurationDTO(master, this.macroService.geMacromasterDTOById(master.getMacroId()));
                    if (d.isGrid()) {
                        gridColumn = d;
                    }
                    if (d.isGridColumn()) {
                        if (gridColumn != null) {
                            gridColumn.addGridColumn(d);
                        }
                    } else {
                        gridColumn = null;
                    }
                    ret.add(d);
                }
            }
            return ret;
        }
        return null;
    }

    @Override
    @Transactional
    public void setAttributeName() {
        List<AssetitemtypeMaster> itemtypes = this.assetItemtypeMasterDAO.getAllAssetTypes();
        for (AssetitemtypeMaster master : itemtypes) {
            List<AssetitemtypeConfiguration> params = this.assetAdditionalParamsDAO.getAssetAdditionalparamsByItemtypeId(master.getId().getItemTypeId());
            int i = 1;
            for (AssetitemtypeConfiguration c : params) {
                c.setFieldName("attribute" + i);
                this.assetAdditionalParamsDAO.save(c);
                ++i;
            }
        }
    }
}

