/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.service.impl;

import com.sapphire.itsm.mailrouting.model.AssetModuleMaster;
import com.sapphireims.cmdb.dao.IAssetModuleMasterDAO;
import com.sapphireims.cmdb.dto.assetcopy.AssetModuleDTO;
import com.sapphireims.cmdb.mindto.AssetModuleMinDTO;
import com.sapphireims.cmdb.service.IAssetMasterDataService;
import com.sapphireims.cmdb.service.ICacheMasterData;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssetMasterDataService
implements IAssetMasterDataService {
    @Autowired
    private IAssetModuleMasterDAO assetModuleMasterDAO;
    @Autowired
    private ICacheMasterData masterDatacache;

    @Override
    @Transactional(readOnly=true)
    public List<AssetModuleMinDTO> getAllAssetModule() {
        ArrayList<AssetModuleMinDTO> ret = null;
        List<AssetModuleMaster> masters = this.assetModuleMasterDAO.getAll();
        if (CollectionUtil.isNotEmpty(masters)) {
            ret = new ArrayList<AssetModuleMinDTO>(masters.size());
            for (AssetModuleMaster d : masters) {
                ret.add(new AssetModuleMinDTO(d));
            }
        }
        return ret;
    }

    @Override
    @Transactional(readOnly=true)
    public AssetModuleDTO getAssetModule(String moduleName, Integer siteId) throws DomainException, ValidationException {
        AssetModuleMaster moduleMaster = this.assetModuleMasterDAO.getAssetModuleMasterByName(moduleName);
        Validate.notNull((Object)((Object)moduleMaster), (String)" Invalid Module name %s ", (Object[])new Object[]{moduleName});
        return this.getAssetModule(moduleMaster.getModuleId(), siteId);
    }

    @Override
    @Transactional(readOnly=true)
    public AssetModuleDTO getAssetModule(Integer moduleId, Integer siteId) throws DomainException, ValidationException {
        return this.masterDatacache.getAssetModule(moduleId);
    }

    @Override
    @Transactional
    public void copyAssetModule(AssetModuleDTO module) {
    }
}

