/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.service.impl;

import com.sapphire.itsm.mailrouting.dao.IMacromasterDAO;
import com.sapphire.itsm.mailrouting.dto.MacrodetailsCalendareventGriddataDTO;
import com.sapphire.itsm.mailrouting.dto.MacrodetailsDTO;
import com.sapphire.itsm.mailrouting.dto.MacrodetailsGriddataDTO;
import com.sapphire.itsm.mailrouting.dto.MacromasterDTO;
import com.sapphire.itsm.mailrouting.model.AssetModuleMaster;
import com.sapphire.itsm.mailrouting.model.AssetitemtypeConfiguration;
import com.sapphire.itsm.mailrouting.model.AssetitemtypeMaster;
import com.sapphire.itsm.mailrouting.model.Macromaster;
import com.sapphireims.cmdb.dao.IAssetControlFlowConfigDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetControlFlowConfigMasterDAO;
import com.sapphireims.cmdb.dao.IAssetDepreciationDAO;
import com.sapphireims.cmdb.dao.IAssetFlowDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetItemtypeConfigurationDAO;
import com.sapphireims.cmdb.dao.IAssetItemtypeMasterDAO;
import com.sapphireims.cmdb.dao.IAssetModuleMasterDAO;
import com.sapphireims.cmdb.dao.IAssetNotificationRuleDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetNotificationRuleMasterDAO;
import com.sapphireims.cmdb.dao.IAssetNotificationTemplateDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetNotificationTemplateMasterDAO;
import com.sapphireims.cmdb.dao.IAssetPrepostActionsDAO;
import com.sapphireims.cmdb.dao.IAssetRequestNumberFormatDAO;
import com.sapphireims.cmdb.dao.IAssetRolesPrivilegeDAO;
import com.sapphireims.cmdb.dao.IAssetTemplateAttachmentDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetcomponentfixedfieldsMappingDAO;
import com.sapphireims.cmdb.dao.IAssetconfigaccessDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetcontrolflowconfigAdditionalparamsDAO;
import com.sapphireims.cmdb.dao.IAssetfieldsTemplatedetailsDAO;
import com.sapphireims.cmdb.dao.IAssetfieldsTemplatemasterDAO;
import com.sapphireims.cmdb.dao.IAssetgenerationdetailsDAO;
import com.sapphireims.cmdb.dao.IAssetgenerationmasterDAO;
import com.sapphireims.cmdb.dao.IAssetmanagementFixedfieldsDAO;
import com.sapphireims.cmdb.dao.IAssetmanagementGlobalfieldsDAO;
import com.sapphireims.cmdb.dao.IAssetrolesDAO;
import com.sapphireims.cmdb.dao.IBarcodeConfigurationDAO;
import com.sapphireims.cmdb.dao.IBarcodeConfigurationDetailsDAO;
import com.sapphireims.cmdb.dao.ICiRelationshipMasterDAO;
import com.sapphireims.cmdb.dao.IGenericNotificationConfigDetailsDAO;
import com.sapphireims.cmdb.dao.IGenericNotificationConfigMasterDAO;
import com.sapphireims.cmdb.dao.IMiscDetailsDAO;
import com.sapphireims.cmdb.dao.IPrenotificationRuledetailsDAO;
import com.sapphireims.cmdb.dao.IUserAcceptanceConfigDAO;
import com.sapphireims.cmdb.dto.AssetModuleCopyExportResponce;
import com.sapphireims.cmdb.dto.AssetModuleCopyImportResponce;
import com.sapphireims.cmdb.dto.AssetModuleCopyRequestDTO;
import com.sapphireims.cmdb.dto.AssetModuleExportDTO;
import com.sapphireims.cmdb.dto.AssetModulesCopyImportResponce;
import com.sapphireims.cmdb.dto.ModuleCopyAttachmentsDTO;
import com.sapphireims.cmdb.dto.assetcopy.AssetModuleDTO;
import com.sapphireims.cmdb.dto.assetcopy.ModuleCopyType;
import com.sapphireims.cmdb.mindto.ModuleMinDTO;
import com.sapphireims.cmdb.model.AssetControlFlowConfigDetails;
import com.sapphireims.cmdb.model.AssetDepreciation;
import com.sapphireims.cmdb.model.AssetNotificationRuleMaster;
import com.sapphireims.cmdb.model.AssetNotificationTemplateMaster;
import com.sapphireims.cmdb.model.AssetPrepostActions;
import com.sapphireims.cmdb.model.AssetRequestNumberFormat;
import com.sapphireims.cmdb.model.AssetTemplateAttachmentdetails;
import com.sapphireims.cmdb.model.AssetcomponentfixedfieldsMapping;
import com.sapphireims.cmdb.model.AssetconfigaccessDetails;
import com.sapphireims.cmdb.model.AssetcontrolflowconfigAdditionalparams;
import com.sapphireims.cmdb.model.AssetcontrolflowconfigMaster;
import com.sapphireims.cmdb.model.AssetfieldsTemplatedetails;
import com.sapphireims.cmdb.model.AssetfieldsTemplatemaster;
import com.sapphireims.cmdb.model.Assetflowdetails;
import com.sapphireims.cmdb.model.Assetgenerationdetails;
import com.sapphireims.cmdb.model.Assetgenerationmaster;
import com.sapphireims.cmdb.model.AssetmanagementFixedfields;
import com.sapphireims.cmdb.model.AssetmanagementGlobalfields;
import com.sapphireims.cmdb.model.Assetroles;
import com.sapphireims.cmdb.model.AssetrolesPrivilege;
import com.sapphireims.cmdb.model.BarcodeConfiguration;
import com.sapphireims.cmdb.model.CiRelationshipMaster;
import com.sapphireims.cmdb.model.GenericNotificationConfigMaster;
import com.sapphireims.cmdb.service.IAssetModuleExportImportService;
import com.sapphireims.cmdb.service.IAssetTemplateAttachmentDetailsService;
import com.sapphireims.dao.IHibernateRepositoryOperations;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.ims.dto.DepartmentMasterDTO;
import com.sapphireims.ims.dto.ServiceDeskLocationMasterDTO;
import com.sapphireims.itsm.dao.IDepartmentMasterDAO;
import com.sapphireims.itsm.dao.IServicedeskLocationMasterDAO;
import com.sapphireims.itsm.dto.TenantDTO;
import com.sapphireims.itsm.model.Departmentmaster;
import com.sapphireims.itsm.model.Macrodetails;
import com.sapphireims.itsm.model.Servicedesklocationmaster;
import com.sapphireims.model.BaseModel;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssetModuleExportImportService
implements IAssetModuleExportImportService {
    @Autowired
    private IAssetModuleMasterDAO assetModuleMasterDAO;
    @Autowired
    @Qualifier(value="hibernateRepositoryOperations")
    protected IHibernateRepositoryOperations hibernateDaoOperations;
    @Autowired
    private IAssetrolesDAO assetrolesDAO;
    @Autowired
    private IAssetRolesPrivilegeDAO assetrolesprivilegeDAO;
    @Autowired
    private IAssetFlowDetailsDAO assetFlowDetailsDAO;
    @Autowired
    protected IAssetItemtypeMasterDAO assetItemtypeMasterDAO;
    @Autowired
    private IAssetcomponentfixedfieldsMappingDAO assetcomponentfixedfieldsMappingDAO;
    @Autowired
    private IAssetItemtypeConfigurationDAO assetItemtypeConfigurationDAO;
    @Autowired
    private IAssetconfigaccessDetailsDAO assetconfigaccessDetailsDAO;
    @Autowired
    private IAssetDepreciationDAO assetDepreciationDAO;
    @Autowired
    private IAssetControlFlowConfigMasterDAO assetControlFlowConfigMasterDAO;
    @Autowired
    private IAssetmanagementFixedfieldsDAO assetmanagementFixedfieldsDAO;
    @Autowired
    private IMiscDetailsDAO miscDetailsDAO;
    @Autowired
    private IAssetNotificationTemplateMasterDAO assetNotificationTemplateMasterDAO;
    @Autowired
    private IAssetNotificationTemplateDetailsDAO assetNotificationTemplateDetailsDAO;
    @Autowired
    private IAssetNotificationRuleMasterDAO assetNotificationRuleMasterDAO;
    @Autowired
    private IAssetNotificationRuleDetailsDAO assetNotificationRuleDetailsDAO;
    @Autowired
    private IGenericNotificationConfigDetailsDAO genericNotificationConfigDetailsDAO;
    @Autowired
    private IGenericNotificationConfigMasterDAO genericNotificationConfigMasterDAO;
    @Autowired
    private IAssetmanagementGlobalfieldsDAO assetmanagementGlobalfieldsDAO;
    @Autowired
    private IPrenotificationRuledetailsDAO prenotificationRuledetailsDAO;
    @Autowired
    private IBarcodeConfigurationDAO barcodeConfigurationDAO;
    @Autowired
    private IBarcodeConfigurationDetailsDAO barcodeConfigurationDetailsDAO;
    @Autowired
    private ICiRelationshipMasterDAO ciRelationshipMasterDAO;
    @Autowired
    private IAssetgenerationmasterDAO assetGenerationMasterDAO;
    @Autowired
    private IAssetgenerationdetailsDAO assetGenerationDetailsDAO;
    @Autowired
    private IAssetPrepostActionsDAO assetPrePostActionsDAO;
    @Autowired
    private IUserAcceptanceConfigDAO userAcceptanceConfigDAO;
    @Autowired
    private IAssetfieldsTemplatemasterDAO assetFieldsTemplateMasterDAO;
    @Autowired
    private IAssetfieldsTemplatedetailsDAO assetFieldsTemplateDetailsDAO;
    @Autowired
    private IAssetRequestNumberFormatDAO assetRequestNumberFormatDAO;
    @Autowired
    private IAssetTemplateAttachmentDetailsDAO assetTemplateAttachmentDetailsDAO;
    @Autowired
    private IAssetControlFlowConfigDetailsDAO assetControlFlowConfigDetailsDAO;
    @Autowired
    private IAssetcontrolflowconfigAdditionalparamsDAO assetcontrolflowconfigAdditionalparamsDAO;
    @Autowired
    private IAssetTemplateAttachmentDetailsService assetTemplateAttachmentDetailsService;
    @Autowired
    protected IServicedeskLocationMasterDAO servicedeskLocationMasterDAO;
    @Autowired
    protected IDepartmentMasterDAO departmentMasterDAO;
    @Autowired
    private IMacromasterDAO macromasterDAO;

    @Override
    @Transactional(readOnly=true)
    public AssetModuleCopyExportResponce exportModule(AssetModuleCopyRequestDTO request) throws DomainException, ValidationException {
        AssetModuleCopyExportResponce res = new AssetModuleCopyExportResponce(request);
        TenantDTO t = res.getTenant();
        if (res.getType() == ModuleCopyType.UAT_TO_PRODUCTION) {
            List locations = this.servicedeskLocationMasterDAO.getAll();
            t = t.setLocation(locations);
            List departments = this.departmentMasterDAO.getAll();
            t = t.setDepartment(departments);
            res.setTenant(t);
        }
        for (ModuleMinDTO mindto : request.getModuleIds()) {
            System.out.println("Module Ids Export Start:" + mindto.getModuleId());
            this.exportModule(mindto, res);
        }
        return res;
    }

    public void exportModule(ModuleMinDTO mindto, AssetModuleCopyExportResponce res) throws DomainException, ValidationException {
        System.out.println("Inside Export Module" + mindto.getModuleId());
        Validate.notNull((Object)((Object)mindto), (String)"Module DTO can't be Empty %s", (Object[])new Object[]{mindto});
        Validate.notNull((Object)mindto.getModuleId(), (String)"ModuleId can't be Empty %s", (Object[])new Object[]{mindto.getModuleId()});
        AssetModuleMaster modulemaster = (AssetModuleMaster)this.assetModuleMasterDAO.get(Integer.valueOf(mindto.getModuleId()));
        Validate.notNull((Object)((Object)modulemaster), (String)"Module Dosent Exist %s", (Object[])new Object[]{mindto.getModuleId()});
        if (mindto.getItemTypeIds() != null) {
            // empty if block
        }
        AssetModuleDTO module = new AssetModuleDTO();
        AssetModuleExportDTO aReq = new AssetModuleExportDTO(module, res.getTenant(), false, this.hibernateDaoOperations);
        AssetModuleMaster assetModuleMaster = this.assetModuleMasterDAO.getAssetModuleMasterById(mindto.getModuleId());
        aReq.setAssetModuleMaster(assetModuleMaster);
        List<GenericNotificationConfigMaster> genericNotificationMaster = this.genericNotificationConfigMasterDAO.getGenericNotificationConfigMasterByModuleId(mindto.getModuleId());
        aReq.setGenericNotificationConfigMaster(genericNotificationMaster);
        List<Assetroles> assetRoles = this.assetrolesDAO.getAssetRoles(mindto.getModuleId());
        aReq.setRoles(assetRoles);
        if (CollectionUtil.isNotEmpty(assetRoles)) {
            ArrayList<Integer> assetRoleIdList = new ArrayList<Integer>();
            for (Assetroles ar : assetRoles) {
                assetRoleIdList.add(ar.getAssetRoleId());
            }
            if (CollectionUtil.isNotEmpty(assetRoleIdList)) {
                List<AssetrolesPrivilege> assetRolesPrivilege = this.assetrolesprivilegeDAO.getAssetRolesPrivilge(assetRoleIdList);
                aReq.setRolesPrivilege(assetRolesPrivilege);
            }
        }
        List<Assetflowdetails> status = this.assetFlowDetailsDAO.getAssetFlowDetailsByModuleId(mindto.getModuleId(), 1);
        aReq.setStatus(status);
        List<AssetitemtypeMaster> itemTypes = null;
        itemTypes = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.assetItemtypeMasterDAO.getAssetitemtypeMasterByItemTypeIds(mindto.getItemTypeIds(), mindto.getModuleId()) : this.assetItemtypeMasterDAO.getAssetTypes(mindto.getModuleId());
        aReq.setItemTypes(itemTypes);
        List<AssetcomponentfixedfieldsMapping> preshippedFixedFields = null;
        preshippedFixedFields = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.assetcomponentfixedfieldsMappingDAO.getAssetcomponentfixedfieldsMappingByItemTypeIds(mindto.getItemTypeIds()) : this.assetcomponentfixedfieldsMappingDAO.getAssetcomponentfixedfieldsMappingByModuleId(mindto.getModuleId());
        aReq.setPreshippedFixedFields(preshippedFixedFields);
        List<AssetitemtypeConfiguration> additionalFields = null;
        additionalFields = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.assetItemtypeConfigurationDAO.getAssetitemtypeConfigurationByItemTypeIds(mindto.getItemTypeIds()) : this.assetItemtypeConfigurationDAO.getAssetitemtypeConfigurationByModuleId(mindto.getModuleId());
        aReq.setAdditionalFields(additionalFields, this.macromasterDAO);
        if (CollectionUtil.isNotEmpty(additionalFields)) {
            ArrayList<Integer> assetDetailsIdList = new ArrayList<Integer>();
            for (AssetitemtypeConfiguration assetaddifields : additionalFields) {
                assetDetailsIdList.add(assetaddifields.getId().getItemDetailsId());
            }
            if (CollectionUtil.isNotEmpty(assetDetailsIdList)) {
                List<AssetconfigaccessDetails> assetconfigaccessDetails = this.assetconfigaccessDetailsDAO.getAssetconfigaccessDetailsByAssetDetailsIds(assetDetailsIdList, 0);
                aReq.setAssetconfigaccessDetails(assetconfigaccessDetails);
            }
        }
        List<AssetDepreciation> assetDepreciation = null;
        assetDepreciation = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.assetDepreciationDAO.getAssetDepreciationByItemTypeIds(mindto.getItemTypeIds()) : this.assetDepreciationDAO.getAssetDepreciationByModuleId(mindto.getModuleId());
        aReq.setAssetDepreciation(assetDepreciation);
        List<AssetcontrolflowconfigMaster> lifecycleFields = this.assetControlFlowConfigMasterDAO.getAssetControlFlowConfigMasterDetails(mindto.getModuleId());
        aReq.setLifecycleFields(lifecycleFields);
        if (CollectionUtil.isNotEmpty(lifecycleFields)) {
            ArrayList<Integer> controlflowIds = new ArrayList<Integer>();
            for (AssetcontrolflowconfigMaster configmaster : lifecycleFields) {
                controlflowIds.add(configmaster.getId().getControlFlowId());
            }
            List<AssetconfigaccessDetails> lifecycleFieldAccessDetails = null;
            List<AssetControlFlowConfigDetails> lifecycleFielddDetails = null;
            List<AssetcontrolflowconfigAdditionalparams> lifecycleAdditionalFields = null;
            if (CollectionUtil.isNotEmpty(controlflowIds)) {
                lifecycleFielddDetails = this.assetControlFlowConfigDetailsDAO.getAssetControlFlowConfigDetails(controlflowIds);
                aReq.setLifecycleFieldsDetails(lifecycleFielddDetails);
                lifecycleAdditionalFields = this.assetcontrolflowconfigAdditionalparamsDAO.getAssetcontrolflowconfigAdditionalparamsByControlflowIds(controlflowIds);
                aReq.setLifecycleAdditionalFields(lifecycleAdditionalFields, this.macromasterDAO);
                if (CollectionUtil.isNotEmpty(lifecycleAdditionalFields)) {
                    ArrayList<Integer> assetDetailsIds = new ArrayList<Integer>();
                    for (AssetcontrolflowconfigAdditionalparams addiParam : lifecycleAdditionalFields) {
                        assetDetailsIds.add(addiParam.getId().getAssetDetailsId());
                    }
                    lifecycleFieldAccessDetails = this.assetconfigaccessDetailsDAO.getAssetconfigaccessDetailsByAssetDetailsIds(assetDetailsIds, 1);
                    aReq.setLifecycleFieldAccessDetails(lifecycleFieldAccessDetails);
                }
            }
        }
        List<AssetmanagementFixedfields> assetmanagementFixedfields = null;
        assetmanagementFixedfields = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.assetmanagementFixedfieldsDAO.getAssetmanagementDefaultFixedfieldsByItemTypeIds(mindto.getItemTypeIds(), mindto.getModuleId()) : this.assetmanagementFixedfieldsDAO.getAssetmanagementDefaultFixedfields(mindto.getModuleId());
        aReq.setAssetmanagementFixedfields(assetmanagementFixedfields);
        List miscDetails = this.miscDetailsDAO.getMiscDetails(Integer.valueOf(mindto.getModuleId()));
        aReq.setMiscDetails(miscDetails);
        List<AssetNotificationTemplateMaster> assetNotificationTemplateMaster = this.assetNotificationTemplateMasterDAO.getAssetNotificationTemplateMasterByTemplateType(mindto.getModuleId(), 1);
        aReq.setAssetNotificationTemplateMaster(assetNotificationTemplateMaster);
        List<AssetNotificationRuleMaster> assetNotificationRuleMaster = this.assetNotificationRuleMasterDAO.getAssetNotificationRuleMasterByRuleType(mindto.getModuleId(), 1);
        aReq.setAssetNotificationRuleMaster(assetNotificationRuleMaster);
        List<BarcodeConfiguration> barcodeConfiguration = null;
        barcodeConfiguration = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.barcodeConfigurationDAO.getBarcodeConfigurationBasedOnItemType(mindto.getItemTypeIds(), mindto.getModuleId()) : this.barcodeConfigurationDAO.getBarcodeConfiguration(mindto.getModuleId());
        aReq.setBarcodeConfiguration(barcodeConfiguration);
        List<CiRelationshipMaster> ciRelationshipMaster = null;
        ciRelationshipMaster = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.ciRelationshipMasterDAO.getCiRelationshipMasterByItemTypeIds(mindto.getItemTypeIds()) : this.ciRelationshipMasterDAO.getCiRelationshipMaster(mindto.getModuleId());
        aReq.setCiRelationshipMaster(ciRelationshipMaster);
        List<Assetgenerationmaster> assetGenerationMaster = this.assetGenerationMasterDAO.getAssetgenerationmasterDetails(mindto.getModuleId());
        aReq.setAssetGenerationMaster(assetGenerationMaster);
        if (CollectionUtil.isNotEmpty(assetGenerationMaster)) {
            ArrayList<Integer> categoryIds = new ArrayList<Integer>();
            for (Assetgenerationmaster masterDetails : assetGenerationMaster) {
                categoryIds.add(masterDetails.getCategoryId());
            }
            List<Assetgenerationdetails> assetGenerationDetails = this.assetGenerationDetailsDAO.getAssetGenerationDetails(categoryIds);
            aReq.setAssetGenerationDetails(assetGenerationDetails);
        }
        List<AssetRequestNumberFormat> assetRequestNumberFormat = null;
        assetRequestNumberFormat = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.assetRequestNumberFormatDAO.getAssetRequestNumberFormatByItemTypeIds(mindto.getItemTypeIds(), mindto.getModuleId()) : this.assetRequestNumberFormatDAO.getAssetRequestNumberFormat(mindto.getModuleId());
        aReq.setAssetRequestNumberFormat(assetRequestNumberFormat);
        List<AssetfieldsTemplatemaster> assetFieldsTemplateMaster = null;
        assetFieldsTemplateMaster = CollectionUtil.isNotEmpty(mindto.getItemTypeIds()) ? this.assetFieldsTemplateMasterDAO.getAssetfieldsTemplatemasterByItemTypeIds(mindto.getItemTypeIds()) : this.assetFieldsTemplateMasterDAO.getAssetfieldsTemplatemaster(mindto.getModuleId());
        aReq.setAssetFieldsTemplateMaster(assetFieldsTemplateMaster);
        if (CollectionUtil.isNotEmpty(assetFieldsTemplateMaster)) {
            ArrayList<Integer> templateIds = new ArrayList<Integer>();
            for (AssetfieldsTemplatemaster masterDetails : assetFieldsTemplateMaster) {
                templateIds.add(masterDetails.getTemplateId());
            }
            List<AssetfieldsTemplatedetails> assetFieldsTemplateDetails = this.assetFieldsTemplateDetailsDAO.getAssetFieldsTemplateDetails(templateIds);
            aReq.setAssetFieldsTemplateDetails(assetFieldsTemplateDetails);
            List<AssetTemplateAttachmentdetails> assetTemplateAttachmentDetails = this.assetTemplateAttachmentDetailsService.getAssetTemplateAttachmentdetailsById(templateIds, res.getMcaDTO());
            aReq.setAssetTemplateAttachmentDetails(assetTemplateAttachmentDetails);
        }
        List<AssetPrepostActions> assetPrePostAction = this.assetPrePostActionsDAO.getAssetPrepostActions(mindto.getModuleId());
        aReq.setAssetPrePostActions(assetPrePostAction);
        List userAcceptanceConfig = this.userAcceptanceConfigDAO.getUserAcceptanceConfig(Integer.valueOf(mindto.getModuleId()));
        aReq.setUserAcceptanceConfig(userAcceptanceConfig);
        module = module.setAssetModule(aReq).setAssetRole(aReq).setAssetControlFlowDetails(aReq).setItemTypeMaster(aReq).setAssetAdditionalFields(aReq, this.macromasterDAO).setAssetNumberFormat(aReq).setAssetPrePostActionDetails(aReq).setCiRelationtionshipDetails(aReq).setMiscConfiguration(aReq).setUserAcceptanceConfigDetails(aReq).setCustomizeBuiltinAttributes(aReq).setAssetLifeCycleFields(aReq, this.macromasterDAO).setAssetPreshippedFixedFields(aReq).setAssetGenerationMasterDTO(aReq).setAssetNotificationMaster(aReq).setBarcodeConfigDetails(aReq).setassetNotificatonRuleMaster(aReq).setAssetImport(aReq).setGenericNotificationCOnfigDetails(aReq).setGenericNotificationConfigMaster(aReq).setPrenotificationRuleDetails(aReq).setDepreciationData(aReq);
        res.getTenant().addModule(module);
    }

    @Override
    @Transactional(rollbackFor={DomainException.class, ValidationException.class})
    public AssetModulesCopyImportResponce importModule(AssetModuleCopyExportResponce request) throws DomainException, ValidationException {
        Validate.notNull((Object)request, (String)"Template Can't be empty", (Object[])new Object[0]);
        TenantDTO tenant = request.getTenant();
        AssetModulesCopyImportResponce responce = new AssetModulesCopyImportResponce();
        Validate.notNull((Object)((Object)tenant), (String)"Tenant cant be Empty", (Object[])new Object[0]);
        this.importMacro(tenant, responce);
        if (request.getType() == ModuleCopyType.UAT_TO_PRODUCTION) {
            this.importLocation(tenant);
            this.importDepartment(tenant);
        }
        for (AssetModuleDTO a : tenant.getModules()) {
            System.out.println("Import Starting");
            this.importModule(a, tenant, responce, request);
        }
        return responce;
    }

    @Transactional(rollbackFor={DomainException.class, ValidationException.class})
    private void importModule(AssetModuleDTO moduleDTO, TenantDTO tenant, AssetModulesCopyImportResponce responce, AssetModuleCopyExportResponce request) throws DomainException {
        System.out.println("Inside Import Module" + moduleDTO.getModuleId());
        Validate.notNull((Object)((Object)moduleDTO), (String)"Module cant be Empty { module id }", (Object[])new Object[0]);
        AssetModuleMaster existingModule = this.assetModuleMasterDAO.getAssetModuleMasterByName(moduleDTO.getModuleName());
        if (existingModule != null) {
            moduleDTO.setModuleName(moduleDTO.getModuleName().concat(" ").concat(new Date().toString()));
        }
        AssetModuleExportDTO module = new AssetModuleExportDTO(moduleDTO, tenant, true, this.hibernateDaoOperations);
        module = module.getAssetModuleMaster(moduleDTO);
        AssetModuleMaster newmodule = (AssetModuleMaster)this.assetModuleMasterDAO.save(module.getAssetModuleMaster());
        AssetModuleCopyImportResponce aResponce = responce.addAssetModuleCopyImportResponce(newmodule, moduleDTO);
        module.setAssetModule(newmodule);
        this.importAssetManagementGlobalFields(module);
        this.importGenericNotificationConfigMaster(module);
        this.importRoles(module, aResponce);
        this.importStatus(module, aResponce);
        this.importItemTypes(module, aResponce);
        this.importMiscConfiguration(module);
        this.importRolesPrivilege(module, request);
        this.importPreshippedFixedFields(module, aResponce);
        this.importAdditionalFields(module, aResponce);
        this.importAdditionalFieldDetails(module);
        this.importDepreciation(module);
        this.importLifecycleFields(module, aResponce);
        this.importLifecycleFieldDetails(module);
        this.importLifecycleAdditionalFields(module, aResponce);
        this.importLifecycleAdditionalFieldAccessDetails(module);
        this.importAssetGenerationMaster(module);
        this.importAssetGenerationDetails(module);
        this.importAssetRequestNumberFormat(module);
        this.importCustomizeBuiltInAttributes(module);
        this.importAssetImport(module);
        this.importAssetImportDetails(module, request);
        this.importAssetAttachmentDetails(module, request.getMcaDTO());
        this.importBarcodeConfiguration(module, aResponce);
        this.importRelationShipConfiguration(module);
        this.importUserAcceptanceConfig(module, request);
        this.importMailNotificationMaster(module);
        this.importMailNotificationDetails(module);
        this.importAssetPrePostActions(module);
        this.importAssetNotificationRuleMaster(module);
        this.importAssetNotificationRuleDetails(module);
    }

    public AssetModuleMaster getAssetModuleMaster(AssetModuleMaster module) {
        AssetModuleMaster assetmodulemaster = new AssetModuleMaster();
        assetmodulemaster.setModuleName(module.getModuleName());
        assetmodulemaster.setModuleType(module.getModuleType());
        assetmodulemaster.setDescription(module.getDescription());
        assetmodulemaster.setDisplayOrder(module.getDisplayOrder());
        assetmodulemaster.setIsVisible(module.getIsVisible());
        assetmodulemaster.setAssetNoGen(module.getAssetNoGen());
        AssetModuleMaster newmodule = (AssetModuleMaster)this.assetModuleMasterDAO.save(assetmodulemaster);
        return newmodule;
    }

    private void importRoles(AssetModuleExportDTO req, AssetModuleCopyImportResponce aResponce) {
        req = req.getRole(req, this.assetrolesDAO);
        aResponce.addRoles(req.getOldIdAssetRoles());
    }

    private void importRolesPrivilege(AssetModuleExportDTO req, AssetModuleCopyExportResponce request) {
        req = req.getRolePrivilege(req, request);
        this.assetrolesprivilegeDAO.batchSaveWithoutFlush(req.getRolesPrivilege());
    }

    private void importStatus(AssetModuleExportDTO req, AssetModuleCopyImportResponce aResponce) {
        req = req.getStatus(req);
        this.assetFlowDetailsDAO.saveAssetStatus(req);
        aResponce.addStatus(req.getOldIdAssetStatus());
    }

    private void importItemTypes(AssetModuleExportDTO req, AssetModuleCopyImportResponce aResponce) {
        req = req.getItemTypes(req);
        this.assetItemtypeMasterDAO.saveAssetItemTypeMaster(req);
        aResponce.addItemType(req.getOldIdItemTypes());
    }

    private void importPreshippedFixedFields(AssetModuleExportDTO req, AssetModuleCopyImportResponce aResponce) {
        req = req.getPreshippedFixedFields(req);
        this.assetcomponentfixedfieldsMappingDAO.saveAssetcomponentfixedfieldsMapping(req);
        aResponce.addPreshippedFixedFields(req.getOldIdPreshippedFixedfields());
    }

    private void importAssetGenerationMaster(AssetModuleExportDTO req) {
        req = req.getAssetGenerationMaster(req, this.assetGenerationMasterDAO);
    }

    private void importAssetGenerationDetails(AssetModuleExportDTO req) {
        req = req.getAssetGenerationDetails(req, this.assetGenerationDetailsDAO);
    }

    private void importAssetRequestNumberFormat(AssetModuleExportDTO req) {
        req = req.getAssetNumberFormat(req);
        this.assetRequestNumberFormatDAO.batchSaveWithoutFlush(req.getAssetRequestNumberFormat());
    }

    private void importAssetPrePostActions(AssetModuleExportDTO req) {
        req = req.getAssetPrePostActions(req);
        this.assetPrePostActionsDAO.batchSaveWithoutFlush(req.getAssetPrePostActions());
    }

    private void importAssetImport(AssetModuleExportDTO req) {
        req = req.getAssetImport(req, this.assetFieldsTemplateMasterDAO);
    }

    private void importAssetImportDetails(AssetModuleExportDTO req, AssetModuleCopyExportResponce request) {
        req = req.getAssetImportDetails(req, request);
        this.assetFieldsTemplateDetailsDAO.batchSaveWithoutFlush(req.getAssetFieldsTemplateDetails());
    }

    private void importAssetAttachmentDetails(AssetModuleExportDTO req, ModuleCopyAttachmentsDTO mcaDTO) {
        req = req.getAssetImportAttachmentDetails(req);
        this.assetTemplateAttachmentDetailsDAO.batchSaveWithoutFlush(req.getAssetTemplateAttachmentDetails());
        req = this.assetTemplateAttachmentDetailsService.replaceAndUpdateAssetTemplateAttachmentDetailsFiles(req, mcaDTO);
    }

    private void importUserAcceptanceConfig(AssetModuleExportDTO req, AssetModuleCopyExportResponce request) {
        req = req.getUserAcceptanceConfig(req, request);
        this.userAcceptanceConfigDAO.batchSaveWithoutFlush(req.getUserAcceptanceConfig());
    }

    private void importAdditionalFields(AssetModuleExportDTO req, AssetModuleCopyImportResponce aResponce) throws DomainException {
        req = req.getAdditionalFields(req);
        this.assetItemtypeConfigurationDAO.saveAssetItemtypeConfiguration(req);
        aResponce.addAdditionalFields(req.getOldIdAdditionalFields());
    }

    private void importAdditionalFieldDetails(AssetModuleExportDTO req) {
        req = req.getAdditionalFieldDetails(req);
        this.assetconfigaccessDetailsDAO.batchSaveWithoutFlush(req.getAssetconfigaccessDetails());
    }

    private void importDepreciation(AssetModuleExportDTO req) {
        req = req.getDepreciation(req);
        this.assetDepreciationDAO.batchSaveWithoutFlush(req.getAssetDepreciation());
    }

    private void importLifecycleFields(AssetModuleExportDTO req, AssetModuleCopyImportResponce aResponce) {
        req = req.getLifecycleFields(req);
        this.assetControlFlowConfigMasterDAO.saveAssetControlFlowConfigMaster(req);
        aResponce.addLifecycleFields(req.getOldIdLifecycleFields());
    }

    private void importLifecycleFieldDetails(AssetModuleExportDTO req) {
        req = req.getLifecycleFieldDetails(req);
        this.assetControlFlowConfigDetailsDAO.batchSaveWithoutFlush(req.getLifecycleFieldsDetails());
    }

    private void importLifecycleAdditionalFields(AssetModuleExportDTO req, AssetModuleCopyImportResponce aResponce) throws DomainException {
        req = req.getLifecycleAdditionalFields(req, this.assetcontrolflowconfigAdditionalparamsDAO);
        this.assetcontrolflowconfigAdditionalparamsDAO.saveAssetcontrolflowconfigAdditionalparams(req);
        aResponce.addLifecycleAddiFields(req.getOldIdLifecycleAddiFields());
    }

    private void importLifecycleAdditionalFieldAccessDetails(AssetModuleExportDTO req) {
        req = req.getLifecycleAdditionalFieldAccessDetails(req);
        this.assetconfigaccessDetailsDAO.batchSaveWithoutFlush(req.getLifecycleFieldAccessDetails());
    }

    private void importCustomizeBuiltInAttributes(AssetModuleExportDTO req) {
        req = req.getCustomizeBuiltInAttributes(req);
        this.assetmanagementFixedfieldsDAO.batchSaveWithoutFlush(req.getAssetmanagementFixedfields());
    }

    private void importMiscConfiguration(AssetModuleExportDTO req) {
        req = req.getMiscConfiguration(req, this.miscDetailsDAO);
    }

    private void importBarcodeConfiguration(AssetModuleExportDTO req, AssetModuleCopyImportResponce aResponce) {
        req = req.getBarcodeConfiguration(req, this.barcodeConfigurationDAO);
        aResponce.addBarcodeConfiguration(req.getOldIdBarcodeConfiguration());
    }

    private void importBarcodeConfigurationDetails(AssetModuleExportDTO req) {
        req = req.getBarcodeConfigurationDetails(req);
        this.barcodeConfigurationDetailsDAO.batchSaveWithoutFlush(req.getBarcodeConfigurationDetails());
    }

    private void importRelationShipConfiguration(AssetModuleExportDTO req) {
        req = req.getCiRelationshipMaster(req);
        this.ciRelationshipMasterDAO.batchSaveWithoutFlush(req.getCiRelationshipMaster());
    }

    private void importMailNotificationMaster(AssetModuleExportDTO req) {
        req = req.getMailNotificationMaster(req, this.assetNotificationTemplateMasterDAO);
    }

    private void importMailNotificationDetails(AssetModuleExportDTO req) {
        req = req.getMailNotificationDetails(req);
        this.assetNotificationTemplateMasterDAO.saveAssetNotificationDetails(req.getAssetNotificationTemplateDetails());
    }

    private void importAssetNotificationRuleMaster(AssetModuleExportDTO req) {
        req = req.getAssetNotificationRuleMaster(req, this.assetNotificationRuleMasterDAO);
    }

    private void importAssetNotificationRuleDetails(AssetModuleExportDTO req) {
        req = req.getAssetNotificationRuleDetails(req);
        this.assetNotificationRuleMasterDAO.saveAssetNotificationRuleDetails(req.getAssetNotificationRuleDetails());
    }

    private void importGenericNotificationConfigMaster(AssetModuleExportDTO req) {
        req = req.getGenericNotificationConfigMaster(req);
        this.genericNotificationConfigMasterDAO.batchSaveWithoutFlush(req.getGenericNotificationConfigMaster());
    }

    private void importAssetManagementGlobalFields(AssetModuleExportDTO req) {
        int newFieldId = this.assetmanagementGlobalfieldsDAO.getMaxAssetManagementGlobalFieldId();
        AssetModuleMaster amm = req.getAssetModuleMaster();
        AssetmanagementGlobalfields amgf = new AssetmanagementGlobalfields(newFieldId, amm.getModuleName(), amm.getModuleId(), amm.getModuleName(), 1);
        this.assetmanagementGlobalfieldsDAO.save(amgf);
    }

    private void importDepartment(TenantDTO tenant) {
        if (CollectionUtil.isNotEmpty(tenant.getDepartments())) {
            for (DepartmentMasterDTO d : tenant.getDepartments()) {
                Departmentmaster master = this.departmentMasterDAO.getDepartmentmasterByName(d.getDepartmentName());
                if (master == null) {
                    master = d.getDepartmentmaster();
                    this.departmentMasterDAO.save((BaseModel)master);
                }
                tenant = tenant.addDepartment(master, d.getDepartmentId());
            }
        }
    }

    private void importLocation(TenantDTO tenant) {
        if (CollectionUtil.isNotEmpty(tenant.getLocations())) {
            for (ServiceDeskLocationMasterDTO d : tenant.getLocations()) {
                Servicedesklocationmaster master = this.servicedeskLocationMasterDAO.getServicedesklocationmasterByName(d.getLocationName());
                if (master == null) {
                    master = d.getServiceDeskLocationMaster();
                    this.servicedeskLocationMasterDAO.save((BaseModel)master);
                }
                tenant = tenant.addLocation(master, d.getLocationId());
            }
        }
    }

    private void importMacro(TenantDTO tenant, AssetModulesCopyImportResponce responce) {
        if (CollectionUtil.isNotEmpty(tenant.getMacromasters())) {
            HashMap<Integer, Macromaster> mapMacromasters = new HashMap<Integer, Macromaster>(tenant.getMacromasters().size());
            for (MacromasterDTO m : tenant.getMacromasters()) {
                Macromaster master = this.macromasterDAO.getUniqueMacromasterByMacroName(m.getMacroName());
                if (master == null) {
                    master = m.getMacromasterEntity();
                    this.macromasterDAO.save(master);
                    this.hibernateDaoOperations.flush();
                    responce.addMacros(master, m);
                    m.setPresentInDb(false);
                } else {
                    m.setPresentInDb(true);
                }
                this.addToMapMacromasters(mapMacromasters, master, m);
            }
            tenant.setMapMacromastersEntity(mapMacromasters);
            this.saveMacrodetailsGriddatasAndDetails(tenant);
        }
    }

    private void saveMacrodetailsGriddatasAndDetails(TenantDTO tenant) {
        if (CollectionUtil.isNotEmpty(tenant.getMacromasters())) {
            for (MacromasterDTO mDto : tenant.getMacromasters()) {
                Serializable mGridEntity;
                if (mDto.isPresentInDb()) continue;
                Macromaster master = tenant.getMapMacromastersEntity().get(mDto.getMacroid());
                if (CollectionUtil.isNotEmpty(mDto.getMacrodetailsGriddatas())) {
                    for (MacrodetailsGriddataDTO macrodetailsGriddataDTO : mDto.getMacrodetailsGriddatas()) {
                        mGridEntity = macrodetailsGriddataDTO.getMacrodetailsGriddataEntity(master, tenant.getMapMacromastersEntity().get(macrodetailsGriddataDTO.getColumnMacroId()).getMacroid());
                        this.hibernateDaoOperations.save(mGridEntity);
                    }
                }
                if (CollectionUtil.isNotEmpty(mDto.getMacrodetailses())) {
                    for (MacrodetailsDTO macrodetailsDTO : mDto.getMacrodetailses()) {
                        Macrodetails d = macrodetailsDTO.getMacrodetailsEntity(master);
                        this.hibernateDaoOperations.save(d);
                    }
                }
                if (!CollectionUtil.isNotEmpty(mDto.getCalendareventGridData())) continue;
                for (MacrodetailsCalendareventGriddataDTO macrodetailsCalendareventGriddataDTO : mDto.getCalendareventGridData()) {
                    mGridEntity = macrodetailsCalendareventGriddataDTO.getMacrodetailsCalendareventGriddata(master, tenant.getMapMacromastersEntity().get(macrodetailsCalendareventGriddataDTO.getColumnMacroId()).getMacroid());
                    this.hibernateDaoOperations.save(mGridEntity);
                }
            }
        }
    }

    private void addToMapMacromasters(HashMap<Integer, Macromaster> mapMacromasters, Macromaster m, MacromasterDTO dto) {
        if (!mapMacromasters.containsKey(dto.getMacroid())) {
            mapMacromasters.put(dto.getMacroid(), m);
        }
    }
}

