/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.service.impl;

import com.sapphireims.cmdb.dao.IAssetRequestNumberFormatDAO;
import com.sapphireims.cmdb.dto.AssetDTO;
import com.sapphireims.cmdb.dto.AssetItemtypeConfigurationDTO;
import com.sapphireims.cmdb.dto.AssetNumberFormatParamDTO;
import com.sapphireims.cmdb.dto.AssetRequestNumberFormatDTO;
import com.sapphireims.cmdb.dto.asset.AssetAttribute;
import com.sapphireims.cmdb.dto.assetcopy.AssetModuleDTO;
import com.sapphireims.cmdb.service.IAssetMasterDataService;
import com.sapphireims.cmdb.service.IAssetRequestNumberFormatService;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.dao.IDepartmentMasterDAO;
import com.sapphireims.itsm.dao.IServicedeskLocationMasterDAO;
import com.sapphireims.itsm.model.Departmentmaster;
import com.sapphireims.itsm.model.Servicedesklocationmaster;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AssetRequestNumberFormatService
implements IAssetRequestNumberFormatService {
    @Value(value="${cache.metadata}")
    private boolean cache;
    public static final Logger logger = LoggerFactory.getLogger((String)"ims");
    @Autowired
    private IAssetMasterDataService assetMasterDataService;
    @Autowired
    private IAssetRequestNumberFormatDAO assetRequestNumberFormatDAO;
    @Autowired
    private IServicedeskLocationMasterDAO servicedeskLocationMasterDAO;
    @Autowired
    private IDepartmentMasterDAO departmentMasterDAO;

    @Override
    public String getRequestAssetNumber(AssetNumberFormatParamDTO s, AssetDTO t) throws DomainException, ValidationException {
        s.setRecordParameters(this.getAssetNumberParameter(t));
        return this.assetRequestNumberFormatDAO.getAssetNumber(t.getItemType().getItemTypeId(), s);
    }

    private String getAssetNumberParameter(AssetDTO master) throws DomainException, ValidationException {
        List<AssetItemtypeConfigurationDTO> additionalParms;
        AssetModuleDTO module = this.assetMasterDataService.getAssetModule(master.getItemType().getAssetModuleId(), master.getSiteId());
        List<AssetRequestNumberFormatDTO> assetRequestNumberFormats = module.getAssetRequestNumberFormatDetails();
        AssetRequestNumberFormatDTO assettypeRequestNumberFormats = module.getAssetRequestNumberFormatDetails(master.getItemType().getItemTypeId());
        String assetNumberFormat = null;
        if (assettypeRequestNumberFormats != null) {
            assetNumberFormat = assettypeRequestNumberFormats.getPrefix();
            if (StringUtil.isEmpty((String)assetNumberFormat)) {
                return "";
            }
        } else if (CollectionUtil.isNotEmpty(assetRequestNumberFormats)) {
            assetNumberFormat = assetRequestNumberFormats.get(0).getPrefix();
            if (StringUtil.isEmpty((String)assetNumberFormat)) {
                return "";
            }
        } else {
            return "";
        }
        if (assetNumberFormat.contains("{}")) {
            assetNumberFormat = assetNumberFormat.replace("{}", master.getLocation().getName());
        }
        if (assetNumberFormat.contains("{AssetType}")) {
            assetNumberFormat = assetNumberFormat.replace("{AssetType}", master.getItemType().getFormat());
        }
        if (assetNumberFormat.contains("{Location}")) {
            assetNumberFormat = master.getLocation() != null ? assetNumberFormat.replace("{Location}", master.getLocation().getName()) : assetNumberFormat.replace("{Location}", "");
        }
        if (assetNumberFormat.contains("{Location Short Name}")) {
            if (master.getLocation() != null) {
                Servicedesklocationmaster locationShortName = this.servicedeskLocationMasterDAO.getLocationByName(master.getLocation().getName());
                if (locationShortName != null) {
                    assetNumberFormat = assetNumberFormat.replace("{Location Short Name}", locationShortName.getShortname());
                }
            } else {
                assetNumberFormat = assetNumberFormat.replace("{Location Short Name}", "");
            }
        }
        if (assetNumberFormat.contains("{Department}")) {
            assetNumberFormat = master.getDepartment() != null ? assetNumberFormat.replace("{Department}", master.getDepartment().getName()) : assetNumberFormat.replace("{Department}", "");
        }
        if (assetNumberFormat.contains("{Department Short Name}")) {
            if (master.getDepartment() != null) {
                Departmentmaster departmentShortName = this.departmentMasterDAO.getByName(master.getDepartment().getName());
                if (departmentShortName != null) {
                    assetNumberFormat = assetNumberFormat.replace("{Department Short Name}", departmentShortName.getShortname());
                }
            } else {
                assetNumberFormat = assetNumberFormat.replace("{Department Short Name}", "");
            }
        }
        if (assetNumberFormat.contains("{SystemName}")) {
            assetNumberFormat = master.getSystemName() != null ? assetNumberFormat.replace("{SystemName}", master.getSystemName()) : assetNumberFormat.replace("{SystemName}", "");
        }
        if (assetNumberFormat.contains("{ExtensionNo}")) {
            assetNumberFormat = master.getExtensionNumber() != null ? assetNumberFormat.replace("{ExtensionNo}", master.getExtensionNumber()) : assetNumberFormat.replace("{ExtensionNo}", "");
        }
        if (assetNumberFormat.contains("{OperatingSystem}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getOperatingSystem() != null ? assetNumberFormat.replace("{OperatingSystem}", master.getAssetHardwareOsComponents().getOperatingSystem()) : assetNumberFormat.replace("{OperatingSystem}", "");
        }
        if (assetNumberFormat.contains("{Processor}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getProcessor() != null ? assetNumberFormat.replace("{Processor}", master.getAssetHardwareOsComponents().getProcessor()) : assetNumberFormat.replace("{Processor}", "");
        }
        if (assetNumberFormat.contains("{RAMSize}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getRamsize() != null ? assetNumberFormat.replace("{RAMSize}", master.getAssetHardwareOsComponents().getRamsize()) : assetNumberFormat.replace("{RAMSize}", "");
        }
        if (assetNumberFormat.contains("{HardDiskSize}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getHardDiskSize() != null ? assetNumberFormat.replace("{HardDiskSize}", master.getAssetHardwareOsComponents().getHardDiskSize()) : assetNumberFormat.replace("{HardDiskSize}", "");
        }
        if (assetNumberFormat.contains("{Manufacturer}")) {
            assetNumberFormat = master.getAssetmakeManufacturer() != null && master.getAssetmakeManufacturer().getManufacturer() != null ? assetNumberFormat.replace("{Manufacturer}", master.getAssetmakeManufacturer().getManufacturer()) : assetNumberFormat.replace("{Manufacturer}", "");
        }
        if (assetNumberFormat.contains("{Model}")) {
            assetNumberFormat = master.getAssetmakeManufacturer() != null && master.getAssetmakeManufacturer().getModel() != null ? assetNumberFormat.replace("{Model}", master.getAssetmakeManufacturer().getModel()) : assetNumberFormat.replace("{Model}", "");
        }
        if (assetNumberFormat.contains("{SerialNumber}")) {
            assetNumberFormat = master.getAssetmakeManufacturer() != null && master.getAssetmakeManufacturer().getSerialNumber() != null ? assetNumberFormat.replace("{SerialNumber}", master.getAssetmakeManufacturer().getSerialNumber()) : assetNumberFormat.replace("{SerialNumber}", "");
        }
        if (assetNumberFormat.contains("{Vendor}")) {
            assetNumberFormat = master.getAssetpurchase() != null && master.getAssetpurchase().getVendor() != null ? assetNumberFormat.replace("{Vendor}", master.getAssetpurchase().getVendor()) : assetNumberFormat.replace("{Vendor}", "");
        }
        if (assetNumberFormat.contains("{PurchaseDate}")) {
            assetNumberFormat = master.getAssetpurchase() != null && master.getAssetpurchase().getPurchaseDate() != null ? assetNumberFormat.replace("{PurchaseDate}", master.getAssetpurchase().getPurchaseDate()) : assetNumberFormat.replace("{PurchaseDate}", "");
        }
        if (assetNumberFormat.contains("{PONumber}")) {
            assetNumberFormat = master.getAssetpurchase() != null && master.getAssetpurchase().getPonumber() != null ? assetNumberFormat.replace("{PONumber}", master.getAssetpurchase().getPonumber()) : assetNumberFormat.replace("{PONumber}", "");
        }
        if (assetNumberFormat.contains("{InvoiceNumber}")) {
            assetNumberFormat = master.getAssetpurchase() != null && master.getAssetpurchase().getInvoiceNumber() != null ? assetNumberFormat.replace("{InvoiceNumber}", master.getAssetpurchase().getInvoiceNumber()) : assetNumberFormat.replace("{InvoiceNumber}", "");
        }
        if (assetNumberFormat.contains("{InvoiceDate}")) {
            assetNumberFormat = master.getAssetpurchase() != null && master.getAssetpurchase().getInvoiceDate() != null ? assetNumberFormat.replace("{InvoiceDate}", master.getAssetpurchase().getInvoiceDate()) : assetNumberFormat.replace("{InvoiceDate}", "");
        }
        if (assetNumberFormat.contains("{GRNNumber}")) {
            assetNumberFormat = master.getAssetpurchase() != null && master.getAssetpurchase().getGrnnumber() != null ? assetNumberFormat.replace("{GRNNumber}", master.getAssetpurchase().getGrnnumber()) : assetNumberFormat.replace("{GRNNumber}", "");
        }
        if (assetNumberFormat.contains("{GRNDate}")) {
            assetNumberFormat = master.getAssetpurchase() != null && master.getAssetpurchase().getGrndate() != null ? assetNumberFormat.replace("{GRNDate}", master.getAssetpurchase().getGrndate()) : assetNumberFormat.replace("{GRNDate}", "");
        }
        if (assetNumberFormat.contains("{WarrantyStartDate}")) {
            assetNumberFormat = master.getAssetamcWarranty() != null && master.getAssetamcWarranty().getWarrantyStartDate() != null ? assetNumberFormat.replace("{WarrantyStartDate}", master.getAssetamcWarranty().getWarrantyStartDate()) : assetNumberFormat.replace("{WarrantyStartDate}", "");
        }
        if (assetNumberFormat.contains("{WarrantyEndDate}")) {
            assetNumberFormat = master.getAssetamcWarranty() != null && master.getAssetamcWarranty().getWarrantyEndDate() != null ? assetNumberFormat.replace("{WarrantyEndDate}", master.getAssetamcWarranty().getWarrantyEndDate()) : assetNumberFormat.replace("{WarrantyEndDate}", "");
        }
        if (assetNumberFormat.contains("{AMCStartDate}")) {
            assetNumberFormat = master.getAssetamcWarranty() != null && master.getAssetamcWarranty().getAmcstartDate() != null ? assetNumberFormat.replace("{AMCStartDate}", master.getAssetamcWarranty().getAmcstartDate()) : assetNumberFormat.replace("{AMCStartDate}", "");
        }
        if (assetNumberFormat.contains("{AMCEndDate}")) {
            assetNumberFormat = master.getAssetamcWarranty() != null && master.getAssetamcWarranty().getAmcendDate() != null ? assetNumberFormat.replace("{AMCEndDate}", master.getAssetamcWarranty().getAmcendDate()) : assetNumberFormat.replace("{AMCEndDate}", "");
        }
        if (assetNumberFormat.contains("{DeploymentDate}")) {
            assetNumberFormat = master.getAssetamcWarranty() != null && master.getAssetamcWarranty().getDeploymentDate() != null ? assetNumberFormat.replace("{DeploymentDate}", master.getAssetamcWarranty().getDeploymentDate()) : assetNumberFormat.replace("{DeploymentDate}", "");
        }
        if (assetNumberFormat.contains("{AssetCost}")) {
            assetNumberFormat = master.getAssetcostDetails() != null && master.getAssetcostDetails().getAssetCost() != null ? assetNumberFormat.replace("{AssetCost}", master.getAssetcostDetails().getAssetCost()) : assetNumberFormat.replace("{AssetCost}", "");
        }
        if (assetNumberFormat.contains("{CurrentCost}")) {
            assetNumberFormat = master.getAssetcostDetails() != null && master.getAssetcostDetails().getCurrentCost() != null ? assetNumberFormat.replace("{CurrentCost}", master.getAssetcostDetails().getCurrentCost()) : assetNumberFormat.replace("{CurrentCost}", "");
        }
        if (assetNumberFormat.contains("{BatterySerialNumber}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getBatterySerialNumber() != null ? assetNumberFormat.replace("{BatterySerialNumber}", master.getAssetHardwareOsComponents().getBatterySerialNumber()) : assetNumberFormat.replace("{BatterySerialNumber}", "");
        }
        if (assetNumberFormat.contains("{DisplaySize}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getDisplaySize() != null ? assetNumberFormat.replace("{DisplaySize}", master.getAssetHardwareOsComponents().getDisplaySize()) : assetNumberFormat.replace("{DisplaySize}", "");
        }
        if (assetNumberFormat.contains("{InternalStorage}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getInternalStorage() != null ? assetNumberFormat.replace("{InternalStorage}", master.getAssetHardwareOsComponents().getInternalStorage()) : assetNumberFormat.replace("{InternalStorage}", "");
        }
        if (assetNumberFormat.contains("{ExternalStorageMake}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getExternalStorageMake() != null ? assetNumberFormat.replace("{ExternalStorageMake}", master.getAssetHardwareOsComponents().getExternalStorageMake()) : assetNumberFormat.replace("{ExternalStorageMake}", "");
        }
        if (assetNumberFormat.contains("{ExternalStorageCapacity}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getExternalStorageCapacity() != null ? assetNumberFormat.replace("{ExternalStorageCapacity}", master.getAssetHardwareOsComponents().getExternalStorageCapacity()) : assetNumberFormat.replace("{ExternalStorageCapacity}", "");
        }
        if (assetNumberFormat.contains("{OSVersion}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getOsversion() != null ? assetNumberFormat.replace("{OSVersion}", master.getAssetHardwareOsComponents().getOsversion()) : assetNumberFormat.replace("{OSVersion}", "");
        }
        if (assetNumberFormat.contains("{IMEINumber}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getImeinumber() != null ? assetNumberFormat.replace("{IMEINumber}", master.getAssetHardwareOsComponents().getImeinumber()) : assetNumberFormat.replace("{IMEINumber}", "");
        }
        if (assetNumberFormat.contains("{TotalPorts}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getTotalPorts() != null ? assetNumberFormat.replace("{TotalPorts}", master.getAssetHardwareOsComponents().getTotalPorts()) : assetNumberFormat.replace("{TotalPorts}", "");
        }
        if (assetNumberFormat.contains("ConnectivityType}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getConnectivityType() != null ? assetNumberFormat.replace("{ConnectivityType}", master.getAssetHardwareOsComponents().getConnectivityType()) : assetNumberFormat.replace("{ConnectivityType}", "");
        }
        if (assetNumberFormat.contains("{PrinterType}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getPrinterType() != null ? assetNumberFormat.replace("{PrinterType}", master.getAssetHardwareOsComponents().getPrinterType()) : assetNumberFormat.replace("{PrinterType}", "");
        }
        if (assetNumberFormat.contains("{PrintMode}")) {
            assetNumberFormat = master.getAssetHardwareOsComponents() != null && master.getAssetHardwareOsComponents().getPrintMode() != null ? assetNumberFormat.replace("{Current Cost}", master.getAssetHardwareOsComponents().getPrintMode()) : assetNumberFormat.replace("{Current Cost}", "");
        }
        if (assetNumberFormat.contains("{DD}") || assetNumberFormat.contains("{MM}") || assetNumberFormat.contains("{YY}") || assetNumberFormat.contains("{YYYY}")) {
            Date dNow = new Date();
            SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd");
            String date = ft.format(dNow);
            String[] dateArr = date.split("\\.");
            if (assetNumberFormat.contains("{DD}")) {
                assetNumberFormat = assetNumberFormat.replace("{DD}", dateArr[2]);
            }
            if (assetNumberFormat.contains("{MM}")) {
                assetNumberFormat = assetNumberFormat.replace("{MM}", dateArr[1]);
            }
            if (assetNumberFormat.contains("{YYYY}")) {
                assetNumberFormat = assetNumberFormat.replace("{YYYY}", dateArr[0]);
            }
            if (assetNumberFormat.contains("{YY}")) {
                assetNumberFormat = assetNumberFormat.replace("{YY}", dateArr[0].substring(2));
            }
        }
        if (CollectionUtil.isNotEmpty(additionalParms = module.getAssetType(master.getItemType().getItemTypeId()).getAssetItemtypeConfigurationDTO()) && master.getAdditionalParams() != null) {
            for (AssetItemtypeConfigurationDTO a : additionalParms) {
                if (!assetNumberFormat.contains("{" + a.getParameterName() + "}")) continue;
                try {
                    AssetAttribute att = (AssetAttribute)((Object)PropertyUtils.getProperty((Object)((Object)master.getAdditionalParams()), (String)a.getFieldName()));
                    if (att != null) {
                        assetNumberFormat = assetNumberFormat.replace("{" + a.getParameterName() + "}", att.getData());
                        continue;
                    }
                    assetNumberFormat = assetNumberFormat.replace("{" + a.getParameterName() + "}", "");
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Invalid Property " + a.getFieldName());
                }
            }
        }
        return assetNumberFormat;
    }
}

