/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.service.impl;

import com.sapphireims.cmdb.dao.IAssetTemplateAttachmentDetailsDAO;
import com.sapphireims.cmdb.dto.AssetModuleExportDTO;
import com.sapphireims.cmdb.dto.ModuleCopyAttachmentsDTO;
import com.sapphireims.cmdb.model.AssetTemplateAttachmentdetails;
import com.sapphireims.cmdb.model.AssetfieldsTemplatedetails;
import com.sapphireims.cmdb.service.IAssetTemplateAttachmentDetailsService;
import com.sapphireims.model.BaseModel;
import com.sapphireims.util.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetTemplateAttachmentDetailsService
implements IAssetTemplateAttachmentDetailsService {
    private final Logger logger = LoggerFactory.getLogger(AssetTemplateAttachmentDetailsService.class);
    @Autowired
    protected IAssetTemplateAttachmentDetailsDAO assetTemplateAttachemntsDetailsDAO;

    @Override
    public List<AssetTemplateAttachmentdetails> getAssetTemplateAttachmentdetailsById(List<Integer> ids, ModuleCopyAttachmentsDTO mcaDTO) {
        List<AssetTemplateAttachmentdetails> assetTemplateAttachmentDetails = this.assetTemplateAttachemntsDetailsDAO.getAssetTemplateAttachmentDetails(ids);
        if (CollectionUtil.isNotEmpty(assetTemplateAttachmentDetails) && mcaDTO != null) {
            Object customerAliasName = "";
            if (mcaDTO.getCustomerAliasName() != null && !mcaDTO.getCustomerAliasName().equals("")) {
                customerAliasName = "\\" + mcaDTO.getCustomerAliasName();
            }
            String sourcePath = mcaDTO.getWebManagementPath() + "\\SapphireUploadFiles" + (String)customerAliasName;
            String destinationPath = mcaDTO.getModulePath();
            for (AssetTemplateAttachmentdetails sqtadObject : assetTemplateAttachmentDetails) {
                String[] aName = sqtadObject.getAttachment().split("\\$@pEr@t0r\\$");
                String oldUIPath = sourcePath + "\\" + aName[1];
                try {
                    File oldUIFile = new File(oldUIPath);
                    if (!oldUIFile.exists() || oldUIFile.isDirectory()) continue;
                    FileUtils.copyFile((File)oldUIFile, (File)FileUtils.getFile((String[])new String[]{destinationPath + "\\" + aName[1]}));
                }
                catch (IOException ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return assetTemplateAttachmentDetails;
    }

    @Override
    public AssetModuleExportDTO replaceAndUpdateAssetTemplateAttachmentDetailsFiles(AssetModuleExportDTO moduleDTO, ModuleCopyAttachmentsDTO mcaDTO) {
        if (mcaDTO != null) {
            Object customerAliasName = "";
            if (mcaDTO.getCustomerAliasName() != null && !mcaDTO.getCustomerAliasName().equals("")) {
                customerAliasName = "\\" + mcaDTO.getCustomerAliasName();
            }
            String sourcePath = mcaDTO.getWebManagementPath() + "\\SapphireUploadFiles" + (String)customerAliasName;
            String fileLoc = mcaDTO.getModulePath();
            ArrayList<AssetTemplateAttachmentdetails> sqtadList = new ArrayList<AssetTemplateAttachmentdetails>();
            ArrayList<AssetfieldsTemplatedetails> aftdList = new ArrayList<AssetfieldsTemplatedetails>();
            if (!moduleDTO.getOldIdTemplateAttachmentDetails().isEmpty()) {
                for (Map.Entry<String, AssetTemplateAttachmentdetails> entry : moduleDTO.getOldIdTemplateAttachmentDetails().entrySet()) {
                    AssetTemplateAttachmentdetails stadObject = entry.getValue();
                    String oldParentId = entry.getKey();
                    String[] oldParentIdArray = oldParentId.split("\\$@pEr@t0r\\$");
                    String TimeInMilliSec = "" + Calendar.getInstance().getTimeInMillis();
                    File oldUIFromCopy = new File(fileLoc + "\\" + oldParentIdArray[1]);
                    try {
                        if (!oldUIFromCopy.exists() || oldUIFromCopy.isDirectory()) continue;
                        String attachmentName = stadObject.getItemDetailsId() + "_" + stadObject.getAttachmentName();
                        String fileName = mcaDTO.getSessionId() + "_" + TimeInMilliSec + "_" + mcaDTO.getUserName() + "_" + attachmentName;
                        FileUtils.copyFile((File)oldUIFromCopy, (File)FileUtils.getFile((String[])new String[]{sourcePath + "\\" + fileName}));
                        String tempFileName = stadObject.getAttachmentName() + "$@pEr@t0r$" + fileName;
                        stadObject.setAttachment(tempFileName);
                        sqtadList.add(stadObject);
                        moduleDTO.getOldIdAssetFieldsTemplateDetails().get(stadObject.getImportTemplateId() + "_" + stadObject.getItemDetailsId()).setFieldValue(tempFileName);
                    }
                    catch (IOException ex) {
                        this.logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                moduleDTO.setAssetTemplateAttachmentDetails(sqtadList);
                for (Map.Entry<String, BaseModel> entry : moduleDTO.getOldIdAssetFieldsTemplateDetails().entrySet()) {
                    aftdList.add((AssetfieldsTemplatedetails)entry.getValue());
                }
                moduleDTO.setAssetFieldsTemplateDetails(aftdList);
            }
        }
        return moduleDTO;
    }
}

