/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.service.impl;

import com.sapphire.itsm.mailrouting.dto.MacromasterDTO;
import com.sapphire.itsm.mailrouting.model.AssetitemtypeConfiguration;
import com.sapphire.itsm.mailrouting.model.AssetitemtypeMaster;
import com.sapphireims.cmdb.dao.IAssetDepreciationDAO;
import com.sapphireims.cmdb.dao.IAssetItemtypeConfigurationDAO;
import com.sapphireims.cmdb.dao.IAssetItemtypeMasterDAO;
import com.sapphireims.cmdb.dao.IAssetcomponentfixedfieldsMappingDAO;
import com.sapphireims.cmdb.dao.IAssetmanagementFixedfieldsDAO;
import com.sapphireims.cmdb.dto.AssetDepreciationDTO;
import com.sapphireims.cmdb.dto.AssetItemtypeConfigurationDTO;
import com.sapphireims.cmdb.dto.AssetItemtypeMasterDTO;
import com.sapphireims.cmdb.dto.AssetcomponentfixedfieldsMappingDTO;
import com.sapphireims.cmdb.dto.AssetmanagementFixedfieldsDTO;
import com.sapphireims.cmdb.dto.assetcopy.AssetTypeDTO;
import com.sapphireims.cmdb.model.AssetDepreciation;
import com.sapphireims.cmdb.model.AssetcomponentfixedfieldsMapping;
import com.sapphireims.cmdb.model.AssetmanagementFixedfields;
import com.sapphireims.cmdb.service.IAssetTypeDataService;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.itsm.service.IMacroService;
import com.sapphireims.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetTypeDataService
implements IAssetTypeDataService {
    @Autowired
    private IAssetItemtypeMasterDAO assetItemtypeMasterDAO;
    @Autowired
    private IAssetmanagementFixedfieldsDAO assetmanagementFixedfieldsDAO;
    @Autowired
    private IAssetcomponentfixedfieldsMappingDAO assetcomponentfixedfieldsMappingDAO;
    @Autowired
    private IAssetItemtypeConfigurationDAO assetItemtypeConfigurationDAO;
    @Autowired
    private IAssetDepreciationDAO assetDepreciationDAO;
    @Autowired
    private IMacroService macroService;

    @Override
    public List<AssetTypeDTO> getAssetTypes(Integer moduleId) throws DomainException, ValidationException {
        ArrayList<AssetTypeDTO> AssetTypeDTOs = null;
        ArrayList<AssetItemtypeMasterDTO> assetItemtypeMasterDetails = null;
        List<AssetitemtypeMaster> details = this.assetItemtypeMasterDAO.getAssetTypes(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetItemtypeMasterDetails = new ArrayList<AssetItemtypeMasterDTO>(details.size());
            AssetTypeDTOs = new ArrayList<AssetTypeDTO>(details.size());
            for (AssetitemtypeMaster master : details) {
                AssetTypeDTO.Builder assetTypeBuilder = AssetTypeDTO.builder();
                assetItemtypeMasterDetails.add(new AssetItemtypeMasterDTO(master));
                assetTypeBuilder.withItemTypeId(master.getId().getItemTypeId());
                assetTypeBuilder.withSiteId(master.getId().getSiteId());
                assetTypeBuilder.withItemType(master.getItemType());
                assetTypeBuilder.withDescription(master.getDescription());
                assetTypeBuilder.withAssetModuleId(master.getAssetModuleId());
                assetTypeBuilder.withMappingKeyType(master.getMappingKeyType());
                assetTypeBuilder.withCmdbViewPrefix(master.getCmdbViewPrefix());
                assetTypeBuilder.withFormat(master.getFormat());
                assetTypeBuilder.withIsDisplay(master.getIsDisplay());
                assetTypeBuilder.withIsInBuilt(master.getIsInBuilt());
                assetTypeBuilder.withAssetmanagementFixedfieldsDTO(this.getAssetmanagementFixedfields(master.getId().getItemTypeId(), moduleId));
                assetTypeBuilder.withAssetcomponentfixedfieldsMappingDTO(this.getAssetcomponentfixedfieldsMapping(master.getId().getItemTypeId()));
                assetTypeBuilder.withAssetItemtypeConfigurationDTO(this.getAssetitemtypeConfiguration(master.getId().getItemTypeId()));
                assetTypeBuilder.withAssetDepreciationDTO(this.getAssetDepreciation(master.getId().getItemTypeId()));
                AssetTypeDTOs.add(assetTypeBuilder.build());
            }
        }
        return AssetTypeDTOs;
    }

    private List<AssetmanagementFixedfieldsDTO> getAssetmanagementFixedfields(Integer itemTypeId, Integer moduleId) {
        ArrayList<AssetmanagementFixedfieldsDTO> assetmanagementFixedfields;
        block3: {
            List<AssetmanagementFixedfields> details;
            block2: {
                assetmanagementFixedfields = null;
                details = this.assetmanagementFixedfieldsDAO.getAssetmanagementFixedfields(itemTypeId);
                if (!CollectionUtil.isNotEmpty(details)) break block2;
                assetmanagementFixedfields = new ArrayList<AssetmanagementFixedfieldsDTO>(details.size());
                for (AssetmanagementFixedfields master : details) {
                    assetmanagementFixedfields.add(new AssetmanagementFixedfieldsDTO(master));
                }
                break block3;
            }
            details = this.assetmanagementFixedfieldsDAO.getAssetmanagementDefaultFixedfields(moduleId);
            if (!CollectionUtil.isNotEmpty(details)) break block3;
            assetmanagementFixedfields = new ArrayList(details.size());
            for (AssetmanagementFixedfields master : details) {
                assetmanagementFixedfields.add(new AssetmanagementFixedfieldsDTO(master));
            }
        }
        return assetmanagementFixedfields;
    }

    private List<AssetcomponentfixedfieldsMappingDTO> getAssetcomponentfixedfieldsMapping(Integer itemTypeId) {
        ArrayList<AssetcomponentfixedfieldsMappingDTO> assetcomponentfixedfieldsMapping = null;
        List<AssetcomponentfixedfieldsMapping> details = this.assetcomponentfixedfieldsMappingDAO.getAssetcomponentfixedfieldsMapping(itemTypeId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetcomponentfixedfieldsMapping = new ArrayList<AssetcomponentfixedfieldsMappingDTO>(details.size());
            for (AssetcomponentfixedfieldsMapping master : details) {
                assetcomponentfixedfieldsMapping.add(new AssetcomponentfixedfieldsMappingDTO(master));
            }
        }
        return assetcomponentfixedfieldsMapping;
    }

    private List<AssetItemtypeConfigurationDTO> getAssetitemtypeConfiguration(Integer itemTypeId) {
        ArrayList<AssetItemtypeConfigurationDTO> assetItemtypeConfiguration = null;
        List<AssetitemtypeConfiguration> details = this.assetItemtypeConfigurationDAO.getAssetitemtypeConfiguration(itemTypeId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetItemtypeConfiguration = new ArrayList<AssetItemtypeConfigurationDTO>(details.size());
            for (AssetitemtypeConfiguration master : details) {
                MacromasterDTO mmDTO = this.macroService.geMacromasterDTOByIdFromCache(master.getMacroId());
                if (mmDTO == null) continue;
                assetItemtypeConfiguration.add(new AssetItemtypeConfigurationDTO(master, mmDTO));
            }
        }
        return assetItemtypeConfiguration;
    }

    private List<AssetDepreciationDTO> getAssetDepreciation(Integer itemTypeId) {
        ArrayList<AssetDepreciationDTO> assetDepreciation = null;
        List<AssetDepreciation> details = this.assetDepreciationDAO.getAssetDepreciation(itemTypeId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetDepreciation = new ArrayList<AssetDepreciationDTO>(details.size());
            for (AssetDepreciation master : details) {
                assetDepreciation.add(new AssetDepreciationDTO(master));
            }
        }
        return assetDepreciation;
    }
}

