/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.cmdb.service.impl;

import com.sapphire.itsm.mailrouting.model.AssetModuleMaster;
import com.sapphireims.cmdb.dao.IAssetControlFlowConfigDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetControlFlowConfigMasterDAO;
import com.sapphireims.cmdb.dao.IAssetFlowDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetModuleMasterDAO;
import com.sapphireims.cmdb.dao.IAssetNotificationRuleDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetNotificationRuleMasterDAO;
import com.sapphireims.cmdb.dao.IAssetNotificationTemplateDetailsDAO;
import com.sapphireims.cmdb.dao.IAssetNotificationTemplateMasterDAO;
import com.sapphireims.cmdb.dao.IAssetPrepostActionsDAO;
import com.sapphireims.cmdb.dao.IAssetRequestNumberFormatDAO;
import com.sapphireims.cmdb.dao.IAssetcontrolflowconfigAdditionalparamsDAO;
import com.sapphireims.cmdb.dao.IAssetfieldsTemplatedetailsDAO;
import com.sapphireims.cmdb.dao.IAssetfieldsTemplatemasterDAO;
import com.sapphireims.cmdb.dao.IAssetgenerationdetailsDAO;
import com.sapphireims.cmdb.dao.IAssetgenerationmasterDAO;
import com.sapphireims.cmdb.dao.IAssetrolesDAO;
import com.sapphireims.cmdb.dao.IBarcodeConfigurationDAO;
import com.sapphireims.cmdb.dao.IBarcodeConfigurationDetailsDAO;
import com.sapphireims.cmdb.dao.ICiRelationshipMasterDAO;
import com.sapphireims.cmdb.dao.IGenericNotificationConfigDetailsDAO;
import com.sapphireims.cmdb.dao.IMiscDetailsDAO;
import com.sapphireims.cmdb.dao.IUserAcceptanceConfigDAO;
import com.sapphireims.cmdb.dto.AssetControlFlowConfigMasterDTO;
import com.sapphireims.cmdb.dto.AssetFlowDetailsDTO;
import com.sapphireims.cmdb.dto.AssetNotificationRuleDetailsDTO;
import com.sapphireims.cmdb.dto.AssetNotificationRuleMasterDTO;
import com.sapphireims.cmdb.dto.AssetNotificationTemplateDetailsDTO;
import com.sapphireims.cmdb.dto.AssetNotificationTemplateMasterDTO;
import com.sapphireims.cmdb.dto.AssetPrepostActionsDTO;
import com.sapphireims.cmdb.dto.AssetRequestNumberFormatDTO;
import com.sapphireims.cmdb.dto.AssetcontrolflowconfigAdditionalparamsDTO;
import com.sapphireims.cmdb.dto.AssetfieldsTemplatedetailsDTO;
import com.sapphireims.cmdb.dto.AssetfieldsTemplatemasterDTO;
import com.sapphireims.cmdb.dto.AssetgenerationdetailsDTO;
import com.sapphireims.cmdb.dto.AssetgenerationmasterDTO;
import com.sapphireims.cmdb.dto.AssetrolesDTO;
import com.sapphireims.cmdb.dto.BarcodeConfigurationDTO;
import com.sapphireims.cmdb.dto.BarcodeConfigurationDetailsDTO;
import com.sapphireims.cmdb.dto.CiRelationshipMasterDTO;
import com.sapphireims.cmdb.dto.GenericNotificationConfigDetailsDTO;
import com.sapphireims.cmdb.dto.MiscDetailsDTO;
import com.sapphireims.cmdb.dto.UserAcceptanceConfigDTO;
import com.sapphireims.cmdb.dto.assetcopy.AssetModuleDTO;
import com.sapphireims.cmdb.dto.assetcopy.AssetTypeDTO;
import com.sapphireims.cmdb.model.AssetNotificationRuleMaster;
import com.sapphireims.cmdb.model.AssetNotificationTemplateMaster;
import com.sapphireims.cmdb.model.AssetPrepostActions;
import com.sapphireims.cmdb.model.AssetRequestNumberFormat;
import com.sapphireims.cmdb.model.AssetcontrolflowconfigAdditionalparams;
import com.sapphireims.cmdb.model.AssetcontrolflowconfigMaster;
import com.sapphireims.cmdb.model.AssetfieldsTemplatemaster;
import com.sapphireims.cmdb.model.Assetflowdetails;
import com.sapphireims.cmdb.model.Assetgenerationmaster;
import com.sapphireims.cmdb.model.Assetroles;
import com.sapphireims.cmdb.model.BarcodeConfiguration;
import com.sapphireims.cmdb.model.CiRelationshipMaster;
import com.sapphireims.cmdb.model.MiscDetails;
import com.sapphireims.cmdb.model.UserAcceptanceConfig;
import com.sapphireims.cmdb.model.enummodel.ModuleType;
import com.sapphireims.cmdb.service.IAssetTypeDataService;
import com.sapphireims.cmdb.service.IAssetcontrolFlowService;
import com.sapphireims.cmdb.service.ICacheMasterData;
import com.sapphireims.dao.impl.rpa.RpaEventRepository;
import com.sapphireims.dto.rpa.RpaEventDTO;
import com.sapphireims.dto.rpa.RpaProcessDTO;
import com.sapphireims.exception.DomainException;
import com.sapphireims.exception.ValidationException;
import com.sapphireims.ims.model.GenericNotificationConfigDetails;
import com.sapphireims.itsm.dao.ISdTemplateDAO;
import com.sapphireims.itsm.dto.SdTemplateDTO;
import com.sapphireims.itsm.model.SdTemplate;
import com.sapphireims.model.rpa.RpaEvent;
import com.sapphireims.util.CollectionUtil;
import com.sapphireims.util.Validate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CacheMasterData
implements ICacheMasterData {
    private Logger logger = LoggerFactory.getLogger(CacheMasterData.class);
    @Autowired
    private IAssetModuleMasterDAO assetModuleMasterDAO;
    @Autowired
    private IAssetFlowDetailsDAO assetFlowDetailsDAO;
    @Autowired
    private IAssetrolesDAO assetRolesDAO;
    @Autowired
    private IAssetControlFlowConfigMasterDAO assetControlFlowConfigMasterDAO;
    @Autowired
    private IAssetgenerationmasterDAO assetgenerationmasterDAO;
    @Autowired
    private IMiscDetailsDAO miscDetailsDAO;
    @Autowired
    private IAssetfieldsTemplatemasterDAO assetfieldsTemplatemasterDAO;
    @Autowired
    private IAssetfieldsTemplatedetailsDAO assetfieldsTemplatedetailsDAO;
    @Autowired
    private IAssetgenerationdetailsDAO assetgenerationdetailsDAO;
    @Autowired
    private IAssetNotificationTemplateMasterDAO assetNotificationTemplateMasterDAO;
    @Autowired
    private IAssetNotificationTemplateDetailsDAO assetNotificationTemplateDetailsDAO;
    @Autowired
    private IAssetNotificationRuleMasterDAO assetNotificationRuleMasterDAO;
    @Autowired
    private IAssetNotificationRuleDetailsDAO assetNotificationRuleDetailsDAO;
    @Autowired
    private IGenericNotificationConfigDetailsDAO genericNotificationConfigDetailsDAO;
    @Autowired
    private IBarcodeConfigurationDAO barcodeConfigurationDAO;
    @Autowired
    private IBarcodeConfigurationDetailsDAO barcodeConfigurationDetailsDAO;
    @Autowired
    private ICiRelationshipMasterDAO ciRelationshipMasterDAO;
    @Autowired
    private IUserAcceptanceConfigDAO userAcceptanceConfigDAO;
    @Autowired
    private IAssetTypeDataService assetTypeDataService;
    @Autowired
    private IAssetcontrolflowconfigAdditionalparamsDAO assetcontrolflowconfigAdditionalparamsDAO;
    @Autowired
    private IAssetPrepostActionsDAO assetPrepostActionsDAO;
    @Autowired
    private IAssetRequestNumberFormatDAO assetRequestNumberFormatDAO;
    @Autowired
    private IAssetcontrolFlowService assetcontrolFlowService;
    @Autowired
    private IAssetControlFlowConfigDetailsDAO assetControlFlowConfigDetails;
    @Autowired
    private RpaEventRepository rpaEventRepository;
    @Autowired
    private ISdTemplateDAO sdTemplateDAO;

    @Override
    @Transactional(readOnly=true)
    @Cacheable(value={"asset_metadata"})
    public AssetModuleDTO getAssetModule(Integer moduleId) throws DomainException, ValidationException {
        Integer siteId = 1;
        AssetModuleDTO.Builder builder = AssetModuleDTO.builder();
        Validate.notNull((Object)moduleId, (String)"Module id should not be null %s ", (Object[])new Object[]{moduleId});
        AssetModuleMaster moduleMaster = (AssetModuleMaster)this.assetModuleMasterDAO.get(moduleId);
        Validate.notNull((Object)((Object)moduleMaster), (String)" No such entity Invalid Module id  %s ", (Object[])new Object[]{moduleId});
        builder.withModuleId(moduleMaster.getModuleId());
        builder.withModuleName(moduleMaster.getModuleName());
        builder.withDescription(moduleMaster.getDescription());
        builder.withModuleType(ModuleType.getModuleType(moduleMaster.getModuleType()));
        builder.withDisplayOrder(moduleMaster.getDisplayOrder());
        builder.withIsVisible(moduleMaster.getIsVisible());
        this.getAssetFlowDetails(builder, moduleId, siteId);
        this.getAssetRoles(builder, moduleId);
        this.getAssetControlFlowConfigMasterDetails(builder, moduleId);
        this.getAssetgenerationmasterDetails(builder, moduleId);
        this.getAssetRequestNumberFormat(builder, moduleId);
        this.getMiscDetails(builder, moduleId);
        this.getAssetfieldsTemplatemaster(builder, moduleId);
        this.getAssetNotificationTemplateMaster(builder, moduleId);
        this.getAssetNotificationRuleMasterDetails(builder, moduleId);
        this.getGenericNotificationConfigDetails(builder, moduleId);
        this.getBarcodeConfiguration(builder, moduleId);
        this.getCiRelationshipMaster(builder, moduleId);
        this.getUserAcceptanceConfig(builder, moduleId);
        this.getRPAEvents(builder, moduleId);
        this.getTemplates(builder, moduleId);
        List<AssetTypeDTO> assetTypeDTO = this.assetTypeDataService.getAssetTypes(moduleId);
        builder.withAssetTypeDTO(assetTypeDTO);
        this.getAssetPrepostActions(builder, moduleId);
        return builder.build();
    }

    private void getAssetFlowDetails(AssetModuleDTO.Builder builder, Integer moduleId, Integer siteId) {
        ArrayList<AssetFlowDetailsDTO> lst = null;
        List<Assetflowdetails> assetFlowDetails = this.assetFlowDetailsDAO.getAssetFlowDetailsByModuleId(moduleId, siteId);
        if (CollectionUtil.isNotEmpty(assetFlowDetails)) {
            lst = new ArrayList<AssetFlowDetailsDTO>(assetFlowDetails.size());
            for (Assetflowdetails a : assetFlowDetails) {
                lst.add(new AssetFlowDetailsDTO(a, this.assetControlFlowConfigDetails.getAssetControlFlowConfigDetailsByFilterId(a.getId().getFlowDetailsId())));
            }
            builder.withAssetFlowDetails(lst);
        }
    }

    private void getAssetRoles(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<AssetrolesDTO> roles = null;
        List<Assetroles> assetRole = this.assetRolesDAO.getAssetRoles(moduleId);
        if (CollectionUtil.isNotEmpty(assetRole)) {
            roles = new ArrayList<AssetrolesDTO>(assetRole.size());
            for (Assetroles role : assetRole) {
                roles.add(new AssetrolesDTO(role));
            }
            builder.withAssetRoles(roles);
        }
    }

    private void getAssetControlFlowConfigMasterDetails(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<AssetControlFlowConfigMasterDTO> assetControlFlowConfig = null;
        List<AssetcontrolflowconfigMaster> details = this.assetControlFlowConfigMasterDAO.getAssetControlFlowConfigMasterDetails(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetControlFlowConfig = new ArrayList<AssetControlFlowConfigMasterDTO>(details.size());
            for (AssetcontrolflowconfigMaster master : details) {
                List<AssetcontrolflowconfigAdditionalparams> lst = this.assetcontrolflowconfigAdditionalparamsDAO.getAssetcontrolflowconfigAdditionalparams(master.getId().getControlFlowId());
                List<AssetcontrolflowconfigAdditionalparamsDTO> lstDetails = this.assetcontrolFlowService.getAssetControlFlowDTOs(lst);
                assetControlFlowConfig.add(new AssetControlFlowConfigMasterDTO(master, lstDetails));
            }
            builder.withAssetControlFlowConfigDetails(assetControlFlowConfig);
        }
    }

    private void getAssetgenerationmasterDetails(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<AssetgenerationmasterDTO> assetgenerationmaster = null;
        List<Assetgenerationmaster> details = this.assetgenerationmasterDAO.getAssetgenerationmasterDetails(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetgenerationmaster = new ArrayList<AssetgenerationmasterDTO>(details.size());
            for (Assetgenerationmaster master : details) {
                List<AssetgenerationdetailsDTO> lstDetails = this.assetgenerationdetailsDAO.getAssetgenerationdetails(master.getCategoryId());
                assetgenerationmaster.add(new AssetgenerationmasterDTO(master, lstDetails));
            }
            builder.withAssetGenerationDetails(assetgenerationmaster);
        }
    }

    private void getAssetRequestNumberFormat(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<AssetRequestNumberFormatDTO> assetRequestNumberFormat = null;
        List<AssetRequestNumberFormat> details = this.assetRequestNumberFormatDAO.getAssetRequestNumberFormat(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetRequestNumberFormat = new ArrayList<AssetRequestNumberFormatDTO>(details.size());
            for (AssetRequestNumberFormat master : details) {
                assetRequestNumberFormat.add(new AssetRequestNumberFormatDTO(master));
            }
            builder.withAssetRequestNumberFormatDetails(assetRequestNumberFormat);
        }
    }

    private void getMiscDetails(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<MiscDetailsDTO> miscDetails = null;
        List details = this.miscDetailsDAO.getMiscDetails(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            miscDetails = new ArrayList<MiscDetailsDTO>(details.size());
            for (MiscDetails misc : details) {
                miscDetails.add(new MiscDetailsDTO(misc));
            }
            builder.withAssetMiscDetails(miscDetails);
        }
    }

    private void getAssetfieldsTemplatemaster(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<AssetfieldsTemplatemasterDTO> assetfieldsTemplatemaster = null;
        List<AssetfieldsTemplatemaster> masterDetails = this.assetfieldsTemplatemasterDAO.getAssetfieldsTemplatemaster(moduleId);
        if (CollectionUtil.isNotEmpty(masterDetails)) {
            assetfieldsTemplatemaster = new ArrayList<AssetfieldsTemplatemasterDTO>(masterDetails.size());
            for (AssetfieldsTemplatemaster master : masterDetails) {
                List<AssetfieldsTemplatedetailsDTO> details = this.assetfieldsTemplatedetailsDAO.getAssetfieldsTemplatedetails(master.getTemplateId());
                assetfieldsTemplatemaster.add(new AssetfieldsTemplatemasterDTO(master, details));
            }
            builder.withAssetFieldsTemplateMaster(assetfieldsTemplatemaster);
        }
    }

    private void getAssetNotificationTemplateMaster(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<AssetNotificationTemplateMasterDTO> assetNotificationTemplateMaster = null;
        List<AssetNotificationTemplateMaster> details = this.assetNotificationTemplateMasterDAO.getAssetNotificationTemplateMaster(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetNotificationTemplateMaster = new ArrayList<AssetNotificationTemplateMasterDTO>(details.size());
            for (AssetNotificationTemplateMaster master : details) {
                List<AssetNotificationTemplateDetailsDTO> lstDetails = this.assetNotificationTemplateDetailsDAO.getAssetNotificationTemplateDetails(master.getTemplateId());
                assetNotificationTemplateMaster.add(new AssetNotificationTemplateMasterDTO(master, lstDetails));
            }
            builder.withAssetNotificationTemplateDetails(assetNotificationTemplateMaster);
        }
    }

    private void getAssetNotificationRuleMasterDetails(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<AssetNotificationRuleMasterDTO> assetNotificationRuleMaster = null;
        List<AssetNotificationRuleMaster> details = this.assetNotificationRuleMasterDAO.getAssetNotificationRuleMaster(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetNotificationRuleMaster = new ArrayList<AssetNotificationRuleMasterDTO>(details.size());
            for (AssetNotificationRuleMaster master : details) {
                List<AssetNotificationRuleDetailsDTO> lstDetails = this.assetNotificationRuleDetailsDAO.getAssetNotificationRuleDetails(master.getRuleId());
                assetNotificationRuleMaster.add(new AssetNotificationRuleMasterDTO(master, lstDetails));
            }
            builder.withAssetNotificatonRuleDetails(assetNotificationRuleMaster);
        }
    }

    private void getGenericNotificationConfigDetails(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<GenericNotificationConfigDetailsDTO> genericNotificationConfigDetails = null;
        List<GenericNotificationConfigDetails> details = this.genericNotificationConfigDetailsDAO.getGenericNotificationConfigDetails(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            genericNotificationConfigDetails = new ArrayList<GenericNotificationConfigDetailsDTO>(details.size());
            for (GenericNotificationConfigDetails master : details) {
                genericNotificationConfigDetails.add(new GenericNotificationConfigDetailsDTO(master));
            }
            builder.withAssetGenericNotificationCOnfigDetails(genericNotificationConfigDetails);
        }
    }

    private void getAssetPrepostActions(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<AssetPrepostActionsDTO> assetPrepostActions = null;
        List<AssetPrepostActions> details = this.assetPrepostActionsDAO.getAssetPrepostActions(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            assetPrepostActions = new ArrayList<AssetPrepostActionsDTO>(details.size());
            for (AssetPrepostActions master : details) {
                assetPrepostActions.add(new AssetPrepostActionsDTO(master));
            }
            builder.withAssetPrepostActions(assetPrepostActions);
        }
    }

    private void getBarcodeConfiguration(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<BarcodeConfigurationDTO> barcodeConfigurationMaster = null;
        List<BarcodeConfiguration> details = this.barcodeConfigurationDAO.getBarcodeConfiguration(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            barcodeConfigurationMaster = new ArrayList<BarcodeConfigurationDTO>(details.size());
            for (BarcodeConfiguration master : details) {
                List<BarcodeConfigurationDetailsDTO> lstDetails = this.barcodeConfigurationDetailsDAO.getBarcodeConfigurationDetails(master.getSno());
                barcodeConfigurationMaster.add(new BarcodeConfigurationDTO(master, lstDetails));
            }
            builder.withAssetBarcodeConfigDetails(barcodeConfigurationMaster);
        }
    }

    private void getCiRelationshipMaster(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<CiRelationshipMasterDTO> ciRelationshipMaster = null;
        List<CiRelationshipMaster> details = this.ciRelationshipMasterDAO.getCiRelationshipMaster(moduleId);
        if (CollectionUtil.isNotEmpty(details)) {
            ciRelationshipMaster = new ArrayList<CiRelationshipMasterDTO>(details.size());
            for (CiRelationshipMaster master : details) {
                ciRelationshipMaster.add(new CiRelationshipMasterDTO(master));
            }
            builder.withAssetCiRelationshipDetails(ciRelationshipMaster);
        }
    }

    private void getUserAcceptanceConfig(AssetModuleDTO.Builder builder, Integer moduleId) {
        ArrayList<UserAcceptanceConfigDTO> userAcceptanceConfig = null;
        List details = this.userAcceptanceConfigDAO.getUserAcceptanceConfig(moduleId);
        if (CollectionUtil.isEmpty(details)) {
            userAcceptanceConfig = new ArrayList<UserAcceptanceConfigDTO>(details.size());
            for (UserAcceptanceConfig master : details) {
                userAcceptanceConfig.add(new UserAcceptanceConfigDTO(master));
            }
            builder.withAssetUserAcceptanceDetails(userAcceptanceConfig);
        }
    }

    private void getRPAEvents(AssetModuleDTO.Builder builder, Integer moduleId) {
        List<RpaEvent> events = this.rpaEventRepository.getActiveRpaEventForCMDB(moduleId);
        ArrayList<RpaEventDTO> ret = null;
        if (CollectionUtil.isNotEmpty(events)) {
            ret = new ArrayList<RpaEventDTO>(events.size());
            for (RpaEvent d : events) {
                RpaEventDTO reDTO = new RpaEventDTO(d, new RpaProcessDTO(d.getRpaProcess()));
                reDTO.setProcessId(d.getRpaProcess().getId());
                ret.add(reDTO);
            }
        }
        builder.withRpaEvents(ret);
    }

    private void getTemplates(AssetModuleDTO.Builder builder, Integer moduleId) {
        List<SdTemplate> templates = this.sdTemplateDAO.getTemplatesByModuleId(moduleId);
        ArrayList<SdTemplateDTO> templateDto = null;
        if (CollectionUtil.isNotEmpty(templates)) {
            templateDto = new ArrayList<SdTemplateDTO>(templates.size());
            for (SdTemplate d : templates) {
                SdTemplateDTO reDTO = new SdTemplateDTO(d);
                templateDto.add(reDTO);
            }
        }
        builder.withTemplates(templateDto);
    }
}

