/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.dao.impl.rpa;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.dao.rpa.IRpaEventRepository;
import com.sapphireims.itsm.model.enummodel.PostAction;
import com.sapphireims.model.rpa.RpaEvent;
import com.sapphireims.util.CollectionUtil;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class RpaEventRepository
extends GenericHibernateRepository<RpaEvent, Integer>
implements IRpaEventRepository {
    @Override
    public RpaEvent getRpaEvent(int rpaProcessId, String eventType, PostAction actiontype) {
        String query = " from RpaEvent where rpaProcess.id = :rpaProcessId and eventType =:eventType and actiontype =:actiontype ";
        String[] paramNames = new String[]{"rpaProcessId", "eventType", "actiontype"};
        Object[] values = new Object[]{rpaProcessId, eventType, actiontype};
        List lst = this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, RpaEvent.class);
        if (CollectionUtil.isNotEmpty(lst)) {
            return (RpaEvent)((Object)lst.get(0));
        }
        return null;
    }

    @Override
    public List<RpaEvent> getRpaEventForProject(int projectId, String eventType, PostAction actiontype) {
        String query = " from RpaEvent where projectId = :projectId and eventType =:eventType and actiontype =:actiontype ";
        String[] paramNames = new String[]{"projectId", "eventType", "actiontype"};
        Object[] values = new Object[]{projectId, eventType, actiontype};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, RpaEvent.class);
    }

    @Override
    public List<RpaEvent> getRpaEventForProject(Integer projectId) {
        String query = " from RpaEvent where projectId = :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, RpaEvent.class);
    }

    @Override
    public List<RpaEvent> getActiveRpaEventForProject(Integer projectId) {
        String query = " from RpaEvent where projectId = :projectId and rpaProcess.active=true ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, RpaEvent.class);
    }

    @Override
    public List<RpaEvent> getActiveRpaEventForCMDB(Integer assetModuleId) {
        String query = " from RpaEvent where assetModuleId = :assetModuleId and rpaProcess.active=true and isCMDB=1";
        String[] paramNames = new String[]{"assetModuleId"};
        Object[] values = new Object[]{assetModuleId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, RpaEvent.class);
    }
}

