/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.dao.impl.rpa;

import com.sapphireims.dao.GenericHibernateRepository;
import com.sapphireims.dao.rpa.IRpaProcessRepository;
import com.sapphireims.dto.SearchEntityResponce;
import com.sapphireims.dto.SearchRequestDTO;
import com.sapphireims.model.rpa.ProcessType;
import com.sapphireims.model.rpa.RpaProcess;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class RpaProcessRepository
extends GenericHibernateRepository<RpaProcess, Integer>
implements IRpaProcessRepository {
    private Logger logger = LoggerFactory.getLogger(RpaProcessRepository.class);

    @Override
    public SearchEntityResponce getProess(SearchRequestDTO search) {
        ProcessType p;
        String query = " from RpaProcess where projectId = :projectId ";
        String countQuery = " select count(id) from RpaProcess where projectId = :projectId ";
        if (search.getAssetModuleId() != null && search.getAssetModuleId() > 0) {
            query = " from RpaProcess where assetModuleId = :projectId ";
            countQuery = " select count(id) from RpaProcess where assetModuleId = :projectId and isCMDB=1";
        }
        String[] paramNames = new String[4];
        paramNames[0] = "projectId";
        Object[] values = new Object[4];
        values[0] = search.getAssetModuleId() != null && search.getAssetModuleId() > 0 ? search.getAssetModuleId() : search.getProjectId();
        if (search.getSearchAttribute1() != null && search.getSearchAttribute1().length() > 1 && (p = ProcessType.valueOf(search.getSearchAttribute1())) != null) {
            query = query.concat("and type=:type");
            countQuery = countQuery.concat("and type=:type");
            paramNames[1] = "type";
            values[1] = ProcessType.valueOf(search.getSearchAttribute1());
        }
        if (search.getSearchAttribute3() != null && search.getSearchAttribute3().length() > 1) {
            query = query.concat(" and name=:name ");
            countQuery = countQuery.concat(" and name=:name ");
            paramNames[2] = "name";
            values[2] = search.getSearchAttribute3();
        }
        if (search.getSearchAttribute4() != null && search.getSearchAttribute4().length() > 0) {
            query = query.concat(" and id!=:id ");
            countQuery = countQuery.concat(" and id!=:id ");
            paramNames[3] = "id";
            values[3] = search.getSearchAttribute4();
        }
        if (!search.getSortAttribute().isEmpty() && !search.getSortDirection().isEmpty()) {
            query = query.concat(" order by ").concat(search.getSortAttribute() + " ").concat(search.getSortDirection());
        }
        this.logger.debug("query : {}  , countQuery : {}  , paramNames : {}  , values : {} , search : {} ", new Object[]{query, countQuery, paramNames, values, search});
        return this.hibernateDaoOperations.findByNamedParam(query, countQuery, paramNames, values, search);
    }

    @Override
    public List<RpaProcess> getProessForProject(Integer projectId) {
        String query = " from RpaProcess where projectId = :projectId";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, RpaProcess.class);
    }

    @Override
    public List<RpaProcess> getActiveProessForProject(Integer projectId) {
        String query = " from RpaProcess where projectId = :projectId and active=true ";
        String[] paramNames = new String[]{"projectId"};
        Object[] values = new Object[]{projectId};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, RpaProcess.class);
    }

    @Override
    public List<RpaProcess> getProessForProject(Integer projectId, ProcessType type) {
        String query = " from RpaProcess where projectId = :projectId and type=:type";
        String[] paramNames = new String[]{"projectId", "type"};
        Object[] values = new Object[]{projectId, type};
        return this.hibernateDaoOperations.findByNamedParam(query, paramNames, values, RpaProcess.class);
    }
}

