/*
 * Decompiled with CFR 0.152.
 */
package com.sapphireims.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.MoreObjects;
import com.sapphireims.ims.dto.EntityType;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataSource {
    private EntityType type;
    private int projectid;
    private String filterParm1;
    private String filterParm2;
    private String filterParm3;

    public DataSource() {
    }

    private DataSource(Builder builder) {
        this.type = builder.type;
        this.projectid = builder.projectid;
        this.filterParm1 = builder.filterParm1;
        this.filterParm2 = builder.filterParm2;
        this.filterParm3 = builder.filterParm3;
    }

    public DataSource(EntityType type) {
        this.type = type;
    }

    public DataSource(EntityType type, int projectid) {
        this.type = type;
        this.projectid = projectid;
    }

    public DataSource(EntityType type, int projectid, String filterParm1) {
        this.type = type;
        this.projectid = projectid;
        this.filterParm1 = filterParm1;
    }

    public DataSource(EntityType type, int projectid, String filterParm1, String filterParm2) {
        this.type = type;
        this.projectid = projectid;
        this.filterParm1 = filterParm1;
        this.filterParm2 = filterParm2;
    }

    public DataSource(EntityType type, int projectid, String filterParm1, String filterParm2, String filterParm3) {
        this.type = type;
        this.projectid = projectid;
        this.filterParm1 = filterParm1;
        this.filterParm2 = filterParm2;
        this.filterParm3 = filterParm3;
    }

    public int getProjectid() {
        return this.projectid;
    }

    public void setProjectid(int projectid) {
        this.projectid = projectid;
    }

    public String getFilterParm1() {
        return this.filterParm1;
    }

    public void setFilterParm1(String filterParm1) {
        this.filterParm1 = filterParm1;
    }

    public String getFilterParm2() {
        return this.filterParm2;
    }

    public void setFilterParm2(String filterParm2) {
        this.filterParm2 = filterParm2;
    }

    public String getFilterParm3() {
        return this.filterParm3;
    }

    public void setFilterParm3(String filterParm3) {
        this.filterParm3 = filterParm3;
    }

    public EntityType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.projectid, this.filterParm1, this.filterParm2, this.filterParm3});
    }

    public boolean equals(Object object) {
        if (object instanceof DataSource) {
            DataSource that = (DataSource)object;
            return Objects.equals((Object)this.type, (Object)that.type) && this.projectid == that.projectid && Objects.equals(this.filterParm1, that.filterParm1) && Objects.equals(this.filterParm2, that.filterParm2) && Objects.equals(this.filterParm3, that.filterParm3);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("projectid", this.projectid).add("filterParm1", (Object)this.filterParm1).add("filterParm2", (Object)this.filterParm2).add("filterParm3", (Object)this.filterParm3).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EntityType type;
        private int projectid;
        private String filterParm1;
        private String filterParm2;
        private String filterParm3;

        private Builder() {
        }

        public Builder withType(EntityType type) {
            this.type = type;
            return this;
        }

        public Builder withProjectid(int projectid) {
            this.projectid = projectid;
            return this;
        }

        public Builder withFilterParm1(String filterParm1) {
            this.filterParm1 = filterParm1;
            return this;
        }

        public Builder withFilterParm2(String filterParm2) {
            this.filterParm2 = filterParm2;
            return this;
        }

        public Builder withFilterParm3(String filterParm3) {
            this.filterParm3 = filterParm3;
            return this;
        }

        public DataSource build() {
            return new DataSource(this);
        }
    }
}

